/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.DefaultSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.ctandem2.CTandem2;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite;
import org.javades.jqueues.r5.extensions.composite.SimQueueCompositeStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_CTandem2<Q extends CTandem2>
extends AbstractSimQueuePredictor_Composite<Q> {
    private Set<JobQueueVisitLog<SimJob, Q>> cachedVisitLogsSet;

    private static List<AbstractSimQueuePredictor> asList(AbstractSimQueuePredictor p1, AbstractSimQueuePredictor p2) {
        if (p1 == null || p2 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<AbstractSimQueuePredictor> list = new ArrayList<AbstractSimQueuePredictor>();
        list.add(p1);
        list.add(p2);
        return list;
    }

    public SimQueuePredictor_CTandem2(AbstractSimQueuePredictor waitQueuePredictor, AbstractSimQueuePredictor serveQueuePredictor) {
        super(SimQueuePredictor_CTandem2.asList(waitQueuePredictor, serveQueuePredictor));
    }

    public String toString() {
        return "Predictor[CTandem2[?]]";
    }

    private SimQueue getWaitQueue(Q queue) {
        if (queue == null) {
            throw new IllegalArgumentException();
        }
        Iterator i_queues = ((AbstractSimQueueComposite)queue).getQueues().iterator();
        return (SimQueue)i_queues.next();
    }

    private SimQueue getServeQueue(Q queue) {
        if (queue == null) {
            throw new IllegalArgumentException();
        }
        Iterator i_queues = ((AbstractSimQueueComposite)queue).getQueues().iterator();
        i_queues.next();
        return (SimQueue)i_queues.next();
    }

    private SimQueuePredictor getWaitQueuePredictor() {
        return (SimQueuePredictor)this.subQueuePredictors.get(0);
    }

    private SimQueuePredictor getServeQueuePredictor() {
        return (SimQueuePredictor)this.subQueuePredictors.get(1);
    }

    private DefaultSimQueueState getWaitQueueState(Q queue, SimQueueState<SimJob, Q> queueState) {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        return queueStateHandler.getSubQueueState(0);
    }

    private DefaultSimQueueState getServeQueueState(Q queue, SimQueueState<SimJob, Q> queueState) {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        return queueStateHandler.getSubQueueState(1);
    }

    @Override
    public boolean isStartArmed(Q queue, SimQueueState<SimJob, Q> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return this.getServeQueuePredictor().isStartArmed(this.getServeQueue(queue), this.getServeQueueState(queue, queueState));
    }

    @Override
    public SimQueueState<SimJob, Q> createQueueState(Q queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        if (subQueues.size() != 2) {
            throw new RuntimeException();
        }
        DefaultSimQueueState waitQueueState = (DefaultSimQueueState)this.getWaitQueuePredictor().createQueueState(this.getWaitQueue(queue), isROEL);
        DefaultSimQueueState serveQueueState = (DefaultSimQueueState)this.getServeQueuePredictor().createQueueState(this.getServeQueue(queue), isROEL);
        LinkedHashSet<DefaultSimQueueState> subQueueStates = new LinkedHashSet<DefaultSimQueueState>();
        subQueueStates.add(waitQueueState);
        subQueueStates.add(serveQueueState);
        queueState.registerHandler(new SimQueueCompositeStateHandler(((AbstractSimQueueComposite)queue).getQueues(), subQueueStates));
        this.getWaitQueueState(queue, queueState).registerPostStartHook(this::waitQueuePostStartHook, new SimQueueAndSimQueueState((SimQueue)queue, queueState));
        return queueState;
    }

    @Override
    public double getNextQueueEventTimeBeyond(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) throws SimQueuePredictionException {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        double minNextEventTime = Double.NaN;
        HashSet<SimQueue> subQueuesMinNextEventTime = new HashSet<SimQueue>();
        SimEntitySimpleEventType.Member nextEvent = null;
        for (int i = 0; i < this.subQueuePredictors.size(); ++i) {
            SimQueue subQueue = (SimQueue)subQueues.get(i);
            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
            LinkedHashSet<SimEntitySimpleEventType.Member> subQueueEventTypes = new LinkedHashSet<SimEntitySimpleEventType.Member>();
            double subQueueNextEventTime = ((AbstractSimQueuePredictor)this.subQueuePredictors.get(i)).getNextQueueEventTimeBeyond(subQueue, subQueueState, subQueueEventTypes);
            if (Double.isNaN(subQueueNextEventTime) || !Double.isNaN(minNextEventTime) && !(subQueueNextEventTime <= minNextEventTime)) continue;
            if (subQueueEventTypes.size() != 1) {
                throw new SimQueuePredictionAmbiguityException();
            }
            if (!Double.isNaN(minNextEventTime) && subQueueNextEventTime < minNextEventTime) {
                subQueuesMinNextEventTime.clear();
            }
            subQueuesMinNextEventTime.add(subQueue);
            nextEvent = (SimEntitySimpleEventType.Member)subQueueEventTypes.iterator().next();
            minNextEventTime = subQueueNextEventTime;
        }
        if (subQueuesMinNextEventTime.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        if (subQueuesMinNextEventTime.size() == 1) {
            queueEventTypes.add(new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent((SimQueue)subQueuesMinNextEventTime.iterator().next(), null, nextEvent, null, null));
        }
        return minNextEventTime;
    }

    @Override
    public void updateToTime(Q queue, SimQueueState queueState, double newTime) {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        for (int i = 0; i < this.subQueuePredictors.size(); ++i) {
            SimQueue subQueue = (SimQueue)subQueues.get(i);
            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
            ((AbstractSimQueuePredictor)this.subQueuePredictors.get(i)).updateToTime(subQueue, subQueueState, newTime);
        }
        queueState.setTime(newTime);
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(Q queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        boolean sacOnWaitQueue;
        boolean needSacOnWaitQueue;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        this.cachedVisitLogsSet = visitLogsSet;
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        if (queueState.getJobs().isEmpty() && (needSacOnWaitQueue = this.getServeQueuePredictor().isStartArmed(this.getServeQueue(queue), this.getServeQueueState(queue, queueState)) && queueState.getServerAccessCredits() > 0) != (sacOnWaitQueue = this.getWaitQueuePredictor().hasServerAccessCredits(this.getServeQueue(queue), this.getWaitQueueState(queue, queueState)))) {
            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent waitQueueSacEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(this.getWaitQueue(queue), SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, needSacOnWaitQueue ? 1 : 0);
            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(waitQueueSacEvent)), visitLogsSet);
        }
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (queueState.getJobs().contains(job)) {
                    if (!(job instanceof DefaultSimJob)) {
                        throw new UnsupportedOperationException();
                    }
                    SimQueue waitQueue = this.getWaitQueue(queue);
                    ((DefaultSimJob)job).setRequestedServiceTimeMappingForQueue(waitQueue, job.getServiceTime(queue));
                    AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent waitQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(waitQueue, SimQueueSimpleEventType.ARRIVAL, null, job, null);
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(waitQueueEvent)), visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    boolean interruptService = (Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job);
                    boolean isJobInServiceArea = queueState.getJobsInServiceArea().contains(job);
                    if (interruptService || !isJobInServiceArea) {
                        HashSet<SimJob> revocations = new HashSet<SimJob>();
                        revocations.add(job);
                        queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                        for (int i = 0; i < ((AbstractSimQueueComposite)queue).getQueues().size(); ++i) {
                            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
                            if (!subQueueState.getJobs().contains(job)) continue;
                            SimQueue subQueue = (SimQueue)new ArrayList(((AbstractSimQueueComposite)queue).getQueues()).get(i);
                            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent subQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(subQueue, SimQueueSimpleEventType.REVOCATION, null, job, null);
                            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueEvent)), visitLogsSet);
                            break;
                        }
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                SimQueue waitQueue = this.getWaitQueue(queue);
                if (oldSac == 0 && newSac > 0 && this.getServeQueuePredictor().isStartArmed(this.getServeQueue(queue), this.getServeQueueState(queue, queueState))) {
                    AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent waitQueueSacEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(waitQueue, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, 1);
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(waitQueueSacEvent)), visitLogsSet);
                    newSac = queueState.getServerAccessCredits();
                } else if (oldSac > 0 && newSac == 0) {
                    AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent waitQueueSacEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(waitQueue, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, 0);
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(waitQueueSacEvent)), visitLogsSet);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        this.cachedVisitLogsSet = visitLogsSet;
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType instanceof AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent) {
                ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
                SimQueue subQueue = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueue;
                int subQueueIndex = subQueues.indexOf(subQueue);
                DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(subQueueIndex);
                AbstractSimQueuePredictor subQueuePredictor = (AbstractSimQueuePredictor)this.subQueuePredictors.get(subQueueIndex);
                SimEntitySimpleEventType.Member subQueueWorkloadEvent = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueueWorkloadEvent;
                SimEntitySimpleEventType.Member subQueueQueueEvent = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueueQueueEvent;
                SimJob job = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).job;
                Object argument = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).argument;
                HashSet subQueueVisitLogsSet = new HashSet();
                try {
                    if (subQueueWorkloadEvent != null) {
                        SimJQEvent subQueueEvent;
                        if (subQueueWorkloadEvent == SimQueueSimpleEventType.ARRIVAL) {
                            subQueueEvent = new SimJQEvent.Arrival<SimJob, SimQueue>(job, subQueue, time);
                        } else if (subQueueWorkloadEvent == SimQueueSimpleEventType.REVOCATION) {
                            subQueueEvent = new SimJQEvent.Revocation<SimJob, SimQueue>(job, subQueue, time, true);
                        } else if (subQueueWorkloadEvent == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                            subQueueEvent = new SimQueueEvent.ServerAccessCredits(subQueue, time, (Integer)argument);
                        } else {
                            throw new RuntimeException();
                        }
                        WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule_SQ_SV_ROEL_U = subQueuePredictor.createWorkloadSchedule_SQ_SV_ROEL_U(subQueue, new HashSet<SimJQEvent>(Collections.singleton(subQueueEvent)));
                        subQueuePredictor.doWorkloadEvents_SQ_SV_ROEL_U(subQueue, workloadSchedule_SQ_SV_ROEL_U, subQueueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueWorkloadEvent)), subQueueVisitLogsSet);
                    } else {
                        subQueuePredictor.doQueueEvents_SQ_SV_ROEL_U(subQueue, subQueueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueQueueEvent)), subQueueVisitLogsSet);
                    }
                }
                catch (WorkloadScheduleException e) {
                    throw new RuntimeException(e);
                }
                for (JobQueueVisitLog jobQueueVisitLog : subQueueVisitLogsSet) {
                    if (jobQueueVisitLog.dropped) {
                        queueState.doExits(time, Collections.singleton(jobQueueVisitLog.job), null, null, null, visitLogsSet);
                        continue;
                    }
                    if (!jobQueueVisitLog.departed) continue;
                    queueState.doExits(time, null, null, Collections.singleton(jobQueueVisitLog.job), null, visitLogsSet);
                }
                SimQueue waitQueue = this.getWaitQueue(queue);
                SimQueue simQueue = this.getServeQueue(queue);
                int sac = queueState.getServerAccessCredits();
                int waitQueueSac = this.getWaitQueueState(queue, queueState).getServerAccessCredits();
                DefaultSimQueueState serveQueueState = this.getServeQueueState(queue, queueState);
                if (sac > 0 && this.getServeQueuePredictor().isStartArmed(simQueue, serveQueueState) && waitQueueSac == 0) {
                    AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent waitQueueSacEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(waitQueue, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, 1);
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(waitQueueSacEvent)), visitLogsSet);
                } else if (!(sac != 0 && this.getServeQueuePredictor().isStartArmed(simQueue, serveQueueState) || waitQueueSac <= 0)) {
                    AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent waitQueueSacEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(waitQueue, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, 0);
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(waitQueueSacEvent)), visitLogsSet);
                }
            } else {
                throw new RuntimeException();
            }
        }
    }

    protected void waitQueuePostStartHook(double time, Set<SimJob> starters, Object userData) throws SimQueuePredictionException {
        if (starters == null || starters.size() != 1 || userData == null) {
            throw new RuntimeException();
        }
        SimJob job = starters.iterator().next();
        CTandem2 queue = (CTandem2)((SimQueueAndSimQueueState)userData).queue;
        DefaultSimQueueState queueState = ((SimQueueAndSimQueueState)userData).queueState;
        if (queue == null || queueState == null) {
            throw new RuntimeException();
        }
        SimQueue waitQueue = this.getWaitQueue(queue);
        SimQueue serveQueue = this.getServeQueue(queue);
        DefaultSimQueueState waitQueueState = this.getWaitQueueState(queue, queueState);
        DefaultSimQueueState serveQueueState = this.getServeQueueState(queue, queueState);
        waitQueueState.doExits(time, null, Collections.singleton(job), null, null, null);
        queueState.doStarts(time, starters);
        if (queueState.getJobs().contains(job)) {
            if (!(job instanceof DefaultSimJob)) {
                throw new UnsupportedOperationException();
            }
            ((DefaultSimJob)job).setRequestedServiceTimeMappingForQueue(serveQueue, job.getServiceTime(queue));
            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent serveQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(serveQueue, SimQueueSimpleEventType.ARRIVAL, null, job, null);
            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(serveQueueEvent)), this.cachedVisitLogsSet);
        }
    }

    private class SimQueueAndSimQueueState {
        public final SimQueue queue;
        public final DefaultSimQueueState queueState;

        public SimQueueAndSimQueueState(SimQueue queue, DefaultSimQueueState simQueueState) {
            this.queue = queue;
            this.queueState = simQueueState;
        }
    }
}

