/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.CUPS;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.SimQueueCatchUpSimpleEventType;
import org.javades.jqueues.r5.extensions.ost.SimQueueOSTStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_CUPS
extends AbstractSimQueuePredictor<CUPS> {
    public String toString() {
        return "Predictor[CUPS]";
    }

    @Override
    public SimQueueState<SimJob, CUPS> createQueueState(CUPS queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        queueState.registerHandler(new SimQueueOSTStateHandler());
        return queueState;
    }

    @Override
    public boolean isStartArmed(CUPS queue, SimQueueState<SimJob, CUPS> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private Map<SimJob, Double> getFirstDeparter(SimQueueState<SimJob, CUPS> queueState, SimQueueOSTStateHandler queueStateHandler) {
        for (Map.Entry entry : queueState.getRemainingServiceMap().entrySet()) {
            for (SimJob job : queueStateHandler.getJobsWithMinimumObtainedServiceTime()) {
                if (!((List)entry.getValue()).contains(job)) continue;
                HashMap<SimJob, Double> map = new HashMap<SimJob, Double>();
                map.put(job, (Double)entry.getKey());
                return map;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public double getNextQueueEventTimeBeyond(CUPS queue, SimQueueState<SimJob, CUPS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        double minOstNext;
        double dT_cup;
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        SimQueueOSTStateHandler queueStateHandler = (SimQueueOSTStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueOSTHandler");
        if (queueStateHandler.isEmpty()) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        double minOst = queueStateHandler.getMinimumObtainedServiceTime();
        Set<SimJob> jobsMinOst = queueStateHandler.getJobsWithMinimumObtainedServiceTime();
        Map<SimJob, Double> firstDeparter = this.getFirstDeparter(queueState, queueStateHandler);
        double dT = firstDeparter.entrySet().iterator().next().getValue() * (double)jobsMinOst.size();
        SimEntitySimpleEventType.Member eventType = SimQueueSimpleEventType.DEPARTURE;
        if (queueStateHandler.getNumberOfOstGroups() > 1 && (dT_cup = ((minOstNext = queueStateHandler.getNextHigherThanMinimumObtainedServiceTime()) - minOst) * (double)jobsMinOst.size()) < dT) {
            dT = dT_cup;
            eventType = SimQueueCatchUpSimpleEventType.CATCH_UP;
        }
        if (Double.isFinite(dT)) {
            queueEventTypes.add(eventType);
            return time + dT;
        }
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(CUPS queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, CUPS> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, CUPS>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueOSTStateHandler queueStateHandler = (SimQueueOSTStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueOSTHandler");
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (!queueState.isQueueAccessVacation() && queueState.getServerAccessCredits() >= 1) {
                    queueState.doStarts(time, arrivals);
                    if (queueState.getJobs().contains(job)) {
                        queueStateHandler.addStartingJob(job);
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    boolean interruptService = (Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job);
                    boolean hasStarted = queueState.getJobsInServiceArea().contains(job);
                    if (interruptService || !hasStarted) {
                        HashSet<SimJob> revocations = new HashSet<SimJob>();
                        revocations.add(job);
                        queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                        queueStateHandler.removeJob(job, hasStarted);
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                if (oldSac == 0 && newSac > 0) {
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    Iterator<SimJob> i_waiters = queueState.getJobsInWaitingAreaOrdered().iterator();
                    int remainingSac = newSac;
                    while ((remainingSac == Integer.MAX_VALUE || remainingSac > 0) && i_waiters.hasNext()) {
                        starters.add(i_waiters.next());
                        if (remainingSac == Integer.MAX_VALUE) continue;
                        --remainingSac;
                    }
                    queueState.doStarts(time, starters);
                    Iterator i_starters = starters.iterator();
                    while (i_starters.hasNext()) {
                        if (queueState.getJobs().contains(i_starters.next())) continue;
                        i_starters.remove();
                    }
                    if (!starters.isEmpty()) {
                        queueStateHandler.addStartingJobs(starters);
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(CUPS queue, SimQueueState<SimJob, CUPS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, CUPS>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueOSTStateHandler queueStateHandler = (SimQueueOSTStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueOSTHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null && eventType != SimQueueCatchUpSimpleEventType.CATCH_UP) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                Set<SimJob> departures = Collections.singleton(this.getFirstDeparter(queueState, queueStateHandler).entrySet().iterator().next().getKey());
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
                queueStateHandler.removeJob(departures.iterator().next(), true);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(CUPS queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            SimQueueOSTStateHandler queueStateHandler = (SimQueueOSTStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueOSTHandler");
            if (!queueStateHandler.isEmpty()) {
                Set<SimJob> jobsMinOst = queueStateHandler.getJobsWithMinimumObtainedServiceTime();
                double dS = dT / (double)jobsMinOst.size();
                queueStateHandler.increaseMinimumObtainedServiceTime(newTime, dS, false, 1.0E-9);
                Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
                NavigableMap rsMap = queueState.getRemainingServiceMap();
                for (SimJob job : jobsMinOst) {
                    double oldRst = rsTimeMap.get(job);
                    double newRstCalculated = oldRst - dS;
                    if (newRstCalculated < -1.0E-9) {
                        throw new IllegalStateException("calculated remaining service time is (too) negative on job " + job + ": " + newRstCalculated + ".");
                    }
                    double newRst = Math.max(newRstCalculated, 0.0);
                    rsTimeMap.put(job, newRst);
                    ((List)rsMap.get(oldRst)).remove(job);
                    if (((List)rsMap.get(oldRst)).isEmpty()) {
                        rsMap.remove(oldRst);
                    }
                    if (!rsMap.containsKey(newRst)) {
                        rsMap.put(newRst, new ArrayList());
                    }
                    ((List)rsMap.get(newRst)).add(job);
                }
            }
        }
        queueState.setTime(newTime);
    }
}

