/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.serverless.DLIMIT;
import org.javades.jqueues.r5.extensions.ratelimit.RateLimitSimpleEventType;
import org.javades.jqueues.r5.extensions.ratelimit.SimQueueRateLimitStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_DLIMIT
extends AbstractSimQueuePredictor<DLIMIT> {
    @Override
    public SimQueueState<SimJob, DLIMIT> createQueueState(DLIMIT queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        SimQueueRateLimitStateHandler queueStateHandler = new SimQueueRateLimitStateHandler();
        queueState.registerHandler(queueStateHandler);
        queueStateHandler.setRateLimited(queue.getRateLimit() == 0.0);
        return queueState;
    }

    public String toString() {
        return "Predictor[DLIMIT[?]]";
    }

    @Override
    public boolean isStartArmed(DLIMIT queue, SimQueueState<SimJob, DLIMIT> queueState) {
        return false;
    }

    @Override
    public double getNextQueueEventTimeBeyond(DLIMIT queue, SimQueueState<SimJob, DLIMIT> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        SimQueueRateLimitStateHandler queueStateHandler = (SimQueueRateLimitStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueRateLimitStateHandler");
        if (!queueStateHandler.isRateLimited()) {
            return Double.NaN;
        }
        queueEventTypes.add(RateLimitSimpleEventType.RATE_LIMIT_EXPIRATION);
        return queueStateHandler.getLastDepTime() + 1.0 / queue.getRateLimit();
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(DLIMIT queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, DLIMIT> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, DLIMIT>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueRateLimitStateHandler queueStateHandler = (SimQueueRateLimitStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueRateLimitStateHandler");
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                if (queueState.isQueueAccessVacation()) {
                    queueState.doExits(time, arrivals, null, null, null, visitLogsSet);
                } else if (queueState.getJobs().isEmpty() && !queueStateHandler.isRateLimited()) {
                    queueState.doExits(time, null, null, arrivals, null, visitLogsSet);
                    queueStateHandler.setLastDepTime(time);
                    if (Double.isFinite(queue.getRateLimit())) {
                        queueStateHandler.setRateLimited(true);
                    }
                } else {
                    queueState.doArrivals(time, arrivals, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(DLIMIT queue, SimQueueState<SimJob, DLIMIT> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, DLIMIT>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueRateLimitStateHandler queueStateHandler = (SimQueueRateLimitStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueRateLimitStateHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == RateLimitSimpleEventType.RATE_LIMIT_EXPIRATION) {
                if (!queueState.getJobs().isEmpty()) {
                    Set<SimJob> departures = Collections.singleton(queueState.getJobArrivalsMap().firstEntry().getValue().get(0));
                    queueState.doExits(time, null, null, departures, null, visitLogsSet);
                    queueStateHandler.setLastDepTime(time);
                    queueStateHandler.setRateLimited(true);
                } else {
                    queueStateHandler.setRateLimited(false);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(DLIMIT queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        queueState.setTime(newTime);
    }
}

