/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.DefaultSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.Enc;
import org.javades.jqueues.r5.extensions.composite.SimQueueCompositeStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.DefaultSimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionInvalidInputException;
import org.javades.jqueues.r5.util.predictor.SimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_Enc
extends AbstractSimQueuePredictor<Enc>
implements SimQueuePredictor<Enc> {
    final SimQueuePredictor encQueuePredictor;

    public SimQueuePredictor_Enc(SimQueuePredictor encQueuePredictor) {
        if (encQueuePredictor == null) {
            throw new IllegalArgumentException();
        }
        this.encQueuePredictor = encQueuePredictor;
    }

    public String toString() {
        return "Predictor[Enc[?]]";
    }

    @Override
    public SimQueueState<SimJob, Enc> createQueueState(Enc queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        SimQueue encQueue = queue.getEncapsulatedQueue();
        DefaultSimQueueState encQueueState = (DefaultSimQueueState)this.encQueuePredictor.createQueueState(encQueue, isROEL);
        queueState.registerHandler(new SimQueueCompositeStateHandler(queue.getQueues(), Collections.singleton(encQueueState)));
        return queueState;
    }

    @Override
    public boolean hasServerAccessCredits(Enc queue, SimQueueState<SimJob, Enc> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        return this.encQueuePredictor.hasServerAccessCredits(queue.getEncapsulatedQueue(), queueStateHandler.getSubQueueState(0));
    }

    @Override
    public boolean isStartArmed(Enc queue, SimQueueState<SimJob, Enc> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        return this.encQueuePredictor.isStartArmed(queue.getEncapsulatedQueue(), queueStateHandler.getSubQueueState(0));
    }

    @Override
    public SimQueuePrediction_SQ_SV predict_SQ_SV_ROEL_U(Enc queue, Set<SimJQEvent> queueEvents) throws SimQueuePredictionException {
        if (queue == null || queue.getEncapsulatedQueue() == null) {
            throw new IllegalArgumentException();
        }
        if (queueEvents == null) {
            return new DefaultSimQueuePrediction_SQ_SV<Enc>(queue, Collections.EMPTY_MAP, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        SimQueue encQueue = queue.getEncapsulatedQueue();
        LinkedHashSet<SimJQEvent> encQueueEvents = new LinkedHashSet<SimJQEvent>();
        for (SimJQEvent e : queueEvents) {
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (e.getQueue() == encQueue) {
                throw new IllegalArgumentException();
            }
            if (e.getQueue() != queue) continue;
            double time = e.getTime();
            Object job = e.getJob();
            if (e instanceof SimQueueEvent.QueueAccessVacation) {
                boolean vacation = ((SimQueueEvent.QueueAccessVacation)e).getVacation();
                encQueueEvents.add(new SimQueueEvent.QueueAccessVacation(encQueue, time, vacation));
                continue;
            }
            if (e instanceof SimJQEvent.Arrival) {
                if (!(job instanceof DefaultSimJob)) {
                    throw new UnsupportedOperationException();
                }
                ((DefaultSimJob)job).setRequestedServiceTimeMappingForQueue(encQueue, job.getServiceTime((Enc)queue));
                encQueueEvents.add(new SimJQEvent.Arrival(job, encQueue, time));
                continue;
            }
            if (e instanceof SimJQEvent.Revocation) {
                boolean interruptService = ((SimJQEvent.Revocation)e).isInterruptService();
                encQueueEvents.add(new SimJQEvent.Revocation(job, encQueue, time, interruptService));
                continue;
            }
            if (e instanceof SimQueueEvent.ServerAccessCredits) {
                int credits = ((SimQueueEvent.ServerAccessCredits)e).getCredits();
                encQueueEvents.add(new SimQueueEvent.ServerAccessCredits(encQueue, time, credits));
                continue;
            }
            throw new SimQueuePredictionInvalidInputException();
        }
        SimQueuePrediction_SQ_SV encPrediction = this.encQueuePredictor.predict_SQ_SV_ROEL_U(encQueue, encQueueEvents);
        Map encVisitLogs = encPrediction.getVisitLogs();
        HashMap visitLogs = new HashMap();
        for (Map.Entry entry : encVisitLogs.entrySet()) {
            SimJob j = entry.getKey();
            if (j == null) {
                throw new UnsupportedOperationException();
            }
            JobQueueVisitLog jvl = entry.getValue();
            if (jvl == null) {
                throw new UnsupportedOperationException();
            }
            if (jvl.job != j || jvl.queue != encQueue) {
                throw new RuntimeException();
            }
            visitLogs.put(j, new JobQueueVisitLog<SimJob, Enc>(j, queue, jvl.arrived, jvl.arrivalTime, jvl.sequenceNumber, jvl.started, jvl.startTime, jvl.dropped, jvl.dropTime, jvl.revoked, jvl.revocationTime, jvl.departed, jvl.departureTime));
        }
        List<Map<Double, Boolean>> encQavLog = encPrediction.getQueueAccessVacationLog();
        List<Map<Double, Boolean>> encSacLog = encPrediction.getServerAccessCreditsAvailabilityLog();
        List<Map<Double, Boolean>> encStaLog = encPrediction.getStartArmedLog();
        return new DefaultSimQueuePrediction_SQ_SV<Enc>(queue, visitLogs, encQavLog, encSacLog, encStaLog);
    }

    @Override
    public SimQueuePrediction_SQ_SV predict_SQ_SV_IOEL_U(Enc queue, NavigableMap<Double, Set<SimJQEvent>> workloadEventsMap, NavigableMap<Double, Set<SimJQEvent>> processedEventsMap) throws SimQueuePredictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getNextQueueEventTimeBeyond(Enc queue, SimQueueState<SimJob, Enc> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) throws SimQueuePredictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateToTime(Enc queue, SimQueueState queueState, double newTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(Enc queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, Enc> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, Enc>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(Enc queue, SimQueueState<SimJob, Enc> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, Enc>> visitLogsSet) throws SimQueuePredictionException {
        throw new UnsupportedOperationException();
    }
}

