/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.DefaultSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.EncHS;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite_Enc;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.DefaultSimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionInvalidInputException;
import org.javades.jqueues.r5.util.predictor.SimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_EncHS
extends AbstractSimQueuePredictor_Composite_Enc<EncHS>
implements SimQueuePredictor<EncHS> {
    final SimQueuePredictor encQueuePredictor;

    public SimQueuePredictor_EncHS(AbstractSimQueuePredictor encQueuePredictor) {
        super(encQueuePredictor);
        this.encQueuePredictor = encQueuePredictor;
    }

    public String toString() {
        return "Predictor[EncHS[?]]";
    }

    @Override
    public boolean isStartArmed(EncHS queue, SimQueueState<SimJob, EncHS> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    @Override
    public SimQueuePrediction_SQ_SV predict_SQ_SV_ROEL_U(EncHS queue, Set<SimJQEvent> queueEvents) throws SimQueuePredictionException {
        if (queue == null || queue.getEncapsulatedQueue() == null) {
            throw new IllegalArgumentException();
        }
        if (queueEvents == null) {
            return new DefaultSimQueuePrediction_SQ_SV<EncHS>(queue, Collections.EMPTY_MAP, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        SimQueue encQueue = queue.getEncapsulatedQueue();
        LinkedHashSet<SimJQEvent> encQueueEvents = new LinkedHashSet<SimJQEvent>();
        int compSac = Integer.MAX_VALUE;
        ArrayList<Map<Double, Boolean>> compSacLog = new ArrayList<Map<Double, Boolean>>();
        for (SimJQEvent e : queueEvents) {
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (e.getQueue() == encQueue) {
                throw new IllegalArgumentException();
            }
            if (e.getQueue() != queue) continue;
            double time = e.getTime();
            Object job = e.getJob();
            if (e instanceof SimQueueEvent.QueueAccessVacation) {
                boolean vacation = ((SimQueueEvent.QueueAccessVacation)e).getVacation();
                encQueueEvents.add(new SimQueueEvent.QueueAccessVacation(encQueue, time, vacation));
                continue;
            }
            if (e instanceof SimJQEvent.Arrival) {
                if (!(job instanceof DefaultSimJob)) {
                    throw new UnsupportedOperationException();
                }
                ((DefaultSimJob)job).setRequestedServiceTimeMappingForQueue(encQueue, job.getServiceTime((EncHS)queue));
                encQueueEvents.add(new SimJQEvent.Arrival(job, encQueue, time));
                continue;
            }
            if (e instanceof SimJQEvent.Revocation) {
                encQueueEvents.add(new SimJQEvent.Revocation(job, encQueue, time, true));
                continue;
            }
            if (e instanceof SimQueueEvent.ServerAccessCredits) {
                int oldCredits = compSac;
                int newCredits = ((SimQueueEvent.ServerAccessCredits)e).getCredits();
                if (oldCredits == 0 && newCredits > 0) {
                    compSacLog.add(Collections.singletonMap(time, true));
                }
                if (oldCredits > 0 && newCredits == 0) {
                    compSacLog.add(Collections.singletonMap(time, false));
                }
                compSac = newCredits;
                continue;
            }
            throw new SimQueuePredictionInvalidInputException();
        }
        SimQueuePrediction_SQ_SV encPrediction = this.encQueuePredictor.predict_SQ_SV_ROEL_U(encQueue, encQueueEvents);
        Map encVisitLogs = encPrediction.getVisitLogs();
        HashMap visitLogs = new HashMap();
        for (Map.Entry entry : encVisitLogs.entrySet()) {
            SimJob j = entry.getKey();
            if (j == null) {
                throw new UnsupportedOperationException();
            }
            JobQueueVisitLog jvl = entry.getValue();
            if (jvl == null) {
                throw new UnsupportedOperationException();
            }
            if (jvl.job != j || jvl.queue != encQueue) {
                throw new RuntimeException();
            }
            visitLogs.put(j, new JobQueueVisitLog<SimJob, EncHS>(j, queue, jvl.arrived, jvl.arrivalTime, jvl.sequenceNumber, false, Double.NaN, jvl.dropped, jvl.dropTime, jvl.revoked, jvl.revocationTime, jvl.departed, jvl.departureTime));
        }
        List<Map<Double, Boolean>> encQavLog = encPrediction.getQueueAccessVacationLog();
        List<Map<Double, Boolean>> encSacLog = encPrediction.getServerAccessCreditsAvailabilityLog();
        if (!encSacLog.isEmpty()) {
            throw new IllegalStateException();
        }
        List<Map<Double, Boolean>> encStaLog = encPrediction.getStartArmedLog();
        return new DefaultSimQueuePrediction_SQ_SV<EncHS>(queue, visitLogs, encQavLog, compSacLog, Collections.EMPTY_LIST);
    }

    @Override
    public SimQueuePrediction_SQ_SV predict_SQ_SV_IOEL_U(EncHS queue, NavigableMap<Double, Set<SimJQEvent>> workloadEventsMap, NavigableMap<Double, Set<SimJQEvent>> processedEventsMap) throws SimQueuePredictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(EncHS queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, EncHS> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, EncHS>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(EncHS queue, SimQueueState<SimJob, EncHS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, EncHS>> visitLogsSet) throws SimQueuePredictionException {
        throw new UnsupportedOperationException();
    }
}

