/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.EncJL;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite_Enc;
import org.javades.jqueues.r5.extensions.composite.SimQueueCompositeStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_EncJL
extends AbstractSimQueuePredictor_Composite_Enc<EncJL>
implements SimQueuePredictor<EncJL> {
    final AbstractSimQueuePredictor encQueuePredictor;

    public SimQueuePredictor_EncJL(AbstractSimQueuePredictor encQueuePredictor) {
        super(encQueuePredictor);
        this.encQueuePredictor = encQueuePredictor;
    }

    public String toString() {
        return "Predictor[EncJL[?]]";
    }

    @Override
    public boolean isStartArmed(EncJL queue, SimQueueState<SimJob, EncJL> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        return !(!this.encQueuePredictor.isStartArmed(queue.getEncapsulatedQueue(), queueStateHandler.getSubQueueState(0)) || queue.getMaxJobs() != Integer.MAX_VALUE && queueState.getJobs().size() >= queue.getMaxJobs() || queue.getMaxJobsInServiceArea() != Integer.MAX_VALUE && queueState.getJobsInServiceArea().size() >= queue.getMaxJobsInServiceArea());
    }

    private void setServerAccessCreditsOnEncQueue(EncJL queue, SimQueueState<SimJob, EncJL> queueState, SimQueue subQueue, SimQueueState subQueueState, Set<JobQueueVisitLog<SimJob, EncJL>> visitLogsSet) throws SimQueuePredictionException {
        int sacRequired = Integer.MAX_VALUE;
        if (queue.getMaxJobsInServiceArea() < Integer.MAX_VALUE) {
            sacRequired = queue.getMaxJobsInServiceArea() - subQueueState.getJobsInServiceArea().size();
        }
        if (queueState.getServerAccessCredits() < Integer.MAX_VALUE && queueState.getServerAccessCredits() < sacRequired) {
            sacRequired = queueState.getServerAccessCredits();
        }
        if (subQueueState.getServerAccessCredits() != sacRequired) {
            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent encQueueSacEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(subQueue, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, sacRequired);
            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, (Set<SimEntitySimpleEventType.Member>)new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(encQueueSacEvent)), visitLogsSet);
        }
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(EncJL queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, EncJL> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, EncJL>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimQueue subQueue = queue.getEncapsulatedQueue();
        DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(0);
        this.setServerAccessCreditsOnEncQueue(queue, queueState, subQueue, subQueueState, visitLogsSet);
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType == SimQueueSimpleEventType.ARRIVAL) {
            SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
            boolean mustDrop = queue.getMaxJobs() == 0;
            boolean bl = mustDrop = mustDrop || queue.getMaxJobsInWaitingArea() < Integer.MAX_VALUE && subQueueState.getJobsInWaitingArea().size() == queue.getMaxJobsInWaitingArea() && (!this.subQueuePredictor.isStartArmed(subQueue, subQueueState) || !subQueueState.getJobsInWaitingArea().isEmpty() || subQueueState.getServerAccessCredits() <= 0);
            if (mustDrop) {
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (queueState.getJobs().contains(job)) {
                    queueState.doExits(time, arrivals, null, null, null, visitLogsSet);
                }
                workloadEventTypes.remove(eventType);
            } else {
                super.doWorkloadEvents_SQ_SV_ROEL_U(queue, workloadSchedule, queueState, workloadEventTypes, visitLogsSet);
            }
        } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
            int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
            queueState.setServerAccessCredits(time, newSac);
            this.setServerAccessCreditsOnEncQueue(queue, queueState, subQueue, subQueueState, visitLogsSet);
        } else {
            super.doWorkloadEvents_SQ_SV_ROEL_U(queue, workloadSchedule, queueState, workloadEventTypes, visitLogsSet);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(EncJL queue, SimQueueState<SimJob, EncJL> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, EncJL>> visitLogsSet) throws SimQueuePredictionException {
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimQueue subQueue = queue.getEncapsulatedQueue();
        DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(0);
        SimEntitySimpleEventType.Member eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        super.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, queueEventTypes, visitLogsSet);
        if (eventType != null) {
            this.setServerAccessCreditsOnEncQueue(queue, queueState, subQueue, subQueueState, visitLogsSet);
        }
    }
}

