/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.DefaultSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.EncTL;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite_Enc;
import org.javades.jqueues.r5.extensions.composite.SimQueueCompositeStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_EncTL
extends AbstractSimQueuePredictor_Composite_Enc<EncTL>
implements SimQueuePredictor<EncTL> {
    final AbstractSimQueuePredictor encQueuePredictor;

    public SimQueuePredictor_EncTL(AbstractSimQueuePredictor encQueuePredictor) {
        super(encQueuePredictor);
        this.encQueuePredictor = encQueuePredictor;
    }

    public String toString() {
        return "Predictor[EncTL[?]]";
    }

    @Override
    public boolean hasServerAccessCredits(EncTL queue, SimQueueState<SimJob, EncTL> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        return this.encQueuePredictor.hasServerAccessCredits(queue.getEncapsulatedQueue(), queueStateHandler.getSubQueueState(0));
    }

    @Override
    public boolean isStartArmed(EncTL queue, SimQueueState<SimJob, EncTL> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        return this.encQueuePredictor.isStartArmed(queue.getEncapsulatedQueue(), queueStateHandler.getSubQueueState(0));
    }

    @Override
    public double getNextQueueEventTimeBeyond(EncTL queue, SimQueueState<SimJob, EncTL> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) throws SimQueuePredictionException {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double encTime = super.getNextQueueEventTimeBeyond(queue, queueState, queueEventTypes);
        if (queueState.getJobs().isEmpty()) {
            return encTime;
        }
        double schedTime = encTime;
        LinkedHashSet<SimJob> expJobs = null;
        if (!Double.isInfinite(queue.getMaxWaitingTime()) && !queueState.getJobsInWaitingArea().isEmpty() && (Double.isNaN(schedTime) || queueState.getArrivalTimesMap().get(queueState.getJobsInWaitingAreaOrdered().iterator().next()) + queue.getMaxWaitingTime() < schedTime)) {
            schedTime = queueState.getArrivalTimesMap().get(queueState.getJobsInWaitingAreaOrdered().iterator().next()) + queue.getMaxWaitingTime();
            expJobs = new LinkedHashSet<SimJob>();
            for (SimJob job : queueState.getJobsInWaitingAreaOrdered()) {
                if (queueState.getArrivalTimesMap().get(job) + queue.getMaxWaitingTime() < schedTime) {
                    throw new RuntimeException();
                }
                if (queueState.getArrivalTimesMap().get(job) + queue.getMaxWaitingTime() == schedTime) {
                    expJobs.add(job);
                    continue;
                }
                if (!expJobs.isEmpty()) break;
                throw new RuntimeException();
            }
        }
        if (!Double.isInfinite(queue.getMaxServiceTime()) && !queueState.getJobsInServiceArea().isEmpty() && (Double.isNaN(schedTime) || (Double)queueState.getJobsInServiceAreaMap().firstKey() + queue.getMaxServiceTime() < schedTime)) {
            schedTime = (Double)queueState.getJobsInServiceAreaMap().firstKey() + queue.getMaxServiceTime();
            expJobs = new LinkedHashSet(queueState.getJobsInServiceAreaMap().firstEntry().getValue());
        }
        if (!Double.isInfinite(queue.getMaxSojournTime()) && !queueState.getJobs().isEmpty() && (Double.isNaN(schedTime) || (Double)queueState.getJobArrivalsMap().firstKey() + queue.getMaxSojournTime() < schedTime)) {
            schedTime = (Double)queueState.getJobArrivalsMap().firstKey() + queue.getMaxSojournTime();
            expJobs = new LinkedHashSet(queueState.getJobArrivalsMap().firstEntry().getValue());
        }
        if (expJobs != null) {
            queueEventTypes.clear();
            queueEventTypes.add(new ForcedDeparture("FORCED_DEPARTURE", expJobs));
        }
        return schedTime;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(EncTL queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, EncTL> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, EncTL>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimQueue subQueue = queue.getEncapsulatedQueue();
        DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(0);
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType == SimQueueSimpleEventType.ARRIVAL && (queue.getMaxSojournTime() == 0.0 || queue.getMaxWaitingTime() == 0.0 && !this.subQueuePredictor.isStartArmed(subQueue, subQueueState) && subQueueState.getJobsInWaitingArea().isEmpty() && subQueueState.getServerAccessCredits() > 0)) {
            SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
            HashSet<SimJob> arrivals = new HashSet<SimJob>();
            arrivals.add(job);
            queueState.doArrivals(time, arrivals, visitLogsSet);
            if (queueState.getJobs().contains(job)) {
                queueState.doExits(time, null, null, arrivals, null, visitLogsSet);
            }
            workloadEventTypes.remove(eventType);
        } else {
            super.doWorkloadEvents_SQ_SV_ROEL_U(queue, workloadSchedule, queueState, workloadEventTypes, visitLogsSet);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(EncTL queue, SimQueueState<SimJob, EncTL> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, EncTL>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null && eventType instanceof ForcedDeparture) {
            Set jobs = ((ForcedDeparture)eventType).jobs;
            for (SimJob job : jobs) {
                SimQueue encQueue = (SimQueue)queue.getQueues().iterator().next();
                if (!(job instanceof DefaultSimJob)) {
                    throw new UnsupportedOperationException();
                }
                AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent encQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(encQueue, SimQueueSimpleEventType.REVOCATION, null, job, true);
                this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, (Set<SimEntitySimpleEventType.Member>)new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(encQueueEvent)), (Set<JobQueueVisitLog<SimJob, EncTL>>)new HashSet<JobQueueVisitLog<SimJob, EncTL>>());
            }
            this.departJobs(time, queue, queueState, jobs, visitLogsSet);
        } else {
            super.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, queueEventTypes, visitLogsSet);
        }
    }

    private static class ForcedDeparture
    extends SimEntitySimpleEventType.Member {
        private final Set<SimJob> jobs;

        public ForcedDeparture(String name, Set<SimJob> jobs) {
            super(name);
            if (jobs == null || jobs.isEmpty() || jobs.contains(null)) {
                throw new IllegalArgumentException();
            }
            this.jobs = jobs;
        }
    }
}

