/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_FCFS
extends AbstractSimQueuePredictor<SimQueue> {
    final boolean hasB;
    final int B;
    final boolean hasc;
    final int c;
    final boolean useLifo;

    protected SimQueuePredictor_FCFS(boolean hasB, int B, boolean hasc, int c, boolean useLifo) {
        if (hasB && B < 0) {
            throw new IllegalArgumentException();
        }
        if (hasc && c < 0) {
            throw new IllegalArgumentException();
        }
        this.hasB = hasB;
        this.B = B;
        this.hasc = hasc;
        this.c = c;
        this.useLifo = useLifo;
    }

    protected SimQueuePredictor_FCFS(boolean hasB, int B, boolean hasc, int c) {
        this(hasB, B, hasc, c, false);
    }

    public SimQueuePredictor_FCFS() {
        this(false, 0, true, 1);
    }

    public String toString() {
        return "Predictor[FCFS]";
    }

    @Override
    public boolean isStartArmed(SimQueue queue, SimQueueState<SimJob, SimQueue> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (this.hasc) {
            return queueState.getJobsInServiceArea().size() < this.c;
        }
        return true;
    }

    @Override
    public double getNextQueueEventTimeBeyond(SimQueue queue, SimQueueState<SimJob, SimQueue> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        int numberOfJobsInServiceArea = queueState.getJobRemainingServiceTimeMap().size();
        if (numberOfJobsInServiceArea == 0) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        if (this.hasc && numberOfJobsInServiceArea > this.c) {
            throw new IllegalStateException();
        }
        if (queueState.getStartTimesMap().isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.hasc && queueState.getStartTimesMap().size() > this.c) {
            throw new IllegalStateException();
        }
        double minDepartureTime = Double.NaN;
        for (Map.Entry<SimJob, Double> jobInServiceAreaEntry : queueState.getStartTimesMap().entrySet()) {
            SimJob jobInServiceArea = jobInServiceAreaEntry.getKey();
            double remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(jobInServiceArea);
            if (!Double.isFinite(remainingServiceTime)) continue;
            double departureTime = time + remainingServiceTime;
            if (departureTime < time) {
                throw new RuntimeException();
            }
            if (!Double.isNaN(minDepartureTime) && !(departureTime < minDepartureTime)) continue;
            minDepartureTime = departureTime;
        }
        if (!Double.isNaN(minDepartureTime)) {
            queueEventTypes.add(SimQueueSimpleEventType.DEPARTURE);
        }
        return minDepartureTime;
    }

    protected SimJob getJobToStart(SimQueue queue, SimQueueState<SimJob, SimQueue> queueState) throws SimQueuePredictionException {
        if (this.useLifo) {
            ArrayList<SimJob> waitingJobs = new ArrayList<SimJob>(queueState.getJobsInWaitingAreaOrdered());
            return waitingJobs.get(waitingJobs.size() - 1);
        }
        return queueState.getJobsInWaitingAreaOrdered().iterator().next();
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(SimQueue queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, SimQueue> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, SimQueue>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                if (queueState.isQueueAccessVacation()) {
                    queueState.doArrivals(time, arrivals, visitLogsSet);
                } else {
                    if (this.hasB && queueState.getJobsInWaitingArea().size() > this.B) {
                        throw new IllegalStateException();
                    }
                    if (this.hasB && queueState.getJobsInWaitingArea().size() == this.B && (queueState.getServerAccessCredits() <= 0 || this.hasc && queueState.getJobsInServiceArea().size() >= this.c)) {
                        if (this.useLifo && !queueState.getJobsInWaitingArea().isEmpty()) {
                            queueState.doArrivals(time, arrivals, visitLogsSet);
                            SimJob jobToDrop = queueState.getJobsInWaitingAreaOrdered().iterator().next();
                            queueState.doExits(time, Collections.singleton(jobToDrop), null, null, null, visitLogsSet);
                        } else {
                            queueState.doExits(time, arrivals, null, null, null, visitLogsSet);
                        }
                    } else {
                        queueState.doArrivals(time, arrivals, visitLogsSet);
                        if (!(this.hasc && queueState.getJobsInServiceArea().size() >= this.c || queueState.getServerAccessCredits() < 1)) {
                            double remainingServiceTime;
                            queueState.doStarts(time, arrivals);
                            if (queueState.getJobs().contains(job) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(job).doubleValue()) == 0.0) {
                                queueState.doExits(time, null, null, arrivals, null, visitLogsSet);
                            }
                        }
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    boolean interruptService = (Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job);
                    boolean isJobInServiceArea = queueState.getJobsInServiceArea().contains(job);
                    if (interruptService || !isJobInServiceArea) {
                        int sac;
                        HashSet<SimJob> revocations = new HashSet<SimJob>();
                        revocations.add(job);
                        queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                        if (isJobInServiceArea && (sac = queueState.getServerAccessCredits()) > 0 && queueState.getJobsInWaitingArea().size() > 0) {
                            LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                            starters.add(this.getJobToStart(queue, queueState));
                            queueState.doStarts(time, starters);
                        }
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int sac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, sac);
                while (!(queueState.getJobsInWaitingArea().size() <= 0 || sac <= 0 || this.hasc && queueState.getJobsInServiceArea().size() >= this.c)) {
                    double remainingServiceTime;
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    SimJob jobToStart = this.getJobToStart(queue, queueState);
                    starters.add(jobToStart);
                    queueState.doStarts(time, starters);
                    if (sac < Integer.MAX_VALUE) {
                        --sac;
                    }
                    if (!queueState.getJobs().contains(jobToStart) || (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(jobToStart).doubleValue()) != 0.0) continue;
                    queueState.doExits(time, null, null, starters, null, visitLogsSet);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(SimQueue queue, SimQueueState<SimJob, SimQueue> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, SimQueue>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                if (queueState.getJobsInServiceArea().size() < 1) {
                    throw new IllegalStateException();
                }
                if (this.hasc && queueState.getJobsInServiceArea().size() > this.c) {
                    throw new IllegalStateException();
                }
                HashSet departures = new HashSet(queueState.getRemainingServiceMap().firstEntry().getValue());
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
                int sac = queueState.getServerAccessCredits();
                if (sac > 0 && queueState.getJobsInWaitingArea().size() > 0) {
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    starters.add(this.getJobToStart(queue, queueState));
                    queueState.doStarts(time, starters);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(SimQueue queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
            NavigableMap rsMap = queueState.getRemainingServiceMap();
            if (dT > 0.0 && !rsTimeMap.isEmpty()) {
                rsMap.clear();
                double dS = dT;
                for (SimJob job : new HashSet(rsTimeMap.keySet())) {
                    double newRs = rsTimeMap.get(job) - dS;
                    rsTimeMap.put(job, newRs);
                    if (!rsMap.containsKey(newRs)) {
                        rsMap.put(newRs, new ArrayList());
                    }
                    ((List)rsMap.get(newRs)).add(job);
                }
            }
        }
        queueState.setTime(newTime);
    }
}

