/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.qos.HOL_PS;
import org.javades.jqueues.r5.extensions.qos.SimQueueQoSStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_HOL_PS<J extends SimJob, Q extends HOL_PS, P>
extends AbstractSimQueuePredictor<HOL_PS> {
    @Override
    public SimQueueState<SimJob, HOL_PS> createQueueState(HOL_PS queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        queueState.registerHandler(new SimQueueQoSStateHandler(false));
        return queueState;
    }

    public String toString() {
        return "Predictor[HOL-PS]";
    }

    @Override
    public boolean isStartArmed(HOL_PS queue, SimQueueState<SimJob, HOL_PS> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return queueState.getJobs().isEmpty();
    }

    @Override
    public double getNextQueueEventTimeBeyond(HOL_PS queue, SimQueueState<SimJob, HOL_PS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        int numberOfJobsExecuting = queueState.getJobRemainingServiceTimeMap().size();
        if (numberOfJobsExecuting == 0) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        double smallestRs = (Double)queueState.getRemainingServiceMap().firstKey();
        if (smallestRs < 0.0) {
            throw new RuntimeException();
        }
        if (Double.isFinite(smallestRs)) {
            queueEventTypes.add(SimQueueSimpleEventType.DEPARTURE);
            return time + smallestRs * (double)numberOfJobsExecuting;
        }
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(HOL_PS queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, HOL_PS> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, HOL_PS>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueQoSStateHandler queueStateHandler = (SimQueueQoSStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueQoSHandler");
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                Object qos;
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                queueStateHandler.updateJobsQoSMap();
                Object defaultQoS = queue.getDefaultJobQoS();
                if (defaultQoS == null) {
                    throw new IllegalStateException();
                }
                Object object = qos = job.getQoS() == null ? defaultQoS : job.getQoS();
                if (!queueState.isQueueAccessVacation() && queueState.getServerAccessCredits() >= 1 && queueStateHandler.getJobsQoSMap().get(qos).size() == 1) {
                    double remainingServiceTime;
                    queueState.doStarts(time, arrivals);
                    if (queueState.getJobs().contains(job) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(job).doubleValue()) == 0.0) {
                        queueState.doExits(time, null, null, arrivals, null, visitLogsSet);
                        queueStateHandler.updateJobsQoSMap();
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    boolean interruptService = (Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job);
                    boolean jobInService = queueState.getJobsInServiceArea().contains(job);
                    if (interruptService || !jobInService) {
                        HashSet<SimJob> revocations = new HashSet<SimJob>();
                        revocations.add(job);
                        queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                        queueStateHandler.updateJobsQoSMap();
                        if (jobInService && queueState.getServerAccessCredits() >= 1) {
                            Object qos;
                            Object defaultQoS = queue.getDefaultJobQoS();
                            if (defaultQoS == null) {
                                throw new IllegalStateException();
                            }
                            Object object = qos = job.getQoS() == null ? defaultQoS : job.getQoS();
                            if (queueStateHandler.getJobsQoSMap().containsKey(qos)) {
                                double remainingServiceTime;
                                SimJob starter = (SimJob)queueStateHandler.getJobsQoSMap().get(qos).iterator().next();
                                HashSet<SimJob> starters = new HashSet<SimJob>();
                                starters.add(starter);
                                queueState.doStarts(time, starters);
                                if (queueState.getJobs().contains(starter) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(starter).doubleValue()) == 0.0) {
                                    queueState.doExits(time, null, null, starters, null, visitLogsSet);
                                    queueStateHandler.updateJobsQoSMap();
                                }
                            }
                        }
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                boolean tryToStart;
                queueState.setServerAccessCredits(time, (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time));
                Object defaultQoS = queue.getDefaultJobQoS();
                if (defaultQoS == null) {
                    throw new IllegalStateException();
                }
                boolean bl = tryToStart = queueState.getJobsInWaitingArea().size() > 0;
                block0: while (queueState.getServerAccessCredits() > 0 && tryToStart) {
                    tryToStart = false;
                    for (SimJob job : queueState.getJobsInWaitingAreaOrdered()) {
                        double remainingServiceTime;
                        Object qos;
                        Object object = qos = job.getQoS() == null ? defaultQoS : job.getQoS();
                        if (queueStateHandler.getJobsQoSMap().get(qos).iterator().next() != job) continue;
                        LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                        starters.add(job);
                        queueState.doStarts(time, starters);
                        if (queueState.getJobs().contains(job) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(job).doubleValue()) == 0.0) {
                            queueState.doExits(time, null, null, starters, null, visitLogsSet);
                            queueStateHandler.updateJobsQoSMap();
                        }
                        tryToStart = true;
                        continue block0;
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(HOL_PS queue, SimQueueState<SimJob, HOL_PS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, HOL_PS>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueQoSStateHandler queueStateHandler = (SimQueueQoSStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueQoSHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                HashSet departures = new HashSet(queueState.getRemainingServiceMap().firstEntry().getValue());
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
                queueStateHandler.updateJobsQoSMap();
                if (queueState.getServerAccessCredits() >= 1) {
                    Object qos;
                    if (departures.size() > 1) {
                        throw new SimQueuePredictionAmbiguityException();
                    }
                    SimJob job = (SimJob)departures.iterator().next();
                    Object defaultQoS = queue.getDefaultJobQoS();
                    if (defaultQoS == null) {
                        throw new IllegalStateException();
                    }
                    Object object = qos = job.getQoS() == null ? defaultQoS : job.getQoS();
                    if (queueStateHandler.getJobsQoSMap().containsKey(qos)) {
                        double remainingServiceTime;
                        SimJob starter = (SimJob)queueStateHandler.getJobsQoSMap().get(qos).iterator().next();
                        HashSet<SimJob> starters = new HashSet<SimJob>();
                        starters.add(starter);
                        queueState.doStarts(time, starters);
                        if (queueState.getJobs().contains(starter) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(starter).doubleValue()) == 0.0) {
                            queueState.doExits(time, null, null, starters, null, visitLogsSet);
                            queueStateHandler.updateJobsQoSMap();
                        }
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(HOL_PS queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
            NavigableMap rsMap = queueState.getRemainingServiceMap();
            if (dT > 0.0 && !rsTimeMap.isEmpty()) {
                rsMap.clear();
                double dS = dT / (double)rsTimeMap.keySet().size();
                for (SimJob job : new HashSet(rsTimeMap.keySet())) {
                    double newRs = rsTimeMap.get(job) - dS;
                    rsTimeMap.put(job, newRs);
                    if (!rsMap.containsKey(newRs)) {
                        rsMap.put(newRs, new ArrayList());
                    }
                    ((List)rsMap.get(newRs)).add(job);
                }
            }
        }
        queueState.setTime(newTime);
    }
}

