/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.P_LCFS;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionComplexityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.queues.SimQueuePredictor_Preemptive;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_P_LCFS
extends SimQueuePredictor_Preemptive<P_LCFS> {
    public String toString() {
        return "Predictor[P_LCFS[?]]";
    }

    @Override
    public boolean isStartArmed(P_LCFS queue, SimQueueState<SimJob, P_LCFS> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    protected SimJob getExecutingJob(P_LCFS queue, SimQueueState<SimJob, P_LCFS> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (queueState.getJobsInServiceArea().isEmpty()) {
            return null;
        }
        ArrayList<SimJob> jobs = new ArrayList<SimJob>(queueState.getJobs());
        for (int i = jobs.size() - 1; i >= 0; --i) {
            SimJob job = (SimJob)jobs.get(i);
            if (!queueState.getJobsInServiceArea().contains(job)) continue;
            return job;
        }
        throw new IllegalStateException();
    }

    @Override
    public double getNextQueueEventTimeBeyond(P_LCFS queue, SimQueueState<SimJob, P_LCFS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        if (queueState.getRemainingServiceMap().isEmpty()) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimJob executingJob = this.getExecutingJob(queue, queueState);
        double rs = queueState.getJobRemainingServiceTimeMap().get(executingJob);
        if (rs < 0.0) {
            throw new RuntimeException();
        }
        if (Double.isFinite(rs)) {
            queueEventTypes.add(SimQueueSimpleEventType.DEPARTURE);
            return time + rs;
        }
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(P_LCFS queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, P_LCFS> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, P_LCFS>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (!queueState.isQueueAccessVacation() && queueState.getServerAccessCredits() >= 1) {
                    SimJob executingJob = this.getExecutingJob(queue, queueState);
                    queueState.doStarts(time, arrivals);
                    if (executingJob != null) {
                        this.preemptJob(queue, queueState, executingJob, visitLogsSet);
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                boolean interruptService;
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job) && ((interruptService = ((Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job)).booleanValue()) || !queueState.getJobsInServiceArea().contains(job))) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                if (oldSac == 0 && newSac > 0 && !queueState.getJobsInWaitingArea().isEmpty()) {
                    ArrayList<SimJob> waiters = new ArrayList<SimJob>(queueState.getJobsInWaitingAreaOrdered());
                    SimJob youngestWaiter = null;
                    while (newSac > 0 && !waiters.isEmpty()) {
                        youngestWaiter = (SimJob)waiters.remove(waiters.size() - 1);
                        if (newSac < Integer.MAX_VALUE) {
                            --newSac;
                        }
                        Set<SimJob> starters = Collections.singleton(youngestWaiter);
                        SimJob executingJob = this.getExecutingJob(queue, queueState);
                        queueState.doStarts(time, starters);
                        if (queueState.getJobs().contains(youngestWaiter)) {
                            if (executingJob != null && !(queueState.getArrivalTimesMap().get(youngestWaiter) >= queueState.getArrivalTimesMap().get(executingJob))) continue;
                            double remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(youngestWaiter);
                            if (remainingServiceTime == 0.0) {
                                queueState.doExits(time, null, null, starters, null, visitLogsSet);
                            }
                            if (executingJob == null) continue;
                            this.preemptJob(queue, queueState, executingJob, visitLogsSet);
                            continue;
                        }
                        if (queueState.getJobs().isEmpty()) continue;
                        throw new SimQueuePredictionComplexityException();
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(P_LCFS queue, SimQueueState<SimJob, P_LCFS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, P_LCFS>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                SimJob youngestWaiter;
                HashSet<SimJob> departures = new HashSet<SimJob>();
                SimJob departingJob = this.getExecutingJob(queue, queueState);
                departures.add(departingJob);
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
                SimJob executingJob = this.getExecutingJob(queue, queueState);
                if (!queueState.getJobsInWaitingArea().isEmpty() && queueState.getServerAccessCredits() > 0) {
                    ArrayList<SimJob> waiters = new ArrayList<SimJob>(queueState.getJobsInWaitingAreaOrdered());
                    youngestWaiter = (SimJob)waiters.get(waiters.size() - 1);
                } else {
                    youngestWaiter = null;
                }
                if (youngestWaiter != null && (executingJob == null || queueState.getArrivalTimesMap().get(youngestWaiter) >= queueState.getArrivalTimesMap().get(executingJob))) {
                    double remainingServiceTime;
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    starters.add(youngestWaiter);
                    queueState.doStarts(time, starters);
                    if (queueState.getJobs().contains(youngestWaiter) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(youngestWaiter).doubleValue()) == 0.0) {
                        this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, queueEventTypes, visitLogsSet);
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        queueEventTypes.remove(eventType);
    }

    @Override
    public void updateToTime(P_LCFS queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
            NavigableMap rsMap = queueState.getRemainingServiceMap();
            if (dT > 0.0 && !rsTimeMap.isEmpty()) {
                SimJob executingJob = this.getExecutingJob(queue, queueState);
                double dS = dT;
                double oldRs = rsTimeMap.get(executingJob);
                double newRs = oldRs - dS;
                rsTimeMap.put(executingJob, newRs);
                if (!rsMap.containsKey(oldRs)) {
                    throw new IllegalStateException();
                }
                if (((List)rsMap.get(oldRs)).size() == 1) {
                    rsMap.put(newRs, rsMap.get(oldRs));
                    rsMap.remove(oldRs);
                } else {
                    ((List)rsMap.get(oldRs)).remove(0);
                    rsMap.put(newRs, new ArrayList());
                    ((List)rsMap.get(newRs)).add(executingJob);
                }
            }
        }
        queueState.setTime(newTime);
    }
}

