/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.AbstractPreemptiveSimQueue;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;

public abstract class SimQueuePredictor_Preemptive<Q extends AbstractPreemptiveSimQueue>
extends AbstractSimQueuePredictor<Q> {
    protected void preemptJob(Q queue, SimQueueState<SimJob, Q> queueState, SimJob executingJob, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        if (queue == null || queueState == null || executingJob == null) {
            throw new IllegalArgumentException();
        }
        double time = queueState.getTime();
        Map<SimJob, Double> rsTimeMap = queueState.getJobRemainingServiceTimeMap();
        NavigableMap<Double, List<SimJob>> rsMap = queueState.getRemainingServiceMap();
        switch (((AbstractPreemptiveSimQueue)queue).getPreemptionStrategy()) {
            case DROP: {
                HashSet<SimJob> drops = new HashSet<SimJob>();
                SimJob droppedJob = executingJob;
                drops.add(droppedJob);
                queueState.doExits(time, drops, null, null, null, visitLogsSet);
                break;
            }
            case RESUME: {
                break;
            }
            case RESTART: {
                double oldRs = rsTimeMap.get(executingJob);
                double newRs = executingJob.getServiceTime(queue);
                rsTimeMap.put(executingJob, newRs);
                ((List)rsMap.get(oldRs)).remove(executingJob);
                if (((List)rsMap.get(oldRs)).isEmpty()) {
                    rsMap.remove(oldRs);
                }
                if (rsMap.containsKey(newRs)) {
                    double startTime = queueState.getStartTimesMap().get(executingJob);
                    List equalRsJobs = (List)rsMap.get(newRs);
                    int indexToInsert = 0;
                    for (SimJob equalRsJob : equalRsJobs) {
                        double equalRsJobStartTime = queueState.getStartTimesMap().get(equalRsJob);
                        if (equalRsJobStartTime < startTime) {
                            ++indexToInsert;
                            continue;
                        }
                        if (equalRsJobStartTime != startTime) break;
                        throw new SimQueuePredictionAmbiguityException();
                    }
                    ((List)rsMap.get(newRs)).add(indexToInsert, executingJob);
                    break;
                }
                rsMap.put(newRs, new ArrayList());
                ((List)rsMap.get(newRs)).add(executingJob);
                break;
            }
            case REDRAW: {
                throw new UnsupportedOperationException();
            }
            case DEPART: {
                HashSet<SimJob> departures = new HashSet<SimJob>();
                SimJob departingJob = executingJob;
                departures.add(departingJob);
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
                break;
            }
            case CUSTOM: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

