/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.serverless.SINK;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_SINK
extends AbstractSimQueuePredictor<SINK> {
    public String toString() {
        return "Predictor[SINK]";
    }

    @Override
    public boolean isStartArmed(SINK queue, SimQueueState<SimJob, SINK> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    @Override
    public double getNextQueueEventTimeBeyond(SINK queue, SimQueueState<SimJob, SINK> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(SINK queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, SINK> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, SINK>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(SINK queue, SimQueueState<SimJob, SINK> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, SINK>> visitLogsSet) throws SimQueuePredictionException {
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        throw new IllegalStateException();
    }

    @Override
    public void updateToTime(SINK queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        queueState.setTime(newTime);
    }
}

