/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.SRTF;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.queues.SimQueuePredictor_Preemptive;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_SRTF
extends SimQueuePredictor_Preemptive<SRTF> {
    public String toString() {
        return "Predictor[SRTF[?]]";
    }

    @Override
    public boolean isStartArmed(SRTF queue, SimQueueState<SimJob, SRTF> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    @Override
    public double getNextQueueEventTimeBeyond(SRTF queue, SimQueueState<SimJob, SRTF> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        if (queueState.getRemainingServiceMap().isEmpty()) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        double smallestRs = (Double)queueState.getRemainingServiceMap().firstKey();
        if (smallestRs < 0.0) {
            throw new RuntimeException();
        }
        if (Double.isFinite(smallestRs)) {
            queueEventTypes.add(SimQueueSimpleEventType.DEPARTURE);
            return time + smallestRs;
        }
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(SRTF queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, SRTF> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, SRTF>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimJob executingJob;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        Map<SimJob, Double> rsTimeMap = queueState.getJobRemainingServiceTimeMap();
        NavigableMap<Double, List<SimJob>> rsMap = queueState.getRemainingServiceMap();
        SimJob simJob = executingJob = rsMap.isEmpty() ? null : rsMap.firstEntry().getValue().get(0);
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (!queueState.isQueueAccessVacation() && queueState.getServerAccessCredits() >= 1) {
                    queueState.doStarts(time, arrivals);
                    if (queueState.getJobs().contains(job) && executingJob != null && rsMap.firstEntry().getValue().get(0) != executingJob) {
                        this.preemptJob(queue, queueState, executingJob, visitLogsSet);
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                boolean interruptService;
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job) && ((interruptService = ((Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job)).booleanValue()) || !queueState.getJobsInServiceArea().contains(job))) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                if (oldSac == 0 && newSac > 0) {
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    Iterator<SimJob> i_waiters = queueState.getJobsInWaitingAreaOrdered().iterator();
                    int remainingSac = newSac;
                    while ((remainingSac == Integer.MAX_VALUE || remainingSac > 0) && i_waiters.hasNext()) {
                        starters.add(i_waiters.next());
                        if (remainingSac == Integer.MAX_VALUE) continue;
                        --remainingSac;
                    }
                    queueState.doStarts(time, starters);
                    if (executingJob != null && rsMap.firstEntry().getValue().get(0) != executingJob) {
                        this.preemptJob(queue, queueState, executingJob, visitLogsSet);
                    }
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(SRTF queue, SimQueueState<SimJob, SRTF> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, SRTF>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                HashSet<SimJob> departures = new HashSet<SimJob>();
                SimJob departingJob = queueState.getRemainingServiceMap().firstEntry().getValue().get(0);
                departures.add(departingJob);
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(SRTF queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
            NavigableMap rsMap = queueState.getRemainingServiceMap();
            if (dT > 0.0 && !rsTimeMap.isEmpty()) {
                SimJob executingJob = (SimJob)rsMap.firstEntry().getValue().get(0);
                double dS = dT;
                double oldRs = rsTimeMap.get(executingJob);
                double newRs = oldRs - dS;
                rsTimeMap.put(executingJob, newRs);
                if (!rsMap.containsKey(oldRs)) {
                    throw new IllegalStateException();
                }
                if (((List)rsMap.get(oldRs)).size() == 1) {
                    rsMap.put(newRs, rsMap.get(oldRs));
                    rsMap.remove(oldRs);
                } else {
                    ((List)rsMap.get(oldRs)).remove(0);
                    rsMap.put(newRs, new ArrayList());
                    ((List)rsMap.get(newRs)).add(executingJob);
                }
            }
        }
        queueState.setTime(newTime);
    }
}

