/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.SocPS;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_SocPS
extends AbstractSimQueuePredictor<SocPS> {
    public String toString() {
        return "Predictor[SocPS]";
    }

    @Override
    public boolean isStartArmed(SocPS queue, SimQueueState<SimJob, SocPS> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    @Override
    public double getNextQueueEventTimeBeyond(SocPS queue, SimQueueState<SimJob, SocPS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        int numberOfJobsExecuting = queueState.getJobRemainingServiceTimeMap().size();
        if (numberOfJobsExecuting == 0) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        double totalWork = 0.0;
        for (double work_j : queueState.getJobRemainingServiceTimeMap().values()) {
            totalWork += work_j;
        }
        if (totalWork < 0.0) {
            throw new RuntimeException();
        }
        if (Double.isFinite(totalWork)) {
            queueEventTypes.add(SimQueueSimpleEventType.DEPARTURE);
            return time + totalWork;
        }
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(SocPS queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, SocPS> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, SocPS>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (!queueState.isQueueAccessVacation() && queueState.getServerAccessCredits() >= 1) {
                    queueState.doStarts(time, arrivals);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                boolean interruptService;
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job) && ((interruptService = ((Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job)).booleanValue()) || !queueState.getJobsInServiceArea().contains(job))) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int sac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, sac);
                while (queueState.getJobsInWaitingArea().size() > 0 && sac > 0) {
                    double remainingServiceTime;
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    SimJob jobToStart = queueState.getJobsInWaitingAreaOrdered().iterator().next();
                    starters.add(jobToStart);
                    queueState.doStarts(time, starters);
                    if (sac < Integer.MAX_VALUE) {
                        --sac;
                    }
                    if (!queueState.getJobs().contains(jobToStart) || (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(jobToStart).doubleValue()) != 0.0) continue;
                    queueState.doExits(time, null, null, starters, null, visitLogsSet);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(SocPS queue, SimQueueState<SimJob, SocPS> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, SocPS>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                HashSet departures = new HashSet(queueState.getRemainingServiceMap().firstEntry().getValue());
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(SocPS queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
            NavigableMap rsMap = queueState.getRemainingServiceMap();
            if (dT > 0.0 && !rsTimeMap.isEmpty()) {
                rsMap.clear();
                double totalWork = 0.0;
                for (double work_j : queueState.getJobRemainingServiceTimeMap().values()) {
                    totalWork += work_j;
                }
                if (totalWork > 0.0) {
                    for (SimJob job : new HashSet(rsTimeMap.keySet())) {
                        double dS = dT * rsTimeMap.get(job) / totalWork;
                        double newRs = Math.max(rsTimeMap.get(job) - dS, 0.0);
                        rsTimeMap.put(job, newRs);
                        if (!rsMap.containsKey(newRs)) {
                            rsMap.put(newRs, new ArrayList());
                        }
                        ((List)rsMap.get(newRs)).add(job);
                    }
                }
            }
        }
        queueState.setTime(newTime);
    }
}

