/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.ToDoubleBiFunction;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueStateHandler;

public class DefaultSimQueueState<J extends SimJob, Q extends SimQueue>
implements SimQueueState<J, Q> {
    private final Map<String, SimQueueStateHandler> handlerNameMap = new HashMap<String, SimQueueStateHandler>();
    private final Q queue;
    private double time;
    private boolean queueAccessVacation = false;
    private final NavigableMap<Double, List<J>> jobArrivalsMap;
    private final Map<J, Double> arrivalTimesMap;
    private int serverAccessCredits = Integer.MAX_VALUE;
    private final Map<J, Double> startTimesMap;
    private final NavigableMap<Double, Set<J>> jobsInServiceAreaMap;
    private final NavigableMap<Double, List<J>> remainingServiceMap;
    private final Map<J, Double> jobRemainingServiceTimeMap;
    private ToDoubleBiFunction<Q, J> serviceTimeProvider = null;
    private final Map<PostStartHook<J>, Object> postStartHooks = new LinkedHashMap<PostStartHook<J>, Object>();

    public DefaultSimQueueState(Q queue) {
        if (queue == null) {
            throw new IllegalArgumentException();
        }
        this.queue = queue;
        this.time = Double.NaN;
        this.queueAccessVacation = false;
        this.jobArrivalsMap = new TreeMap<Double, List<J>>();
        this.arrivalTimesMap = new LinkedHashMap<J, Double>();
        this.serverAccessCredits = Integer.MAX_VALUE;
        this.startTimesMap = new HashMap<J, Double>();
        this.jobsInServiceAreaMap = new TreeMap<Double, Set<J>>();
        this.remainingServiceMap = new TreeMap<Double, List<J>>();
        this.jobRemainingServiceTimeMap = new HashMap<J, Double>();
    }

    public final void registerHandler(SimQueueStateHandler handler) {
        if (handler == null || handler.getHandlerName() == null || this.handlerNameMap.containsKey(handler.getHandlerName())) {
            throw new IllegalArgumentException();
        }
        this.handlerNameMap.put(handler.getHandlerName(), handler);
        handler.initHandler(this);
    }

    public final SimQueueStateHandler getHandler(String name) {
        return this.handlerNameMap.get(name);
    }

    @Override
    public final Q getQueue() {
        return this.queue;
    }

    @Override
    public void reset() {
        this.time = Double.NaN;
        this.queueAccessVacation = false;
        this.jobArrivalsMap.clear();
        this.arrivalTimesMap.clear();
        this.serverAccessCredits = Integer.MAX_VALUE;
        this.startTimesMap.clear();
        this.jobsInServiceAreaMap.clear();
        this.remainingServiceMap.clear();
        this.jobRemainingServiceTimeMap.clear();
        for (SimQueueStateHandler handler : this.handlerNameMap.values()) {
            handler.resetHandler(this);
        }
    }

    @Override
    public final double getTime() {
        return this.time;
    }

    @Override
    public final void setTime(double time) {
        if (Double.isNaN(time)) {
            throw new IllegalArgumentException();
        }
        if (!Double.isNaN(this.time) && time < this.time) {
            throw new IllegalArgumentException();
        }
        this.time = time;
    }

    @Override
    public final boolean isQueueAccessVacation() {
        return this.queueAccessVacation;
    }

    @Override
    public final void setQueueAccessVacation(double time, boolean start) {
        this.setTime(time);
        this.queueAccessVacation = start;
    }

    @Override
    public final NavigableMap<Double, List<J>> getJobArrivalsMap() {
        return this.jobArrivalsMap;
    }

    @Override
    public final Map<J, Double> getArrivalTimesMap() {
        return this.arrivalTimesMap;
    }

    @Override
    public final Set<J> getJobs() {
        return SimQueueState.super.getJobs();
    }

    @Override
    public final Set<J> getJobsInWaitingArea() {
        return SimQueueState.super.getJobsInWaitingArea();
    }

    @Override
    public final Set<J> getJobsInWaitingAreaOrdered() {
        return SimQueueState.super.getJobsInWaitingAreaOrdered();
    }

    @Override
    public int getServerAccessCredits() {
        return this.serverAccessCredits;
    }

    @Override
    public void setServerAccessCredits(double time, int credits) {
        if (credits < 0) {
            throw new IllegalArgumentException();
        }
        this.setTime(time);
        this.serverAccessCredits = credits;
    }

    @Override
    public final Map<J, Double> getStartTimesMap() {
        return this.startTimesMap;
    }

    @Override
    public final NavigableMap<Double, Set<J>> getJobsInServiceAreaMap() {
        return this.jobsInServiceAreaMap;
    }

    @Override
    public final Set<J> getJobsInServiceArea() {
        return SimQueueState.super.getJobsInServiceArea();
    }

    @Override
    public final NavigableMap<Double, List<J>> getRemainingServiceMap() {
        return this.remainingServiceMap;
    }

    @Override
    public final Map<J, Double> getJobRemainingServiceTimeMap() {
        return this.jobRemainingServiceTimeMap;
    }

    public final double getServiceTime(Q queue, J job) {
        if (this.serviceTimeProvider == null) {
            return job.getServiceTime(this.queue);
        }
        return this.serviceTimeProvider.applyAsDouble(queue, job);
    }

    public void setServiceTimeProvider(ToDoubleBiFunction<Q, J> serviceTimeProvider) {
        this.serviceTimeProvider = serviceTimeProvider;
    }

    @Override
    public void doArrivals(double time, Set<J> arrivals, Set<JobQueueVisitLog<J, Q>> visitLogs) {
        block6: {
            block5: {
                if (arrivals == null || arrivals.contains(null)) {
                    throw new IllegalArgumentException();
                }
                this.setTime(time);
                for (SimJob job : arrivals) {
                    if (!this.getJobs().contains(job)) continue;
                    throw new IllegalArgumentException();
                }
                if (!this.queueAccessVacation) break block5;
                if (visitLogs == null) break block6;
                for (SimJob job : arrivals) {
                    JobQueueVisitLog.addDroppedJob(visitLogs, this.queue, job, time, false, Double.NaN, time);
                }
                break block6;
            }
            for (SimJob job : arrivals) {
                if (!this.jobArrivalsMap.containsKey(time)) {
                    this.jobArrivalsMap.put(time, new ArrayList());
                }
                ((List)this.jobArrivalsMap.get(time)).add(job);
                this.arrivalTimesMap.put(job, time);
            }
        }
    }

    @Override
    public void doStarts(double time, Set<J> starters) {
        if (starters == null || starters.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.setTime(time);
        for (SimJob simJob : starters) {
            if (this.getJobsInWaitingArea().contains(simJob)) continue;
            throw new IllegalArgumentException();
        }
        if (this.serverAccessCredits < starters.size()) {
            throw new IllegalArgumentException();
        }
        if (this.serverAccessCredits < Integer.MAX_VALUE) {
            this.serverAccessCredits -= starters.size();
        }
        for (SimJob simJob : starters) {
            this.startTimesMap.put(simJob, time);
            if (!this.jobsInServiceAreaMap.containsKey(time)) {
                this.jobsInServiceAreaMap.put(time, new LinkedHashSet());
            }
            ((Set)this.jobsInServiceAreaMap.get(time)).add(simJob);
            double rsJob = this.getServiceTime(this.queue, simJob);
            if (!this.remainingServiceMap.containsKey(rsJob)) {
                this.remainingServiceMap.put(rsJob, new ArrayList());
            }
            ((List)this.remainingServiceMap.get(rsJob)).add(simJob);
            this.jobRemainingServiceTimeMap.put(simJob, rsJob);
        }
        for (Map.Entry entry : this.postStartHooks.entrySet()) {
            try {
                ((PostStartHook)entry.getKey()).hook(time, starters, entry.getValue());
            }
            catch (SimQueuePredictionException sqpe) {
                throw new RuntimeException(sqpe);
            }
        }
    }

    @Override
    public void doExits(double time, Set<J> drops, Set<J> revocations, Set<J> departures, Set<J> stickers, Set<JobQueueVisitLog<J, Q>> visitLogs) {
        if (drops != null && drops.contains(null) || revocations != null && revocations.contains(null) || departures != null && departures.contains(null) || stickers != null && stickers.contains(null)) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<J> allExits = new LinkedHashSet<J>();
        int allExitsOffered = 0;
        if (drops != null) {
            allExits.addAll(drops);
            allExitsOffered += drops.size();
        }
        if (revocations != null) {
            allExits.addAll(revocations);
            allExitsOffered += revocations.size();
        }
        if (departures != null) {
            allExits.addAll(departures);
            allExitsOffered += departures.size();
        }
        if (stickers != null) {
            allExits.addAll(stickers);
            allExitsOffered += stickers.size();
        }
        if (allExitsOffered == 0 || allExitsOffered > allExits.size()) {
            throw new IllegalArgumentException();
        }
        this.setTime(time);
        for (SimJob job : allExits) {
            double startTime;
            if (drops != null && drops.contains(job) && !this.arrivalTimesMap.containsKey(job)) {
                JobQueueVisitLog.addDroppedJob(visitLogs, this.queue, job, time, false, Double.NaN, time);
                continue;
            }
            if (departures != null && departures.contains(job) && !this.arrivalTimesMap.containsKey(job)) {
                JobQueueVisitLog.addDepartedJob(visitLogs, this.queue, job, time, false, Double.NaN, time);
                continue;
            }
            if (revocations != null && revocations.contains(job) && !this.arrivalTimesMap.containsKey(job)) continue;
            double arrivalTime = this.arrivalTimesMap.get(job);
            boolean started = this.startTimesMap.containsKey(job);
            double d = startTime = started ? this.startTimesMap.get(job) : Double.NaN;
            if (visitLogs != null) {
                if (drops != null && drops.contains(job)) {
                    JobQueueVisitLog.addDroppedJob(visitLogs, this.queue, job, arrivalTime, started, startTime, time);
                } else if (revocations != null && revocations.contains(job)) {
                    JobQueueVisitLog.addRevokedJob(visitLogs, this.queue, job, arrivalTime, started, startTime, time);
                } else if (departures != null && departures.contains(job)) {
                    JobQueueVisitLog.addDepartedJob(visitLogs, this.queue, job, arrivalTime, started, startTime, time);
                } else if (stickers != null && stickers.contains(job)) {
                    JobQueueVisitLog.addStickyJob(visitLogs, this.queue, job, arrivalTime, started, startTime);
                } else {
                    throw new RuntimeException();
                }
            }
            ((List)this.jobArrivalsMap.get(arrivalTime)).remove(job);
            if (((List)this.jobArrivalsMap.get(arrivalTime)).isEmpty()) {
                this.jobArrivalsMap.remove(arrivalTime);
            }
            this.arrivalTimesMap.remove(job);
            if (!started) continue;
            this.startTimesMap.remove(job);
            ((Set)this.jobsInServiceAreaMap.get(startTime)).remove(job);
            if (((Set)this.jobsInServiceAreaMap.get(startTime)).isEmpty()) {
                this.jobsInServiceAreaMap.remove(startTime);
            }
            double rsJob = this.jobRemainingServiceTimeMap.get(job);
            this.jobRemainingServiceTimeMap.remove(job);
            if (!((List)this.remainingServiceMap.get(rsJob)).remove(job)) {
                throw new IllegalStateException();
            }
            if (!((List)this.remainingServiceMap.get(rsJob)).isEmpty()) continue;
            this.remainingServiceMap.remove(rsJob);
        }
    }

    public final void registerPostStartHook(PostStartHook<J> postStartHook, Object userData) {
        if (postStartHook == null || this.postStartHooks.keySet().contains(postStartHook)) {
            throw new IllegalArgumentException();
        }
        this.postStartHooks.put(postStartHook, userData);
    }

    @FunctionalInterface
    public static interface PostStartHook<J extends SimJob> {
        public void hook(double var1, Set<J> var3, Object var4) throws SimQueuePredictionException;
    }
}

