/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.state;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;

public interface SimQueueState<J extends SimJob, Q extends SimQueue> {
    public Q getQueue();

    public void reset();

    public double getTime();

    public void setTime(double var1);

    public boolean isQueueAccessVacation();

    public void setQueueAccessVacation(double var1, boolean var3);

    public NavigableMap<Double, List<J>> getJobArrivalsMap();

    public Map<J, Double> getArrivalTimesMap();

    default public Set<J> getJobs() {
        return this.getArrivalTimesMap().keySet();
    }

    default public Set<J> getJobsInWaitingArea() {
        HashSet<J> jobsWaiting = new HashSet<J>();
        jobsWaiting.addAll(this.getJobs());
        jobsWaiting.removeAll(this.getJobsInServiceArea());
        return jobsWaiting;
    }

    default public Set<J> getJobsInWaitingAreaOrdered() {
        LinkedHashSet<SimJob> jobsWaitingOrdered = new LinkedHashSet<SimJob>();
        Set<J> jobsInWaitingArea = this.getJobsInServiceArea();
        for (List l : this.getJobArrivalsMap().values()) {
            for (SimJob job : l) {
                if (jobsInWaitingArea.contains(job)) continue;
                jobsWaitingOrdered.add(job);
            }
        }
        return jobsWaitingOrdered;
    }

    public int getServerAccessCredits();

    public void setServerAccessCredits(double var1, int var3);

    public Map<J, Double> getStartTimesMap();

    public NavigableMap<Double, Set<J>> getJobsInServiceAreaMap();

    default public Set<J> getJobsInServiceArea() {
        return this.getStartTimesMap().keySet();
    }

    public NavigableMap<Double, List<J>> getRemainingServiceMap();

    public Map<J, Double> getJobRemainingServiceTimeMap();

    public void doArrivals(double var1, Set<J> var3, Set<JobQueueVisitLog<J, Q>> var4);

    public void doStarts(double var1, Set<J> var3);

    public void doExits(double var1, Set<J> var3, Set<J> var4, Set<J> var5, Set<J> var6, Set<JobQueueVisitLog<J, Q>> var7);
}

