/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.workload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.event.map.DefaultSimEntityEventMap;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleHandler;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleInvalidException;

public class DefaultWorkloadSchedule
extends DefaultSimEntityEventMap
implements WorkloadSchedule,
WorkloadScheduleHandler {
    private final Map<Class<? extends SimJQEvent>, WorkloadScheduleHandler> handlerEventMap = new HashMap<Class<? extends SimJQEvent>, WorkloadScheduleHandler>();
    private final Map<String, WorkloadScheduleHandler> handlerNameMap = new HashMap<String, WorkloadScheduleHandler>();
    private final Set<SimJQEvent> queueEvents = new LinkedHashSet<SimJQEvent>();
    private final Set<SimJQEvent> processedQueueEvents = new HashSet<SimJQEvent>();
    private final Set<SimQueue> queues = new HashSet<SimQueue>();
    private final Map<SimQueue, NavigableMap<Double, List<Boolean>>> qavTimesMap = new HashMap<SimQueue, NavigableMap<Double, List<Boolean>>>();
    private final Set<SimJob> jobs = new HashSet<SimJob>();
    private final Map<SimQueue, Map<SimJob, List<Double>>> arrTimesMap = new HashMap<SimQueue, Map<SimJob, List<Double>>>();
    private final Map<SimQueue, NavigableMap<Double, List<SimJob>>> timeArrsMap = new HashMap<SimQueue, NavigableMap<Double, List<SimJob>>>();
    private final Map<SimQueue, Map<SimJob, List<Map<Double, Boolean>>>> revTimesMap = new HashMap<SimQueue, Map<SimJob, List<Map<Double, Boolean>>>>();
    private final Map<SimQueue, NavigableMap<Double, List<Map<SimJob, Boolean>>>> timeRevsMap = new HashMap<SimQueue, NavigableMap<Double, List<Map<SimJob, Boolean>>>>();
    private final Map<SimQueue, NavigableMap<Double, List<Integer>>> sacTimesMap = new HashMap<SimQueue, NavigableMap<Double, List<Integer>>>();
    private static final Map<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member> EVENT_MAP = new HashMap<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member>();

    public <E extends SimJQEvent> DefaultWorkloadSchedule(Set<? extends SimQueue> queues, Set<E> queueEvents) throws WorkloadScheduleException {
        super(queueEvents);
        if (queueEvents != null) {
            this.queueEvents.addAll(queueEvents);
        }
        this.queueEvents.remove(null);
        if (queues != null) {
            this.queues.addAll(queues);
        } else {
            this.queues.addAll(this.getSimQueueTimeSimEntityEventMap().keySet());
        }
        this.registerHandler(this);
    }

    public <E extends SimJQEvent> DefaultWorkloadSchedule(Set<E> queueEvents) throws WorkloadScheduleException {
        this(null, queueEvents);
    }

    public <E extends SimJQEvent> DefaultWorkloadSchedule(Set<? extends SimQueue> queues, Map<Double, Set<E>> queueEvents) throws WorkloadScheduleException {
        super(queueEvents);
        if (queueEvents != null) {
            for (Set<E> queueEvents_q : queueEvents.values()) {
                this.queueEvents.addAll(queueEvents_q);
            }
        }
        this.queueEvents.remove(null);
        if (queues != null) {
            this.queues.addAll(queues);
        } else {
            this.queues.addAll(this.getSimQueueTimeSimEntityEventMap().keySet());
        }
        this.registerHandler(this);
    }

    public <E extends SimJQEvent> DefaultWorkloadSchedule(Map<Double, Set<E>> queueEvents) throws WorkloadScheduleException {
        this(null, queueEvents);
    }

    @Override
    public double getNextEventTimeBeyond(SimQueue queue, double time, Set<SimEntitySimpleEventType.Member> eventTypes) throws WorkloadScheduleException {
        if (eventTypes != null) {
            eventTypes.clear();
        }
        if (queue == null || !this.getQueues().contains(queue)) {
            return Double.NaN;
        }
        double nextEventTime = Double.NaN;
        NavigableMap<Double, Set<SimJQEvent>> timeSimEntityMap = this.getSimQueueTimeSimEntityEventMap().get(queue);
        if (timeSimEntityMap != null) {
            Map.Entry<Double, Set<SimJQEvent>> nextEntry;
            Map.Entry<Double, Set<SimJQEvent>> entry = nextEntry = Double.isNaN(time) ? timeSimEntityMap.firstEntry() : timeSimEntityMap.higherEntry(time);
            if (nextEntry != null) {
                nextEventTime = nextEntry.getKey();
                if (eventTypes != null) {
                    for (SimJQEvent entityEvent : nextEntry.getValue()) {
                        if (entityEvent == null) {
                            throw new RuntimeException();
                        }
                        if (!this.handlerEventMap.containsKey(((Object)((Object)entityEvent)).getClass())) {
                            System.err.println("Handler for SimEventEntity class " + ((Object)((Object)entityEvent)).getClass() + " NOT found!.");
                            throw new WorkloadScheduleInvalidException();
                        }
                        if (this.handlerEventMap.get(((Object)((Object)entityEvent)).getClass()) == null) {
                            throw new RuntimeException();
                        }
                        if (!this.handlerEventMap.get(((Object)((Object)entityEvent)).getClass()).getEventMap().containsKey(((Object)((Object)entityEvent)).getClass())) {
                            throw new RuntimeException();
                        }
                        if (this.handlerEventMap.get(((Object)((Object)entityEvent)).getClass()).getEventMap().get(((Object)((Object)entityEvent)).getClass()) == null) {
                            throw new RuntimeException();
                        }
                        eventTypes.add(this.handlerEventMap.get(((Object)((Object)entityEvent)).getClass()).getEventMap().get(((Object)((Object)entityEvent)).getClass()));
                    }
                }
            }
        }
        return nextEventTime;
    }

    public final void registerHandler(WorkloadScheduleHandler handler) throws WorkloadScheduleException {
        if (handler == null || handler.getHandlerName() == null || this.handlerNameMap.containsKey(handler.getHandlerName())) {
            throw new IllegalArgumentException();
        }
        Map<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member> eventMap = handler.getEventMap();
        if (eventMap != null) {
            if (eventMap.containsKey(null)) {
                throw new IllegalArgumentException();
            }
            for (Class<? extends SimJQEvent> eventClass : eventMap.keySet()) {
                if (this.handlerEventMap.containsKey(eventClass)) {
                    throw new IllegalArgumentException();
                }
                this.handlerEventMap.put(eventClass, handler);
            }
        }
        this.handlerNameMap.put(handler.getHandlerName(), handler);
        if (handler.needsScan()) {
            Set<SimJQEvent> handlerProcessedQueueEvents = handler.scan(this);
            if (handlerProcessedQueueEvents != null) {
                for (SimJQEvent event : handlerProcessedQueueEvents) {
                    if (event != null && !this.processedQueueEvents.contains((Object)event)) continue;
                    throw new WorkloadScheduleInvalidException();
                }
            }
            if (handlerProcessedQueueEvents != null) {
                this.processedQueueEvents.addAll(handlerProcessedQueueEvents);
            }
        }
    }

    public final WorkloadScheduleHandler getHandler(String name) {
        return this.handlerNameMap.get(name);
    }

    @Override
    public final Set<SimJQEvent> getQueueEvents() {
        return Collections.unmodifiableSet(this.queueEvents);
    }

    @Override
    public final Set<SimJQEvent> getProcessedQueueEvents() {
        return Collections.unmodifiableSet(this.processedQueueEvents);
    }

    @Override
    public final Set<SimQueue> getQueues() {
        return Collections.unmodifiableSet(this.queues);
    }

    @Override
    public final NavigableMap<Double, List<Boolean>> getQueueAccessVacationMap(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.unmodifiableNavigableMap(new TreeMap());
        }
        return Collections.unmodifiableNavigableMap(this.qavTimesMap.get(queue));
    }

    @Override
    public final Set<SimJob> getJobs() {
        return Collections.unmodifiableSet(this.jobs);
    }

    @Override
    public final Set<SimJob> getJobs(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.EMPTY_SET;
        }
        HashSet<SimJob> jobs_q = new HashSet<SimJob>(this.arrTimesMap.get(queue).keySet());
        jobs_q.addAll(this.revTimesMap.get(queue).keySet());
        return Collections.unmodifiableSet(jobs_q);
    }

    @Override
    public final Map<SimJob, List<Double>> getArrivalTimesMap(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.arrTimesMap.get(queue));
    }

    @Override
    public final NavigableMap<Double, List<SimJob>> getJobArrivalsMap(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.unmodifiableNavigableMap(new TreeMap());
        }
        return Collections.unmodifiableNavigableMap(this.timeArrsMap.get(queue));
    }

    @Override
    public final Map<SimJob, List<Map<Double, Boolean>>> getRevocationTimesMap(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.revTimesMap.get(queue));
    }

    @Override
    public final NavigableMap<Double, List<Map<SimJob, Boolean>>> getJobRevocationsMap(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.unmodifiableNavigableMap(new TreeMap());
        }
        return Collections.unmodifiableNavigableMap(this.timeRevsMap.get(queue));
    }

    @Override
    public final NavigableMap<Double, List<Integer>> getServerAccessCreditsMap(SimQueue queue) {
        if (queue == null || !this.queues.contains(queue)) {
            return Collections.unmodifiableNavigableMap(new TreeMap());
        }
        return Collections.unmodifiableNavigableMap(this.sacTimesMap.get(queue));
    }

    @Override
    public final String getHandlerName() {
        return "SimQueueHandler";
    }

    @Override
    public final Map<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member> getEventMap() {
        return EVENT_MAP;
    }

    @Override
    public final boolean needsScan() {
        return true;
    }

    @Override
    public final Set<SimJQEvent> scan(DefaultWorkloadSchedule workloadSchedule) {
        if (workloadSchedule != this) {
            throw new IllegalArgumentException();
        }
        HashSet<SimJQEvent> handlerProcessedQueueEvents = new HashSet<SimJQEvent>();
        for (SimQueue q : this.queues) {
            this.qavTimesMap.put(q, new TreeMap());
            this.arrTimesMap.put(q, new HashMap());
            this.timeArrsMap.put(q, new TreeMap());
            this.revTimesMap.put(q, new HashMap());
            this.timeRevsMap.put(q, new TreeMap());
            this.sacTimesMap.put(q, new TreeMap());
        }
        if (this.queueEvents != null) {
            for (SimJQEvent event : this.queueEvents) {
                double time = event.getTime();
                Object queue = event.getQueue();
                Object job = event.getJob();
                if (!this.queues.contains(queue)) continue;
                if (event instanceof SimQueueEvent.QueueAccessVacation) {
                    handlerProcessedQueueEvents.add(event);
                    boolean vacation = ((SimQueueEvent.QueueAccessVacation)event).getVacation();
                    NavigableMap<Double, List<Boolean>> qavTimesMap_q = this.qavTimesMap.get(queue);
                    if (!qavTimesMap_q.containsKey(time)) {
                        qavTimesMap_q.put(time, new ArrayList());
                    }
                    ((List)qavTimesMap_q.get(time)).add(vacation);
                    continue;
                }
                if (event instanceof SimJQEvent.Arrival) {
                    handlerProcessedQueueEvents.add(event);
                    this.jobs.add((SimJob)job);
                    Map<SimJob, List<Double>> arrTimesMap_q = this.arrTimesMap.get(queue);
                    if (!arrTimesMap_q.containsKey(job)) {
                        arrTimesMap_q.put((SimJob)job, new ArrayList());
                    }
                    arrTimesMap_q.get(job).add(time);
                    NavigableMap<Double, List<SimJob>> timeArrsMap_q = this.timeArrsMap.get(queue);
                    if (!timeArrsMap_q.containsKey(time)) {
                        timeArrsMap_q.put(time, new ArrayList());
                    }
                    ((List)timeArrsMap_q.get(time)).add(job);
                    continue;
                }
                if (event instanceof SimJQEvent.Revocation) {
                    handlerProcessedQueueEvents.add(event);
                    this.jobs.add((SimJob)job);
                    boolean interruptService = ((SimJQEvent.Revocation)event).isInterruptService();
                    Map<SimJob, List<Map<Double, Boolean>>> revTimesMap_q = this.revTimesMap.get(queue);
                    if (!revTimesMap_q.containsKey(job)) {
                        revTimesMap_q.put((SimJob)job, new ArrayList());
                    }
                    HashMap<Double, Boolean> timeIsMap = new HashMap<Double, Boolean>();
                    timeIsMap.put(time, interruptService);
                    revTimesMap_q.get(job).add(timeIsMap);
                    NavigableMap<Double, List<Map<SimJob, Boolean>>> timeRevsMap_q = this.timeRevsMap.get(queue);
                    if (!timeRevsMap_q.containsKey(time)) {
                        timeRevsMap_q.put(time, new ArrayList());
                    }
                    HashMap jobIsMap = new HashMap();
                    jobIsMap.put(job, interruptService);
                    ((List)timeRevsMap_q.get(time)).add(jobIsMap);
                    continue;
                }
                if (!(event instanceof SimQueueEvent.ServerAccessCredits)) continue;
                handlerProcessedQueueEvents.add(event);
                int credits = ((SimQueueEvent.ServerAccessCredits)event).getCredits();
                NavigableMap<Double, List<Integer>> sacTimesMap_q = this.sacTimesMap.get(queue);
                if (!sacTimesMap_q.containsKey(time)) {
                    sacTimesMap_q.put(time, new ArrayList());
                }
                ((List)sacTimesMap_q.get(time)).add(credits);
            }
        }
        return handlerProcessedQueueEvents;
    }

    static {
        EVENT_MAP.put(SimQueueEvent.QueueAccessVacation.class, SimQueueSimpleEventType.QUEUE_ACCESS_VACATION);
        EVENT_MAP.put(SimJQEvent.Arrival.class, SimQueueSimpleEventType.ARRIVAL);
        EVENT_MAP.put(SimJQEvent.Revocation.class, SimQueueSimpleEventType.REVOCATION);
        EVENT_MAP.put(SimQueueEvent.ServerAccessCredits.class, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS);
    }
}

