/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.stat;

import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueListener;

public abstract class AbstractSimQueueStat<J extends SimJob, Q extends SimQueue>
implements SimQueueListener<J, Q> {
    private Q queue = null;
    private double startTime = Double.NEGATIVE_INFINITY;
    private double lastUpdateTime = Double.NEGATIVE_INFINITY;
    private boolean statisticsValid = false;

    public AbstractSimQueueStat(Q queue) {
        this.setQueueInt(queue);
    }

    public AbstractSimQueueStat() {
        this(null);
    }

    protected abstract void resetStatistics();

    protected abstract void updateStatistics(double var1, double var3);

    protected abstract void calculateStatistics(double var1, double var3);

    public void reset() {
        this.resetInt();
        this.resetStatistics();
    }

    private void resetInt() {
        this.startTime = this.queue != null ? this.queue.getEventList().getTime() : Double.NEGATIVE_INFINITY;
        this.lastUpdateTime = this.startTime;
        this.statisticsValid = false;
    }

    protected void update(double time) {
        if (time < this.lastUpdateTime) {
            throw new IllegalArgumentException();
        }
        if (time == this.lastUpdateTime) {
            return;
        }
        this.statisticsValid = false;
        double dt = time - this.lastUpdateTime;
        this.updateStatistics(time, dt);
        this.lastUpdateTime = time;
    }

    protected void calculate(double time) {
        if (this.statisticsValid && time == this.lastUpdateTime) {
            return;
        }
        this.statisticsValid = false;
        if (time < this.lastUpdateTime) {
            throw new IllegalArgumentException();
        }
        if (this.lastUpdateTime < this.startTime) {
            throw new RuntimeException();
        }
        if (time > this.lastUpdateTime) {
            this.update(time);
        }
        this.calculateStatistics(this.startTime, this.lastUpdateTime);
        this.statisticsValid = true;
    }

    protected void calculate() {
        Q queue = this.getQueue();
        if (queue != null) {
            this.calculate(queue.getEventList().getTime());
        } else {
            this.calculate(this.getLastUpdateTime());
        }
    }

    public final Q getQueue() {
        return this.queue;
    }

    public void setQueue(Q queue) {
        this.setQueueCommon(queue);
        this.reset();
    }

    private void setQueueInt(Q queue) {
        this.setQueueCommon(queue);
        this.resetInt();
    }

    private void setQueueCommon(Q queue) {
        if (queue != this.queue) {
            if (this.queue != null) {
                this.queue.unregisterSimEntityListener(this);
            }
            this.queue = queue;
            if (this.queue != null) {
                this.queue.registerSimEntityListener(this);
            }
        }
    }

    public final double getStartTime() {
        return this.startTime;
    }

    public final double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final boolean getStatisticsValid() {
        return this.statisticsValid;
    }

    @Override
    public void notifyResetEntity(SimEntity entity) {
        this.reset();
    }

    @Override
    public void notifyUpdate(double time, SimEntity entity) {
        if (entity == null || entity != this.getQueue()) {
            throw new IllegalArgumentException();
        }
        this.update(time);
    }

    @Override
    public void notifyStateChanged(double time, SimEntity entity, List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> notifications) {
    }

    @Override
    public void notifyArrival(double time, J job, Q queue) {
    }

    @Override
    public void notifyStart(double time, J job, Q queue) {
    }

    @Override
    public void notifyDrop(double time, J job, Q queue) {
    }

    @Override
    public void notifyRevocation(double time, J job, Q queue) {
    }

    @Override
    public void notifyAutoRevocation(double time, J job, Q queue) {
    }

    @Override
    public void notifyDeparture(double time, J job, Q queue) {
    }

    @Override
    public void notifyNewStartArmed(double time, Q queue, boolean startArmed) {
    }

    @Override
    public void notifyStartQueueAccessVacation(double time, Q queue) {
    }

    @Override
    public void notifyStopQueueAccessVacation(double time, Q queue) {
    }

    @Override
    public void notifyOutOfServerAccessCredits(double time, Q queue) {
    }

    @Override
    public void notifyRegainedServerAccessCredits(double time, Q queue) {
    }
}

