/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.stat;

import java.util.ArrayList;
import java.util.List;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.stat.AbstractSimQueueStat;
import org.javades.jqueues.r5.util.stat.AutoSimQueueStatEntry;

public class AutoSimQueueStat<J extends SimJob, Q extends SimQueue>
extends AbstractSimQueueStat<J, Q> {
    private List<AutoSimQueueStatEntry<Q>> entries;

    public final List<AutoSimQueueStatEntry<Q>> getEntries() {
        return this.entries;
    }

    protected final void setEntries(List<AutoSimQueueStatEntry<Q>> entries) {
        this.entries = entries;
        this.reset();
    }

    @Override
    protected final void resetStatistics() {
        if (this.entries != null) {
            for (AutoSimQueueStatEntry<Q> e : this.entries) {
                if (e == null) continue;
                e.reset();
            }
        }
    }

    @Override
    protected final void updateStatistics(double time, double dt) {
        if (this.entries != null) {
            for (AutoSimQueueStatEntry e : this.entries) {
                if (e == null) continue;
                e.update(this.getQueue(), dt);
            }
        }
    }

    @Override
    protected void calculateStatistics(double startTime, double endTime) {
        if (this.entries != null) {
            for (AutoSimQueueStatEntry<Q> e : this.entries) {
                if (e == null) continue;
                e.calculate(startTime, endTime);
            }
        }
    }

    public AutoSimQueueStat(Q queue, List<AutoSimQueueStatEntry<Q>> entries) {
        super(queue);
        this.entries = entries;
        this.resetStatistics();
    }

    public AutoSimQueueStat() {
        this.entries = new ArrayList<AutoSimQueueStatEntry<Q>>();
        this.resetStatistics();
    }

    public void report() {
        this.report(0);
    }

    public void report(int indent) {
        this.calculate();
        if (this.entries != null) {
            for (AutoSimQueueStatEntry<Q> e : this.entries) {
                int i;
                if (e == null) continue;
                for (i = 1; i <= indent; ++i) {
                    System.out.print(" ");
                }
                System.out.println("Average " + e.getName() + ": " + e.getAvgValue() + ".");
                for (i = 1; i <= indent; ++i) {
                    System.out.print(" ");
                }
                System.out.println("Minimum " + e.getName() + ": " + e.getMinValue() + ".");
                for (i = 1; i <= indent; ++i) {
                    System.out.print(" ");
                }
                System.out.println("Maximum " + e.getName() + ": " + e.getMaxValue() + ".");
            }
        }
    }
}

