/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.stat;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.stat.SimQueueProbe;

public class AutoSimQueueStatEntry<Q extends SimQueue> {
    private static final Logger LOGGER = Logger.getLogger(AutoSimQueueStatEntry.class.getName());
    private static final boolean LOGGING = false;
    private final String name;
    private final SimQueueProbe<Q> probe;
    private int numberOfProbes = 0;
    private double cumValue = 0.0;
    private double avgValue = 0.0;
    private double minValue = Double.NaN;
    private double maxValue = Double.NaN;

    public AutoSimQueueStatEntry(String name, SimQueueProbe<Q> probe) {
        if (name == null || probe == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.probe = probe;
        this.resetInt();
    }

    public final String getName() {
        return this.name;
    }

    public final SimQueueProbe<Q> getSimQueueProbe() {
        return this.probe;
    }

    public final int getNumberOfProbes() {
        return this.numberOfProbes;
    }

    public final double getCumValue() {
        return this.cumValue;
    }

    public final double getAvgValue() {
        return this.avgValue;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue;
    }

    private void resetInt() {
        this.numberOfProbes = 0;
        this.cumValue = 0.0;
        this.avgValue = 0.0;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
    }

    public void reset() {
        this.resetInt();
    }

    public void update(Q queue, double dt) {
        if (queue == null) {
            LOGGER.log(Level.WARNING, "Updating {0} for queue=null, dt={1}.", new Object[]{this.name, dt});
        } else {
            double probeValue = this.probe.get(queue);
            this.cumValue += probeValue * dt;
            if (this.numberOfProbes == 0) {
                this.minValue = probeValue;
                this.maxValue = probeValue;
            } else {
                this.minValue = Math.min(this.minValue, probeValue);
                this.maxValue = Math.max(this.maxValue, probeValue);
            }
            ++this.numberOfProbes;
        }
    }

    public void calculate(double startTime, double endTime) {
        if (endTime < startTime) {
            throw new IllegalArgumentException();
        }
        if (startTime == endTime) {
            this.avgValue = 0.0;
        } else {
            double dT = endTime - startTime;
            this.avgValue = this.cumValue / dT;
        }
    }
}

