/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.stat;

import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.stat.AbstractSimQueueStat;

public class SimpleSimQueueStat<J extends SimJob, Q extends SimQueue>
extends AbstractSimQueueStat<J, Q> {
    private int nrOfUpdates = 0;
    private double cumNrOfJobs = 0.0;
    private double avgNrOfJobs = 0.0;
    private double minNrOfJobs = Double.NaN;
    private double maxNrOfJobs = Double.NaN;
    private double cumNrOfJobsX = 0.0;
    private double avgNrOfJobsX = 0.0;
    private double minNrOfJobsX = Double.NaN;
    private double maxNrOfJobsX = Double.NaN;

    public SimpleSimQueueStat(Q queue) {
        super(queue);
        this.resetStatisticsInt();
    }

    public SimpleSimQueueStat() {
        this.resetStatisticsInt();
    }

    public final int getNumberOfUpdates() {
        return this.nrOfUpdates;
    }

    private void resetStatisticsInt() {
        this.nrOfUpdates = 0;
        this.cumNrOfJobs = 0.0;
        this.avgNrOfJobs = 0.0;
        this.minNrOfJobs = Double.NaN;
        this.maxNrOfJobs = Double.NaN;
        this.cumNrOfJobsX = 0.0;
        this.avgNrOfJobsX = 0.0;
        this.minNrOfJobsX = Double.NaN;
        this.maxNrOfJobsX = Double.NaN;
    }

    private void updateStatisticsInt(double time, double dt) {
        Object queue = this.getQueue();
        if (queue == null) {
            return;
        }
        int J = queue.getNumberOfJobs();
        int JX = queue.getNumberOfJobsInServiceArea();
        this.cumNrOfJobs += (double)J * dt;
        this.cumNrOfJobsX += (double)JX * dt;
        if (this.nrOfUpdates == 0) {
            this.minNrOfJobs = J;
            this.maxNrOfJobs = J;
            this.minNrOfJobsX = JX;
            this.maxNrOfJobsX = JX;
        } else {
            this.minNrOfJobs = Math.min(this.minNrOfJobs, (double)J);
            this.maxNrOfJobs = Math.max(this.maxNrOfJobs, (double)J);
            this.minNrOfJobsX = Math.min(this.minNrOfJobsX, (double)JX);
            this.maxNrOfJobsX = Math.max(this.maxNrOfJobsX, (double)JX);
        }
        ++this.nrOfUpdates;
    }

    private void calculateStatisticsInt(double startTime, double endTime) {
        if (endTime < startTime) {
            throw new IllegalArgumentException();
        }
        if (startTime == endTime) {
            this.avgNrOfJobs = 0.0;
            this.avgNrOfJobsX = 0.0;
        } else {
            double dT = endTime - startTime;
            this.avgNrOfJobs = this.cumNrOfJobs / dT;
            this.avgNrOfJobsX = this.cumNrOfJobsX / dT;
        }
    }

    public final double getAvgNrOfJobs() {
        this.calculate();
        return this.avgNrOfJobs;
    }

    public final double getMinNrOfJobs() {
        return this.minNrOfJobs;
    }

    public final double getMaxNrOfJobs() {
        return this.maxNrOfJobs;
    }

    public final double getAvgNrOfJobsInServiceArea() {
        this.calculate();
        return this.avgNrOfJobsX;
    }

    public final double getMinNrOfJobsInServiceArea() {
        return this.minNrOfJobsX;
    }

    public final double getMaxNrOfJobsInServiceArea() {
        return this.maxNrOfJobsX;
    }

    @Override
    protected void resetStatistics() {
        this.resetStatisticsInt();
    }

    @Override
    protected void updateStatistics(double time, double dt) {
        this.updateStatisticsInt(time, dt);
    }

    @Override
    protected void calculateStatistics(double startTime, double endTime) {
        this.calculateStatisticsInt(startTime, endTime);
    }
}

