/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.stat;

import java.util.HashMap;
import java.util.Map;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.stat.AbstractSimQueueStat;

public class SimpleSimQueueVisitsStat<J extends SimJob, Q extends SimQueue>
extends AbstractSimQueueStat<J, Q> {
    private int Narrivals;
    private int Ndrops;
    private int Nrevocations;
    private int NautoRevocations;
    private int Nstarted;
    private int Ndepartures;
    private int Nexits;
    private double cumWaitingTime = 0.0;
    private double cumSojournTime = 0.0;
    private double avgWaitingTime = Double.NaN;
    private double avgSojournTime = Double.NaN;
    private double minWaitingTime = Double.NaN;
    private double minSojournTime = Double.NaN;
    private double maxWaitingTime = Double.NaN;
    private double maxSojournTime = Double.NaN;
    private final Map<J, Double> arrivals = new HashMap<J, Double>();
    private final Map<J, Double> started = new HashMap<J, Double>();

    private void resetStatisticsInt() {
        this.Narrivals = 0;
        this.Ndrops = 0;
        this.Nrevocations = 0;
        this.NautoRevocations = 0;
        this.Nstarted = 0;
        this.Ndepartures = 0;
        this.Nexits = 0;
        this.cumWaitingTime = 0.0;
        this.cumSojournTime = 0.0;
        this.avgWaitingTime = Double.NaN;
        this.avgSojournTime = Double.NaN;
        this.minWaitingTime = Double.NaN;
        this.minSojournTime = Double.NaN;
        this.maxWaitingTime = Double.NaN;
        this.maxSojournTime = Double.NaN;
        this.arrivals.clear();
        this.started.clear();
    }

    private void updateStatisticsInt(double time, double dt) {
    }

    private void calculateStatisticsInt(double startTime, double endTime) {
        if (endTime < startTime) {
            throw new IllegalArgumentException();
        }
        this.avgWaitingTime = this.Nstarted > 0 ? this.cumWaitingTime / (double)this.Nstarted : Double.NaN;
        this.avgSojournTime = this.Ndepartures > 0 ? this.cumSojournTime / (double)this.Ndepartures : Double.NaN;
    }

    public final int getNumberOfArrivals() {
        this.calculate();
        return this.Narrivals;
    }

    public final int getNumberOfJobsDropped() {
        this.calculate();
        return this.Ndrops;
    }

    public final int getNumberOfRevocations() {
        this.calculate();
        return this.Nrevocations;
    }

    public final int getNumberOfAutoRevocations() {
        this.calculate();
        return this.NautoRevocations;
    }

    public final int getNumberOfStartedJobs() {
        this.calculate();
        return this.Nstarted;
    }

    public final int getNumberOfDepartures() {
        this.calculate();
        return this.Nstarted;
    }

    public final int getNumberOfExits() {
        this.calculate();
        return this.Nexits;
    }

    public final double getAvgWaitingTime() {
        this.calculate();
        return this.avgWaitingTime;
    }

    public final double getAvgSojournTime() {
        this.calculate();
        return this.avgSojournTime;
    }

    public final double getMinWaitingTime() {
        return this.minWaitingTime;
    }

    public final double getMinSojournTime() {
        return this.minSojournTime;
    }

    public final double getMaxWaitingTime() {
        return this.maxWaitingTime;
    }

    public final double getMaxSojournTime() {
        return this.maxSojournTime;
    }

    @Override
    protected void resetStatistics() {
        this.resetStatisticsInt();
    }

    @Override
    protected void updateStatistics(double time, double dt) {
        this.updateStatisticsInt(time, dt);
    }

    @Override
    protected void calculateStatistics(double startTime, double endTime) {
        this.calculateStatisticsInt(startTime, endTime);
    }

    @Override
    public void notifyArrival(double time, J job, Q queue) {
        super.notifyArrival(time, job, queue);
        if (time < this.getLastUpdateTime() || job == null || queue == null || queue != this.getQueue() || this.arrivals.containsKey(job) || this.started.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        this.arrivals.put(job, time);
        ++this.Narrivals;
    }

    @Override
    public void notifyStart(double time, J job, Q queue) {
        super.notifyStart(time, job, queue);
        if (time < this.getLastUpdateTime() || job == null || queue == null || queue != this.getQueue() || !this.arrivals.containsKey(job) || this.started.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        this.started.put(job, time);
        double waitingTime = this.started.get(job) - this.arrivals.get(job);
        this.cumWaitingTime += waitingTime;
        if (this.Nstarted == 0) {
            this.minWaitingTime = waitingTime;
            this.maxWaitingTime = waitingTime;
        } else {
            this.minWaitingTime = Math.min(this.minWaitingTime, waitingTime);
            this.maxWaitingTime = Math.max(this.maxWaitingTime, waitingTime);
        }
        ++this.Nstarted;
    }

    @Override
    public void notifyDrop(double time, J job, Q queue) {
        super.notifyDrop(time, job, queue);
        if (time < this.getLastUpdateTime() || job == null || queue == null || queue != this.getQueue() || !this.arrivals.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        ++this.Ndrops;
        ++this.Nexits;
        this.arrivals.remove(job);
        this.started.remove(job);
    }

    @Override
    public void notifyRevocation(double time, J job, Q queue) {
        super.notifyRevocation(time, job, queue);
        if (time < this.getLastUpdateTime() || job == null || queue == null || queue != this.getQueue() || !this.arrivals.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        ++this.Nrevocations;
        ++this.Nexits;
        this.arrivals.remove(job);
        this.started.remove(job);
    }

    @Override
    public void notifyAutoRevocation(double time, J job, Q queue) {
        super.notifyAutoRevocation(time, job, queue);
        if (time < this.getLastUpdateTime() || job == null || queue == null || queue != this.getQueue() || !this.arrivals.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        ++this.NautoRevocations;
        ++this.Nexits;
        this.arrivals.remove(job);
        this.started.remove(job);
    }

    @Override
    public void notifyDeparture(double time, J job, Q queue) {
        super.notifyDeparture(time, job, queue);
        if (time < this.getLastUpdateTime() || job == null || queue == null || queue != this.getQueue() || !this.arrivals.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        double sojournTime = time - this.arrivals.get(job);
        this.cumSojournTime += sojournTime;
        if (this.Ndepartures == 0) {
            this.minSojournTime = sojournTime;
            this.maxSojournTime = sojournTime;
        } else {
            this.minSojournTime = Math.min(this.minSojournTime, sojournTime);
            this.maxSojournTime = Math.max(this.maxSojournTime, sojournTime);
        }
        ++this.Ndepartures;
        ++this.Nexits;
        this.arrivals.remove(job);
        this.started.remove(job);
    }

    public SimpleSimQueueVisitsStat(Q queue) {
        super(queue);
        this.resetStatisticsInt();
    }

    public SimpleSimQueueVisitsStat() {
        this.resetStatisticsInt();
    }
}

