/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueListener;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueComposite;
import org.javades.jsimulation.r5.SimEventList;

public class JSimQueue
extends JComponent
implements SimQueueListener {
    private final SimEventList eventList;
    private final SimQueue queue;
    private final ArrivalInfo arrivalInfo = new ArrivalInfo();
    private final DropInfo dropInfo = new DropInfo();
    private final RevocationInfo revocationInfo = new RevocationInfo();
    private final DepartureInfo departureInfo = new DepartureInfo();

    public JSimQueue(SimEventList eventList, SimQueue queue) {
        if (eventList == null || queue == null) {
            throw new IllegalArgumentException();
        }
        this.eventList = eventList;
        this.queue = queue;
        this.queue.registerSimEntityListener(this);
        if (this.queue instanceof SimQueueComposite) {
            for (SimQueue q : ((SimQueueComposite)this.queue).getQueues()) {
                this.add(new JSimQueue(eventList, q));
            }
        } else {
            this.setMinimumSize(new Dimension(120, 240));
        }
    }

    private final void setArrivalInfo(double t, SimJob job, SimQueue queue) {
        if (queue == this.queue) {
            this.arrivalInfo.job = job;
            this.arrivalInfo.time = t;
            this.arrivalInfo.counter++;
        }
    }

    private final void setDropInfo(double t, SimJob job, SimQueue queue) {
        if (queue == this.queue) {
            this.dropInfo.job = job;
            this.dropInfo.time = t;
            this.dropInfo.counter++;
        }
    }

    private final void setRevocationInfo(double t, SimJob job, SimQueue queue) {
        if (queue == this.queue) {
            this.revocationInfo.job = job;
            this.revocationInfo.time = t;
            this.revocationInfo.counter++;
        }
    }

    private final void setDepartureInfo(double t, SimJob job, SimQueue queue) {
        if (queue == this.queue) {
            this.departureInfo.job = job;
            this.departureInfo.time = t;
            this.departureInfo.counter++;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        int middleX = width / 2;
        int middleY = height / 2;
        g2d.setStroke(new BasicStroke(4.0f));
        g2d.setColor(this.queue.isQueueAccessVacation() ? Color.red : Color.green);
        g2d.drawRect(middleX - 50, middleY - 100, 100, 200);
        g2d.setColor(Color.yellow.darker());
        g2d.drawString("Ar:" + this.arrivalInfo.counter, middleX - 47, middleY - 80);
        g2d.setColor(Color.green.darker());
        g2d.drawString("De:" + this.departureInfo.counter, middleX - 2, middleY - 80);
        g2d.setColor(Color.orange.darker());
        g2d.drawString("Re:" + this.revocationInfo.counter, middleX - 47, middleY - 60);
        g2d.setColor(Color.red.darker());
        g2d.drawString("Dr:" + this.dropInfo.counter, middleX - 2, middleY - 60);
        g2d.setColor(this.queue.getServerAccessCredits() > 0 ? Color.green : Color.red);
        g2d.drawLine(middleX, middleY - 20, middleX, middleY + 10);
        if (this.queue.getServerAccessCredits() < Integer.MAX_VALUE) {
            g2d.drawString("" + this.queue.getServerAccessCredits(), middleX + 10, middleY);
        }
        g2d.setColor(Color.black);
        BasicStroke savedStroke = (BasicStroke)g2d.getStroke();
        if (this.queue.isStartArmed()) {
            g2d.setStroke(new BasicStroke(savedStroke.getLineWidth(), savedStroke.getEndCap(), savedStroke.getLineJoin(), savedStroke.getMiterLimit(), new float[]{5.0f, 10.0f}, 0.0f));
        }
        g2d.drawLine(middleX - 30, middleY - 20, middleX + 30, middleY - 20);
        g2d.drawLine(middleX - 30, middleY - 40, middleX - 30, middleY - 20);
        g2d.drawLine(middleX + 30, middleY - 40, middleX + 30, middleY - 20);
        g2d.setStroke(savedStroke);
        g2d.drawString("W:" + (this.queue.getNumberOfJobs() - this.queue.getNumberOfJobsInServiceArea()), middleX - 20, middleY - 30);
        g2d.setColor(Color.black);
        g2d.drawOval(middleX - 30, middleY + 10, 60, 60);
        g2d.drawString("S:" + this.queue.getNumberOfJobsInServiceArea(), middleX - 20, middleY + 45);
        g2d.setColor(Color.black);
        g2d.drawString(this.queue.toString(), middleX - 40, middleY + 90);
        g2d.dispose();
    }

    protected void notifyQueueChanged(double t, SimQueue queue) {
        if (queue == this.queue) {
            this.repaint();
        }
    }

    public void notifyStartQueueAccessVacation(double t, SimQueue queue) {
        this.notifyQueueChanged(t, queue);
    }

    public void notifyStopQueueAccessVacation(double t, SimQueue queue) {
        this.notifyQueueChanged(t, queue);
    }

    public void notifyOutOfServerAccessCredits(double t, SimQueue queue) {
        this.notifyQueueChanged(t, queue);
    }

    public void notifyRegainedServerAccessCredits(double t, SimQueue queue) {
        this.notifyQueueChanged(t, queue);
    }

    @Override
    public void notifyResetEntity(SimEntity entity) {
        if (entity != null && entity instanceof SimQueue && (SimQueue)entity == this.queue) {
            this.arrivalInfo.job = null;
            this.arrivalInfo.time = Double.NEGATIVE_INFINITY;
            this.arrivalInfo.counter = 0;
            this.dropInfo.job = null;
            this.dropInfo.time = Double.NEGATIVE_INFINITY;
            this.dropInfo.counter = 0;
            this.revocationInfo.job = null;
            this.revocationInfo.time = Double.NEGATIVE_INFINITY;
            this.revocationInfo.counter = 0;
            this.departureInfo.job = null;
            this.departureInfo.time = Double.NEGATIVE_INFINITY;
            this.departureInfo.counter = 0;
            this.notifyQueueChanged(this.eventList.getTime(), this.queue);
        }
    }

    @Override
    public void notifyUpdate(double t, SimEntity entity) {
    }

    public void notifyStateChanged(double time, SimEntity entity, List notifications) {
        this.notifyQueueChanged(time, (SimQueue)entity);
    }

    @Override
    public void notifyArrival(double t, SimJob job, SimQueue queue) {
        this.setArrivalInfo(t, job, queue);
        this.notifyQueueChanged(t, queue);
    }

    @Override
    public void notifyStart(double t, SimJob job, SimQueue queue) {
        this.notifyQueueChanged(t, queue);
    }

    @Override
    public void notifyDrop(double t, SimJob job, SimQueue queue) {
        this.setDropInfo(t, job, queue);
        this.notifyQueueChanged(t, queue);
    }

    @Override
    public void notifyRevocation(double t, SimJob job, SimQueue queue) {
        this.setRevocationInfo(t, job, queue);
        this.notifyQueueChanged(t, queue);
    }

    @Override
    public void notifyAutoRevocation(double t, SimJob job, SimQueue queue) {
        this.notifyRevocation(t, job, queue);
    }

    @Override
    public void notifyDeparture(double t, SimJob job, SimQueue queue) {
        this.setDepartureInfo(t, job, queue);
        this.notifyQueueChanged(t, queue);
    }

    public void notifyNewStartArmed(double t, SimQueue queue, boolean startArmed) {
        this.notifyQueueChanged(t, queue);
    }

    private class DepartureInfo {
        private SimJob job = null;
        private double time;
        private int counter = 0;

        private DepartureInfo() {
        }
    }

    private class RevocationInfo {
        private SimJob job = null;
        private double time;
        private int counter = 0;

        private RevocationInfo() {
        }
    }

    private class DropInfo {
        private SimJob job = null;
        private double time;
        private int counter = 0;

        private DropInfo() {
        }
    }

    private class ArrivalInfo {
        private SimJob job = null;
        private double time;
        private int counter = 0;

        private ArrivalInfo() {
        }
    }
}

