/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueComposite;
import org.javades.jqueues.r5.util.swing.KnownSimQueue;
import org.javades.jsimulation.r5.SimEventList;

public class JSimQueueCreationDialog
extends JDialog
implements ItemListener {
    private final Frame frame;
    private final SimEventList eventList;
    private SimQueue createdQueue = null;
    private final KnownSimQueue.Parameters parameters = new KnownSimQueue.Parameters();
    private final JComboBox queueTypeComboBox;
    private final TableModel tableModel = new QueuesTableModel();
    private final JTable table = new JTable(this.tableModel);
    final JButton moveUpSubQueueButton = new JButton("Up");
    final JButton moveDownSubQueueButton = new JButton("Down");
    final JButton addSubQueueButton = new JButton("Add");
    final JButton insertSubQueueButton = new JButton("Insert");
    final JButton deleteSubQueueButton = new JButton("Delete");
    final JTextField numberOfServersTextField = new JTextField("Number of Servers Value");
    final JTextField bufferSizeTextField = new JTextField("Buffer Size Value");
    final JTextField waitServiceTimeTextField = new JTextField("Wait/Service Time Value");
    final JTextField startTimeTextField = new JTextField("Start Time Value");
    final JCheckBox queueAccessVacationCheckBox = new JCheckBox();
    final JTextField serverAccessCreditsTextField = new JTextField("Server-Access Credits Value");
    final JCheckBox onlyWaitingJobsCheckBox = new JCheckBox();
    final JTextField feedbackProbabilityTextField = new JTextField("Feedback Probability Value");
    final JTextField numberOfVisitsTextField = new JTextField("Number of Visits Value");
    private OtherParametersDialog otherParametersDialog = null;

    public final SimQueue getCreatedQueue() {
        return this.createdQueue;
    }

    private void setQueueType(KnownSimQueue queueType) {
        if (queueType != null) {
            this.table.setEnabled(queueType.isComposite());
            this.table.setBackground(queueType.isComposite() ? this.getBackground() : new Color(255, 192, 192));
            int defaultNumberOfServers = queueType.getNumberOfServersProfile().getDefValue();
            this.numberOfServersTextField.setText(defaultNumberOfServers == -1 ? "Infinite" : Integer.toString(defaultNumberOfServers));
            this.parameters.numberOfServers = defaultNumberOfServers;
            boolean numberOfServersEditable = queueType.getNumberOfServersProfile().isUserSettable();
            this.numberOfServersTextField.setEditable(numberOfServersEditable);
            this.numberOfServersTextField.setBackground(numberOfServersEditable ? this.getBackground() : new Color(255, 192, 192));
            int defaultBufferSize = queueType.getBufferSizeProfile().getDefValue();
            this.bufferSizeTextField.setText(defaultBufferSize == -1 ? "Infinite" : Integer.toString(defaultBufferSize));
            this.parameters.bufferSize = defaultBufferSize;
            boolean bufferSizeEditable = queueType.getBufferSizeProfile().isUserSettable();
            this.bufferSizeTextField.setEditable(bufferSizeEditable);
            this.bufferSizeTextField.setBackground(bufferSizeEditable ? this.getBackground() : new Color(255, 192, 192));
            double defaultWaitServiceTime = queueType.getWaitServiceTimeProfile().getDefValue();
            this.waitServiceTimeTextField.setText(Double.toString(defaultWaitServiceTime));
            this.parameters.waitServiceTime = defaultWaitServiceTime;
            boolean waitServiceTimeEditable = queueType.getWaitServiceTimeProfile().isUserSettable();
            this.waitServiceTimeTextField.setEditable(waitServiceTimeEditable);
            this.waitServiceTimeTextField.setBackground(waitServiceTimeEditable ? this.getBackground() : new Color(255, 192, 192));
        }
    }

    private void createQueueAndClose() {
        SimQueue createdQueue = ((KnownSimQueue)((Object)this.queueTypeComboBox.getSelectedItem())).newInstance(this.parameters);
        if (createdQueue == null) {
            JOptionPane.showConfirmDialog(this, "Could not create SimQueue!", "Error", 2, 0);
        } else {
            this.createdQueue = createdQueue;
            this.eventList.reset(this.parameters.startTime);
            this.setVisible(false);
        }
    }

    public JSimQueueCreationDialog(Frame frame, SimEventList eventList, SimQueue queue) {
        super(frame, "Create Queue", true);
        if (eventList == null) {
            throw new IllegalArgumentException();
        }
        this.frame = frame;
        this.parameters.eventList = this.eventList = eventList;
        this.queueTypeComboBox = new JComboBox<KnownSimQueue>(KnownSimQueue.values());
        if (queue != null) {
            this.queueTypeComboBox.setSelectedItem((Object)KnownSimQueue.valueOf(queue));
        }
        this.parameters.queues = new LinkedHashSet<SimQueue>();
        if (queue != null && queue instanceof SimQueueComposite) {
            this.parameters.queues.addAll(((SimQueueComposite)queue).getQueues());
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.queueTypeComboBox.setPreferredSize(new Dimension(200, 50));
        this.queueTypeComboBox.setMaximumSize(new Dimension(200, 50));
        this.queueTypeComboBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 4, true), "Select Queue Type"));
        this.add(this.queueTypeComboBox);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box subQueuesBox = new Box(3);
        if (this.queueTypeComboBox.getSelectedItem() != null && ((KnownSimQueue)((Object)this.queueTypeComboBox.getSelectedItem())).isComposite()) {
            this.table.setBackground(this.getBackground());
            this.table.setEnabled(true);
        } else {
            this.table.setBackground(new Color(255, 192, 192));
            this.table.setEnabled(false);
        }
        this.table.setSelectionMode(0);
        this.table.setPreferredSize(new Dimension(200, 200));
        this.table.setMaximumSize(new Dimension(200, 200));
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        scrollPane.setMaximumSize(new Dimension(400, 200));
        subQueuesBox.add(scrollPane);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box tableButtonBox = new Box(2);
        this.moveUpSubQueueButton.addActionListener(new MoveUpQueueButtonListener());
        this.moveDownSubQueueButton.addActionListener(new MoveDownQueueButtonListener());
        this.addSubQueueButton.addActionListener(new AddSubQueueButtonListener());
        this.insertSubQueueButton.addActionListener(new InsertSubQueueButtonListener());
        this.deleteSubQueueButton.addActionListener(new DeleteSubQueueButtonListener());
        tableButtonBox.add(this.moveUpSubQueueButton);
        tableButtonBox.add(this.moveDownSubQueueButton);
        tableButtonBox.add(this.addSubQueueButton);
        tableButtonBox.add(this.insertSubQueueButton);
        tableButtonBox.add(this.deleteSubQueueButton);
        subQueuesBox.add(tableButtonBox);
        this.add(subQueuesBox);
        subQueuesBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 4, true), "Sub-Queues"));
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel parametersPanel = new JPanel();
        JLabel numberOfServersLabel = new JLabel("Number of Servers");
        JLabel bufferSizeLabel = new JLabel("Buffer Size");
        JLabel waitServiceTimeLabel = new JLabel("Wait/Service Time");
        NumberOfServersTextFieldListener numberOfServersTextFieldListener = new NumberOfServersTextFieldListener();
        this.numberOfServersTextField.addActionListener(numberOfServersTextFieldListener);
        this.numberOfServersTextField.addFocusListener(numberOfServersTextFieldListener);
        BufferSizeTextFieldListener bufferSizeTextFieldListener = new BufferSizeTextFieldListener();
        this.bufferSizeTextField.addActionListener(bufferSizeTextFieldListener);
        this.bufferSizeTextField.addFocusListener(bufferSizeTextFieldListener);
        WaitServiceTimeTextFieldListener waitServiceTimeTextFieldListener = new WaitServiceTimeTextFieldListener();
        this.waitServiceTimeTextField.addActionListener(waitServiceTimeTextFieldListener);
        this.waitServiceTimeTextField.addFocusListener(waitServiceTimeTextFieldListener);
        JLabel otherParametersLabel = new JLabel("Other");
        JButton otherParametersButton = new JButton("Edit");
        otherParametersButton.addActionListener(new OtherParametersButtonListener());
        GroupLayout parametersLayout = new GroupLayout(parametersPanel);
        parametersPanel.setLayout(parametersLayout);
        parametersLayout.setAutoCreateGaps(true);
        parametersLayout.setAutoCreateContainerGaps(true);
        parametersLayout.setHorizontalGroup(parametersLayout.createSequentialGroup().addGroup(parametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(numberOfServersLabel).addComponent(bufferSizeLabel).addComponent(waitServiceTimeLabel).addComponent(otherParametersLabel)).addGroup(parametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numberOfServersTextField).addComponent(this.bufferSizeTextField).addComponent(this.waitServiceTimeTextField).addComponent(otherParametersButton)));
        parametersLayout.setVerticalGroup(parametersLayout.createSequentialGroup().addGroup(parametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(numberOfServersLabel).addComponent(this.numberOfServersTextField)).addGroup(parametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(bufferSizeLabel).addComponent(this.bufferSizeTextField)).addGroup(parametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(waitServiceTimeLabel).addComponent(this.waitServiceTimeTextField)).addGroup(parametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(otherParametersLabel).addComponent(otherParametersButton)));
        parametersPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 4, true), "Parameters"));
        this.add(parametersPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel initialStatePanel = new JPanel();
        JLabel startTimeLabel = new JLabel("Start Time");
        JLabel queueAccessVacationLabel = new JLabel("Queue Access Vacation");
        JLabel serverAccessCreditsLabel = new JLabel("Server-Access Credits");
        this.startTimeTextField.setText(Double.toString(this.parameters.startTime));
        StartTimeTextFieldListener startTimeTextFieldListener = new StartTimeTextFieldListener();
        this.startTimeTextField.addActionListener(startTimeTextFieldListener);
        this.startTimeTextField.addFocusListener(startTimeTextFieldListener);
        this.queueAccessVacationCheckBox.setSelected(queue == null ? false : queue.isQueueAccessVacation());
        this.parameters.queueAccessVacation = queue == null ? false : queue.isQueueAccessVacation();
        this.queueAccessVacationCheckBox.addItemListener(new QueueAccessVacationCheckBoxListener());
        String initServerAccessCreditsString = queue == null || queue.getServerAccessCredits() == Integer.MAX_VALUE ? "Infinity" : Integer.toString(queue.getServerAccessCredits());
        this.serverAccessCreditsTextField.setText(initServerAccessCreditsString);
        ServerAccessCreditsTextFieldListener serverAccessCreditsTextFieldListener = new ServerAccessCreditsTextFieldListener();
        this.serverAccessCreditsTextField.addActionListener(serverAccessCreditsTextFieldListener);
        this.serverAccessCreditsTextField.addFocusListener(serverAccessCreditsTextFieldListener);
        GroupLayout initialStateLayout = new GroupLayout(initialStatePanel);
        initialStatePanel.setLayout(initialStateLayout);
        initialStateLayout.setAutoCreateGaps(true);
        initialStateLayout.setAutoCreateContainerGaps(true);
        initialStateLayout.setHorizontalGroup(initialStateLayout.createSequentialGroup().addGroup(initialStateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(startTimeLabel).addComponent(queueAccessVacationLabel).addComponent(serverAccessCreditsLabel)).addGroup(initialStateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startTimeTextField).addComponent(this.queueAccessVacationCheckBox).addComponent(this.serverAccessCreditsTextField)));
        initialStateLayout.setVerticalGroup(initialStateLayout.createSequentialGroup().addGroup(initialStateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(startTimeLabel).addComponent(this.startTimeTextField)).addGroup(initialStateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(queueAccessVacationLabel).addComponent(this.queueAccessVacationCheckBox)).addGroup(initialStateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(serverAccessCreditsLabel).addComponent(this.serverAccessCreditsTextField)));
        initialStatePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 4, true), "Initial State"));
        this.add(initialStatePanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel exitPanel = new JPanel();
        GroupLayout exitLayout = new GroupLayout(exitPanel);
        exitPanel.setLayout(exitLayout);
        exitLayout.setAutoCreateGaps(true);
        exitLayout.setAutoCreateContainerGaps(true);
        JButton createButton = new JButton(new AbstractAction("Create"){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                JSimQueueCreationDialog.this.createQueueAndClose();
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                JSimQueueCreationDialog.this.setVisible(false);
            }
        });
        exitLayout.setHorizontalGroup(exitLayout.createSequentialGroup().addComponent(createButton).addComponent(cancelButton));
        exitLayout.setVerticalGroup(exitLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(createButton).addComponent(cancelButton));
        exitPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 4, true), "Exit"));
        this.add(exitPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setQueueType((KnownSimQueue)((Object)this.queueTypeComboBox.getSelectedItem()));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.pack();
        this.setLocationRelativeTo(frame);
        this.queueTypeComboBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            KnownSimQueue item = (KnownSimQueue)((Object)event.getItem());
            this.setQueueType(item);
        }
    }

    private final class NumberOfVisitsTextFieldListener
    implements ActionListener,
    FocusListener {
        private NumberOfVisitsTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            String text = JSimQueueCreationDialog.this.numberOfVisitsTextField.getText();
            if (text != null) {
                try {
                    int numberOfVisitsInt = Integer.parseInt(text);
                    if (numberOfVisitsInt >= 0) {
                        ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfVisits = numberOfVisitsInt;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            JSimQueueCreationDialog.this.numberOfVisitsTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfVisits));
        }
    }

    private final class FeedbackProbabilityTextFieldListener
    implements ActionListener,
    FocusListener {
        private FeedbackProbabilityTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            String text = JSimQueueCreationDialog.this.feedbackProbabilityTextField.getText();
            if (text != null) {
                try {
                    double feedbackProbabilityDouble = Double.parseDouble(text);
                    if (feedbackProbabilityDouble >= 0.0 && feedbackProbabilityDouble <= 1.0) {
                        ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.feedbackProbability = feedbackProbabilityDouble;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            JSimQueueCreationDialog.this.feedbackProbabilityTextField.setText(Double.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.feedbackProbability));
        }
    }

    private final class OnlyWaitingJobsBoxCheckBoxListener
    implements ItemListener {
        private OnlyWaitingJobsBoxCheckBoxListener() {
        }

        @Override
        public final void itemStateChanged(ItemEvent ie) {
            ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.onlyWaitingJobs = ie.getStateChange() == 1;
        }
    }

    private final class OtherParametersButtonListener
    extends AbstractAction {
        private OtherParametersButtonListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            if (JSimQueueCreationDialog.this.otherParametersDialog == null) {
                JSimQueueCreationDialog.this.otherParametersDialog = new OtherParametersDialog();
            }
            JSimQueueCreationDialog.this.otherParametersDialog.pack();
            JSimQueueCreationDialog.this.otherParametersDialog.setVisible(true);
        }
    }

    private final class OtherParametersDialog
    extends JDialog {
        public OtherParametersDialog() {
            super(JSimQueueCreationDialog.this, "Other Parameters", true);
            JLabel onlyWaitingJobsLabel = new JLabel("Only Waiting Jobs");
            JSimQueueCreationDialog.this.onlyWaitingJobsCheckBox.setSelected(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.onlyWaitingJobs);
            JSimQueueCreationDialog.this.onlyWaitingJobsCheckBox.addItemListener(new OnlyWaitingJobsBoxCheckBoxListener());
            JLabel feedbackProbabilityLabel = new JLabel("Feedback Probability");
            JSimQueueCreationDialog.this.feedbackProbabilityTextField.setText(Double.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.feedbackProbability));
            FeedbackProbabilityTextFieldListener feedbackProbabilityTextFieldListener = new FeedbackProbabilityTextFieldListener();
            JSimQueueCreationDialog.this.feedbackProbabilityTextField.addActionListener(feedbackProbabilityTextFieldListener);
            JSimQueueCreationDialog.this.feedbackProbabilityTextField.addFocusListener(feedbackProbabilityTextFieldListener);
            JLabel numberOfVisitsLabel = new JLabel("Number of Visits");
            JSimQueueCreationDialog.this.numberOfVisitsTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfVisits));
            NumberOfVisitsTextFieldListener numberOfVisitsTextFieldListener = new NumberOfVisitsTextFieldListener();
            JSimQueueCreationDialog.this.numberOfVisitsTextField.addActionListener(numberOfVisitsTextFieldListener);
            JSimQueueCreationDialog.this.numberOfVisitsTextField.addFocusListener(numberOfVisitsTextFieldListener);
            JPanel jPanel = new JPanel();
            this.getContentPane().add(jPanel);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 4, true), "Other Parameters"));
            GroupLayout layout = new GroupLayout(jPanel);
            jPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(onlyWaitingJobsLabel).addComponent(feedbackProbabilityLabel).addComponent(numberOfVisitsLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(JSimQueueCreationDialog.this.onlyWaitingJobsCheckBox).addComponent(JSimQueueCreationDialog.this.feedbackProbabilityTextField).addComponent(JSimQueueCreationDialog.this.numberOfVisitsTextField)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(onlyWaitingJobsLabel).addComponent(JSimQueueCreationDialog.this.onlyWaitingJobsCheckBox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(feedbackProbabilityLabel).addComponent(JSimQueueCreationDialog.this.feedbackProbabilityTextField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(numberOfVisitsLabel).addComponent(JSimQueueCreationDialog.this.numberOfVisitsTextField)));
        }
    }

    private final class ServerAccessCreditsTextFieldListener
    implements ActionListener,
    FocusListener {
        private ServerAccessCreditsTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            block14: {
                String text = JSimQueueCreationDialog.this.serverAccessCreditsTextField.getText();
                if (text != null) {
                    if (text.trim().startsWith("inf") || text.trim().startsWith("Inf")) {
                        JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText("Infinity");
                        ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits = Integer.MAX_VALUE;
                    } else {
                        try {
                            int serverAccessCreditsInt = Integer.parseInt(text);
                            if (serverAccessCreditsInt < 0) {
                                if (((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits == Integer.MAX_VALUE) {
                                    JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText("Infinity");
                                } else {
                                    JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits));
                                }
                            } else {
                                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits = serverAccessCreditsInt;
                                if (serverAccessCreditsInt == Integer.MAX_VALUE) {
                                    JSimQueueCreationDialog.this.numberOfServersTextField.setText("Infinity");
                                }
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits == Integer.MAX_VALUE) {
                                JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText("Infinity");
                                break block14;
                            }
                            JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits));
                        }
                    }
                } else if (((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits == Integer.MAX_VALUE) {
                    JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText("Infinity");
                } else {
                    JSimQueueCreationDialog.this.serverAccessCreditsTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.serverAccessCredits));
                }
            }
        }
    }

    private final class QueueAccessVacationCheckBoxListener
    implements ItemListener {
        private QueueAccessVacationCheckBoxListener() {
        }

        @Override
        public final void itemStateChanged(ItemEvent ie) {
            ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queueAccessVacation = ie.getStateChange() == 1;
        }
    }

    private final class StartTimeTextFieldListener
    implements ActionListener,
    FocusListener {
        private StartTimeTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            String text = JSimQueueCreationDialog.this.startTimeTextField.getText();
            if (text != null) {
                try {
                    double startTimeDouble;
                    ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.startTime = startTimeDouble = Double.parseDouble(text);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            JSimQueueCreationDialog.this.startTimeTextField.setText(Double.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.startTime));
        }
    }

    private final class WaitServiceTimeTextFieldListener
    implements ActionListener,
    FocusListener {
        private WaitServiceTimeTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            KnownSimQueue knownQueue = (KnownSimQueue)((Object)JSimQueueCreationDialog.this.queueTypeComboBox.getSelectedItem());
            if (knownQueue == null) {
                JSimQueueCreationDialog.this.waitServiceTimeTextField.setText("NaN");
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.waitServiceTime = Double.NaN;
                return;
            }
            String text = JSimQueueCreationDialog.this.waitServiceTimeTextField.getText();
            if (text != null) {
                try {
                    double waitServiceTimeDouble = Double.parseDouble(text);
                    if (knownQueue.getWaitServiceTimeProfile().isValidValue(waitServiceTimeDouble)) {
                        ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.waitServiceTime = waitServiceTimeDouble;
                    }
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!knownQueue.getWaitServiceTimeProfile().isValidValue(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.waitServiceTime)) {
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.waitServiceTime = knownQueue.getWaitServiceTimeProfile().getDefValue();
            }
            JSimQueueCreationDialog.this.waitServiceTimeTextField.setText(Double.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.waitServiceTime));
        }
    }

    private final class BufferSizeTextFieldListener
    implements ActionListener,
    FocusListener {
        private BufferSizeTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            KnownSimQueue knownQueue = (KnownSimQueue)((Object)JSimQueueCreationDialog.this.queueTypeComboBox.getSelectedItem());
            if (knownQueue == null) {
                JSimQueueCreationDialog.this.bufferSizeTextField.setText("0");
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.bufferSize = 0;
                return;
            }
            String text = JSimQueueCreationDialog.this.bufferSizeTextField.getText();
            if (text != null) {
                try {
                    int bufferSizeInt = Integer.parseInt(text);
                    if (knownQueue.getBufferSizeProfile().isValidValue(bufferSizeInt)) {
                        ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.bufferSize = bufferSizeInt;
                    }
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!knownQueue.getBufferSizeProfile().isValidValue(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.bufferSize)) {
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.bufferSize = knownQueue.getBufferSizeProfile().getDefValue();
            }
            JSimQueueCreationDialog.this.bufferSizeTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.bufferSize));
        }
    }

    private final class NumberOfServersTextFieldListener
    implements ActionListener,
    FocusListener {
        private NumberOfServersTextFieldListener() {
        }

        @Override
        public final void focusGained(FocusEvent fe) {
        }

        @Override
        public final void focusLost(FocusEvent fe) {
            this.actionPerformed();
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            this.actionPerformed();
        }

        private void actionPerformed() {
            KnownSimQueue knownQueue = (KnownSimQueue)((Object)JSimQueueCreationDialog.this.queueTypeComboBox.getSelectedItem());
            if (knownQueue == null) {
                JSimQueueCreationDialog.this.numberOfServersTextField.setText("0");
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfServers = 0;
                return;
            }
            String text = JSimQueueCreationDialog.this.numberOfServersTextField.getText();
            if (text != null) {
                try {
                    int numberOfServersInt = Integer.parseInt(text);
                    if (knownQueue.getNumberOfServersProfile().isValidValue(numberOfServersInt)) {
                        ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfServers = numberOfServersInt;
                    }
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!knownQueue.getNumberOfServersProfile().isValidValue(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfServers)) {
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfServers = knownQueue.getNumberOfServersProfile().getDefValue();
            }
            JSimQueueCreationDialog.this.numberOfServersTextField.setText(Integer.toString(((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.numberOfServers));
        }
    }

    private final class DeleteSubQueueButtonListener
    extends AbstractAction {
        private DeleteSubQueueButtonListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            int selectedIndex = JSimQueueCreationDialog.this.table.getSelectedRow();
            if (selectedIndex < 0) {
                return;
            }
            if (selectedIndex >= ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size()) {
                System.err.println("Unexpected software problem with selected index of sub-queues table!");
                System.err.println("-> Ignoring request!");
                return;
            }
            Iterator<SimQueue> iterator = ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.iterator();
            LinkedHashSet<SimQueue> newSubQueues = new LinkedHashSet<SimQueue>();
            for (int i = 0; i < selectedIndex; ++i) {
                newSubQueues.add(iterator.next());
            }
            iterator.next();
            while (iterator.hasNext()) {
                newSubQueues.add(iterator.next());
            }
            ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues = newSubQueues;
            ((AbstractTableModel)JSimQueueCreationDialog.this.tableModel).fireTableDataChanged();
        }
    }

    private final class InsertSubQueueButtonListener
    extends AbstractAction {
        private InsertSubQueueButtonListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            JSimQueueCreationDialog dialog = new JSimQueueCreationDialog(JSimQueueCreationDialog.this.frame, JSimQueueCreationDialog.this.eventList, null);
            dialog.setTitle("Create New Sub-Queue");
            dialog.setVisible(true);
            SimQueue createdSubQueue = dialog.getCreatedQueue();
            if (createdSubQueue != null) {
                int selectedIndex = JSimQueueCreationDialog.this.table.getSelectedRow();
                if (selectedIndex >= ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size()) {
                    System.err.println("Unexpected software problem with selected index of sub-queues table!");
                    System.err.println("-> Ignoring request!");
                    return;
                }
                Iterator<SimQueue> iterator = ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.iterator();
                LinkedHashSet<SimQueue> newSubQueues = new LinkedHashSet<SimQueue>();
                for (int i = 0; i < selectedIndex; ++i) {
                    newSubQueues.add(iterator.next());
                }
                newSubQueues.add(createdSubQueue);
                while (iterator.hasNext()) {
                    newSubQueues.add(iterator.next());
                }
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues = newSubQueues;
                ((AbstractTableModel)JSimQueueCreationDialog.this.tableModel).fireTableDataChanged();
            }
        }
    }

    private final class AddSubQueueButtonListener
    extends AbstractAction {
        private AddSubQueueButtonListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            JSimQueueCreationDialog dialog = new JSimQueueCreationDialog(JSimQueueCreationDialog.this.frame, JSimQueueCreationDialog.this.eventList, null);
            dialog.setTitle("Create New Sub-Queue");
            dialog.setVisible(true);
            SimQueue createdSubQueue = dialog.getCreatedQueue();
            if (createdSubQueue != null) {
                ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.add(createdSubQueue);
                ((AbstractTableModel)JSimQueueCreationDialog.this.tableModel).fireTableDataChanged();
            }
        }
    }

    private final class MoveDownQueueButtonListener
    extends AbstractAction {
        private MoveDownQueueButtonListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            int selectedIndex = JSimQueueCreationDialog.this.table.getSelectedRow();
            if (selectedIndex < 0 || ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size() <= 1 || selectedIndex == ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size() - 1) {
                return;
            }
            if (selectedIndex >= ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size()) {
                System.err.println("Unexpected software problem with selected index of sub-queues table!");
                System.err.println("-> Ignoring request!");
                return;
            }
            Iterator<SimQueue> iterator = ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.iterator();
            LinkedHashSet<SimQueue> newSubQueues = new LinkedHashSet<SimQueue>();
            for (int i = 0; i < selectedIndex; ++i) {
                newSubQueues.add(iterator.next());
            }
            SimQueue q1 = iterator.next();
            SimQueue q2 = iterator.next();
            newSubQueues.add(q2);
            newSubQueues.add(q1);
            while (iterator.hasNext()) {
                newSubQueues.add(iterator.next());
            }
            ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues = newSubQueues;
            ((AbstractTableModel)JSimQueueCreationDialog.this.tableModel).fireTableDataChanged();
        }
    }

    private final class MoveUpQueueButtonListener
    extends AbstractAction {
        private MoveUpQueueButtonListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            int selectedIndex = JSimQueueCreationDialog.this.table.getSelectedRow();
            if (selectedIndex <= 0 || ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size() <= 1) {
                return;
            }
            if (selectedIndex >= ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size()) {
                System.err.println("Unexpected software problem with selected index of sub-queues table!");
                System.err.println("-> Ignoring request!");
                return;
            }
            Iterator<SimQueue> iterator = ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.iterator();
            LinkedHashSet<SimQueue> newSubQueues = new LinkedHashSet<SimQueue>();
            for (int i = 0; i < selectedIndex - 1; ++i) {
                newSubQueues.add(iterator.next());
            }
            SimQueue q1 = iterator.next();
            SimQueue q2 = iterator.next();
            newSubQueues.add(q2);
            newSubQueues.add(q1);
            while (iterator.hasNext()) {
                newSubQueues.add(iterator.next());
            }
            ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues = newSubQueues;
            ((AbstractTableModel)JSimQueueCreationDialog.this.tableModel).fireTableDataChanged();
        }
    }

    private final class QueuesTableModel
    extends AbstractTableModel {
        private QueuesTableModel() {
        }

        @Override
        public final int getRowCount() {
            return ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size();
        }

        @Override
        public final int getColumnCount() {
            return 3;
        }

        @Override
        public final String getColumnName(int column) {
            if (column < 0) {
                return null;
            }
            if (column == 0) {
                return "Type";
            }
            if (column == 1) {
                return "Name";
            }
            if (column == 2) {
                return "Composite";
            }
            return null;
        }

        @Override
        public final Class<?> getColumnClass(int column) {
            if (column < 0) {
                return null;
            }
            if (column == 0) {
                return KnownSimQueue.class;
            }
            if (column == 1) {
                return String.class;
            }
            if (column == 2) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public final Object getValueAt(int r, int c) {
            if (r < 0 || r >= ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.size()) {
                return null;
            }
            if (c < 0 || c >= 2) {
                return null;
            }
            Iterator<SimQueue> iterator = ((JSimQueueCreationDialog)JSimQueueCreationDialog.this).parameters.queues.iterator();
            SimQueue q = iterator.next();
            for (int i = 0; i < r; ++i) {
                q = iterator.next();
            }
            if (c == 0) {
                return KnownSimQueue.valueOf(q);
            }
            if (c == 1) {
                return q.toString();
            }
            if (c == 2) {
                return KnownSimQueue.valueOf(q).isComposite();
            }
            throw new RuntimeException();
        }
    }
}

