/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.swing;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.collector.DropCol;
import org.javades.jqueues.r5.entity.jq.queue.composite.ctandem2.CTandem2;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.Enc;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.EncHS;
import org.javades.jqueues.r5.entity.jq.queue.composite.feedback.FB_p;
import org.javades.jqueues.r5.entity.jq.queue.composite.feedback.FB_v;
import org.javades.jqueues.r5.entity.jq.queue.composite.jackson.Jackson;
import org.javades.jqueues.r5.entity.jq.queue.composite.parallel.JSQ;
import org.javades.jqueues.r5.entity.jq.queue.composite.parallel.Par;
import org.javades.jqueues.r5.entity.jq.queue.composite.tandem.Tandem;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS_B;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS_c;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IC;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IS_CST;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LJF;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.NoBuffer_c;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.RANDOM;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.SJF;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.PS;
import org.javades.jqueues.r5.entity.jq.queue.serverless.DELAY;
import org.javades.jqueues.r5.entity.jq.queue.serverless.DROP;
import org.javades.jqueues.r5.entity.jq.queue.serverless.GATE;
import org.javades.jqueues.r5.entity.jq.queue.serverless.SINK;
import org.javades.jqueues.r5.entity.jq.queue.serverless.ZERO;
import org.javades.jsimulation.r5.SimEventList;

public enum KnownSimQueue {
    DROP("DROP", false, DROP.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ZERO, IntegerParameterProfile.IPP_IRRELEVANT, DoubleParameterProfile.DPP_IRRELEVANT),
    SINK("SINK", false, SINK.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ZERO, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    DELAY("DELAY", false, DELAY.class, GeneratorProfile.SE_WST, IntegerParameterProfile.IPP_ALWAYS_ZERO, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_POSITIVE),
    ZERO("ZERO", false, ZERO.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ZERO, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    GATE("GATE", false, GATE.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ZERO, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    NO_BUFFER_c("NoBuffer_c", false, NoBuffer_c.class, GeneratorProfile.SE_c, IntegerParameterProfile.IPP_FINITE, IntegerParameterProfile.IPP_ALWAYS_ZERO, DoubleParameterProfile.DPP_IRRELEVANT),
    FCFS("FCFS", false, FCFS.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    FCFS_B("FCFS_B", false, FCFS_B.class, GeneratorProfile.SE_B, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_FINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    FCFS_c("FCFS_c", false, FCFS_c.class, GeneratorProfile.SE_c, IntegerParameterProfile.IPP_FINITE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    LCFS("LCFS", false, LCFS.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    RANDOM("RANDOM", false, RANDOM.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    SJF("SJF", false, SJF.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    LJF("LJF", false, LJF.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    IS("IS", false, IS.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    IS_CST("IS_CST", false, IS_CST.class, GeneratorProfile.SE_WST, IntegerParameterProfile.IPP_ALWAYS_INFINITE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_POSITIVE),
    IC("IC", false, IC.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    PS("PS", false, PS.class, GeneratorProfile.SE, IntegerParameterProfile.IPP_ALWAYS_ONE, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    ENC("Enc", true, Enc.class, GeneratorProfile.SE_Q_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    ENC_HS("EncHS", true, EncHS.class, GeneratorProfile.SE_Q_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    DROP_COLLECTOR("DropCol", true, DropCol.class, GeneratorProfile.SE_Q1_Q2_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    TANDEM("Tandem", true, Tandem.class, GeneratorProfile.SE_QSET_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    COMP_TANDEM_2("CTandem2", true, CTandem2.class, GeneratorProfile.SE_Q1_Q2_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    PARALLEL("Par", true, Par.class, GeneratorProfile.UNKNOWN, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    JSQ("JSQ", true, JSQ.class, GeneratorProfile.SE_QSET_DSJF_OWJ_RNG, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    FB_PROB("FB_p", true, FB_p.class, GeneratorProfile.SE_Q_PFB_RNG_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    FB_VISITS("FB_n", true, FB_v.class, GeneratorProfile.SE_Q_NUMV_DSJF, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    JACKSON("Jackson", true, Jackson.class, GeneratorProfile.UNKNOWN, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_ALWAYS_INFINITE, DoubleParameterProfile.DPP_IRRELEVANT),
    UNKNOWN("Unknown", true, null, GeneratorProfile.UNKNOWN, IntegerParameterProfile.IPP_IRRELEVANT, IntegerParameterProfile.IPP_IRRELEVANT, DoubleParameterProfile.DPP_IRRELEVANT);

    private final Class<? extends SimQueue> queueClass;
    private final boolean composite;
    private final String defaultName;
    private final GeneratorProfile generatorProfile;
    private final IntegerParameterProfile numberOfServersProfile;
    private final IntegerParameterProfile bufferSizeProfile;
    private final DoubleParameterProfile waitServiceTimeProfile;

    private KnownSimQueue(String defaultName, boolean composite, Class<? extends SimQueue> queueClass, GeneratorProfile generatorProfile, IntegerParameterProfile numberOfServersProfile, IntegerParameterProfile bufferSizeProfile, DoubleParameterProfile waitServiceTimeProfile) {
        this.queueClass = queueClass;
        this.defaultName = defaultName;
        this.composite = composite;
        this.generatorProfile = generatorProfile;
        this.numberOfServersProfile = numberOfServersProfile;
        this.bufferSizeProfile = bufferSizeProfile;
        this.waitServiceTimeProfile = waitServiceTimeProfile;
    }

    public final Class<? extends SimQueue> getQueueClass() {
        return this.queueClass;
    }

    public final boolean isComposite() {
        return this.composite;
    }

    public final String getDefaultName() {
        return this.defaultName;
    }

    private final GeneratorProfile getGeneratorProfile() {
        return this.generatorProfile;
    }

    public final IntegerParameterProfile getNumberOfServersProfile() {
        return this.numberOfServersProfile;
    }

    public final IntegerParameterProfile getBufferSizeProfile() {
        return this.bufferSizeProfile;
    }

    public final DoubleParameterProfile getWaitServiceTimeProfile() {
        return this.waitServiceTimeProfile;
    }

    public final SimQueue newInstance(Parameters parameters) {
        GeneratorProfile generatorProfile = this.getGeneratorProfile();
        if (generatorProfile == null) {
            System.err.println("No generator profile on " + (Object)((Object)this) + ".");
            return null;
        }
        SimQueue queue = generatorProfile.newInstance(this.getQueueClass(), parameters);
        if (queue != null) {
            if (parameters.queueAccessVacation) {
                queue.setQueueAccessVacation(Double.NEGATIVE_INFINITY, true);
            }
            if (Double.isFinite(parameters.serverAccessCredits)) {
                queue.setServerAccessCredits(Double.NEGATIVE_INFINITY, parameters.serverAccessCredits);
            }
        } else {
            System.err.println("Generator profile " + (Object)((Object)generatorProfile) + " on " + (Object)((Object)this) + " failed to generate a new SimQueue.");
        }
        return queue;
    }

    public static KnownSimQueue valueOf(SimQueue queue) {
        if (queue == null) {
            return null;
        }
        for (KnownSimQueue ksq : KnownSimQueue.values()) {
            if (queue.getClass() != ksq.getQueueClass()) continue;
            return ksq;
        }
        System.err.println("Unknown SimQueue type of " + queue + ".");
        return UNKNOWN;
    }

    public static final class Parameters {
        public SimEventList eventList = null;
        public Set<SimQueue> queues = null;
        public boolean queueAccessVacation = false;
        public int serverAccessCredits = Integer.MAX_VALUE;
        public double waitServiceTime = 0.0;
        public int numberOfServers = 1;
        public int bufferSize = 10;
        public double startTime = Double.NEGATIVE_INFINITY;
        public boolean onlyWaitingJobs = false;
        public double feedbackProbability = 0.5;
        public int numberOfVisits = 1;
    }

    public static enum DoubleParameterProfile {
        DPP_IRRELEVANT(0.0, 0.0, 0.0),
        DPP_ALWAYS_ZERO(0.0, 0.0, 0.0),
        DPP_ALWAYS_ONE(1.0, 1.0, 1.0),
        DPP_ZERO_ONE_INC(0.0, 1.0, 0.5),
        DPP_POSITIVE(0.0, Double.POSITIVE_INFINITY, 1.0),
        DPP_ANY(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);

        private final double minVal;
        private final double maxVal;
        private final double defVal;

        private DoubleParameterProfile(double minVal, double maxVal, double defVal) {
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.defVal = defVal;
        }

        public final double getMinValue() {
            return this.minVal;
        }

        public final double getMaxValue() {
            return this.maxVal;
        }

        public final double getDefValue() {
            return this.defVal;
        }

        public final boolean isUserSettable() {
            return this.getMinValue() != this.getMaxValue();
        }

        public final boolean isValidValue(double val) {
            if (!this.isUserSettable()) {
                return val == this.getMinValue();
            }
            if (val < this.minVal) {
                return false;
            }
            return val <= this.maxVal;
        }
    }

    public static enum IntegerParameterProfile {
        IPP_IRRELEVANT(0, 0, 0),
        IPP_ALWAYS_ZERO(0, 0, 0),
        IPP_ALWAYS_ONE(1, 1, 1),
        IPP_ALWAYS_INFINITE(-1, -1, -1),
        IPP_NON_ZERO(1, -1, -1),
        IPP_FINITE(0, Integer.MAX_VALUE, 1),
        IPP_NON_ZERO_FINITE(1, Integer.MAX_VALUE, 1),
        IPP_ANY(0, -1, -1);

        private final int minVal;
        private final int maxVal;
        private final int defVal;

        private IntegerParameterProfile(int minVal, int maxVal, int defVal) {
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.defVal = defVal;
        }

        public final int getMinValue() {
            return this.minVal;
        }

        public final int getMaxValue() {
            return this.maxVal;
        }

        public final int getDefValue() {
            return this.defVal;
        }

        public final boolean isUserSettable() {
            return this.getMinValue() != this.getMaxValue();
        }

        public final boolean isValidValue(int val) {
            if (val < -1) {
                return false;
            }
            if (!this.isUserSettable()) {
                return val == this.getMinValue();
            }
            if (this.minVal == -1) {
                return val == -1;
            }
            if (val != -1 && val < this.minVal) {
                return false;
            }
            if (this.maxVal == -1) {
                return true;
            }
            return val != -1 && val <= this.maxVal;
        }
    }

    public static enum GeneratorProfile {
        SE(true, true, false, false, false, false, 0, 0, false, false, false),
        SE_WST(true, true, true, false, false, false, 0, 0, false, false, false),
        SE_c(true, true, false, true, false, false, 0, 0, false, false, false),
        SE_B(true, true, false, false, true, false, 0, 0, false, false, false),
        SE_Q_DSJF(true, true, false, false, false, true, 1, 1, false, false, false),
        SE_Q1_Q2_DSJF(true, true, false, false, false, true, 2, 2, false, false, false),
        SE_QSET_DSJF(true, true, false, false, false, true, 0, Integer.MAX_VALUE, false, false, false),
        SE_QSET_DSJF_OWJ_RNG(true, true, false, false, false, true, 0, Integer.MAX_VALUE, true, false, false),
        SE_Q_PFB_RNG_DSJF(true, true, false, false, false, true, 1, 1, false, true, false),
        SE_Q_NUMV_DSJF(true, true, false, false, false, true, 1, 1, false, false, true),
        UNKNOWN(false, false, false, false, false, false, 0, 0, false, false, false);

        private final boolean canInstantiate;
        private final boolean requiresSimEventList;
        private final boolean requiresWaitServiceTime;
        private final boolean requiresNumberOfServers;
        private final boolean requiresBufferSize;
        private final boolean requiresSubQueues;
        private final int minSubQueues;
        private final int maxSubQueues;
        private final boolean requiresOnlyWaitingJobs;
        private final boolean requiresFeedbackProbability;
        private final boolean requiresNumberOfVists;

        private GeneratorProfile(boolean canInstatiate, boolean requiresSimEventList, boolean requiresWaitServiceTime, boolean requiresNumberOfServers, boolean requiresBufferSize, boolean requiresSubQueues, int minSubQueues, int maxSubQueues, boolean requiresOnlyWaitingJobs, boolean requiresFeedbackProbability, boolean requiresNumberOfVisits) {
            this.canInstantiate = canInstatiate;
            this.requiresSimEventList = requiresSimEventList;
            this.requiresWaitServiceTime = requiresWaitServiceTime;
            this.requiresNumberOfServers = requiresNumberOfServers;
            this.requiresBufferSize = requiresBufferSize;
            this.requiresSubQueues = requiresSubQueues;
            this.minSubQueues = minSubQueues;
            this.maxSubQueues = maxSubQueues;
            this.requiresOnlyWaitingJobs = requiresOnlyWaitingJobs;
            this.requiresFeedbackProbability = requiresFeedbackProbability;
            this.requiresNumberOfVists = requiresNumberOfVisits;
        }

        private SimQueue newInstance(Class<? extends SimQueue> queueClass, Parameters parameters) {
            Set<SimQueue> copiedQueues;
            if (!this.canInstantiate) {
                System.err.println("Cannot instantiate profile " + (Object)((Object)this) + ".");
                return null;
            }
            if (queueClass == null) {
                System.err.println("Cannot instantiate null SimQueue class instance with profile " + (Object)((Object)this) + ".");
                return null;
            }
            if (parameters == null) {
                System.err.println("No parameters for new SimQueue instance with profile " + (Object)((Object)this) + ".");
                return null;
            }
            if (this.requiresSimEventList && parameters.eventList == null) {
                System.err.println("No event-list supplied for new SimQueue instance with profile " + (Object)((Object)this) + ".");
                return null;
            }
            if (this.requiresSubQueues) {
                if (parameters.queues == null) {
                    System.err.println("No sub-queues supplied for new SimQueue instance with profile " + (Object)((Object)this) + ".");
                    return null;
                }
                if (parameters.queues.size() < this.minSubQueues) {
                    System.err.println("Error: Not enough sub-queues supplied for new SimQueue instance with profile " + (Object)((Object)this) + ".");
                    System.err.println("-> Minimum:  " + this.minSubQueues + ".");
                    System.err.println("-> Supplied: " + parameters.queues.size() + ".");
                    return null;
                }
                if (parameters.queues.size() > this.maxSubQueues) {
                    System.err.println("Warning: Too many sub-queues supplied for new SimQueue instance with profile " + (Object)((Object)this) + ".");
                    System.err.println("-> Maximum:  " + this.maxSubQueues + ".");
                    System.err.println("-> Supplied: " + parameters.queues.size() + ".");
                }
                copiedQueues = AbstractSimQueueComposite.getCopySimQueues(parameters.queues);
            } else {
                copiedQueues = null;
            }
            try {
                if (this == SE) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class);
                    return constructor.newInstance(parameters.eventList);
                }
                if (this == SE_WST) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, Double.TYPE);
                    return constructor.newInstance(parameters.eventList, parameters.waitServiceTime);
                }
                if (this == SE_c) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, Integer.TYPE);
                    return constructor.newInstance(parameters.eventList, parameters.numberOfServers);
                }
                if (this == SE_B) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, Integer.TYPE);
                    return constructor.newInstance(parameters.eventList, parameters.bufferSize);
                }
                if (this == SE_Q_DSJF) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, SimQueue.class, DelegateSimJobFactory.class);
                    Iterator<SimQueue> iterator = copiedQueues.iterator();
                    SimQueue q = iterator.next();
                    return constructor.newInstance(parameters.eventList, q, null);
                }
                if (this == SE_Q1_Q2_DSJF) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, SimQueue.class, SimQueue.class, DelegateSimJobFactory.class);
                    Iterator<SimQueue> iterator = copiedQueues.iterator();
                    SimQueue q1 = iterator.next();
                    SimQueue q2 = iterator.next();
                    return constructor.newInstance(parameters.eventList, q1, q2, null);
                }
                if (this == SE_QSET_DSJF) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, Set.class, DelegateSimJobFactory.class);
                    return constructor.newInstance(parameters.eventList, copiedQueues, null);
                }
                if (this == SE_QSET_DSJF_OWJ_RNG) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, Set.class, DelegateSimJobFactory.class, Boolean.TYPE, Random.class);
                    return constructor.newInstance(parameters.eventList, copiedQueues, null, parameters.onlyWaitingJobs, null);
                }
                if (this == SE_Q_PFB_RNG_DSJF) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, SimQueue.class, Double.TYPE, Random.class, DelegateSimJobFactory.class);
                    Iterator<SimQueue> iterator = copiedQueues.iterator();
                    SimQueue q = iterator.next();
                    return constructor.newInstance(parameters.eventList, q, parameters.feedbackProbability, null, null);
                }
                if (this == SE_Q_NUMV_DSJF) {
                    Constructor<? extends SimQueue> constructor = queueClass.getConstructor(SimEventList.class, SimQueue.class, Integer.TYPE, DelegateSimJobFactory.class);
                    Iterator<SimQueue> iterator = copiedQueues.iterator();
                    SimQueue q = iterator.next();
                    return constructor.newInstance(parameters.eventList, q, parameters.numberOfVisits, null);
                }
                System.err.println("Unsupported instantiation of new SimQueue instance with profile " + (Object)((Object)this) + ".");
                return null;
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("Could not find suitable constructor for new SimQueue instance with profile " + (Object)((Object)this) + ".");
                return null;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                System.err.println("Could not find instantiate new SimQueue instance with profile " + (Object)((Object)this) + ": " + e + ".");
                return null;
            }
        }
    }
}

