/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jsimulation.r5;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventFactory;
import org.javades.jsimulation.r5.SimEventList;
import org.javades.jsimulation.r5.SimEventListListener;
import org.javades.jsimulation.r5.SimEventListResetListener;

public abstract class AbstractSimEventList<E extends SimEvent>
extends TreeSet<E>
implements SimEventList<E> {
    private static final Logger LOG = Logger.getLogger(AbstractSimEventList.class.getName());
    private static final long serialVersionUID = 3944696628174847328L;
    protected static final boolean USE_ARRAY_OPTIMIZATION = true;
    private Function<SimEventList, String> toStringFunction = null;
    private double defaultResetTime = Double.NEGATIVE_INFINITY;
    private double lastUpdateTime = Double.NEGATIVE_INFINITY;
    private boolean firstUpdate = true;
    private final Class<E> eventClass;
    private SimEventFactory<? extends E> eventFactory = null;
    private volatile boolean running = false;
    private final Set<SimEventListResetListener> resetListeners = new HashSet<SimEventListResetListener>();
    private final Set<SimEventListListener> listeners = new HashSet<SimEventListListener>();
    private SimEventListListener[] listenersAsArray = new SimEventListListener[0];
    private final Set<SimEventListListener.Fine> fineListeners = new HashSet<SimEventListListener.Fine>();
    private SimEventListListener.Fine[] fineListenersAsArray = new SimEventListListener.Fine[0];

    protected AbstractSimEventList(Comparator comparator, double defaultResetTime, Class<E> eventClass) {
        super(comparator);
        this.defaultResetTime = defaultResetTime;
        if (eventClass == null) {
            throw new IllegalArgumentException();
        }
        this.eventClass = eventClass;
        this.resetFromContructor();
    }

    public final Function<SimEventList, String> getToStringFunction() {
        return this.toStringFunction;
    }

    public final void setToStringFunction(Function<SimEventList, String> toStringFunction) {
        this.toStringFunction = toStringFunction;
    }

    @Override
    public final String toString() {
        if (this.toStringFunction != null) {
            return "" + this.toStringFunction.apply(this);
        }
        return "EventList[t=" + this.lastUpdateTime + "]";
    }

    @Override
    public final double getDefaultResetTime() {
        return this.defaultResetTime;
    }

    @Override
    public final void setDefaultResetTime(double defaultResetTime) {
        this.defaultResetTime = defaultResetTime;
    }

    @Override
    public final double getTime() {
        return this.lastUpdateTime;
    }

    @Override
    public final Class<E> getSimEventClass() {
        return this.eventClass;
    }

    @Override
    public final SimEventFactory<? extends E> getSimEventFactory() {
        return this.eventFactory;
    }

    @Override
    public final void setSimEventFactory(SimEventFactory<? extends E> eventFactory) {
        this.eventFactory = eventFactory;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException("Attempt to add null collection to event list!");
        }
        boolean changed = false;
        for (SimEvent e : collection) {
            changed = this.add(e) || changed;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(double time) {
        AbstractSimEventList abstractSimEventList = this;
        synchronized (abstractSimEventList) {
            if (this.running) {
                throw new IllegalStateException();
            }
            this.clear();
            this.lastUpdateTime = time;
            this.firstUpdate = true;
        }
        this.fireReset();
    }

    private void resetFromContructor() {
        this.lastUpdateTime = this.defaultResetTime;
        this.firstUpdate = true;
    }

    protected final void checkUpdate(double newTime) {
        if (!this.firstUpdate && newTime < this.lastUpdateTime) {
            throw new IllegalArgumentException();
        }
        if (this.firstUpdate || newTime > this.lastUpdateTime) {
            this.lastUpdateTime = newTime;
            this.firstUpdate = false;
            this.fireUpdate();
        }
    }

    protected final void checkUpdate(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        this.checkUpdate(e.getTime());
    }

    @Override
    public final void run() {
        SimEventList.super.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void runUntil(double endTime, boolean inclusive, boolean setTimeToEndTime) {
        AbstractSimEventList abstractSimEventList = this;
        synchronized (abstractSimEventList) {
            if (this.running) {
                throw new IllegalStateException();
            }
            this.running = true;
        }
        if (endTime < this.getTime()) {
            this.running = false;
            throw new IllegalArgumentException();
        }
        while (!this.isEmpty() && (((SimEvent)this.first()).getTime() < endTime || inclusive && ((SimEvent)this.first()).getTime() == endTime) && !Thread.interrupted()) {
            this.fireNextEvent();
            SimEvent e = (SimEvent)this.pollFirst();
            this.checkUpdate(e);
            SimEventAction a = e.getEventAction();
            if (a == null) continue;
            a.action(e);
        }
        if (inclusive && setTimeToEndTime && this.getTime() < endTime) {
            this.checkUpdate(endTime);
        }
        if (this.isEmpty()) {
            this.fireEmpty();
        }
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void runSingleStep() {
        AbstractSimEventList abstractSimEventList = this;
        synchronized (abstractSimEventList) {
            if (this.isEmpty()) {
                return;
            }
            if (this.running) {
                throw new IllegalStateException();
            }
            this.running = true;
        }
        this.fireNextEvent();
        SimEvent e = (SimEvent)this.pollFirst();
        this.checkUpdate(e);
        SimEventAction a = e.getEventAction();
        if (a != null) {
            a.action(e);
        }
        if (this.isEmpty()) {
            this.fireEmpty();
        }
        this.running = false;
    }

    @Override
    public final void addListener(SimEventListResetListener l) {
        if (l != null) {
            if (l instanceof SimEventListListener.Fine) {
                if (!this.fineListeners.contains((SimEventListListener.Fine)l)) {
                    this.fineListeners.add((SimEventListListener.Fine)l);
                    this.fineListenersAsArray = this.fineListeners.toArray(new SimEventListListener.Fine[this.fineListeners.size()]);
                }
            } else if (l instanceof SimEventListListener) {
                if (!this.listeners.contains((SimEventListListener)l)) {
                    this.listeners.add((SimEventListListener)l);
                    this.listenersAsArray = this.listeners.toArray(new SimEventListListener[this.listeners.size()]);
                }
            } else {
                this.resetListeners.add(l);
            }
        }
    }

    @Override
    public final void removeListener(SimEventListResetListener l) {
        if (l != null) {
            this.resetListeners.remove(l);
            if (l instanceof SimEventListListener && this.listeners.contains((SimEventListListener)l)) {
                this.listeners.remove((SimEventListListener)l);
                this.listenersAsArray = this.listeners.toArray(new SimEventListListener[this.listeners.size()]);
            }
            if (l instanceof SimEventListListener.Fine && this.fineListeners.contains((SimEventListListener.Fine)l)) {
                this.fineListeners.remove((SimEventListListener.Fine)l);
                this.fineListenersAsArray = this.fineListeners.toArray(new SimEventListListener.Fine[this.fineListeners.size()]);
            }
        }
    }

    protected final void fireReset() {
        for (SimEventListListener.Fine fine : this.fineListeners) {
            fine.notifyEventListReset(this);
        }
        for (SimEventListListener simEventListListener : this.listeners) {
            simEventListListener.notifyEventListReset(this);
        }
        for (SimEventListResetListener simEventListResetListener : this.resetListeners) {
            simEventListResetListener.notifyEventListReset(this);
        }
    }

    protected final void fireUpdate() {
        if (!this.fineListeners.isEmpty()) {
            for (SimEventListListener simEventListListener : this.fineListenersAsArray) {
                simEventListListener.notifyEventListUpdate(this, this.lastUpdateTime);
            }
        }
        if (!this.listeners.isEmpty()) {
            for (SimEventListListener simEventListListener : this.listenersAsArray) {
                simEventListListener.notifyEventListUpdate(this, this.lastUpdateTime);
            }
        }
    }

    protected final void fireEmpty() {
        if (!this.fineListeners.isEmpty()) {
            for (SimEventListListener simEventListListener : this.fineListenersAsArray) {
                simEventListListener.notifyEventListEmpty(this, this.lastUpdateTime);
            }
        }
        if (!this.listeners.isEmpty()) {
            for (SimEventListListener simEventListListener : this.listenersAsArray) {
                simEventListListener.notifyEventListEmpty(this, this.lastUpdateTime);
            }
        }
    }

    protected final void fireNextEvent() {
        if (!this.fineListeners.isEmpty()) {
            for (SimEventListListener.Fine l : this.fineListenersAsArray) {
                l.notifyNextEvent(this, this.lastUpdateTime);
            }
        }
    }
}

