/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jsimulation.r5;

import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractSimTimer {
    private final String name;
    private SimEventList eventList = null;
    private final SimEvent EXPIRE_EVENT;
    private final SimEventAction EXPIRE_EVENT_ACTION = event -> {
        this.eventList = null;
        this.expireAction(event.getTime());
    };

    public AbstractSimTimer(String name) {
        this.name = name == null ? "" : name;
        this.EXPIRE_EVENT = new DefaultSimEvent<Object>(this.name + "_expire", 0.0, null, this.EXPIRE_EVENT_ACTION);
    }

    public AbstractSimTimer() {
        this(null);
    }

    public final String getName() {
        return this.name;
    }

    public abstract void expireAction(double var1);

    public void scheduleAction(double time) {
    }

    public void cancelAction(double time) {
    }

    public void schedule(double delay, SimEventList eventList) {
        if (delay < 0.0 || Double.isInfinite(delay) || eventList == null || Double.isInfinite(eventList.getTime())) {
            throw new IllegalArgumentException();
        }
        if (this.eventList != null) {
            throw new RuntimeException("Timer already scheduled!");
        }
        this.eventList = eventList;
        this.EXPIRE_EVENT.setTime(this.eventList.getTime() + delay);
        this.eventList.add(this.EXPIRE_EVENT);
        this.scheduleAction(this.eventList.getTime());
    }

    public void cancel() {
        if (this.eventList != null) {
            double time = this.eventList.getTime();
            this.eventList.remove(this.EXPIRE_EVENT);
            this.eventList = null;
            this.cancelAction(time);
        }
    }
}

