/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jsimulation.r5;

import java.io.PrintStream;
import java.util.SortedSet;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventFactory;
import org.javades.jsimulation.r5.SimEventListResetListener;

public interface SimEventList<E extends SimEvent>
extends SortedSet<E>,
Runnable {
    default public void print() {
        this.print(System.out);
    }

    default public void print(PrintStream stream) {
        PrintStream ps = stream == null ? System.out : stream;
        ps.println("SimEventList " + this + ", class=" + this.getClass().getSimpleName() + ", time=" + this.getTime() + ":");
        if (this.isEmpty()) {
            ps.println("  EMPTY!");
        } else {
            for (SimEvent event : this) {
                ps.println("  t=" + event.getTime() + ", name=" + event.getName() + ", object=" + event.getObject() + ", action=" + event.getEventAction() + ".");
            }
        }
    }

    public double getDefaultResetTime();

    public void setDefaultResetTime(double var1);

    public double getTime();

    public Class<E> getSimEventClass();

    public SimEventFactory<? extends E> getSimEventFactory();

    public void setSimEventFactory(SimEventFactory<? extends E> var1);

    public void reset(double var1);

    default public void reset() {
        this.reset(this.getDefaultResetTime());
    }

    public void runUntil(double var1, boolean var3, boolean var4);

    @Override
    default public void run() {
        this.runUntil(Double.POSITIVE_INFINITY, true, false);
    }

    public void runSingleStep();

    public void addListener(SimEventListResetListener var1);

    public void removeListener(SimEventListResetListener var1);

    default public void schedule(E event) {
        if (event == null || event.getTime() < this.getTime() || this.contains(event)) {
            throw new IllegalArgumentException();
        }
        this.add(event);
    }

    default public void schedule(double time, E event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        event.setTime(time);
        this.schedule(event);
    }

    default public void reschedule(double time, E event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        this.remove(event);
        this.schedule(time, event);
    }

    default public E schedule(double time, SimEventAction action, String name) {
        if (time < this.getTime()) {
            throw new IllegalArgumentException("Schedule time is in the past: " + time + " < " + this.getTime() + "!");
        }
        try {
            SimEvent<Object> event = this.getSimEventFactory() != null ? this.getSimEventFactory().newInstance(name, time, action) : (SimEvent)this.getSimEventClass().newInstance();
            event.setTime(time);
            event.setEventAction(action);
            event.setObject(null);
            if (name != null) {
                event.setName(name);
            }
            this.schedule(event);
            return (E)event;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot instantiate " + this.getSimEventClass().getSimpleName() + "!", e);
        }
    }

    default public E schedule(double time, SimEventAction action) {
        return this.schedule(time, action, null);
    }

    default public void scheduleNow(E event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        event.setTime(this.getTime());
        this.schedule(event);
    }

    default public E scheduleNow(SimEventAction action, String name) {
        return this.schedule(this.getTime(), action, name);
    }

    default public E scheduleNow(SimEventAction action) {
        return this.scheduleNow(action, null);
    }
}

