/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jsimulation.r5.example;

import org.javades.jsimulation.r5.AbstractSimTimer;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        int n;
        System.out.println("=== EXAMPLE PROGRAM FOR jsimulation PACKAGE ===");
        System.out.println("-> Creating actions...");
        SimEventAction<Object> a1 = new SimEventAction<Object>(){

            @Override
            public void action(SimEvent<Object> event) {
                System.out.println("  -> Action 1 on " + event.getName() + ", user object: " + (Integer)event.getObject() + " @" + event.getTime() + ".");
            }
        };
        SimEventAction<Object> a2 = new SimEventAction<Object>(){

            @Override
            public void action(SimEvent<Object> event) {
                System.out.println("  -> Action 2 on " + event.getName() + ", user object: " + (Integer)event.getObject() + " @" + event.getTime() + ".");
            }
        };
        System.out.println("-> Creating and populating event list with events at one-second interval...");
        final DefaultSimEventList<DefaultSimEvent<Integer>> el = new DefaultSimEventList<DefaultSimEvent<Integer>>();
        for (n = 0; n < 15; ++n) {
            el.add(new DefaultSimEvent<Integer>(n, n, n % 2 == 0 ? a1 : a2));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Populating event list with events all scheduled at t = 1.0; these will be executed in random order...");
        for (n = 0; n < 15; ++n) {
            el.add(new DefaultSimEvent<Integer>(1.0, n, n % 2 == 0 ? a1 : a2));
        }
        System.out.println("-> Executing event list...");
        el.run();
        SimEventAction<Object> a3 = new SimEventAction<Object>(){

            @Override
            public void action(SimEvent<Object> event) {
                if (event.getTime() < 16.0) {
                    System.out.println("  -> Rescheduling event at @" + (event.getTime() + 1.0) + ".");
                    event.setTime(event.getTime() + 1.0);
                    el.add(event);
                }
            }
        };
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Populating event list with auto-rescheduling event...");
        el.add(new DefaultSimEvent<Object>(1.0, null, a3));
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list to zero time...");
        el.reset(0.0);
        System.out.println("-> Populating event list with 16-seconds timer...");
        new AbstractSimTimer("Timer"){

            @Override
            public void expireAction(double time) {
                System.out.println("  -> Timer expired @" + time + ".");
            }
        }.schedule(16.0, el);
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("=== FINISHED ===");
    }
}

