/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jsimulation.r5.swing;

import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventList;
import org.javades.jsimulation.r5.SimEventListListener;

public class JSimEventList
extends JComponent
implements SimEventListListener.Fine {
    private final SimEventList eventList;
    private final JTable table;
    private final TableModel tableModel = new AbstractTableModel(){

        @Override
        public final int getRowCount() {
            return JSimEventList.this.eventList.size();
        }

        @Override
        public final int getColumnCount() {
            return 4;
        }

        @Override
        public final String getColumnName(int column) {
            if (column < 0) {
                return null;
            }
            if (column == 0) {
                return "Time";
            }
            if (column == 1) {
                return "Name";
            }
            if (column == 2) {
                return "Object";
            }
            if (column == 3) {
                return "Action";
            }
            return null;
        }

        @Override
        public final Object getValueAt(int r, int c) {
            if (r < 0 || r >= JSimEventList.this.eventList.size()) {
                return null;
            }
            if (c < 0 || c >= 4) {
                return null;
            }
            Iterator iterator = JSimEventList.this.eventList.iterator();
            SimEvent e = (SimEvent)iterator.next();
            for (int i = 0; i < r; ++i) {
                e = (SimEvent)iterator.next();
            }
            if (c == 0) {
                return e.getTime();
            }
            if (c == 1) {
                return e.getName();
            }
            if (c == 2) {
                return e.getObject();
            }
            if (c == 3) {
                return e.getEventAction();
            }
            throw new RuntimeException();
        }
    };

    public JSimEventList(SimEventList eventList) {
        if (eventList == null) {
            throw new IllegalArgumentException();
        }
        this.setPreferredSize(new Dimension(200, 200));
        this.eventList = eventList;
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 2));
        this.add(new JScrollPane(this.table));
        this.eventList.addListener(this);
    }

    public void eventListChangedNotification() {
        ((AbstractTableModel)this.tableModel).fireTableDataChanged();
    }

    @Override
    public void notifyNextEvent(SimEventList eventList, double time) {
        this.eventListChangedNotification();
    }

    @Override
    public void notifyEventListReset(SimEventList eventList) {
        this.eventListChangedNotification();
    }

    @Override
    public void notifyEventListUpdate(SimEventList eventList, double time) {
        this.eventListChangedNotification();
    }

    @Override
    public void notifyEventListEmpty(SimEventList eventList, double time) {
        this.eventListChangedNotification();
    }
}

