/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jsimulation.r5.swing.example;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEventList;
import org.javades.jsimulation.r5.SimEventListListener;
import org.javades.jsimulation.r5.swing.JSimEventList;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){
            private JFrame frame;
            private SimEventList eventList;

            @Override
            public void run() {
                this.frame = new JFrame("JSimQueue demonstration.");
                this.frame.setDefaultCloseOperation(3);
                JPanel topPanel = new JPanel();
                topPanel.setLayout(new BoxLayout(topPanel, 3));
                this.frame.getContentPane().add(topPanel);
                this.eventList = new DefaultSimEventList();
                this.eventList.schedule(0.0, null, "First Event");
                this.eventList.schedule(5.0, null, "Second Event");
                this.eventList.schedule(1000.0, null, "Third Event");
                this.eventList.schedule(Double.POSITIVE_INFINITY, null, "Fourth Event");
                final JLabel timeLabel = new JLabel("" + this.eventList.getTime());
                this.eventList.addListener(new SimEventListListener(){

                    @Override
                    public final void notifyEventListReset(SimEventList eventList) {
                        timeLabel.setText("" + eventList.getTime());
                    }

                    @Override
                    public final void notifyEventListUpdate(SimEventList eventList, double time) {
                        timeLabel.setText("" + time);
                    }

                    @Override
                    public final void notifyEventListEmpty(SimEventList eventList, double time) {
                    }
                });
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                JPanel timePanel = new JPanel();
                timePanel.add(timeLabel);
                timePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 3, true), "Current Time"));
                timePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 150));
                topPanel.add(timePanel);
                final JSimEventList jSimEventList = new JSimEventList(this.eventList);
                jSimEventList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 3, true), "Event List"));
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                topPanel.add(jSimEventList);
                final JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
                buttonPanel.add(new JButton(new AbstractAction("Reset"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        eventList.reset();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("New@t+10"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        eventList.schedule(eventList.getTime() + 10.0, null, "New Event");
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("New@t+100"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        eventList.schedule(eventList.getTime() + 100.0, null, "New Event");
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("New@Infinity"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        eventList.schedule(Double.POSITIVE_INFINITY, null, "New Event");
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Step"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        eventList.runSingleStep();
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Run Until / Set Time"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        String s = (String)JOptionPane.showInputDialog(frame, "Enter Time", "Enter Time", -1, null, null, Double.toString(eventList.getTime()));
                        if (s != null) {
                            try {
                                double newTime = Double.parseDouble(s);
                                if (newTime >= eventList.getTime()) {
                                    eventList.runUntil(newTime, true, true);
                                } else {
                                    JOptionPane.showMessageDialog(buttonPanel, "Time is in the past!", "Error", 0);
                                }
                            }
                            catch (NumberFormatException nfe) {
                                JOptionPane.showMessageDialog(buttonPanel, "Illegal time value!", "Error", 0);
                            }
                        }
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Run"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        eventList.run();
                    }
                }));
                buttonPanel.setAlignmentY(0.5f);
                buttonPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.orange, 3, true), "Control"));
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                topPanel.add(buttonPanel);
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
            }
        });
    }
}

