/*
 * Decompiled with CFR 0.152.
 */
package org.datafx.ejb;

import java.util.ServiceLoader;
import org.datafx.ejb.EjbLookup;
import org.datafx.ejb.EjbLookupConfiguration;
import org.datafx.ejb.EjbLookupConfigurationProvider;

public class EjbLookupFactory {
    public EjbLookup get(String name) {
        ServiceLoader<EjbLookupConfigurationProvider> loader = ServiceLoader.load(EjbLookupConfigurationProvider.class);
        for (EjbLookupConfigurationProvider provider : loader) {
            if (!this.isNameMatching(provider.getLookupName(), name)) continue;
            EjbLookupConfiguration configuration = provider.getConfiguration();
            EjbLookup lookup = configuration.createLookup();
            return lookup;
        }
        return null;
    }

    public boolean isNameMatching(String providerName, String name) {
        if (providerName == null && name == null) {
            return true;
        }
        if (providerName == null && name != null) {
            return name == "";
        }
        if (providerName != null && name == null) {
            return providerName == "";
        }
        return providerName.equals(name);
    }
}

