/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window$$Lambda$1;
import com.sun.glass.ui.Window$$Lambda$2;
import com.sun.prism.impl.PrismSettings;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Window {
    private long ptr;
    private volatile long delegatePtr = 0L;
    private static final LinkedList<Window> visibleWindows = new LinkedList();
    public static final int UNTITLED = 0;
    public static final int TITLED = 1;
    public static final int TRANSPARENT = 2;
    public static final int NORMAL = 0;
    public static final int UTILITY = 4;
    public static final int POPUP = 8;
    public static final int CLOSABLE = 16;
    public static final int MINIMIZABLE = 32;
    public static final int MAXIMIZABLE = 64;
    public static final int RIGHT_TO_LEFT = 128;
    public static final int UNIFIED = 256;
    private final Window owner;
    private final long parent;
    private final int styleMask;
    private final boolean isDecorated;
    private boolean shouldStartUndecoratedMove = false;
    private View view = null;
    private Screen screen = null;
    private MenuBar menubar = null;
    private String title = "";
    private UndecoratedMoveResizeHelper helper = null;
    private int state = 1;
    private int level = 1;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private float alpha = 1.0f;
    private float platformScale = 1.0f;
    private float renderScale = 1.0f;
    private Timer embeddedLocationTimer = null;
    private int lastKnownEmbeddedX = 0;
    private int lastKnownEmbeddedY = 0;
    private volatile boolean isResizable = false;
    private volatile boolean isVisible = false;
    private volatile boolean isFocused = false;
    private volatile boolean isFocusable = true;
    private volatile boolean isModal = false;
    private volatile int disableCount = 0;
    private int minimumWidth = 0;
    private int minimumHeight = 0;
    private int maximumWidth = Integer.MAX_VALUE;
    private int maximumHeight = Integer.MAX_VALUE;
    private EventHandler eventHandler;
    private static volatile Window focusedWindow = null;

    public static synchronized List<Window> getWindows() {
        Application.checkEventThread();
        return Collections.unmodifiableList(visibleWindows);
    }

    public static List<Window> getWindowsClone() {
        Application.checkEventThread();
        return (List)visibleWindows.clone();
    }

    protected static void add(Window window) {
        visibleWindows.add(window);
    }

    protected static void addFirst(Window window) {
        visibleWindows.addFirst(window);
    }

    protected static void remove(Window window) {
        visibleWindows.remove(window);
    }

    protected abstract long _createWindow(long var1, long var3, int var5);

    protected Window(Window owner, Screen screen, int styleMask) {
        Application.checkEventThread();
        switch (styleMask & 3) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException("The visual kind should be UNTITLED, TITLED, or TRANSPARENT, but not a combination of these");
            }
        }
        switch (styleMask & 0xC) {
            case 0: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("The functional type should be NORMAL, POPUP, or UTILITY, but not a combination of these");
            }
        }
        if ((styleMask & 0x100) != 0 && !Application.GetApplication().supportsUnifiedWindows()) {
            styleMask &= 0xFFFFFEFF;
        }
        if ((styleMask & 2) != 0 && !Application.GetApplication().supportsTransparentWindows()) {
            styleMask &= 0xFFFFFFFD;
        }
        this.owner = owner;
        this.parent = 0L;
        this.styleMask = styleMask;
        this.isDecorated = (this.styleMask & 1) != 0;
        this.screen = screen != null ? screen : Screen.getMainScreen();
        this.ptr = this._createWindow(owner != null ? owner.getNativeHandle() : 0L, this.screen.getNativeScreen(), this.styleMask);
        if (this.ptr == 0L) {
            throw new RuntimeException("could not create platform window");
        }
    }

    protected abstract long _createChildWindow(long var1);

    protected Window(long parent) {
        Application.checkEventThread();
        this.owner = null;
        this.parent = parent;
        this.styleMask = 0;
        this.isDecorated = false;
        this.screen = null;
        this.ptr = this._createChildWindow(parent);
        if (this.ptr == 0L) {
            throw new RuntimeException("could not create platform window");
        }
    }

    public boolean isClosed() {
        Application.checkEventThread();
        return this.ptr == 0L;
    }

    private void checkNotClosed() {
        if (this.ptr == 0L) {
            throw new IllegalStateException("The window has already been closed");
        }
    }

    protected abstract boolean _close(long var1);

    public void close() {
        Application.checkEventThread();
        if (this.view != null) {
            if (this.ptr != 0L) {
                this._setView(this.ptr, null);
            }
            this.view.setWindow(null);
            this.view.close();
            this.view = null;
        }
        if (this.ptr != 0L) {
            this._close(this.ptr);
        }
    }

    private boolean isChild() {
        Application.checkEventThread();
        return this.parent != 0L;
    }

    public long getNativeWindow() {
        Application.checkEventThread();
        this.checkNotClosed();
        return this.delegatePtr != 0L ? this.delegatePtr : this.ptr;
    }

    public long getNativeHandle() {
        Application.checkEventThread();
        return this.delegatePtr != 0L ? this.delegatePtr : this.ptr;
    }

    protected long getRawHandle() {
        return this.ptr;
    }

    public Window getOwner() {
        Application.checkEventThread();
        return this.owner;
    }

    public View getView() {
        Application.checkEventThread();
        return this.view;
    }

    protected abstract boolean _setView(long var1, View var3);

    public void setView(View view) {
        Window host;
        Application.checkEventThread();
        this.checkNotClosed();
        View oldView = this.getView();
        if (oldView == view) {
            return;
        }
        if (oldView != null) {
            oldView.setWindow(null);
        }
        if (view != null && (host = view.getWindow()) != null) {
            host.setView(null);
        }
        if (view != null && this._setView(this.ptr, view)) {
            this.view = view;
            this.view.setWindow(this);
            if (!this.isDecorated) {
                this.helper = new UndecoratedMoveResizeHelper();
            }
        } else {
            this._setView(this.ptr, null);
            this.view = null;
        }
    }

    public Screen getScreen() {
        Application.checkEventThread();
        return this.screen;
    }

    protected void setScreen(Screen screen) {
        Application.checkEventThread();
        Screen old = this.screen;
        this.screen = screen;
        if (this.eventHandler != null && (old == null && this.screen != null || old != null && !old.equals(this.screen))) {
            this.eventHandler.handleScreenChangedEvent(this, System.nanoTime(), old, this.screen);
        }
    }

    public int getStyleMask() {
        Application.checkEventThread();
        return this.styleMask;
    }

    public MenuBar getMenuBar() {
        Application.checkEventThread();
        return this.menubar;
    }

    protected abstract boolean _setMenubar(long var1, long var3);

    public void setMenuBar(MenuBar menubar) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (this._setMenubar(this.ptr, menubar.getNativeMenu())) {
            this.menubar = menubar;
        }
    }

    public boolean isDecorated() {
        Application.checkEventThread();
        return this.isDecorated;
    }

    public boolean isMinimized() {
        Application.checkEventThread();
        return this.state == 2;
    }

    protected abstract boolean _minimize(long var1, boolean var3);

    public boolean minimize(boolean minimize) {
        Application.checkEventThread();
        this.checkNotClosed();
        this._minimize(this.ptr, minimize);
        return this.isMinimized();
    }

    public boolean isMaximized() {
        Application.checkEventThread();
        return this.state == 3;
    }

    protected abstract boolean _maximize(long var1, boolean var3, boolean var4);

    public boolean maximize(boolean maximize) {
        Application.checkEventThread();
        this.checkNotClosed();
        this._maximize(this.ptr, maximize, this.isMaximized());
        return this.isMaximized();
    }

    public void setPlatformScale(float platformScale) {
        if (!PrismSettings.allowHiDPIScaling) {
            return;
        }
        this.platformScale = platformScale;
    }

    public final float getPlatformScale() {
        return this.platformScale;
    }

    public void setRenderScale(float renderScale) {
        if (!PrismSettings.allowHiDPIScaling) {
            return;
        }
        this.renderScale = renderScale;
    }

    public final float getRenderScale() {
        return this.renderScale;
    }

    public float getOutputScale() {
        return this.platformScale;
    }

    protected abstract int _getEmbeddedX(long var1);

    protected abstract int _getEmbeddedY(long var1);

    private void checkScreenLocation() {
        this.x = this._getEmbeddedX(this.ptr);
        this.y = this._getEmbeddedY(this.ptr);
        if (this.x != this.lastKnownEmbeddedX || this.y != this.lastKnownEmbeddedY) {
            this.lastKnownEmbeddedX = this.x;
            this.lastKnownEmbeddedY = this.y;
            this.handleWindowEvent(System.nanoTime(), 512);
        }
    }

    public int getX() {
        Application.checkEventThread();
        return this.x;
    }

    public int getY() {
        Application.checkEventThread();
        return this.y;
    }

    public int getWidth() {
        Application.checkEventThread();
        return this.width;
    }

    public int getHeight() {
        Application.checkEventThread();
        return this.height;
    }

    protected abstract void _setBounds(long var1, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, float var11, float var12);

    public void setBounds(int x, int y, boolean xSet, boolean ySet, int w, int h, int cw, int ch, float xGravity, float yGravity) {
        Application.checkEventThread();
        this.checkNotClosed();
        this._setBounds(this.ptr, x, y, xSet, ySet, w, h, cw, ch, xGravity, yGravity);
    }

    public void setPosition(int x, int y) {
        Application.checkEventThread();
        this.setBounds(x, y, true, true, 0, 0, 0, 0, 0.0f, 0.0f);
    }

    public void setSize(int w, int h) {
        Application.checkEventThread();
        this.setBounds(0, 0, false, false, w, h, 0, 0, 0.0f, 0.0f);
    }

    public void setContentSize(int cw, int ch) {
        Application.checkEventThread();
        this.setBounds(0, 0, false, false, 0, 0, cw, ch, 0.0f, 0.0f);
    }

    public boolean isVisible() {
        Application.checkEventThread();
        return this.isVisible;
    }

    private void synthesizeViewMoveEvent() {
        View view = this.getView();
        if (view != null) {
            view.notifyView(423);
        }
    }

    protected abstract boolean _setVisible(long var1, boolean var3);

    public void setVisible(boolean visible) {
        Application.checkEventThread();
        if (this.isVisible != visible) {
            if (!visible) {
                if (this.getView() != null) {
                    this.getView().setVisible(visible);
                }
                this.isVisible = this.ptr != 0L ? this._setVisible(this.ptr, visible) : visible;
                Window.remove(this);
                if (this.parent != 0L) {
                    this.embeddedLocationTimer.stop();
                }
            } else {
                this.checkNotClosed();
                this.isVisible = this._setVisible(this.ptr, visible);
                if (this.getView() != null) {
                    this.getView().setVisible(this.isVisible);
                }
                Window.add(this);
                if (this.parent != 0L) {
                    Runnable checkRunnable = Window$$Lambda$1.lambdaFactory$(this);
                    Runnable timerRunnable = Window$$Lambda$2.lambdaFactory$(checkRunnable);
                    this.embeddedLocationTimer = Application.GetApplication().createTimer(timerRunnable);
                    this.embeddedLocationTimer.start(16);
                }
                this.synthesizeViewMoveEvent();
            }
        }
    }

    protected abstract boolean _setResizable(long var1, boolean var3);

    public boolean setResizable(boolean resizable) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (this.isResizable != resizable && this._setResizable(this.ptr, resizable)) {
            this.isResizable = resizable;
            this.synthesizeViewMoveEvent();
        }
        return this.isResizable;
    }

    public boolean isResizable() {
        Application.checkEventThread();
        return this.isResizable;
    }

    public boolean isUnifiedWindow() {
        return (this.styleMask & 0x100) != 0;
    }

    public boolean isTransparentWindow() {
        return (this.styleMask & 2) != 0;
    }

    public static Window getFocusedWindow() {
        Application.checkEventThread();
        return focusedWindow;
    }

    private static void setFocusedWindow(Window window) {
        focusedWindow = window;
    }

    public boolean isFocused() {
        Application.checkEventThread();
        return this.isFocused;
    }

    protected abstract boolean _requestFocus(long var1, int var3);

    public boolean requestFocus(int event) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (!this.isChild() && event != 542) {
            throw new IllegalArgumentException("Invalid focus event ID for top-level window");
        }
        if (this.isChild() && (event < 541 || event > 544)) {
            throw new IllegalArgumentException("Invalid focus event ID for child window");
        }
        if (event == 541 && !this.isFocused()) {
            return true;
        }
        if (!this.isFocusable) {
            return false;
        }
        return this._requestFocus(this.ptr, event);
    }

    public boolean requestFocus() {
        Application.checkEventThread();
        return this.requestFocus(542);
    }

    protected abstract void _setFocusable(long var1, boolean var3);

    public void setFocusable(boolean isFocusable) {
        Application.checkEventThread();
        this.checkNotClosed();
        this.isFocusable = isFocusable;
        if (this.isEnabled()) {
            this._setFocusable(this.ptr, isFocusable);
        }
    }

    protected abstract boolean _grabFocus(long var1);

    protected abstract void _ungrabFocus(long var1);

    public boolean grabFocus() {
        Application.checkEventThread();
        this.checkNotClosed();
        if (!this.isFocused()) {
            throw new IllegalStateException("The window must be focused when calling grabFocus()");
        }
        return this._grabFocus(this.ptr);
    }

    public void ungrabFocus() {
        Application.checkEventThread();
        this.checkNotClosed();
        this._ungrabFocus(this.ptr);
    }

    public String getTitle() {
        Application.checkEventThread();
        return this.title;
    }

    protected abstract boolean _setTitle(long var1, String var3);

    public void setTitle(String title) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (title == null) {
            title = "";
        }
        if (!title.equals(this.title) && this._setTitle(this.ptr, title)) {
            this.title = title;
        }
    }

    protected abstract void _setLevel(long var1, int var3);

    public void setLevel(int level) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (level < 1 || level > 3) {
            throw new IllegalArgumentException("Level should be in the range [1..3]");
        }
        if (this.level != level) {
            this._setLevel(this.ptr, level);
            this.level = level;
        }
    }

    public int getLevel() {
        Application.checkEventThread();
        return this.level;
    }

    private boolean isInFullscreen() {
        View view = this.getView();
        return view == null ? false : view.isInFullscreen();
    }

    void notifyFullscreen(boolean entered) {
        float alpha = this.getAlpha();
        if (alpha < 1.0f) {
            if (entered) {
                this._setAlpha(this.ptr, 1.0f);
            } else {
                this.setAlpha(alpha);
            }
        }
    }

    protected abstract void _setAlpha(long var1, float var3);

    public void setAlpha(float alpha) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Alpha should be in the range [0f..1f]");
        }
        this.alpha = alpha;
        if (alpha < 1.0f && this.isInFullscreen()) {
            return;
        }
        this._setAlpha(this.ptr, this.alpha);
    }

    public float getAlpha() {
        Application.checkEventThread();
        return this.alpha;
    }

    protected abstract boolean _setBackground(long var1, float var3, float var4, float var5);

    public boolean setBackground(float r, float g, float b) {
        Application.checkEventThread();
        this.checkNotClosed();
        return this._setBackground(this.ptr, r, g, b);
    }

    public boolean isEnabled() {
        Application.checkEventThread();
        return this.disableCount == 0;
    }

    protected abstract void _setEnabled(long var1, boolean var3);

    public void setEnabled(boolean enabled) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (!enabled) {
            if (++this.disableCount > 1) {
                return;
            }
        } else {
            if (this.disableCount == 0) {
                return;
            }
            if (--this.disableCount > 0) {
                return;
            }
        }
        this._setEnabled(this.ptr, this.isEnabled());
    }

    public int getMinimumWidth() {
        Application.checkEventThread();
        return this.minimumWidth;
    }

    public int getMinimumHeight() {
        Application.checkEventThread();
        return this.minimumHeight;
    }

    public int getMaximumWidth() {
        Application.checkEventThread();
        return this.maximumWidth;
    }

    public int getMaximumHeight() {
        Application.checkEventThread();
        return this.maximumHeight;
    }

    protected abstract boolean _setMinimumSize(long var1, int var3, int var4);

    public void setMinimumSize(int width, int height) {
        Application.checkEventThread();
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("The width and height must be >= 0. Got: width=" + width + "; height=" + height);
        }
        this.checkNotClosed();
        if (this._setMinimumSize(this.ptr, width, height)) {
            this.minimumWidth = width;
            this.minimumHeight = height;
        }
    }

    protected abstract boolean _setMaximumSize(long var1, int var3, int var4);

    public void setMaximumSize(int width, int height) {
        Application.checkEventThread();
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("The width and height must be >= 0. Got: width=" + width + "; height=" + height);
        }
        this.checkNotClosed();
        if (this._setMaximumSize(this.ptr, width == Integer.MAX_VALUE ? -1 : width, height == Integer.MAX_VALUE ? -1 : height)) {
            this.maximumWidth = width;
            this.maximumHeight = height;
        }
    }

    protected abstract void _setIcon(long var1, Pixels var3);

    public void setIcon(Pixels pixels) {
        Application.checkEventThread();
        this.checkNotClosed();
        this._setIcon(this.ptr, pixels);
    }

    protected abstract void _setCursor(long var1, Cursor var3);

    public void setCursor(Cursor cursor) {
        Application.checkEventThread();
        this._setCursor(this.ptr, cursor);
    }

    protected abstract void _toFront(long var1);

    public void toFront() {
        Application.checkEventThread();
        this.checkNotClosed();
        this._toFront(this.ptr);
    }

    protected abstract void _toBack(long var1);

    public void toBack() {
        Application.checkEventThread();
        this.checkNotClosed();
        this._toBack(this.ptr);
    }

    protected abstract void _enterModal(long var1);

    public void enterModal() {
        this.checkNotClosed();
        if (!this.isModal) {
            this.isModal = true;
            this._enterModal(this.ptr);
        }
    }

    protected abstract void _enterModalWithWindow(long var1, long var3);

    public void enterModal(Window window) {
        this.checkNotClosed();
        if (!this.isModal) {
            this.isModal = true;
            this._enterModalWithWindow(this.ptr, window.getNativeHandle());
        }
    }

    protected abstract void _exitModal(long var1);

    public void exitModal() {
        this.checkNotClosed();
        if (this.isModal) {
            this._exitModal(this.ptr);
            this.isModal = false;
        }
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void dispatchNpapiEvent(Map eventInfo) {
        Application.checkEventThread();
        throw new RuntimeException("This operation is not supported on this platform");
    }

    public EventHandler getEventHandler() {
        Application.checkEventThread();
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        Application.checkEventThread();
        this.eventHandler = eventHandler;
    }

    public void setShouldStartUndecoratedMove(boolean v) {
        Application.checkEventThread();
        this.shouldStartUndecoratedMove = v;
    }

    protected void notifyClose() {
        this.handleWindowEvent(System.nanoTime(), 521);
    }

    protected void notifyDestroy() {
        if (this.ptr == 0L) {
            return;
        }
        this.handleWindowEvent(System.nanoTime(), 522);
        this.ptr = 0L;
        this.setVisible(false);
    }

    protected void notifyMove(int x, int y) {
        this.x = x;
        this.y = y;
        this.handleWindowEvent(System.nanoTime(), 512);
    }

    protected void notifyMoveToAnotherScreen(Screen newScreen) {
        this.setScreen(newScreen);
    }

    protected void notifyResize(int type, int width, int height) {
        if (type == 531) {
            this.state = 2;
        } else {
            this.state = type == 532 ? 3 : 1;
            this.width = width;
            this.height = height;
            if (this.helper != null) {
                this.helper.updateRectangles();
            }
        }
        this.handleWindowEvent(System.nanoTime(), type);
        if (type == 532 || type == 533) {
            this.handleWindowEvent(System.nanoTime(), 511);
        }
    }

    protected void notifyFocus(int event) {
        boolean focused;
        boolean bl = focused = event != 541;
        if (this.isFocused != focused) {
            this.isFocused = focused;
            if (this.isFocused) {
                Window.setFocusedWindow(this);
            } else {
                Window.setFocusedWindow(null);
            }
            this.handleWindowEvent(System.nanoTime(), event);
        }
    }

    protected void notifyFocusDisabled() {
        this.handleWindowEvent(System.nanoTime(), 545);
    }

    protected void notifyFocusUngrab() {
        this.handleWindowEvent(System.nanoTime(), 546);
    }

    protected void notifyDelegatePtr(long ptr) {
        this.delegatePtr = ptr;
    }

    private void handleWindowEvent(long time, int type) {
        if (this.eventHandler != null) {
            this.eventHandler.handleWindowEvent(this, time, type);
        }
    }

    public void setUndecoratedMoveRectangle(int size) {
        Application.checkEventThread();
        if (this.isDecorated) {
            System.err.println("Glass Window.setUndecoratedMoveRectangle is only valid for Undecorated Window. In the future this will be hard error.");
            Thread.dumpStack();
            return;
        }
        if (this.helper != null) {
            this.helper.setMoveRectangle(size);
        }
    }

    public boolean shouldStartUndecoratedMove(int x, int y) {
        Application.checkEventThread();
        if (this.shouldStartUndecoratedMove) {
            return true;
        }
        if (this.isDecorated) {
            return false;
        }
        if (this.helper != null) {
            return this.helper.shouldStartMove(x, y);
        }
        return false;
    }

    public void setUndecoratedResizeRectangle(int size) {
        Application.checkEventThread();
        if (this.isDecorated || !this.isResizable) {
            System.err.println("Glass Window.setUndecoratedResizeRectangle is only valid for Undecorated Resizable Window. In the future this will be hard error.");
            Thread.dumpStack();
            return;
        }
        if (this.helper != null) {
            this.helper.setResizeRectangle(size);
        }
    }

    public boolean shouldStartUndecoratedResize(int x, int y) {
        Application.checkEventThread();
        if (this.isDecorated || !this.isResizable) {
            return false;
        }
        if (this.helper != null) {
            return this.helper.shouldStartResize(x, y);
        }
        return false;
    }

    boolean handleMouseEvent(int type, int button, int x, int y, int xAbs, int yAbs) {
        if (!this.isDecorated) {
            return this.helper.handleMouseEvent(type, button, x, y, xAbs, yAbs);
        }
        return false;
    }

    public String toString() {
        Application.checkEventThread();
        return "Window:\n    ptr: " + this.getNativeWindow() + "\n" + "    screen ptr: " + (this.screen != null ? Long.valueOf(this.screen.getNativeScreen()) : "null") + "\n" + "    isDecorated: " + this.isDecorated() + "\n" + "    title: " + this.getTitle() + "\n" + "    visible: " + this.isVisible() + "\n" + "    focused: " + this.isFocused() + "\n" + "    modal: " + this.isModal() + "\n" + "    state: " + this.state + "\n" + "    x: " + this.getX() + ", y: " + this.getY() + ", w: " + this.getWidth() + ", h: " + this.getHeight() + "\n" + "";
    }

    protected void notifyLevelChanged(int level) {
        this.level = level;
        if (this.eventHandler != null) {
            this.eventHandler.handleLevelEvent(level);
        }
    }

    public void requestInput(String text, int type, double width, double height, double Mxx, double Mxy, double Mxz, double Mxt, double Myx, double Myy, double Myz, double Myt, double Mzx, double Mzy, double Mzz, double Mzt, double fontSize) {
        Application.checkEventThread();
        this._requestInput(this.ptr, text, type, width, height, Mxx, Mxy, Mxz, Mxt, Myx, Myy, Myz, Myt, Mzx, Mzy, Mzz, Mzt, fontSize);
    }

    public void updateInput(String text) {
        Application.checkEventThread();
        this._updateInput(this.ptr, text);
    }

    public void releaseInput() {
        Application.checkEventThread();
        this._releaseInput(this.ptr);
    }

    protected abstract void _requestInput(long var1, String var3, int var4, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    protected abstract void _updateInput(long var1, String var3);

    protected abstract void _releaseInput(long var1);

    private static /* synthetic */ void lambda$setVisible$1(Runnable checkRunnable) {
        Application.invokeLater(checkRunnable);
    }

    private /* synthetic */ void lambda$setVisible$0() {
        this.checkScreenLocation();
    }

    static /* synthetic */ void access$lambda$0(Window window) {
        window.lambda$setVisible$0();
    }

    static /* synthetic */ void access$lambda$1(Runnable runnable) {
        Window.lambda$setVisible$1(runnable);
    }

    private class UndecoratedMoveResizeHelper {
        TrackingRectangle moveRect = new TrackingRectangle();
        TrackingRectangle resizeRect = new TrackingRectangle();
        boolean inMove = false;
        boolean inResize = false;
        int startMouseX;
        int startMouseY;
        int startX;
        int startY;
        int startWidth;
        int startHeight;

        UndecoratedMoveResizeHelper() {
        }

        void setMoveRectangle(int size) {
            this.moveRect.size = size;
            this.moveRect.x = 0;
            this.moveRect.y = 0;
            this.moveRect.width = Window.this.getWidth();
            this.moveRect.height = this.moveRect.size;
        }

        boolean shouldStartMove(int x, int y) {
            return this.moveRect.contains(x, y);
        }

        boolean inMove() {
            return this.inMove;
        }

        void startMove(int x, int y) {
            this.inMove = true;
            this.startMouseX = x;
            this.startMouseY = y;
            this.startX = Window.this.getX();
            this.startY = Window.this.getY();
        }

        void deltaMove(int x, int y) {
            int deltaX = x - this.startMouseX;
            int deltaY = y - this.startMouseY;
            Window.this.setPosition(this.startX + deltaX, this.startY + deltaY);
        }

        void stopMove() {
            this.inMove = false;
        }

        void setResizeRectangle(int size) {
            this.resizeRect.size = size;
            this.resizeRect.x = Window.this.getWidth() - this.resizeRect.size;
            this.resizeRect.y = Window.this.getHeight() - this.resizeRect.size;
            this.resizeRect.width = this.resizeRect.size;
            this.resizeRect.height = this.resizeRect.size;
        }

        boolean shouldStartResize(int x, int y) {
            return this.resizeRect.contains(x, y);
        }

        boolean inResize() {
            return this.inResize;
        }

        void startResize(int x, int y) {
            this.inResize = true;
            this.startMouseX = x;
            this.startMouseY = y;
            this.startWidth = Window.this.getWidth();
            this.startHeight = Window.this.getHeight();
        }

        void deltaResize(int x, int y) {
            int deltaX = x - this.startMouseX;
            int deltaY = y - this.startMouseY;
            Window.this.setSize(this.startWidth + deltaX, this.startHeight + deltaY);
        }

        protected void stopResize() {
            this.inResize = false;
        }

        void updateRectangles() {
            if (this.moveRect.size > 0) {
                this.setMoveRectangle(this.moveRect.size);
            }
            if (this.resizeRect.size > 0) {
                this.setResizeRectangle(this.resizeRect.size);
            }
        }

        boolean handleMouseEvent(int type, int button, int x, int y, int xAbs, int yAbs) {
            switch (type) {
                case 221: {
                    if (button != 212) break;
                    if (Window.this.shouldStartUndecoratedMove(x, y)) {
                        this.startMove(xAbs, yAbs);
                        return true;
                    }
                    if (!Window.this.shouldStartUndecoratedResize(x, y)) break;
                    this.startResize(xAbs, yAbs);
                    return true;
                }
                case 223: 
                case 224: {
                    if (this.inMove()) {
                        this.deltaMove(xAbs, yAbs);
                        return true;
                    }
                    if (!this.inResize()) break;
                    this.deltaResize(xAbs, yAbs);
                    return true;
                }
                case 222: {
                    boolean wasProcessed = this.inMove() || this.inResize();
                    this.stopResize();
                    this.stopMove();
                    return wasProcessed;
                }
            }
            return false;
        }
    }

    private static class TrackingRectangle {
        int size = 0;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;

        private TrackingRectangle() {
        }

        boolean contains(int x, int y) {
            return this.size > 0 && x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
        }
    }

    public static final class Level {
        private static final int _MIN = 1;
        public static final int NORMAL = 1;
        public static final int FLOATING = 2;
        public static final int TOPMOST = 3;
        private static final int _MAX = 3;
    }

    private static final class State {
        private static final int NORMAL = 1;
        private static final int MINIMIZED = 2;
        private static final int MAXIMIZED = 3;

        private State() {
        }
    }

    public static class EventHandler {
        public void handleWindowEvent(Window window, long time, int type) {
        }

        public void handleScreenChangedEvent(Window window, long time, Screen oldScreen, Screen newScreen) {
        }

        public void handleLevelEvent(int level) {
        }
    }
}

