/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.events.ViewEvent;
import com.sun.glass.events.WindowEvent;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.lens.LensApplication$$Lambda$1;
import com.sun.glass.ui.lens.LensApplication$$Lambda$2;
import com.sun.glass.ui.lens.LensApplication$$Lambda$3;
import com.sun.glass.ui.lens.LensApplication$$Lambda$4;
import com.sun.glass.ui.lens.LensApplication$$Lambda$5;
import com.sun.glass.ui.lens.LensApplication$$Lambda$6;
import com.sun.glass.ui.lens.LensCursor;
import com.sun.glass.ui.lens.LensLogger;
import com.sun.glass.ui.lens.LensPixels;
import com.sun.glass.ui.lens.LensRobot;
import com.sun.glass.ui.lens.LensTimer;
import com.sun.glass.ui.lens.LensTouchInputSupport;
import com.sun.glass.ui.lens.LensView;
import com.sun.glass.ui.lens.LensWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import sun.util.logging.PlatformLogger;

final class LensApplication
extends Application {
    private static final int DEVICE_TOUCH = 0;
    private static final int DEVICE_MULTITOUCH = 1;
    private static final int DEVICE_POINTER = 2;
    private static final int DEVICE_5WAY = 3;
    private static final int DEVICE_PC_KEYBOARD = 4;
    private static final int DEVICE_MAX = 4;
    private int[] deviceFlags = new int[5];
    private int previousTouchMoveX = -1;
    private int previousTouchMoveY = -1;
    private int previousTouchMoveScreenX = -1;
    private int previousTouchMoveScreenY = -1;
    private boolean cursorVisible = true;
    Menu windowMenu;
    Menu editMenu;
    Menu fileMenu;
    private static final Object invokeAndWaitLock = new Object();
    private static Runnable waitingFor;
    private static int activeEventLoopThreads;
    private static final Object activeEventLoopLock;
    private static boolean doComposite;
    private static boolean isInitialized;
    private EventLoop dndEventLoop;
    private final LinkedList<Event> eventList = new LinkedList();
    LinkedList<RunLoopControl> activeRunLoops = new LinkedList();
    private static int nativeThreadCounter;
    private int cachedButtonPressed = 211;
    private LensView dragView = null;
    private int dragActionsPreformed = DragActions.NONE.getValue();
    private boolean dragStarted = false;

    private static native void _initIDs();

    private static native boolean _initialize();

    private static native void _notifyRenderingEnd();

    private static void initLibrary() {
        String lensProperty = "glass.lens";
        String platform = (String)AccessController.doPrivileged(LensApplication$$Lambda$1.lambdaFactory$());
        doComposite = (Boolean)AccessController.doPrivileged(LensApplication$$Lambda$2.lambdaFactory$());
        if (isInitialized) {
            return;
        }
        LensLogger.getLogger().info("LensApplication initialization");
        if (platform.equals("")) {
            LensLogger.getLogger().severe("System property glass.lens not defined");
        }
        AccessController.doPrivileged(LensApplication$$Lambda$3.lambdaFactory$(platform));
        LensApplication._initIDs();
        isInitialized = true;
        LensLogger.getLogger().info("LensApplication initialization done");
    }

    native void registerApplication();

    LensApplication() {
        LensLogger.getLogger().fine("LensApplication ctor called, registering in native layer");
        this.registerApplication();
    }

    @Override
    public boolean hasWindowManager() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvent(Event e) {
        if (Thread.currentThread() == LensApplication.getEventThread()) {
            try {
                e.dispatch();
            }
            catch (Exception ex) {
                LensApplication.reportException(ex);
            }
        } else {
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                this.eventList.addLast(e);
                this.eventList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postMouseEvent(LensView view, int eventType, int x, int y, int absx, int absy, int button, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            if (!(this.eventList.isEmpty() || eventType != 223 && eventType != 224)) {
                Iterator<Event> events = this.eventList.descendingIterator();
                while (events.hasNext()) {
                    LensMouseEvent e;
                    Event lastEvent = events.next();
                    if (!(lastEvent instanceof LensMouseEvent) || (e = (LensMouseEvent)lastEvent).target != view || e.action != eventType || e.button != button || e.modifiers != modifiers || e.isPopupTrigger != isPopupTrigger || e.isSynthesized != isSynthesized) continue;
                    e.x = x;
                    e.y = y;
                    e.absx = absx;
                    e.absy = absy;
                    return;
                }
            }
            this.postEvent(new LensMouseEvent(view, eventType, x, y, absx, absy, button, modifiers, isPopupTrigger, isSynthesized));
        }
    }

    @Override
    protected Object _enterNestedEventLoop() {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("_enterNestedEventLoop");
        }
        Object ret = this._runLoop();
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Resuming event loop");
        }
        return ret;
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("_leaveNestedEventLoop");
        }
        RunLoopControl current = this.activeRunLoops.pop();
        assert (current != null);
        current.active = false;
        current.release = retValue;
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("_leaveNestedEventLoop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _runLoop() {
        RunLoopControl control = new RunLoopControl();
        this.activeRunLoops.push(control);
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Starting event loop");
        }
        control.active = true;
        while (control.active) {
            Event event;
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                if (this.eventList.isEmpty()) {
                    try {
                        this.eventList.wait();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                if (this.eventList.isEmpty()) {
                    continue;
                }
                event = this.eventList.removeFirst();
            }
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().fine("Processing " + event);
            }
            try {
                event.dispatch();
            }
            catch (Exception e) {
                LensApplication.reportException(e);
            }
        }
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Leaving event loop");
        }
        return control.release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEventLoop() {
        Object object = activeEventLoopLock;
        synchronized (object) {
            LensLogger.getLogger().info("activeEventLoopThreads := " + ++activeEventLoopThreads);
            activeEventLoopLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterEventLoop() {
        Object object = activeEventLoopLock;
        synchronized (object) {
            LensLogger.getLogger().info("activeEventLoopThreads := " + --activeEventLoopThreads);
            activeEventLoopLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitEventLoopsToFinish() {
        Object object = activeEventLoopLock;
        synchronized (object) {
            try {
                LensLogger.getLogger().info("Waiting for all event loops to finish");
                while (activeEventLoopThreads > 0) {
                    LensLogger.getLogger().info("activeEventLoopThreads = " + activeEventLoopThreads);
                    activeEventLoopLock.wait();
                }
            }
            catch (InterruptedException e) {
                LensLogger.getLogger().severe("interrupted");
            }
        }
    }

    @Override
    protected void runLoop(Runnable launchable) {
        this._invokeLater(launchable);
        long stackSize = (Long)AccessController.doPrivileged(LensApplication$$Lambda$4.lambdaFactory$());
        Thread toolkitThread = new Thread(new ThreadGroup("Events"), LensApplication$$Lambda$5.lambdaFactory$(this), "Lens Event Thread", stackSize);
        LensApplication.setEventThread(toolkitThread);
        toolkitThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LensApplication.this.shutdown();
            }
        });
    }

    private native void nativeEventLoop(LensApplication var1, long var2, long var4);

    private static void createNativeEventThread(long nativeEventHandler, long data) {
        LensApplication lensApplication = (LensApplication)Application.GetApplication();
        Thread eventThread = new Thread(LensApplication$$Lambda$6.lambdaFactory$(lensApplication, nativeEventHandler, data), "Lens Native Event Thread " + nativeThreadCounter++);
        LensLogger.getLogger().info("Starting native event thread");
        eventThread.setDaemon(true);
        eventThread.start();
    }

    Object enterDnDEventLoop() {
        this.dndEventLoop = this.createEventLoop();
        return this.dndEventLoop.enter();
    }

    void leaveDndEventLoop(Object value) {
        this.dndEventLoop.leave(value);
    }

    native void shutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTerminating() {
        LensLogger.getLogger().info("Finishing terminating");
        this.shutdown();
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            this.eventList.clear();
            while (!this.activeRunLoops.isEmpty()) {
                RunLoopControl control = this.activeRunLoops.pop();
                control.active = false;
            }
            this.eventList.notify();
        }
        super.finishTerminating();
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    protected void notifyWindowResize(LensWindow window, int eventType, int width, int height) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
            LensLogger.getLogger().info("notifyResize with " + WindowEvent.getEventName(eventType) + " event " + window + " to " + width + "x" + height);
        }
        if (window != null) {
            this.postEvent(new LensWindowEvent(LensWindowEvent.EType.RESIZE, window, eventType, 0, 0, width, height));
        }
    }

    protected void notifyWindowMove(LensWindow window, int x, int y) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
            LensLogger.getLogger().info("Move " + window + " to " + x + "," + y);
        }
        this.postEvent(new LensWindowEvent(LensWindowEvent.EType.MOVE, window, 512, x, y, 0, 0));
    }

    protected void notifyWindowEvent(LensWindow window, int windowEvent) {
        LensWindowEvent.EType etype = null;
        switch (windowEvent) {
            case 542: {
                etype = LensWindowEvent.EType.FOCUS;
                break;
            }
            case 541: {
                etype = LensWindowEvent.EType.FOCUS;
                break;
            }
            case 522: {
                etype = LensWindowEvent.EType.DESTROY;
                break;
            }
            case 521: {
                etype = LensWindowEvent.EType.CLOSE;
                break;
            }
            case 546: {
                etype = LensWindowEvent.EType.UNGRAB;
                break;
            }
            case 545: {
                etype = LensWindowEvent.EType.FOCUS_DISABLED;
                break;
            }
            default: {
                LensLogger.getLogger().warning("Unsupported event type (" + WindowEvent.getEventName(windowEvent) + ") skipping event");
                return;
            }
        }
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("notifyWindowEvent eventType = " + WindowEvent.getEventName(windowEvent));
        }
        if (etype != null) {
            this.postEvent(new LensWindowEvent(etype, window, windowEvent));
        }
    }

    protected void windowExpose(LensWindow window, int x, int y, int width, int height) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Expose " + window + " " + x + "," + y + "+" + width + "x" + height);
        }
        this.postEvent(new LensWindowEvent(LensWindowEvent.EType.EXPOSE, window, 511, x, y, width, height));
    }

    private void notifyKeyEvent(LensView view, int type, int keyCode, int modifiers, char[] chars) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINER)) {
                LensLogger.getLogger().finer("Key event on " + view);
            }
            this.postEvent(new LensKeyEvent(view, type, keyCode, modifiers, chars));
        }
        catch (Exception e) {
            LensApplication.reportException(e);
        }
    }

    void notifyMouseEvent(LensView view, int eventType, int x, int y, int absx, int absy, int button, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("Mouse event on " + view);
            }
            if (!this.handleDragEvents(view, eventType, x, y, absx, absy, button, modifiers)) {
                this.postMouseEvent(view, eventType, x, y, absx, absy, button, modifiers, isPopupTrigger, isSynthesized);
            }
        }
        catch (Exception e) {
            LensApplication.reportException(e);
        }
    }

    private native void _notfyPlatformDnDStarted();

    private native void _notfyPlatformDnDEnded();

    void notifyDragStart() {
        this._notfyPlatformDnDStarted();
        this.dragStarted = true;
    }

    private boolean handleDragEvents(LensView view, int eventType, int x, int y, int absx, int absy, int button, int modifiers) {
        boolean eventConsumed = false;
        if (eventType == 221 && this.cachedButtonPressed == 211) {
            this.cachedButtonPressed = button;
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("Caching mouse button - " + button);
            }
        } else if (eventType == 222 && button == this.cachedButtonPressed) {
            this.cachedButtonPressed = 211;
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("reset mouse button cache " + button);
            }
            if (this.dragStarted) {
                if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                    LensLogger.getLogger().finest("notifying drag DROP");
                }
                this.postEvent(new LensDragEvent(view, x, y, absx, absy, DragActions.DROP));
                this._notfyPlatformDnDEnded();
                this.dragActionsPreformed = DragActions.NONE.getValue();
                this.dragView = null;
                this.dragStarted = false;
            }
        } else if (eventType == 224 && this.cachedButtonPressed != 211 && ((modifiers & 0x20) == 32 || (modifiers & 0x80) == 128 || (modifiers & 0x40) == 64)) {
            if (this.dragStarted) {
                eventConsumed = true;
                if (this.dragView == view && this.dragActionsPreformed == DragActions.NONE.getValue()) {
                    this.postEvent(new LensDragEvent(view, x, y, absx, absy, DragActions.ENTER));
                    this.dragActionsPreformed |= DragActions.ENTER.getValue();
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragEnter");
                    }
                } else if (this.dragView == view && (this.dragActionsPreformed & DragActions.ENTER.getValue()) == DragActions.ENTER.getValue()) {
                    this.postEvent(new LensDragEvent(view, x, y, absx, absy, DragActions.OVER));
                    this.dragActionsPreformed |= DragActions.OVER.getValue();
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragOver");
                    }
                } else if (this.dragView != view) {
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragLeave old view");
                    }
                    this.postEvent(new LensDragEvent(this.dragView, x, y, absx, absy, DragActions.LEAVE));
                    if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                        LensLogger.getLogger().finest("Notifying DragEnter new view");
                    }
                    this.postEvent(new LensDragEvent(view, x, y, absx, absy, DragActions.ENTER));
                    this.dragActionsPreformed = DragActions.ENTER.getValue();
                    this.dragView = view;
                }
            } else {
                eventType = 223;
                if (this.dragView == null) {
                    this.dragView = view;
                }
                if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                    LensLogger.getLogger().finest("Drag detected - sending DRAG event");
                }
                this.postMouseEvent(view, eventType, x, y, absx, absy, button, modifiers, false, false);
                eventConsumed = true;
            }
        }
        return eventConsumed;
    }

    private void notifyScrollEvent(LensView view, int x, int y, int absx, int absy, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
                LensLogger.getLogger().fine("Scroll event on " + view);
            }
            this.postEvent(new LensScrollEvent(view, x, y, absx, absy, deltaX, deltaY, modifiers, lines, chars, defaultLines, defaultChars, xMultiplier, yMultiplier));
        }
        catch (Exception e) {
            LensApplication.reportException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postTouchMoveEvent(LensView view, long id, int x, int y, int absX, int absY) {
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            boolean isEventCompacted = false;
            if (!this.eventList.isEmpty()) {
                Iterator<Event> events = this.eventList.descendingIterator();
                while (events.hasNext()) {
                    Event lastEvent = events.next();
                    if (lastEvent instanceof LensTouchEvent) {
                        LensTouchEvent e = (LensTouchEvent)lastEvent;
                        if (e.view != view || e.id != id || e.state != 812 && e.state != 814) break;
                        e.x = x;
                        e.y = y;
                        e.absX = absX;
                        e.absY = absY;
                        isEventCompacted = true;
                        break;
                    }
                    if (!(lastEvent instanceof LensMultiTouchEvent)) continue;
                    break;
                }
            }
            if (!isEventCompacted) {
                this.postEvent(new LensTouchEvent(view, 812, id, x, y, absX, absY));
            }
        }
    }

    private void notifyTouchEvent(LensView view, int state, long id, int x, int y, int absX, int absY) {
        try {
            boolean hadPreviousTouchMove;
            boolean bl = hadPreviousTouchMove = this.previousTouchMoveScreenX >= 0;
            if (state == 812) {
                this.postTouchMoveEvent(view, id, x, y, absX, absY);
            } else {
                this.postEvent(new LensTouchEvent(view, state, id, x, y, absX, absY));
            }
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
                LensLogger.getLogger().fine("Touch event " + state + " at " + x + "," + y + " on " + view);
            }
        }
        catch (Exception e) {
            LensApplication.reportException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMultiTouchEvent(LensView view, int[] states, long[] ids, int[] xs, int[] ys, int dx, int dy) {
        try {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
                LensLogger.getLogger().fine("MultiTouch event with " + states.length + " points " + " on " + view);
            }
            LinkedList<Event> linkedList = this.eventList;
            synchronized (linkedList) {
                boolean match = false;
                if (!this.eventList.isEmpty()) {
                    Iterator<Event> events = this.eventList.descendingIterator();
                    while (events.hasNext()) {
                        Event lastEvent = events.next();
                        if (lastEvent instanceof LensMultiTouchEvent) {
                            LensMultiTouchEvent e = (LensMultiTouchEvent)lastEvent;
                            if (e.view != view || e.states.length != states.length) break;
                            assert (states.length == ids.length);
                            assert (e.states.length == e.ids.length);
                            match = true;
                            for (int i = 0; i < states.length && match; ++i) {
                                if (e.states[i] != 812 && e.states[i] != 814 || states[i] != 812 && states[i] != 814) {
                                    match = false;
                                }
                                if (e.ids[i] == ids[i]) continue;
                                match = false;
                            }
                            if (!match) break;
                            LensMultiTouchEvent.access$2602(e, xs);
                            LensMultiTouchEvent.access$2702(e, ys);
                            LensMultiTouchEvent.access$2402(e, states);
                            e.dx = dx;
                            e.dy = dy;
                            break;
                        }
                        if (!(lastEvent instanceof LensTouchEvent)) continue;
                        break;
                    }
                }
                if (!match) {
                    this.postEvent(new LensMultiTouchEvent(view, states, ids, xs, ys, dx, dy));
                }
            }
        }
        catch (Exception e) {
            LensApplication.reportException(e);
        }
    }

    private void notifyViewEvent(LensView view, int viewEventType, int x, int y, int width, int height) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Notify event type " + ViewEvent.getTypeString(viewEventType) + " on " + view);
        }
        this.postEvent(new LensViewEvent(view, viewEventType, x, y, width, height));
    }

    private void notifyMenuEvent(LensView view, int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINER)) {
            LensLogger.getLogger().finer("Notify menu event x=" + x + ", y=" + y + ", xAbs=" + xAbs + ", yAbs=" + yAbs + ", isKeyboardTrigger " + isKeyboardTrigger + ", on " + view);
        }
        if (view != null) {
            this.postEvent(new LensMenuEvent(view, x, y, xAbs, yAbs, isKeyboardTrigger));
        } else if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINER)) {
            LensLogger.getLogger().finer("view is null, skipping event");
        }
    }

    private void notifyDeviceEvent(int flags, boolean attach) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Notify device event attach=" + attach + ", flags=0x" + Integer.toHexString(flags));
        }
        this.postEvent(new LensDeviceEvent(flags, attach));
    }

    private void notifyScreenSettingsChanged() {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINE)) {
            LensLogger.getLogger().fine("Notify screen settings changed");
        }
        this.postEvent(new LensScreenEvent());
    }

    public void installWindowMenu(MenuBar menubar) {
        this.windowMenu = this.createMenu("Window");
    }

    public Menu getWindowMenu() {
        return this.windowMenu;
    }

    @Override
    public void installDefaultMenus(MenuBar menubar) {
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new LensWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new LensWindow(parent);
    }

    @Override
    public View createView() {
        return new LensView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new LensCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new LensCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        this.cursorVisible = visible;
        if (this.deviceFlags[2] >= 1) {
            LensCursor.setVisible_impl(visible);
        }
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return LensCursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new LensPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new LensPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new LensPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return LensPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new LensRobot();
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new LensTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return LensTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return LensTimer.getMaxPeriod_impl();
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        return null;
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return null;
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return LensView._getMultiClickTime();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return LensView._getMultiClickMaxX();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return LensView._getMultiClickMaxY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
            LensLogger.getLogger().fine("invokeAndWait " + runnable);
        }
        Object object = invokeAndWaitLock;
        synchronized (object) {
            waitingFor = runnable;
        }
        object = this.eventList;
        synchronized (object) {
            this.eventList.addLast(new RunnableEvent(true, runnable));
            this.eventList.notify();
        }
        object = invokeAndWaitLock;
        synchronized (object) {
            while (waitingFor == runnable) {
                try {
                    invokeAndWaitLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _invokeLater(Runnable runnable) {
        if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
            LensLogger.getLogger().fine("invokeLater " + runnable);
        }
        LinkedList<Event> linkedList = this.eventList;
        synchronized (linkedList) {
            this.eventList.addLast(new RunnableEvent(false, runnable));
            this.eventList.notify();
        }
    }

    @Override
    public boolean hasTwoLevelFocus() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[3] > 0;
    }

    @Override
    public boolean hasVirtualKeyboard() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasTouch() {
        return this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasMultiTouch() {
        return this.deviceFlags[1] > 0;
    }

    @Override
    public boolean hasPointer() {
        return this.deviceFlags[2] > 0;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    private static /* synthetic */ void lambda$createNativeEventThread$59(LensApplication lensApplication, long nativeEventHandler, long data) {
        LensApplication.registerEventLoop();
        lensApplication.nativeEventLoop(lensApplication, nativeEventHandler, data);
        LensApplication.unregisterEventLoop();
    }

    private /* synthetic */ void lambda$runLoop$58() {
        if (!LensApplication._initialize()) {
            LensLogger.getLogger().severe("Display failed initialization");
            throw new RuntimeException("Display failed initialization");
        }
        this._runLoop();
    }

    private static /* synthetic */ Long lambda$runLoop$57() {
        return Long.getLong("glass.lens.stackSize", 0L);
    }

    private static /* synthetic */ Void lambda$initLibrary$56(String platform) {
        Application.loadNativeLibrary("glass_lens_" + platform);
        return null;
    }

    private static /* synthetic */ Boolean lambda$initLibrary$55() {
        return Boolean.getBoolean("doNativeComposite");
    }

    private static /* synthetic */ String lambda$initLibrary$54() {
        return System.getProperty("glass.lens", "");
    }

    static {
        activeEventLoopThreads = 0;
        activeEventLoopLock = new Object();
        doComposite = true;
        isInitialized = false;
        LensApplication.initLibrary();
        nativeThreadCounter = 0;
    }

    static /* synthetic */ String access$lambda$0() {
        return LensApplication.lambda$initLibrary$54();
    }

    static /* synthetic */ Boolean access$lambda$1() {
        return LensApplication.lambda$initLibrary$55();
    }

    static /* synthetic */ Void access$lambda$2(String string) {
        return LensApplication.lambda$initLibrary$56(string);
    }

    static /* synthetic */ Long access$lambda$3() {
        return LensApplication.lambda$runLoop$57();
    }

    static /* synthetic */ void access$lambda$4(LensApplication lensApplication) {
        lensApplication.lambda$runLoop$58();
    }

    static /* synthetic */ void access$lambda$5(LensApplication lensApplication, long l, long l2) {
        LensApplication.lambda$createNativeEventThread$59(lensApplication, l, l2);
    }

    private static enum DragActions {
        NONE(0, "NONE"),
        ENTER(2, "ENTER"),
        LEAVE(4, "LEAVE"),
        OVER(8, "OVER"),
        DROP(16, "DROP");

        public int value;
        private String name;

        private DragActions(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class RunLoopControl {
        boolean active;
        Object release;

        private RunLoopControl() {
        }
    }

    private class LensScreenEvent
    extends Event {
        private LensScreenEvent() {
        }

        @Override
        void dispatch() {
            Screen.notifySettingsChanged();
        }
    }

    private class LensDeviceEvent
    extends Event {
        private int flags;
        private boolean attach;

        LensDeviceEvent(int flags, boolean attach) {
            this.flags = flags;
            this.attach = attach;
        }

        @Override
        void dispatch() {
            for (int i = 0; i <= 4; ++i) {
                if ((this.flags & 1 << i) == 0) continue;
                if (this.attach) {
                    int[] nArray = LensApplication.this.deviceFlags;
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = LensApplication.this.deviceFlags;
                int n = i;
                nArray[n] = nArray[n] - 1;
            }
            if ((this.flags & 4) != 0) {
                if (this.attach && LensApplication.this.deviceFlags[2] == 1 && LensApplication.this.cursorVisible) {
                    LensCursor.setVisible_impl(true);
                } else if (!this.attach && LensApplication.this.deviceFlags[2] == 0) {
                    LensCursor.setVisible_impl(false);
                }
            }
        }
    }

    private class LensMenuEvent
    extends Event {
        LensView view;
        int x;
        int y;
        int xAbs;
        int yAbs;
        boolean isKeyboardTrigger;

        LensMenuEvent(LensView view, int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
            this.view = view;
            this.x = x;
            this.y = y;
            this.xAbs = xAbs;
            this.yAbs = yAbs;
            this.isKeyboardTrigger = isKeyboardTrigger;
        }

        @Override
        void dispatch() {
            this.view._notifyMenu(this.x, this.y, this.xAbs, this.yAbs, this.isKeyboardTrigger);
        }

        public String toString() {
            return "LensMenuEvent[view=" + this.view + ", x=" + this.x + ", y=" + this.y + ", absx=" + this.xAbs + ", absy=" + this.yAbs + ", isKeyboardTrigger=" + this.isKeyboardTrigger + "]";
        }
    }

    private class LensDragEvent
    extends Event {
        int x;
        int y;
        int absx;
        int absy;
        DragActions action;
        LensView view;
        final int ENTER;
        final int LEAVE;
        final int OVER;
        final int DROP;

        LensDragEvent(LensView view, int x, int y, int absx, int absy, DragActions action) {
            this.ENTER = DragActions.ENTER.getValue();
            this.LEAVE = DragActions.LEAVE.getValue();
            this.OVER = DragActions.OVER.getValue();
            this.DROP = DragActions.DROP.getValue();
            this.absx = absx;
            this.absy = absy;
            this.x = x;
            this.y = y;
            this.action = action;
            this.view = view;
        }

        @Override
        void dispatch() {
            if (LensLogger.getLogger().isLoggable(PlatformLogger.Level.FINEST)) {
                LensLogger.getLogger().finest("processing drag  " + (Object)((Object)this.action));
            }
            switch (this.action) {
                case ENTER: {
                    this.view._notifyDragEnter(this.x, this.y, this.absx, this.absy, 3);
                    break;
                }
                case LEAVE: {
                    this.view._notifyDragLeave();
                    break;
                }
                case OVER: {
                    this.view._notifyDragOver(this.x, this.y, this.absx, this.absy, 3);
                    break;
                }
                case DROP: {
                    this.view._notifyDragDrop(this.x, this.y, this.absx, this.absy, 3);
                    LensApplication.this.leaveDndEventLoop(null);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public String toString() {
            return "LensDragEvent[x=" + this.x + ", y=" + this.y + ", absx=" + this.absx + ", absy=" + this.absy + ", action " + (Object)((Object)this.action) + ", view " + this.view;
        }
    }

    private static class LensViewEvent
    extends Event {
        private LensView target;
        private int x;
        private int y;
        private int width;
        private int height;
        private int viewEventType;

        LensViewEvent(LensView view, int viewEventType, int x, int y, int width, int height) {
            this.target = view;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.viewEventType = viewEventType;
        }

        @Override
        void dispatch() {
            this.target._notifyViewEvent(this.viewEventType);
        }

        public String toString() {
            return "LensViewEvent[target=" + this.target + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", event type code " + this.viewEventType + ", event type name " + ViewEvent.getTypeString(this.viewEventType);
        }
    }

    private static class LensMultiTouchEvent
    extends Event {
        private LensView view;
        private int[] states;
        private long[] ids;
        private int[] xs;
        private int[] ys;
        private int dx;
        private int dy;

        LensMultiTouchEvent(LensView view, int[] states, long[] ids, int[] xs, int[] ys, int dx, int dy) {
            this.view = view;
            this.states = states;
            this.ids = ids;
            this.xs = xs;
            this.ys = ys;
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        void dispatch() {
            LensTouchInputSupport.postMultiTouchEvent(this.view, this.states, this.ids, this.xs, this.ys, this.dx, this.dy);
        }

        public String toString() {
            return "LensMultiTouchEvent[view=" + this.view + ", ids " + Arrays.toString(this.ids) + ", states " + Arrays.toString(this.states) + ", xs " + Arrays.toString(this.xs) + ", ys " + Arrays.toString(this.ys) + "]";
        }

        static /* synthetic */ int[] access$2602(LensMultiTouchEvent x0, int[] x1) {
            x0.xs = x1;
            return x1;
        }

        static /* synthetic */ int[] access$2702(LensMultiTouchEvent x0, int[] x1) {
            x0.ys = x1;
            return x1;
        }

        static /* synthetic */ int[] access$2402(LensMultiTouchEvent x0, int[] x1) {
            x0.states = x1;
            return x1;
        }
    }

    private static class LensTouchEvent
    extends Event {
        private LensView view;
        private int state;
        private long id;
        private int x;
        private int y;
        private int absX;
        private int absY;

        LensTouchEvent(LensView view, int state, long id, int x, int y, int absX, int absY) {
            this.view = view;
            this.state = state;
            this.id = id;
            this.x = x;
            this.y = y;
            this.absX = absX;
            this.absY = absY;
        }

        @Override
        void dispatch() {
            LensTouchInputSupport.postTouchEvent(this.view, this.state, this.id, this.x, this.y, this.absX, this.absY);
        }

        public String toString() {
            return "LensTouchEvent[view=" + this.view + ",state=" + this.state + ",id=" + this.id + ",x=" + this.x + ",y=" + this.y + ",absX=" + this.absX + ",absY=" + this.absY + "]";
        }
    }

    private static class LensScrollEvent
    extends Event {
        private LensView target;
        private int x;
        private int y;
        private int absx;
        private int absy;
        private double deltaX;
        private double deltaY;
        private int modifiers;
        private int lines;
        private int chars;
        private int defaultLines;
        private int defaultChars;
        private double xMultiplier;
        private double yMultiplier;

        LensScrollEvent(LensView target, int x, int y, int absx, int absy, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
            this.target = target;
            this.x = x;
            this.y = y;
            this.absx = absx;
            this.absy = absy;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.modifiers = modifiers;
            this.lines = lines;
            this.chars = chars;
            this.defaultLines = defaultLines;
            this.defaultChars = defaultChars;
            this.xMultiplier = xMultiplier;
            this.yMultiplier = yMultiplier;
        }

        @Override
        void dispatch() {
            this.target._notifyScroll(this.x, this.y, this.absx, this.absy, this.deltaX, this.deltaY, this.modifiers, this.lines, this.chars, this.defaultLines, this.defaultChars, this.xMultiplier, this.yMultiplier);
        }

        public String toString() {
            return "LensScrollEvent[target=" + this.target + ",x=" + this.x + ",y=" + this.y + ",absx=" + this.absx + ",absy=" + this.absy + ",deltaX=" + this.deltaX + ",deltaY=" + this.deltaY + ",modifiers=" + this.modifiers + ",lines=" + this.lines + ",chars=" + this.chars + ",defaultLines=" + this.defaultLines + ",defaultChars=" + this.defaultChars + ",xMultiplier=" + this.xMultiplier + ",yMultiplier=" + this.yMultiplier + "]";
        }
    }

    private static class LensMouseEvent
    extends Event {
        private LensView target;
        private int action;
        private int x;
        private int y;
        private int absx;
        private int absy;
        private int button;
        private int modifiers;
        private boolean isPopupTrigger;
        private boolean isSynthesized;

        LensMouseEvent(LensView target, int action, int x, int y, int absx, int absy, int button, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
            this.target = target;
            this.action = action;
            this.x = x;
            this.y = y;
            this.absx = absx;
            this.absy = absy;
            this.button = button;
            this.modifiers = modifiers;
            this.isPopupTrigger = isPopupTrigger;
            this.isSynthesized = isSynthesized;
        }

        @Override
        void dispatch() {
            this.target._notifyMouse(this.action, this.button, this.x, this.y, this.absx, this.absy, this.modifiers, this.isPopupTrigger, this.isSynthesized);
        }

        public String toString() {
            return "LensMouseEvent[target=" + this.target + ",action=" + this.action + ",x=" + this.x + ",y=" + this.y + ",absx=" + this.absx + ",absy=" + this.absy + ",button=" + this.button + ",modifiers=" + this.modifiers + ",isPopupTrigger=" + this.isPopupTrigger + ",isSynthesized=" + this.isSynthesized + "]";
        }
    }

    private static class LensWindowEvent
    extends Event {
        private EType type;
        private LensWindow window;
        private int windowEvent;
        private int x;
        private int y;
        private int width;
        private int height;

        LensWindowEvent(EType type, LensWindow window, int windowEvent) {
            this.type = type;
            this.window = window;
            this.windowEvent = windowEvent;
        }

        LensWindowEvent(EType type, LensWindow window, int windowEvent, int x, int y, int width, int height) {
            this.type = type;
            this.window = window;
            this.windowEvent = windowEvent;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        void dispatch() {
            switch (this.type) {
                case FOCUS: {
                    this.window._notifyFocus(this.windowEvent);
                    break;
                }
                case MOVE: {
                    this.window._notifyMove(this.x, this.y);
                    break;
                }
                case RESIZE: {
                    this.window._notifyResize(this.windowEvent, this.width, this.height);
                    break;
                }
                case UNGRAB: {
                    this.window._notifyFocusUngrab();
                    break;
                }
                case DESTROY: {
                    this.window._notifyDestroy();
                    break;
                }
                case CLOSE: {
                    this.window._notifyClose();
                    break;
                }
                case EXPOSE: {
                    this.window._notifyExpose(this.x, this.y, this.width, this.height);
                    break;
                }
                case FOCUS_DISABLED: {
                    this.window._notifyFocusDisabled();
                    break;
                }
                default: {
                    LensLogger.getLogger().severe("Unrecognized window event type");
                }
            }
        }

        public String toString() {
            return super.toString() + "[window=" + this.window + ",type=" + (Object)((Object)this.type) + ",windowEvent=" + this.windowEvent + ",x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
        }

        static enum EType {
            CLOSE,
            DESTROY,
            EXPOSE,
            FOCUS,
            MOVE,
            RESIZE,
            UNGRAB,
            FOCUS_DISABLED;

        }
    }

    private static class LensKeyEvent
    extends Event {
        private LensView view;
        private int type;
        private int keyCode;
        private int modifiers;
        private char[] chars;

        LensKeyEvent(LensView view, int type, int keyCode, int modifiers, char[] chars) {
            this.view = view;
            this.type = type;
            this.keyCode = keyCode;
            this.modifiers = modifiers;
            this.chars = chars;
        }

        @Override
        void dispatch() {
            this.view._notifyKey(this.type, this.keyCode, this.chars, this.modifiers);
        }

        public String toString() {
            return "LensKeyEvent[view=" + this.view + ",type=" + this.type + ",keyCode=" + this.keyCode + ",modifiers=" + this.modifiers + ",chars=" + String.valueOf(this.chars) + "]";
        }
    }

    private static class RunnableEvent
    extends Event {
        private boolean wait;
        private Runnable runnable;

        RunnableEvent(boolean wait, Runnable runnable) {
            this.wait = wait;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dispatch() {
            this.runnable.run();
            if (this.wait) {
                Object object = invokeAndWaitLock;
                synchronized (object) {
                    waitingFor = null;
                    invokeAndWaitLock.notify();
                }
            }
        }

        public String toString() {
            return "RunnableEvent[runnable=" + this.runnable + ",wait=" + this.wait + "]";
        }
    }

    private static abstract class Event {
        private Event() {
        }

        abstract void dispatch();
    }
}

