/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.lens.LensLogger;
import com.sun.glass.ui.lens.LensTouchInputSupport;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;

final class LensView
extends View {
    private static long multiClickTime = 300L;
    private static int multiClickMaxX = LensTouchInputSupport.touchTapRadius;
    private static int multiClickMaxY = LensTouchInputSupport.touchTapRadius;
    private int x;
    private int y;
    private long nativePtr;

    protected LensView() {
    }

    protected static long _getMultiClickTime() {
        if (multiClickTime == -1L) {
            multiClickTime = 300L;
        }
        return multiClickTime;
    }

    protected static int _getMultiClickMaxX() {
        if (multiClickMaxX == -1) {
            multiClickMaxX = 2;
        }
        return multiClickMaxX;
    }

    protected static int _getMultiClickMaxY() {
        if (multiClickMaxY == -1) {
            multiClickMaxY = 2;
        }
        return multiClickMaxY;
    }

    private native void _paintInt(long var1, int var3, int var4, IntBuffer var5, int[] var6, int var7);

    private native void _paintByte(long var1, int var3, int var4, ByteBuffer var5, byte[] var6, int var7);

    private native void _paintIntDirect(long var1, int var3, int var4, Buffer var5);

    @Override
    protected void _enableInputMethodEvents(long ptr, boolean enable) {
    }

    @Override
    protected long _getNativeView(long ptr) {
        return ptr;
    }

    @Override
    protected int _getX(long ptr) {
        return this.x;
    }

    @Override
    protected int _getY(long ptr) {
        return this.y;
    }

    @Override
    protected void _scheduleRepaint(long ptr) {
        LensLogger.getLogger().info("Ignoring repaint");
    }

    @Override
    protected void _uploadPixels(long nativeViewPtr, Pixels pixels) {
        if (this.getWindow() != null) {
            Buffer data = pixels.getPixels();
            int width = pixels.getWidth();
            int height = pixels.getHeight();
            if (data.isDirect()) {
                this._paintIntDirect(nativeViewPtr, width, height, data);
            } else if (data.hasArray()) {
                if (pixels.getBytesPerComponent() == 1) {
                    ByteBuffer bytes = (ByteBuffer)data;
                    this._paintByte(nativeViewPtr, width, height, bytes, bytes.array(), bytes.arrayOffset());
                } else {
                    IntBuffer ints = (IntBuffer)data;
                    int[] intArray = ints.array();
                    this._paintInt(nativeViewPtr, width, height, ints, intArray, ints.arrayOffset());
                }
            }
        }
    }

    protected void _notifyMove(int x, int y) {
        this.x = x;
        this.y = y;
        this.notifyView(423);
    }

    protected void _notifyKey(int type, int keyCode, char[] keyChars, int modifiers) {
        this.notifyKey(type, keyCode, keyChars, modifiers);
    }

    protected void _notifyMouse(int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        this.notifyMouse(type, button, x, y, xAbs, yAbs, modifiers, isPopupTrigger, isSynthesized);
    }

    protected void _notifyScroll(int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        this.notifyScroll(x, y, xAbs, yAbs, deltaX, deltaY, modifiers, lines, chars, defaultLines, defaultChars, xMultiplier, yMultiplier);
    }

    protected void _notifyRepaint(int x, int y, int width, int height) {
        this.notifyRepaint(x, y, width, height);
    }

    protected void _notifyResize(int width, int height) {
        this.notifyResize(width, height);
    }

    protected void _notifyViewEvent(int viewEvent) {
        this.notifyView(viewEvent);
    }

    protected void _notifyDragEnter(int x, int y, int absx, int absy, int recommendedDropAction) {
        this.notifyDragEnter(x, y, absx, absy, recommendedDropAction);
    }

    protected void _notifyDragLeave() {
        this.notifyDragLeave();
    }

    protected void _notifyDragDrop(int x, int y, int absx, int absy, int recommendedDropAction) {
        this.notifyDragDrop(x, y, absx, absy, recommendedDropAction);
    }

    protected void _notifyDragOver(int x, int y, int absx, int absy, int recommendedDropAction) {
        this.notifyDragOver(x, y, absx, absy, recommendedDropAction);
    }

    protected void _notifyMenu(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        this.notifyMenu(x, y, xAbs, yAbs, isKeyboardTrigger);
    }

    @Override
    protected int _getNativeFrameBuffer(long ptr) {
        return 0;
    }

    @Override
    protected long _create(Map caps) {
        this.nativePtr = this._createNativeView(caps);
        return this.nativePtr;
    }

    private native long _createNativeView(Map var1);

    @Override
    protected native void _begin(long var1);

    @Override
    protected native void _end(long var1);

    @Override
    protected native void _setParent(long var1, long var3);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    @Override
    protected native void _exitFullscreen(long var1, boolean var3);

    public String toString() {
        return "LensView[nativePtr=0x" + Long.toHexString(this.nativePtr) + "]";
    }
}

