/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.glass.ui.Application;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl$$Lambda$1;
import com.sun.javafx.application.PlatformImpl$$Lambda$10;
import com.sun.javafx.application.PlatformImpl$$Lambda$11;
import com.sun.javafx.application.PlatformImpl$$Lambda$12;
import com.sun.javafx.application.PlatformImpl$$Lambda$13;
import com.sun.javafx.application.PlatformImpl$$Lambda$14;
import com.sun.javafx.application.PlatformImpl$$Lambda$15;
import com.sun.javafx.application.PlatformImpl$$Lambda$16;
import com.sun.javafx.application.PlatformImpl$$Lambda$17;
import com.sun.javafx.application.PlatformImpl$$Lambda$18;
import com.sun.javafx.application.PlatformImpl$$Lambda$19;
import com.sun.javafx.application.PlatformImpl$$Lambda$2;
import com.sun.javafx.application.PlatformImpl$$Lambda$3;
import com.sun.javafx.application.PlatformImpl$$Lambda$4;
import com.sun.javafx.application.PlatformImpl$$Lambda$5;
import com.sun.javafx.application.PlatformImpl$$Lambda$6;
import com.sun.javafx.application.PlatformImpl$$Lambda$7;
import com.sun.javafx.application.PlatformImpl$$Lambda$8;
import com.sun.javafx.application.PlatformImpl$$Lambda$9;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.tk.TKListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.ConditionalFeature;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Scene;

public class PlatformImpl {
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static AtomicBoolean platformExit = new AtomicBoolean(false);
    private static AtomicBoolean toolkitExit = new AtomicBoolean(false);
    private static CountDownLatch startupLatch = new CountDownLatch(1);
    private static AtomicBoolean listenersRegistered = new AtomicBoolean(false);
    private static TKListener toolkitListener = null;
    private static volatile boolean implicitExit = true;
    private static boolean taskbarApplication = true;
    private static boolean contextual2DNavigation;
    private static AtomicInteger pendingRunnables;
    private static AtomicInteger numWindows;
    private static volatile boolean firstWindowShown;
    private static volatile boolean lastWindowClosed;
    private static AtomicBoolean reallyIdle;
    private static Set<FinishListener> finishListeners;
    private static final Object runLaterLock;
    private static Boolean isGraphicsSupported;
    private static Boolean isControlsSupported;
    private static Boolean isMediaSupported;
    private static Boolean isWebSupported;
    private static Boolean isSWTSupported;
    private static Boolean isSwingSupported;
    private static Boolean isFXMLSupported;
    private static Boolean hasTwoLevelFocus;
    private static Boolean hasVirtualKeyboard;
    private static Boolean hasTouch;
    private static Boolean hasMultiTouch;
    private static Boolean hasPointer;
    private static boolean isThreadMerged;
    private static BooleanProperty accessibilityActive;
    private static final CountDownLatch platformExitLatch;
    private static boolean isModena;
    private static boolean isCaspian;
    private static String accessibilityTheme;

    public static void setTaskbarApplication(boolean taskbarApplication) {
        PlatformImpl.taskbarApplication = taskbarApplication;
    }

    public static boolean isTaskbarApplication() {
        return taskbarApplication;
    }

    public static void setApplicationName(Class appClass) {
        PlatformImpl.runLater(PlatformImpl$$Lambda$1.lambdaFactory$(appClass));
    }

    public static boolean isContextual2DNavigation() {
        return contextual2DNavigation;
    }

    public static void startup(Runnable r) {
        if (platformExit.get()) {
            throw new IllegalStateException("Platform.exit has been called");
        }
        if (initialized.getAndSet(true)) {
            PlatformImpl.runLater(r);
            return;
        }
        AccessController.doPrivileged(PlatformImpl$$Lambda$2.lambdaFactory$());
        if (!taskbarApplication) {
            AccessController.doPrivileged(PlatformImpl$$Lambda$3.lambdaFactory$());
        }
        toolkitListener = new TKListener(){

            @Override
            public void changedTopLevelWindows(List<TKStage> windows) {
                numWindows.set(windows.size());
                PlatformImpl.checkIdle();
            }

            @Override
            public void exitedLastNestedLoop() {
                PlatformImpl.checkIdle();
            }
        };
        Toolkit.getToolkit().addTkListener(toolkitListener);
        Toolkit.getToolkit().startup(PlatformImpl$$Lambda$4.lambdaFactory$(r));
        if (isThreadMerged) {
            PlatformImpl.installFwEventQueue();
        }
    }

    private static void installFwEventQueue() {
        PlatformImpl.invokeSwingFXUtilsMethod("installFwEventQueue");
    }

    private static void removeFwEventQueue() {
        PlatformImpl.invokeSwingFXUtilsMethod("removeFwEventQueue");
    }

    private static void invokeSwingFXUtilsMethod(String methodName) {
        try {
            Class<?> swingFXUtilsClass = Class.forName("javafx.embed.swing.SwingFXUtils");
            Method installFwEventQueue = swingFXUtilsClass.getDeclaredMethod(methodName, new Class[0]);
            AccessController.doPrivileged(PlatformImpl$$Lambda$5.lambdaFactory$(installFwEventQueue));
            PlatformImpl.waitForStart();
            installFwEventQueue.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Property javafx.embed.singleThread is not supported");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void waitForStart() {
        if (startupLatch.getCount() > 0L) {
            try {
                startupLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean isFxApplicationThread() {
        return Toolkit.getToolkit().isFxUserThread();
    }

    public static void runLater(Runnable r) {
        PlatformImpl.runLater(r, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLater(Runnable r, boolean exiting) {
        if (!initialized.get()) {
            throw new IllegalStateException("Toolkit not initialized");
        }
        pendingRunnables.incrementAndGet();
        PlatformImpl.waitForStart();
        if (SystemProperties.isDebug()) {
            Toolkit.getToolkit().pauseCurrentThread();
        }
        Object object = runLaterLock;
        synchronized (object) {
            if (!exiting && toolkitExit.get()) {
                pendingRunnables.decrementAndGet();
                return;
            }
            AccessControlContext acc = AccessController.getContext();
            Toolkit.getToolkit().defer(PlatformImpl$$Lambda$6.lambdaFactory$(r, acc));
        }
    }

    public static void runAndWait(Runnable r) {
        PlatformImpl.runAndWait(r, false);
    }

    private static void runAndWait(Runnable r, boolean exiting) {
        if (SystemProperties.isDebug()) {
            Toolkit.getToolkit().pauseCurrentThread();
        }
        if (PlatformImpl.isFxApplicationThread()) {
            try {
                r.run();
            }
            catch (Throwable t) {
                System.err.println("Exception in runnable");
                t.printStackTrace();
            }
        } else {
            CountDownLatch doneLatch = new CountDownLatch(1);
            PlatformImpl.runLater(PlatformImpl$$Lambda$7.lambdaFactory$(r, doneLatch), exiting);
            if (!exiting && toolkitExit.get()) {
                throw new IllegalStateException("Toolkit has exited");
            }
            try {
                doneLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setImplicitExit(boolean implicitExit) {
        PlatformImpl.implicitExit = implicitExit;
        PlatformImpl.checkIdle();
    }

    public static boolean isImplicitExit() {
        return implicitExit;
    }

    public static void addListener(FinishListener l) {
        listenersRegistered.set(true);
        finishListeners.add(l);
    }

    public static void removeListener(FinishListener l) {
        finishListeners.remove(l);
        listenersRegistered.set(!finishListeners.isEmpty());
        if (!listenersRegistered.get()) {
            PlatformImpl.checkIdle();
        }
    }

    private static void notifyFinishListeners(boolean exitCalled) {
        if (listenersRegistered.get()) {
            for (FinishListener l : finishListeners) {
                if (exitCalled) {
                    l.exitCalled();
                    continue;
                }
                l.idle(implicitExit);
            }
        } else if (implicitExit || platformExit.get()) {
            PlatformImpl.tkExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkIdle() {
        if (!initialized.get()) {
            return;
        }
        if (!PlatformImpl.isFxApplicationThread()) {
            PlatformImpl.runLater(PlatformImpl$$Lambda$8.lambdaFactory$());
            return;
        }
        boolean doNotify = false;
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            int numWin = numWindows.get();
            if (numWin > 0) {
                firstWindowShown = true;
                lastWindowClosed = false;
                reallyIdle.set(false);
            } else if (numWin == 0 && firstWindowShown) {
                lastWindowClosed = true;
            }
            if (lastWindowClosed && pendingRunnables.get() == 0 && (toolkitExit.get() || !Toolkit.getToolkit().isNestedLoopRunning())) {
                if (reallyIdle.getAndSet(true)) {
                    doNotify = true;
                    lastWindowClosed = false;
                } else {
                    PlatformImpl.runLater(PlatformImpl$$Lambda$9.lambdaFactory$());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (doNotify) {
                PlatformImpl.notifyFinishListeners(false);
            }
            return;
        }
    }

    static CountDownLatch test_getPlatformExitLatch() {
        return platformExitLatch;
    }

    public static void tkExit() {
        if (toolkitExit.getAndSet(true)) {
            return;
        }
        if (initialized.get()) {
            PlatformImpl.runAndWait(PlatformImpl$$Lambda$10.lambdaFactory$(), true);
            if (isThreadMerged) {
                PlatformImpl.removeFwEventQueue();
            }
            Toolkit.getToolkit().removeTkListener(toolkitListener);
            toolkitListener = null;
            platformExitLatch.countDown();
        }
    }

    public static BooleanProperty accessibilityActiveProperty() {
        return accessibilityActive;
    }

    public static void exit() {
        platformExit.set(true);
        PlatformImpl.notifyFinishListeners(true);
    }

    private static Boolean checkForClass(String classname) {
        try {
            Class.forName(classname, false, PlatformImpl.class.getClassLoader());
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException cnfe) {
            return Boolean.FALSE;
        }
    }

    public static boolean isSupported(ConditionalFeature feature) {
        boolean supported = PlatformImpl.isSupportedImpl(feature);
        if (supported && feature == ConditionalFeature.TRANSPARENT_WINDOW) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission(new AllPermission());
                }
                catch (SecurityException e) {
                    return false;
                }
            }
            return true;
        }
        return supported;
    }

    public static void setDefaultPlatformUserAgentStylesheet() {
        PlatformImpl.setPlatformUserAgentStylesheet("MODENA");
    }

    public static boolean isModena() {
        return isModena;
    }

    public static boolean isCaspian() {
        return isCaspian;
    }

    public static void setPlatformUserAgentStylesheet(String stylesheetUrl) {
        if (PlatformImpl.isFxApplicationThread()) {
            PlatformImpl._setPlatformUserAgentStylesheet(stylesheetUrl);
        } else {
            PlatformImpl.runLater(PlatformImpl$$Lambda$11.lambdaFactory$(stylesheetUrl));
        }
    }

    public static boolean setAccessibilityTheme(String platformTheme) {
        if (accessibilityTheme != null) {
            StyleManager.getInstance().removeUserAgentStylesheet(accessibilityTheme);
            accessibilityTheme = null;
        }
        PlatformImpl._setAccessibilityTheme(platformTheme);
        if (accessibilityTheme != null) {
            StyleManager.getInstance().addUserAgentStylesheet(accessibilityTheme);
            return true;
        }
        return false;
    }

    private static void _setAccessibilityTheme(String platformTheme) {
        String userTheme = (String)AccessController.doPrivileged(PlatformImpl$$Lambda$12.lambdaFactory$());
        if (PlatformImpl.isCaspian()) {
            if (platformTheme != null || userTheme != null) {
                accessibilityTheme = "com/sun/javafx/scene/control/skin/caspian/highcontrast.css";
            }
        } else if (PlatformImpl.isModena()) {
            if (userTheme != null) {
                switch (userTheme.toUpperCase()) {
                    case "BLACKONWHITE": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
                        break;
                    }
                    case "WHITEONBLACK": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
                        break;
                    }
                    case "YELLOWONBLACK": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
                        break;
                    }
                }
            } else if (platformTheme != null) {
                switch (platformTheme) {
                    case "High Contrast White": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
                        break;
                    }
                    case "High Contrast Black": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
                        break;
                    }
                    case "High Contrast #1": 
                    case "High Contrast #2": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
                        break;
                    }
                }
            }
        }
    }

    private static void _setPlatformUserAgentStylesheet(String stylesheetUrl) {
        isCaspian = false;
        isModena = false;
        String overrideStylesheetUrl = (String)AccessController.doPrivileged(PlatformImpl$$Lambda$13.lambdaFactory$());
        if (overrideStylesheetUrl != null) {
            stylesheetUrl = overrideStylesheetUrl;
        }
        ArrayList<String> uaStylesheets = new ArrayList<String>();
        if ("CASPIAN".equalsIgnoreCase(stylesheetUrl)) {
            isCaspian = true;
            uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/caspian.css");
            if (PlatformImpl.isSupported(ConditionalFeature.INPUT_TOUCH)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/embedded.css");
                if (Utils.isQVGAScreen()) {
                    uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/embedded-qvga.css");
                }
                if (PlatformUtil.isAndroid()) {
                    uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/android.css");
                }
            }
            if (PlatformImpl.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/two-level-focus.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/fxvk.css");
            }
            if (!PlatformImpl.isSupported(ConditionalFeature.TRANSPARENT_WINDOW)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/caspian-no-transparency.css");
            }
        } else if ("MODENA".equalsIgnoreCase(stylesheetUrl)) {
            isModena = true;
            uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/modena.css");
            if (PlatformImpl.isSupported(ConditionalFeature.INPUT_TOUCH)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/touch.css");
            }
            if (PlatformUtil.isEmbedded()) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/modena-embedded-performance.css");
            }
            if (PlatformUtil.isAndroid()) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/android.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/two-level-focus.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/fxvk.css");
            }
            if (!PlatformImpl.isSupported(ConditionalFeature.TRANSPARENT_WINDOW)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/modena-no-transparency.css");
            }
        } else {
            uaStylesheets.add(stylesheetUrl);
        }
        PlatformImpl._setAccessibilityTheme(Toolkit.getToolkit().getThemeName());
        if (accessibilityTheme != null) {
            uaStylesheets.add(accessibilityTheme);
        }
        AccessController.doPrivileged(PlatformImpl$$Lambda$14.lambdaFactory$(uaStylesheets));
    }

    public static void addNoTransparencyStylesheetToScene(Scene scene) {
        if (PlatformImpl.isCaspian()) {
            AccessController.doPrivileged(PlatformImpl$$Lambda$15.lambdaFactory$(scene));
        } else if (PlatformImpl.isModena()) {
            AccessController.doPrivileged(PlatformImpl$$Lambda$16.lambdaFactory$(scene));
        }
    }

    private static boolean isSupportedImpl(ConditionalFeature feature) {
        switch (feature) {
            case GRAPHICS: {
                if (isGraphicsSupported == null) {
                    isGraphicsSupported = PlatformImpl.checkForClass("javafx.stage.Stage");
                }
                return isGraphicsSupported;
            }
            case CONTROLS: {
                if (isControlsSupported == null) {
                    isControlsSupported = PlatformImpl.checkForClass("javafx.scene.control.Control");
                }
                return isControlsSupported;
            }
            case MEDIA: {
                if (isMediaSupported == null && (isMediaSupported = PlatformImpl.checkForClass("javafx.scene.media.MediaView")).booleanValue() && PlatformUtil.isEmbedded()) {
                    AccessController.doPrivileged(PlatformImpl$$Lambda$17.lambdaFactory$());
                }
                return isMediaSupported;
            }
            case WEB: {
                if (isWebSupported == null && (isWebSupported = PlatformImpl.checkForClass("javafx.scene.web.WebView")).booleanValue() && PlatformUtil.isEmbedded()) {
                    AccessController.doPrivileged(PlatformImpl$$Lambda$18.lambdaFactory$());
                }
                return isWebSupported;
            }
            case SWT: {
                if (isSWTSupported == null) {
                    isSWTSupported = PlatformImpl.checkForClass("javafx.embed.swt.FXCanvas");
                }
                return isSWTSupported;
            }
            case SWING: {
                if (isSwingSupported == null) {
                    isSwingSupported = PlatformImpl.checkForClass("javax.swing.JComponent") != false && PlatformImpl.checkForClass("javafx.embed.swing.JFXPanel") != false;
                }
                return isSwingSupported;
            }
            case FXML: {
                if (isFXMLSupported == null) {
                    isFXMLSupported = PlatformImpl.checkForClass("javafx.fxml.FXMLLoader") != false && PlatformImpl.checkForClass("javax.xml.stream.XMLInputFactory") != false;
                }
                return isFXMLSupported;
            }
            case TWO_LEVEL_FOCUS: {
                if (hasTwoLevelFocus == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasTwoLevelFocus;
            }
            case VIRTUAL_KEYBOARD: {
                if (hasVirtualKeyboard == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasVirtualKeyboard;
            }
            case INPUT_TOUCH: {
                if (hasTouch == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasTouch;
            }
            case INPUT_MULTITOUCH: {
                if (hasMultiTouch == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasMultiTouch;
            }
            case INPUT_POINTER: {
                if (hasPointer == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasPointer;
            }
        }
        return Toolkit.getToolkit().isSupported(feature);
    }

    private static /* synthetic */ Void lambda$isSupportedImpl$169() {
        String s = System.getProperty("com.sun.javafx.experimental.embedded.web", "false");
        isWebSupported = Boolean.valueOf(s);
        return null;
    }

    private static /* synthetic */ Void lambda$isSupportedImpl$168() {
        String s = System.getProperty("com.sun.javafx.experimental.embedded.media", "false");
        isMediaSupported = Boolean.valueOf(s);
        return null;
    }

    private static /* synthetic */ Object lambda$addNoTransparencyStylesheetToScene$167(Scene scene) {
        StyleManager.getInstance().addUserAgentStylesheet(scene, "com/sun/javafx/scene/control/skin/modena/modena-no-transparency.css");
        return null;
    }

    private static /* synthetic */ Object lambda$addNoTransparencyStylesheetToScene$166(Scene scene) {
        StyleManager.getInstance().addUserAgentStylesheet(scene, "com/sun/javafx/scene/control/skin/caspian/caspian-no-transparency.css");
        return null;
    }

    private static /* synthetic */ Object lambda$_setPlatformUserAgentStylesheet$165(List uaStylesheets) {
        StyleManager.getInstance().setUserAgentStylesheets(uaStylesheets);
        return null;
    }

    private static /* synthetic */ String lambda$_setPlatformUserAgentStylesheet$164() {
        return System.getProperty("javafx.userAgentStylesheetUrl");
    }

    private static /* synthetic */ String lambda$_setAccessibilityTheme$163() {
        return System.getProperty("com.sun.javafx.highContrastTheme");
    }

    private static /* synthetic */ void lambda$tkExit$161() {
        Toolkit.getToolkit().exit();
    }

    private static /* synthetic */ void lambda$checkIdle$160() {
    }

    private static /* synthetic */ void lambda$checkIdle$159() {
    }

    private static /* synthetic */ void lambda$runAndWait$158(Runnable r, CountDownLatch doneLatch) {
        try {
            r.run();
        }
        finally {
            doneLatch.countDown();
        }
    }

    private static /* synthetic */ void lambda$runLater$157(Runnable r, AccessControlContext acc) {
        try {
            AccessController.doPrivileged(PlatformImpl$$Lambda$19.lambdaFactory$(r), acc);
        }
        finally {
            pendingRunnables.decrementAndGet();
            PlatformImpl.checkIdle();
        }
    }

    private static /* synthetic */ Void lambda$null$156(Runnable r) {
        r.run();
        return null;
    }

    private static /* synthetic */ Void lambda$invokeSwingFXUtilsMethod$155(Method installFwEventQueue) {
        installFwEventQueue.setAccessible(true);
        return null;
    }

    private static /* synthetic */ void lambda$startup$154(Runnable r) {
        startupLatch.countDown();
        r.run();
    }

    private static /* synthetic */ Void lambda$startup$153() {
        System.setProperty("glass.taskbarApplication", "false");
        return null;
    }

    private static /* synthetic */ Void lambda$startup$152() {
        contextual2DNavigation = Boolean.getBoolean("com.sun.javafx.isContextual2DNavigation");
        String s = System.getProperty("com.sun.javafx.twoLevelFocus");
        if (s != null) {
            hasTwoLevelFocus = Boolean.valueOf(s);
        }
        if ((s = System.getProperty("com.sun.javafx.virtualKeyboard")) != null) {
            if (s.equalsIgnoreCase("none")) {
                hasVirtualKeyboard = false;
            } else if (s.equalsIgnoreCase("javafx")) {
                hasVirtualKeyboard = true;
            } else if (s.equalsIgnoreCase("native")) {
                hasVirtualKeyboard = true;
            }
        }
        if ((s = System.getProperty("com.sun.javafx.touch")) != null) {
            hasTouch = Boolean.valueOf(s);
        }
        if ((s = System.getProperty("com.sun.javafx.multiTouch")) != null) {
            hasMultiTouch = Boolean.valueOf(s);
        }
        if ((s = System.getProperty("com.sun.javafx.pointer")) != null) {
            hasPointer = Boolean.valueOf(s);
        }
        if ((s = System.getProperty("javafx.embed.singleThread")) != null) {
            isThreadMerged = Boolean.valueOf(s);
        }
        return null;
    }

    private static /* synthetic */ void lambda$setApplicationName$151(Class appClass) {
        Application.GetApplication().setName(appClass.getName());
    }

    static {
        pendingRunnables = new AtomicInteger(0);
        numWindows = new AtomicInteger(0);
        firstWindowShown = false;
        lastWindowClosed = false;
        reallyIdle = new AtomicBoolean(false);
        finishListeners = new CopyOnWriteArraySet<FinishListener>();
        runLaterLock = new Object();
        isThreadMerged = false;
        accessibilityActive = new SimpleBooleanProperty();
        platformExitLatch = new CountDownLatch(1);
        isModena = false;
        isCaspian = false;
    }

    static /* synthetic */ void access$lambda$0(Class clazz) {
        PlatformImpl.lambda$setApplicationName$151(clazz);
    }

    static /* synthetic */ Void access$lambda$1() {
        return PlatformImpl.lambda$startup$152();
    }

    static /* synthetic */ Void access$lambda$2() {
        return PlatformImpl.lambda$startup$153();
    }

    static /* synthetic */ void access$lambda$3(Runnable runnable) {
        PlatformImpl.lambda$startup$154(runnable);
    }

    static /* synthetic */ Void access$lambda$4(Method method) {
        return PlatformImpl.lambda$invokeSwingFXUtilsMethod$155(method);
    }

    static /* synthetic */ void access$lambda$5(Runnable runnable, AccessControlContext accessControlContext) {
        PlatformImpl.lambda$runLater$157(runnable, accessControlContext);
    }

    static /* synthetic */ void access$lambda$6(Runnable runnable, CountDownLatch countDownLatch) {
        PlatformImpl.lambda$runAndWait$158(runnable, countDownLatch);
    }

    static /* synthetic */ void access$lambda$7() {
        PlatformImpl.lambda$checkIdle$159();
    }

    static /* synthetic */ void access$lambda$8() {
        PlatformImpl.lambda$checkIdle$160();
    }

    static /* synthetic */ void access$lambda$9() {
        PlatformImpl.lambda$tkExit$161();
    }

    static /* synthetic */ void access$lambda$10(String string) {
        PlatformImpl._setPlatformUserAgentStylesheet(string);
    }

    static /* synthetic */ String access$lambda$11() {
        return PlatformImpl.lambda$_setAccessibilityTheme$163();
    }

    static /* synthetic */ String access$lambda$12() {
        return PlatformImpl.lambda$_setPlatformUserAgentStylesheet$164();
    }

    static /* synthetic */ Object access$lambda$13(List list) {
        return PlatformImpl.lambda$_setPlatformUserAgentStylesheet$165(list);
    }

    static /* synthetic */ Object access$lambda$14(Scene scene) {
        return PlatformImpl.lambda$addNoTransparencyStylesheetToScene$166(scene);
    }

    static /* synthetic */ Object access$lambda$15(Scene scene) {
        return PlatformImpl.lambda$addNoTransparencyStylesheetToScene$167(scene);
    }

    static /* synthetic */ Void access$lambda$16() {
        return PlatformImpl.lambda$isSupportedImpl$168();
    }

    static /* synthetic */ Void access$lambda$17() {
        return PlatformImpl.lambda$isSupportedImpl$169();
    }

    static /* synthetic */ Void access$lambda$18(Runnable runnable) {
        return PlatformImpl.lambda$null$156(runnable);
    }

    public static interface FinishListener {
        public void idle(boolean var1);

        public void exitCalled();
    }
}

