/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.charts;

import com.sun.javafx.charts.Legend$$Lambda$1;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.TilePane;

public class Legend
extends TilePane {
    private static final int GAP = 5;
    private ListChangeListener<LegendItem> itemsListener = Legend$$Lambda$1.lambdaFactory$(this);
    private BooleanProperty vertical = new BooleanPropertyBase(false){

        @Override
        protected void invalidated() {
            Legend.this.setOrientation(this.get() ? Orientation.VERTICAL : Orientation.HORIZONTAL);
        }

        @Override
        public Object getBean() {
            return Legend.this;
        }

        @Override
        public String getName() {
            return "vertical";
        }
    };
    private ObjectProperty<ObservableList<LegendItem>> items = new ObjectPropertyBase<ObservableList<LegendItem>>(){
        ObservableList<LegendItem> oldItems = null;

        @Override
        protected void invalidated() {
            if (this.oldItems != null) {
                this.oldItems.removeListener(Legend.this.itemsListener);
            }
            Legend.this.getChildren().clear();
            ObservableList newItems = (ObservableList)this.get();
            if (newItems != null) {
                newItems.addListener(Legend.this.itemsListener);
                for (LegendItem item : newItems) {
                    Legend.this.getChildren().add(item.label);
                }
            }
            this.oldItems = (ObservableList)this.get();
            Legend.this.requestLayout();
        }

        @Override
        public Object getBean() {
            return Legend.this;
        }

        @Override
        public String getName() {
            return "items";
        }
    };

    public final boolean isVertical() {
        return this.vertical.get();
    }

    public final void setVertical(boolean value) {
        this.vertical.set(value);
    }

    public final BooleanProperty verticalProperty() {
        return this.vertical;
    }

    public final void setItems(ObservableList<LegendItem> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<LegendItem> getItems() {
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<LegendItem>> itemsProperty() {
        return this.items;
    }

    public Legend() {
        super(5.0, 5.0);
        this.setTileAlignment(Pos.CENTER_LEFT);
        this.setItems(FXCollections.observableArrayList());
        this.getStyleClass().setAll((String[])new String[]{"chart-legend"});
    }

    @Override
    protected double computePrefWidth(double forHeight) {
        return this.getItems().size() > 0 ? super.computePrefWidth(forHeight) : 0.0;
    }

    @Override
    protected double computePrefHeight(double forWidth) {
        return this.getItems().size() > 0 ? super.computePrefHeight(forWidth) : 0.0;
    }

    private /* synthetic */ void lambda$new$0(ListChangeListener.Change c) {
        this.getChildren().clear();
        for (LegendItem item : this.getItems()) {
            this.getChildren().add(item.label);
        }
        if (this.isVisible()) {
            this.requestLayout();
        }
    }

    static /* synthetic */ void access$lambda$0(Legend legend, ListChangeListener.Change change) {
        legend.lambda$new$0(change);
    }

    public static class LegendItem {
        private Label label = new Label();
        private StringProperty text = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                LegendItem.this.label.setText(this.get());
            }

            @Override
            public Object getBean() {
                return LegendItem.this;
            }

            @Override
            public String getName() {
                return "text";
            }
        };
        private ObjectProperty<Node> symbol = new ObjectPropertyBase<Node>((Node)new Region()){

            @Override
            protected void invalidated() {
                Node symbol = (Node)this.get();
                if (symbol != null) {
                    symbol.getStyleClass().setAll((String[])new String[]{"chart-legend-item-symbol"});
                }
                LegendItem.this.label.setGraphic(symbol);
            }

            @Override
            public Object getBean() {
                return LegendItem.this;
            }

            @Override
            public String getName() {
                return "symbol";
            }
        };

        public final String getText() {
            return this.text.getValue();
        }

        public final void setText(String value) {
            this.text.setValue(value);
        }

        public final StringProperty textProperty() {
            return this.text;
        }

        public final Node getSymbol() {
            return (Node)this.symbol.getValue();
        }

        public final void setSymbol(Node value) {
            this.symbol.setValue(value);
        }

        public final ObjectProperty<Node> symbolProperty() {
            return this.symbol;
        }

        public LegendItem(String text) {
            this.setText(text);
            this.label.getStyleClass().add("chart-legend-item");
            this.label.setAlignment(Pos.CENTER_LEFT);
            this.label.setContentDisplay(ContentDisplay.LEFT);
            this.label.setGraphic(this.getSymbol());
            this.getSymbol().getStyleClass().setAll((String[])new String[]{"chart-legend-item-symbol"});
        }

        public LegendItem(String text, Node symbol) {
            this(text);
            this.setSymbol(symbol);
        }
    }
}

