/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import java.util.Arrays;
import javafx.collections.ObservableArrayBase;
import javafx.collections.ObservableIntegerArray;

public class ObservableIntegerArrayImpl
extends ObservableArrayBase<ObservableIntegerArray>
implements ObservableIntegerArray {
    private static final int[] INITIAL = new int[0];
    private int[] array = INITIAL;
    private int size = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ObservableIntegerArrayImpl() {
    }

    public ObservableIntegerArrayImpl(int ... elements) {
        this.setAll(elements);
    }

    public ObservableIntegerArrayImpl(ObservableIntegerArray src) {
        this.setAll(src);
    }

    @Override
    public void clear() {
        this.resize(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void addAllInternal(ObservableIntegerArray src, int srcIndex, int length) {
        this.growCapacity(length);
        src.copyTo(srcIndex, this.array, this.size, length);
        this.size += length;
        this.fireChange(length != 0, this.size - length, this.size);
    }

    private void addAllInternal(int[] src, int srcIndex, int length) {
        this.growCapacity(length);
        System.arraycopy(src, srcIndex, this.array, this.size, length);
        this.size += length;
        this.fireChange(length != 0, this.size - length, this.size);
    }

    @Override
    public void addAll(ObservableIntegerArray src) {
        this.addAllInternal(src, 0, src.size());
    }

    @Override
    public void addAll(int ... elements) {
        this.addAllInternal(elements, 0, elements.length);
    }

    @Override
    public void addAll(ObservableIntegerArray src, int srcIndex, int length) {
        this.rangeCheck(src, srcIndex, length);
        this.addAllInternal(src, srcIndex, length);
    }

    @Override
    public void addAll(int[] src, int srcIndex, int length) {
        this.rangeCheck(src, srcIndex, length);
        this.addAllInternal(src, srcIndex, length);
    }

    private void setAllInternal(ObservableIntegerArray src, int srcIndex, int length) {
        boolean sizeChanged;
        boolean bl = sizeChanged = this.size() != length;
        if (src == this) {
            if (srcIndex == 0) {
                this.resize(length);
            } else {
                System.arraycopy(this.array, srcIndex, this.array, 0, length);
                this.size = length;
                this.fireChange(sizeChanged, 0, this.size);
            }
        } else {
            this.size = 0;
            this.ensureCapacity(length);
            src.copyTo(srcIndex, this.array, 0, length);
            this.size = length;
            this.fireChange(sizeChanged, 0, this.size);
        }
    }

    private void setAllInternal(int[] src, int srcIndex, int length) {
        boolean sizeChanged = this.size() != length;
        this.size = 0;
        this.ensureCapacity(length);
        System.arraycopy(src, srcIndex, this.array, 0, length);
        this.size = length;
        this.fireChange(sizeChanged, 0, this.size);
    }

    @Override
    public void setAll(ObservableIntegerArray src) {
        this.setAllInternal(src, 0, src.size());
    }

    @Override
    public void setAll(ObservableIntegerArray src, int srcIndex, int length) {
        this.rangeCheck(src, srcIndex, length);
        this.setAllInternal(src, srcIndex, length);
    }

    @Override
    public void setAll(int[] src, int srcIndex, int length) {
        this.rangeCheck(src, srcIndex, length);
        this.setAllInternal(src, srcIndex, length);
    }

    @Override
    public void setAll(int ... src) {
        this.setAllInternal(src, 0, src.length);
    }

    @Override
    public void set(int destIndex, int[] src, int srcIndex, int length) {
        this.rangeCheck(destIndex + length);
        System.arraycopy(src, srcIndex, this.array, destIndex, length);
        this.fireChange(false, destIndex, destIndex + length);
    }

    @Override
    public void set(int destIndex, ObservableIntegerArray src, int srcIndex, int length) {
        this.rangeCheck(destIndex + length);
        src.copyTo(srcIndex, this.array, destIndex, length);
        this.fireChange(false, destIndex, destIndex + length);
    }

    @Override
    public int[] toArray(int[] dest) {
        if (dest == null || this.size() > dest.length) {
            dest = new int[this.size()];
        }
        System.arraycopy(this.array, 0, dest, 0, this.size());
        return dest;
    }

    @Override
    public int get(int index) {
        this.rangeCheck(index + 1);
        return this.array[index];
    }

    @Override
    public void set(int index, int value) {
        this.rangeCheck(index + 1);
        this.array[index] = value;
        this.fireChange(false, index, index + 1);
    }

    @Override
    public int[] toArray(int index, int[] dest, int length) {
        this.rangeCheck(index + length);
        if (dest == null || length > dest.length) {
            dest = new int[length];
        }
        System.arraycopy(this.array, index, dest, 0, length);
        return dest;
    }

    @Override
    public void copyTo(int srcIndex, int[] dest, int destIndex, int length) {
        this.rangeCheck(srcIndex + length);
        System.arraycopy(this.array, srcIndex, dest, destIndex, length);
    }

    @Override
    public void copyTo(int srcIndex, ObservableIntegerArray dest, int destIndex, int length) {
        this.rangeCheck(srcIndex + length);
        dest.set(destIndex, this.array, srcIndex, length);
    }

    @Override
    public void resize(int newSize) {
        if (newSize < 0) {
            throw new NegativeArraySizeException("Can't resize to negative value: " + newSize);
        }
        this.ensureCapacity(newSize);
        int minSize = Math.min(this.size, newSize);
        boolean sizeChanged = this.size != newSize;
        this.size = newSize;
        Arrays.fill(this.array, minSize, this.size, 0);
        this.fireChange(sizeChanged, minSize, newSize);
    }

    private void growCapacity(int length) {
        int minCapacity = this.size + length;
        int oldCapacity = this.array.length;
        if (minCapacity > this.array.length) {
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            if (newCapacity > 0x7FFFFFF7) {
                newCapacity = ObservableIntegerArrayImpl.hugeCapacity(minCapacity);
            }
            this.ensureCapacity(newCapacity);
        } else if (length > 0 && minCapacity < 0) {
            throw new OutOfMemoryError();
        }
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (this.array.length < capacity) {
            this.array = Arrays.copyOf(this.array, capacity);
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void trimToSize() {
        if (this.array.length != this.size) {
            int[] newArray = new int[this.size];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    private void rangeCheck(int size) {
        if (size > this.size) {
            throw new ArrayIndexOutOfBoundsException(this.size);
        }
    }

    private void rangeCheck(ObservableIntegerArray src, int srcIndex, int length) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (srcIndex < 0 || srcIndex + length > src.size()) {
            throw new ArrayIndexOutOfBoundsException(src.size());
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
    }

    private void rangeCheck(int[] src, int srcIndex, int length) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (srcIndex < 0 || srcIndex + length > src.length) {
            throw new ArrayIndexOutOfBoundsException(src.length);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(-1);
        }
    }

    public String toString() {
        if (this.array == null) {
            return "null";
        }
        int iMax = this.size() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.array[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

