/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.CssError;
import com.sun.javafx.css.FontFace;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SelectorPartitioning;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleClassSet;
import com.sun.javafx.css.StyleConverterImpl;
import com.sun.javafx.css.StyleManager$$Lambda$1;
import com.sun.javafx.css.StyleManager$$Lambda$2;
import com.sun.javafx.css.StyleManager$$Lambda$3;
import com.sun.javafx.css.StyleManager$$Lambda$4;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.parser.CSSParser;
import com.sun.javafx.util.Logging;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Window;
import sun.util.logging.PlatformLogger;

public final class StyleManager {
    private static final Object styleLock = new Object();
    private static PlatformLogger LOGGER;
    static final Map<Parent, CacheContainer> cacheContainerMap;
    final List<StylesheetContainer> userAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    final List<StylesheetContainer> platformUserAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    boolean hasDefaultUserAgentStylesheet = false;
    final Map<String, StylesheetContainer> stylesheetContainerMap = new HashMap<String, StylesheetContainer>();
    private final Map<String, Image> imageCache = new HashMap<String, Image>();
    private Key key = null;
    private static ObservableList<CssError> errors;
    private static List<String> cacheMapKey;

    private static PlatformLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getCSSLogger();
        }
        return LOGGER;
    }

    public static StyleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private StyleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheContainer getCacheContainer(Styleable styleable, SubScene subScene) {
        Scene scene;
        if (styleable == null && subScene == null) {
            return null;
        }
        Parent root = null;
        if (subScene != null) {
            root = subScene.getRoot();
        } else if (styleable instanceof Node) {
            Node node = (Node)styleable;
            Scene scene2 = node.getScene();
            if (scene2 != null) {
                root = scene2.getRoot();
            }
        } else if (styleable instanceof Window && (scene = ((Window)((Object)styleable)).getScene()) != null) {
            root = scene.getRoot();
        }
        if (root == null) {
            return null;
        }
        Object object = styleLock;
        synchronized (object) {
            CacheContainer container = cacheContainerMap.get(root);
            if (container == null) {
                container = new CacheContainer();
                cacheContainerMap.put(root, container);
            }
            return container;
        }
    }

    public StyleCache getSharedCache(Styleable styleable, SubScene subScene, StyleCache.Key key) {
        CacheContainer container = this.getCacheContainer(styleable, subScene);
        if (container == null) {
            return null;
        }
        Map styleCache = container.getStyleCache();
        if (styleCache == null) {
            return null;
        }
        StyleCache sharedCache = (StyleCache)styleCache.get(key);
        if (sharedCache == null) {
            sharedCache = new StyleCache();
            styleCache.put(new StyleCache.Key(key), sharedCache);
        }
        return sharedCache;
    }

    public StyleMap getStyleMap(Styleable styleable, SubScene subScene, int smapId) {
        if (smapId == -1) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer container = this.getCacheContainer(styleable, subScene);
        if (container == null) {
            return StyleMap.EMPTY_MAP;
        }
        return container.getStyleMap(smapId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Scene scene) {
        if (scene == null) {
            return;
        }
        this.forget(scene.getRoot());
        Object object = styleLock;
        synchronized (object) {
            String sceneUserAgentStylesheet = null;
            if (scene.getUserAgentStylesheet() != null && !(sceneUserAgentStylesheet = scene.getUserAgentStylesheet().trim()).isEmpty()) {
                for (int n = this.userAgentStylesheetContainers.size() - 1; 0 <= n; --n) {
                    StylesheetContainer container = this.userAgentStylesheetContainers.get(n);
                    if (!sceneUserAgentStylesheet.equals(container.fname)) continue;
                    container.parentUsers.remove(scene.getRoot());
                    if (container.parentUsers.list.size() != 0) continue;
                    this.userAgentStylesheetContainers.remove(n);
                }
            }
            Set<Map.Entry<String, StylesheetContainer>> stylesheetContainers = this.stylesheetContainerMap.entrySet();
            Iterator<Map.Entry<String, StylesheetContainer>> iter = stylesheetContainers.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, StylesheetContainer> entry = iter.next();
                StylesheetContainer container = entry.getValue();
                Iterator parentIter = container.parentUsers.list.iterator();
                while (parentIter.hasNext()) {
                    Reference ref = parentIter.next();
                    Parent _parent = (Parent)ref.get();
                    if (_parent != null && _parent.getScene() != scene && _parent.getScene() != null) continue;
                    ref.clear();
                    parentIter.remove();
                }
                if (!container.parentUsers.list.isEmpty()) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stylesheetsChanged(Scene scene, ListChangeListener.Change<String> c) {
        Object object = styleLock;
        synchronized (object) {
            Set<Map.Entry<Parent, CacheContainer>> entrySet = cacheContainerMap.entrySet();
            for (Map.Entry<Parent, CacheContainer> entry : entrySet) {
                Parent parent = entry.getKey();
                CacheContainer container = entry.getValue();
                if (parent.getScene() != scene) continue;
                container.clearCache();
            }
            c.reset();
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                for (String fname : c.getRemoved()) {
                    this.stylesheetRemoved(scene, fname);
                    StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(fname);
                    if (stylesheetContainer == null) continue;
                    stylesheetContainer.invalidateChecksum();
                }
            }
        }
    }

    private void stylesheetRemoved(Scene scene, String fname) {
        this.stylesheetRemoved(scene.getRoot(), fname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Parent parent) {
        if (parent == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            ObservableList<String> stylesheets;
            if (cacheContainerMap.containsKey(parent)) {
                CacheContainer container = cacheContainerMap.remove(parent);
                container.clearCache();
            }
            if ((stylesheets = parent.getStylesheets()) != null && !stylesheets.isEmpty()) {
                for (String fname : stylesheets) {
                    this.stylesheetRemoved(parent, fname);
                }
            }
            Iterator<Map.Entry<String, StylesheetContainer>> containerIterator = this.stylesheetContainerMap.entrySet().iterator();
            while (containerIterator.hasNext()) {
                Map.Entry<String, StylesheetContainer> entry = containerIterator.next();
                StylesheetContainer container = entry.getValue();
                container.parentUsers.remove(parent);
                if (!container.parentUsers.list.isEmpty()) continue;
                containerIterator.remove();
                if (container.selectorPartitioning != null) {
                    container.selectorPartitioning.reset();
                }
                String fname = container.fname;
                this.cleanUpImageCache(fname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stylesheetsChanged(Parent parent, ListChangeListener.Change<String> c) {
        Object object = styleLock;
        synchronized (object) {
            c.reset();
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                for (String fname : c.getRemoved()) {
                    this.stylesheetRemoved(parent, fname);
                    StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(fname);
                    if (stylesheetContainer == null) continue;
                    stylesheetContainer.invalidateChecksum();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stylesheetRemoved(Parent parent, String fname) {
        Object object = styleLock;
        synchronized (object) {
            StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(fname);
            if (stylesheetContainer == null) {
                return;
            }
            stylesheetContainer.parentUsers.remove(parent);
            if (stylesheetContainer.parentUsers.list.isEmpty()) {
                this.removeStylesheetContainer(stylesheetContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(SubScene subScene) {
        if (subScene == null) {
            return;
        }
        Parent subSceneRoot = subScene.getRoot();
        if (subSceneRoot == null) {
            return;
        }
        this.forget(subSceneRoot);
        Object object = styleLock;
        synchronized (object) {
            String sceneUserAgentStylesheet = null;
            if (subScene.getUserAgentStylesheet() != null && !(sceneUserAgentStylesheet = subScene.getUserAgentStylesheet().trim()).isEmpty()) {
                Iterator<StylesheetContainer> iterator = this.userAgentStylesheetContainers.iterator();
                while (iterator.hasNext()) {
                    StylesheetContainer container = iterator.next();
                    if (!sceneUserAgentStylesheet.equals(container.fname)) continue;
                    container.parentUsers.remove(subScene.getRoot());
                    if (container.parentUsers.list.size() != 0) continue;
                    iterator.remove();
                }
            }
            ArrayList<StylesheetContainer> stylesheetContainers = new ArrayList<StylesheetContainer>(this.stylesheetContainerMap.values());
            for (StylesheetContainer container : stylesheetContainers) {
                Iterator parentIter = container.parentUsers.list.iterator();
                block5: while (parentIter.hasNext()) {
                    Reference ref = parentIter.next();
                    Parent _parent = (Parent)ref.get();
                    if (_parent == null) continue;
                    for (Parent p = _parent; p != null; p = p.getParent()) {
                        if (subSceneRoot != p.getParent()) continue;
                        ref.clear();
                        parentIter.remove();
                        this.forget(_parent);
                        continue block5;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStylesheetContainer(StylesheetContainer stylesheetContainer) {
        if (stylesheetContainer == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            String fname = stylesheetContainer.fname;
            this.stylesheetContainerMap.remove(fname);
            if (stylesheetContainer.selectorPartitioning != null) {
                stylesheetContainer.selectorPartitioning.reset();
            }
            for (Map.Entry<Parent, CacheContainer> entry : cacheContainerMap.entrySet()) {
                CacheContainer container = entry.getValue();
                if (container == null || container.cacheMap == null || container.cacheMap.isEmpty()) continue;
                ArrayList<List> entriesToRemove = new ArrayList<List>();
                for (Map.Entry cacheMapEntry : container.cacheMap.entrySet()) {
                    List cacheMapKey = (List)cacheMapEntry.getKey();
                    if (!(cacheMapKey != null ? cacheMapKey.contains(fname) : fname == null)) continue;
                    entriesToRemove.add(cacheMapKey);
                }
                if (entriesToRemove.isEmpty()) continue;
                for (List cacheMapKey : entriesToRemove) {
                    Map cacheEntry = (Map)container.cacheMap.remove(cacheMapKey);
                    if (cacheEntry == null) continue;
                    cacheEntry.clear();
                }
            }
            this.cleanUpImageCache(fname);
            List parentList = stylesheetContainer.parentUsers.list;
            for (int n = parentList.size() - 1; 0 <= n; --n) {
                Reference ref = parentList.remove(n);
                Parent parent = (Parent)ref.get();
                ref.clear();
                if (parent == null || parent.getScene() == null) continue;
                parent.impl_reapplyCSS();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getCachedImage(String url) {
        Object object = styleLock;
        synchronized (object) {
            Image image;
            block11: {
                image = null;
                if (this.imageCache.containsKey(url)) {
                    image = this.imageCache.get(url);
                } else {
                    try {
                        image = new Image(url);
                        if (image.isError()) {
                            PlatformLogger logger = StyleManager.getLogger();
                            if (logger != null && logger.isLoggable(PlatformLogger.Level.WARNING)) {
                                logger.warning("Error loading image: " + url);
                            }
                            image = null;
                        }
                        this.imageCache.put(url, image);
                    }
                    catch (IllegalArgumentException iae) {
                        PlatformLogger logger = StyleManager.getLogger();
                        if (logger != null && logger.isLoggable(PlatformLogger.Level.WARNING)) {
                            logger.warning(iae.getLocalizedMessage());
                        }
                    }
                    catch (NullPointerException npe) {
                        PlatformLogger logger = StyleManager.getLogger();
                        if (logger == null || !logger.isLoggable(PlatformLogger.Level.WARNING)) break block11;
                        logger.warning(npe.getLocalizedMessage());
                    }
                }
            }
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpImageCache(String imgFname) {
        Object object = styleLock;
        synchronized (object) {
            if (imgFname == null && this.imageCache.isEmpty()) {
                return;
            }
            String fname = imgFname.trim();
            if (fname.isEmpty()) {
                return;
            }
            int len = fname.lastIndexOf(47);
            String path = len > 0 ? fname.substring(0, len) : fname;
            int plen = path.length();
            String[] entriesToRemove = new String[this.imageCache.size()];
            int count = 0;
            Set<Map.Entry<String, Image>> entrySet = this.imageCache.entrySet();
            for (Map.Entry<String, Image> entry : entrySet) {
                String key = entry.getKey();
                len = key.lastIndexOf(47);
                String kpath = len > 0 ? key.substring(0, len) : key;
                int klen = kpath.length();
                boolean match = klen > plen ? kpath.startsWith(path) : path.startsWith(kpath);
                if (!match) continue;
                entriesToRemove[count++] = key;
            }
            for (int n = 0; n < count; ++n) {
                Image image = this.imageCache.remove(entriesToRemove[n]);
            }
        }
    }

    private static URL getURL(String str) {
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(str.trim());
            if (!uri.isAbsolute()) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                String path = uri.getPath();
                URL resource = null;
                resource = path.startsWith("/") ? contextClassLoader.getResource(path.substring(1)) : contextClassLoader.getResource(path);
                return resource;
            }
            return uri.toURL();
        }
        catch (MalformedURLException malf) {
            return null;
        }
        catch (URISyntaxException urise) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    static byte[] calculateCheckSum(String fname) {
        block28: {
            byte[] byArray;
            Throwable throwable;
            DigestInputStream dis;
            Throwable throwable2;
            InputStream stream;
            block31: {
                block32: {
                    block29: {
                        block30: {
                            if (fname == null || fname.isEmpty()) {
                                return new byte[0];
                            }
                            URL url = StyleManager.getURL(fname);
                            if (url == null || !"file".equals(url.getProtocol())) break block28;
                            stream = url.openStream();
                            throwable2 = null;
                            dis = new DigestInputStream(stream, MessageDigest.getInstance("MD5"));
                            throwable = null;
                            dis.getMessageDigest().reset();
                            while (dis.read() != -1) {
                            }
                            byArray = dis.getMessageDigest().digest();
                            if (dis == null) break block29;
                            if (throwable == null) break block30;
                            try {
                                dis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block29;
                        }
                        dis.close();
                    }
                    if (stream == null) break block31;
                    if (throwable2 == null) break block32;
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    break block31;
                }
                stream.close();
            }
            return byArray;
            {
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (dis != null) {
                                        if (throwable != null) {
                                            try {
                                                dis.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            dis.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                        }
                        catch (Throwable throwable9) {
                            if (stream != null) {
                                if (throwable2 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable2.addSuppressed(throwable10);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable9;
                        }
                    }
                    catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
                        // empty catch block
                    }
                }
            }
        }
        return new byte[0];
    }

    public static Stylesheet loadStylesheet(String fname) {
        try {
            return StyleManager.loadStylesheetUnPrivileged(fname);
        }
        catch (AccessControlException ace) {
            if (fname.length() < 7 && fname.indexOf("!/") < fname.length() - 7) {
                return null;
            }
            try {
                String requestedFilePath;
                String requestedFileJarPart;
                URI styleManagerJarURI;
                String styleManagerJarPath;
                URI requestedFileUrI = new URI(fname);
                if ("jar".equals(requestedFileUrI.getScheme()) && (styleManagerJarPath = (styleManagerJarURI = (URI)AccessController.doPrivileged(StyleManager$$Lambda$1.lambdaFactory$())).getSchemeSpecificPart()).equals(requestedFileJarPart = (requestedFilePath = requestedFileUrI.getSchemeSpecificPart()).substring(requestedFilePath.indexOf(47), requestedFilePath.indexOf("!/")))) {
                    String requestedFileJarPathNoLeadingSlash = fname.substring(fname.indexOf("!/") + 2);
                    if (fname.endsWith(".css") || fname.endsWith(".bss")) {
                        JarEntry entry;
                        FilePermission perm = new FilePermission(styleManagerJarPath, "read");
                        PermissionCollection perms = perm.newPermissionCollection();
                        perms.add(perm);
                        AccessControlContext permsAcc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
                        JarFile jar = null;
                        try {
                            jar = (JarFile)AccessController.doPrivileged(StyleManager$$Lambda$2.lambdaFactory$(styleManagerJarPath), permsAcc);
                        }
                        catch (PrivilegedActionException pae) {
                            return null;
                        }
                        if (jar != null && (entry = jar.getJarEntry(requestedFileJarPathNoLeadingSlash)) != null) {
                            return (Stylesheet)AccessController.doPrivileged(StyleManager$$Lambda$3.lambdaFactory$(fname), permsAcc);
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
            catch (PrivilegedActionException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Stylesheet loadStylesheetUnPrivileged(String fname) {
        Object object = styleLock;
        synchronized (object) {
            block23: {
                Boolean parse = (Boolean)AccessController.doPrivileged(StyleManager$$Lambda$4.lambdaFactory$(fname));
                try {
                    String ext = parse != false ? ".css" : ".bss";
                    URL url = null;
                    Stylesheet stylesheet = null;
                    if (!fname.endsWith(".css") && !fname.endsWith(".bss")) {
                        url = StyleManager.getURL(fname);
                        parse = true;
                    } else {
                        String name = fname.substring(0, fname.length() - 4);
                        url = StyleManager.getURL(name + ext);
                        if (url == null && (parse = Boolean.valueOf(parse == false)).booleanValue()) {
                            url = StyleManager.getURL(name + ".css");
                        }
                        if (url != null && !parse.booleanValue()) {
                            try {
                                stylesheet = Stylesheet.loadBinary(url);
                            }
                            catch (IOException ioe) {
                                stylesheet = null;
                            }
                            if (stylesheet == null && (parse = Boolean.valueOf(parse == false)).booleanValue()) {
                                url = StyleManager.getURL(fname);
                            }
                        }
                    }
                    if (url != null && parse.booleanValue()) {
                        stylesheet = new CSSParser().parse(url);
                    }
                    if (stylesheet == null) {
                        if (errors != null) {
                            CssError error = new CssError("Resource \"" + fname + "\" not found.");
                            errors.add(error);
                        }
                        if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                            StyleManager.getLogger().warning(String.format("Resource \"%s\" not found.", fname));
                        }
                    }
                    if (stylesheet != null) {
                        block8: for (FontFace fontFace : stylesheet.getFontFaces()) {
                            for (FontFace.FontFaceSrc src : fontFace.getSources()) {
                                if (src.getType() != FontFace.FontFaceSrcType.URL) continue;
                                Font loadedFont = Font.loadFont(src.getSrc(), 10.0);
                                if (loadedFont != null) continue block8;
                                StyleManager.getLogger().info("Could not load @font-face font [" + src.getSrc() + "]");
                                continue block8;
                            }
                        }
                    }
                    return stylesheet;
                }
                catch (FileNotFoundException fnfe) {
                    if (errors != null) {
                        CssError error = new CssError("Stylesheet \"" + fname + "\" not found.");
                        errors.add(error);
                    }
                    if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                        StyleManager.getLogger().info("Could not find stylesheet: " + fname);
                    }
                }
                catch (IOException ioe) {
                    if (errors != null) {
                        CssError error = new CssError("Could not load stylesheet: " + fname);
                        errors.add(error);
                    }
                    if (!StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) break block23;
                    StyleManager.getLogger().info("Could not load stylesheet: " + fname);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAgentStylesheets(List<String> urls) {
        if (urls == null || urls.size() == 0) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            String fname;
            String url;
            int n;
            int nMax;
            if (urls.size() == this.platformUserAgentStylesheetContainers.size()) {
                boolean isSame = true;
                nMax = urls.size();
                for (n = 0; n < nMax && isSame; ++n) {
                    url = urls.get(n);
                    String string = fname = url != null ? url.trim() : null;
                    if (fname == null || fname.isEmpty()) break;
                    StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                    isSame = fname.equals(container.fname);
                    if (!isSame) continue;
                    String stylesheetUrl = container.stylesheet.getUrl();
                    byte[] checksum = StyleManager.calculateCheckSum(stylesheetUrl);
                    isSame = Arrays.equals(checksum, container.checksum);
                }
                if (isSame) {
                    return;
                }
            }
            boolean modified = false;
            nMax = urls.size();
            for (n = 0; n < nMax; ++n) {
                url = urls.get(n);
                String string = fname = url != null ? url.trim() : null;
                if (fname == null || fname.isEmpty()) continue;
                if (!modified) {
                    this.platformUserAgentStylesheetContainers.clear();
                    modified = true;
                }
                if (n == 0) {
                    this._setDefaultUserAgentStylesheet(fname);
                    continue;
                }
                this._addUserAgentStylesheet(fname);
            }
            if (modified) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    public void addUserAgentStylesheet(String fname) {
        this.addUserAgentStylesheet(null, fname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserAgentStylesheet(Scene scene, String url) {
        String fname;
        String string = fname = url != null ? url.trim() : null;
        if (fname == null || fname.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            CssError.setCurrentScene(scene);
            if (this._addUserAgentStylesheet(fname)) {
                this.userAgentStylesheetsChanged();
            }
            CssError.setCurrentScene(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addUserAgentStylesheet(String fname) {
        Object object = styleLock;
        synchronized (object) {
            int nMax = this.platformUserAgentStylesheetContainers.size();
            for (int n = 0; n < nMax; ++n) {
                StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                if (!fname.equals(container.fname)) continue;
                return false;
            }
            Stylesheet ua_stylesheet = StyleManager.loadStylesheet(fname);
            if (ua_stylesheet == null) {
                return false;
            }
            ua_stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(fname, ua_stylesheet));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserAgentStylesheet(Scene scene, Stylesheet ua_stylesheet) {
        if (ua_stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        String url = ua_stylesheet.getUrl();
        String fname = url != null ? url.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int nMax = this.platformUserAgentStylesheetContainers.size();
            for (int n = 0; n < nMax; ++n) {
                StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                if (!fname.equals(container.fname)) continue;
                return;
            }
            CssError.setCurrentScene(scene);
            this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(fname, ua_stylesheet));
            if (ua_stylesheet != null) {
                ua_stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            }
            this.userAgentStylesheetsChanged();
            CssError.setCurrentScene(null);
        }
    }

    public void setDefaultUserAgentStylesheet(String fname) {
        this.setDefaultUserAgentStylesheet(null, fname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultUserAgentStylesheet(Scene scene, String url) {
        String fname;
        String string = fname = url != null ? url.trim() : null;
        if (fname == null || fname.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            CssError.setCurrentScene(scene);
            if (this._setDefaultUserAgentStylesheet(fname)) {
                this.userAgentStylesheetsChanged();
            }
            CssError.setCurrentScene(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _setDefaultUserAgentStylesheet(String fname) {
        Object object = styleLock;
        synchronized (object) {
            int nMax = this.platformUserAgentStylesheetContainers.size();
            for (int n = 0; n < nMax; ++n) {
                StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                if (!fname.equals(container.fname)) continue;
                if (n > 0) {
                    this.platformUserAgentStylesheetContainers.remove(n);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, container);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, container);
                    }
                }
                return n > 0;
            }
            Stylesheet ua_stylesheet = StyleManager.loadStylesheet(fname);
            if (ua_stylesheet == null) {
                return false;
            }
            ua_stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            StylesheetContainer sc = new StylesheetContainer(fname, ua_stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(sc);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, sc);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, sc);
            }
            this.hasDefaultUserAgentStylesheet = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserAgentStylesheet(String url) {
        String fname;
        String string = fname = url != null ? url.trim() : null;
        if (fname == null || fname.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            boolean removed = false;
            for (int n = this.platformUserAgentStylesheetContainers.size() - 1; n >= 0; --n) {
                if (fname.equals(Application.getUserAgentStylesheet())) continue;
                StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                if (!fname.equals(container.fname)) continue;
                this.platformUserAgentStylesheetContainers.remove(n);
                removed = true;
            }
            if (removed) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultUserAgentStylesheet(Stylesheet ua_stylesheet) {
        if (ua_stylesheet == null) {
            return;
        }
        String url = ua_stylesheet.getUrl();
        String fname = url != null ? url.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int nMax = this.platformUserAgentStylesheetContainers.size();
            for (int n = 0; n < nMax; ++n) {
                StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                if (!fname.equals(container.fname)) continue;
                if (n > 0) {
                    this.platformUserAgentStylesheetContainers.remove(n);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, container);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, container);
                    }
                }
                return;
            }
            StylesheetContainer sc = new StylesheetContainer(fname, ua_stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(sc);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, sc);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, sc);
            }
            this.hasDefaultUserAgentStylesheet = true;
            ua_stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.userAgentStylesheetsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userAgentStylesheetsChanged() {
        ArrayList<Parent> parents = new ArrayList<Parent>();
        Iterator iterator = styleLock;
        synchronized (iterator) {
            for (CacheContainer container : cacheContainerMap.values()) {
                container.clearCache();
            }
            StyleConverterImpl.clearCache();
            for (Parent root : cacheContainerMap.keySet()) {
                if (root == null) continue;
                parents.add(root);
            }
        }
        for (Parent root : parents) {
            root.impl_reapplyCSS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> processStylesheets(List<String> stylesheets, Parent parent) {
        Object object = styleLock;
        synchronized (object) {
            ArrayList<StylesheetContainer> list = new ArrayList<StylesheetContainer>();
            int nMax = stylesheets.size();
            for (int n = 0; n < nMax; ++n) {
                String fname = stylesheets.get(n);
                StylesheetContainer container = null;
                if (this.stylesheetContainerMap.containsKey(fname)) {
                    container = this.stylesheetContainerMap.get(fname);
                    if (!list.contains(container)) {
                        if (container.checksumInvalid) {
                            byte[] checksum = StyleManager.calculateCheckSum(fname);
                            if (!Arrays.equals(checksum, container.checksum)) {
                                this.removeStylesheetContainer(container);
                                Stylesheet stylesheet = StyleManager.loadStylesheet(fname);
                                container = new StylesheetContainer(fname, stylesheet, checksum);
                                this.stylesheetContainerMap.put(fname, container);
                            } else {
                                container.checksumInvalid = false;
                            }
                        }
                        list.add(container);
                    }
                    container.parentUsers.add(parent);
                    continue;
                }
                Stylesheet stylesheet = StyleManager.loadStylesheet(fname);
                container = new StylesheetContainer(fname, stylesheet);
                container.parentUsers.add(parent);
                this.stylesheetContainerMap.put(fname, container);
                list.add(container);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> gatherParentStylesheets(Parent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        List<String> parentStylesheets = parent.impl_getAllParentStylesheets();
        if (parentStylesheets == null || parentStylesheets.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            CssError.setCurrentScene(parent.getScene());
            List<StylesheetContainer> list = this.processStylesheets(parentStylesheets, parent);
            CssError.setCurrentScene(null);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> gatherSceneStylesheets(Scene scene) {
        if (scene == null) {
            return Collections.emptyList();
        }
        ObservableList<String> sceneStylesheets = scene.getStylesheets();
        if (sceneStylesheets == null || sceneStylesheets.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            CssError.setCurrentScene(scene);
            List<StylesheetContainer> list = this.processStylesheets(sceneStylesheets, scene.getRoot());
            CssError.setCurrentScene(null);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap findMatchingStyles(Node node, SubScene subScene, Set<PseudoClass>[] triggerStates) {
        Scene scene = node.getScene();
        if (scene == null) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(node, subScene);
        if (cacheContainer == null) {
            assert (false) : node.toString();
            return StyleMap.EMPTY_MAP;
        }
        Object object = styleLock;
        synchronized (object) {
            boolean hasRegionUserAgentStylesheet;
            Node region;
            Parent parent = node instanceof Parent ? (Parent)node : node.getParent();
            List<StylesheetContainer> parentStylesheets = this.gatherParentStylesheets(parent);
            boolean hasParentStylesheets = !parentStylesheets.isEmpty();
            List<StylesheetContainer> sceneStylesheets = this.gatherSceneStylesheets(scene);
            boolean hasSceneStylesheets = !sceneStylesheets.isEmpty();
            String inlineStyle = node.getStyle();
            boolean hasInlineStyles = inlineStyle != null && !inlineStyle.trim().isEmpty();
            String sceneUserAgentStylesheet = scene.getUserAgentStylesheet();
            boolean hasSceneUserAgentStylesheet = sceneUserAgentStylesheet != null && !sceneUserAgentStylesheet.trim().isEmpty();
            String subSceneUserAgentStylesheet = subScene != null ? subScene.getUserAgentStylesheet() : null;
            boolean hasSubSceneUserAgentStylesheet = subSceneUserAgentStylesheet != null && !subSceneUserAgentStylesheet.trim().isEmpty();
            String regionUserAgentStylesheet = null;
            for (region = node; region != null; region = region.getParent()) {
                String string = regionUserAgentStylesheet = region instanceof Region ? ((Region)region).getUserAgentStylesheet() : null;
                if (regionUserAgentStylesheet != null) break;
            }
            boolean bl = hasRegionUserAgentStylesheet = regionUserAgentStylesheet != null && !regionUserAgentStylesheet.trim().isEmpty();
            if (!(hasInlineStyles || hasParentStylesheets || hasSceneStylesheets || hasSceneUserAgentStylesheet || hasSubSceneUserAgentStylesheet || hasRegionUserAgentStylesheet || !this.platformUserAgentStylesheetContainers.isEmpty())) {
                return StyleMap.EMPTY_MAP;
            }
            String cname = node.getTypeSelector();
            String id = node.getId();
            ObservableList<String> styleClasses = node.getStyleClass();
            if (this.key == null) {
                this.key = new Key();
            }
            this.key.className = cname;
            this.key.id = id;
            int nMax = styleClasses.size();
            for (int n = 0; n < nMax; ++n) {
                String styleClass = (String)styleClasses.get(n);
                if (styleClass == null || styleClass.isEmpty()) continue;
                this.key.styleClasses.add(StyleClassSet.getStyleClass(styleClass));
            }
            Map cacheMap = cacheContainer.getCacheMap(parentStylesheets, regionUserAgentStylesheet);
            Cache cache = (Cache)cacheMap.get(this.key);
            if (cache != null) {
                this.key.styleClasses.clear();
            } else {
                ArrayList<Selector> selectorData = new ArrayList<Selector>();
                if (hasSubSceneUserAgentStylesheet || hasSceneUserAgentStylesheet) {
                    String uaFileName = hasSubSceneUserAgentStylesheet ? subScene.getUserAgentStylesheet().trim() : scene.getUserAgentStylesheet().trim();
                    StylesheetContainer container = null;
                    int nMax2 = this.userAgentStylesheetContainers.size();
                    for (int n = 0; n < nMax2; ++n) {
                        container = this.userAgentStylesheetContainers.get(n);
                        if (uaFileName.equals(container.fname)) break;
                        container = null;
                    }
                    if (container == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet(uaFileName);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        container = new StylesheetContainer(uaFileName, stylesheet);
                        this.userAgentStylesheetContainers.add(container);
                    }
                    if (container.selectorPartitioning != null) {
                        Parent root = hasSubSceneUserAgentStylesheet ? subScene.getRoot() : scene.getRoot();
                        container.parentUsers.add(root);
                        List<Selector> matchingRules = container.selectorPartitioning.match(id, cname, this.key.styleClasses);
                        selectorData.addAll(matchingRules);
                    }
                } else if (!this.platformUserAgentStylesheetContainers.isEmpty()) {
                    int nMax3 = this.platformUserAgentStylesheetContainers.size();
                    for (int n = 0; n < nMax3; ++n) {
                        StylesheetContainer container = this.platformUserAgentStylesheetContainers.get(n);
                        if (container == null || container.selectorPartitioning == null) continue;
                        List<Selector> matchingRules = container.selectorPartitioning.match(id, cname, this.key.styleClasses);
                        selectorData.addAll(matchingRules);
                    }
                }
                if (hasRegionUserAgentStylesheet) {
                    StylesheetContainer container = null;
                    int nMax4 = this.userAgentStylesheetContainers.size();
                    for (int n = 0; n < nMax4; ++n) {
                        container = this.userAgentStylesheetContainers.get(n);
                        if (regionUserAgentStylesheet.equals(container.fname)) break;
                        container = null;
                    }
                    if (container == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet(regionUserAgentStylesheet);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        container = new StylesheetContainer(regionUserAgentStylesheet, stylesheet);
                        this.userAgentStylesheetContainers.add(container);
                    }
                    if (container.selectorPartitioning != null) {
                        container.parentUsers.add((Parent)region);
                        List<Selector> matchingRules = container.selectorPartitioning.match(id, cname, this.key.styleClasses);
                        selectorData.addAll(matchingRules);
                    }
                }
                if (!sceneStylesheets.isEmpty()) {
                    int nMax5 = sceneStylesheets.size();
                    for (int n = 0; n < nMax5; ++n) {
                        StylesheetContainer container = sceneStylesheets.get(n);
                        if (container == null || container.selectorPartitioning == null) continue;
                        List<Selector> matchingRules = container.selectorPartitioning.match(id, cname, this.key.styleClasses);
                        selectorData.addAll(matchingRules);
                    }
                }
                if (hasParentStylesheets) {
                    int nMax6 = parentStylesheets == null ? 0 : parentStylesheets.size();
                    for (int n = 0; n < nMax6; ++n) {
                        StylesheetContainer container = parentStylesheets.get(n);
                        if (container.selectorPartitioning == null) continue;
                        List<Selector> matchingRules = container.selectorPartitioning.match(id, cname, this.key.styleClasses);
                        selectorData.addAll(matchingRules);
                    }
                }
                cache = new Cache(selectorData);
                cacheMap.put(this.key, cache);
                this.key = null;
            }
            StyleMap smap = cache.getStyleMap(cacheContainer, node, triggerStates, hasInlineStyles);
            return smap;
        }
    }

    public static ObservableList<CssError> errorsProperty() {
        if (errors == null) {
            errors = FXCollections.observableArrayList();
        }
        return errors;
    }

    public static ObservableList<CssError> getErrors() {
        return errors;
    }

    private static /* synthetic */ Boolean lambda$loadStylesheetUnPrivileged$174(String fname) {
        String bss = System.getProperty("binary.css");
        return !fname.endsWith(".bss") && bss != null ? !Boolean.valueOf(bss).booleanValue() : Boolean.FALSE;
    }

    private static /* synthetic */ JarFile lambda$loadStylesheet$172(String styleManagerJarPath) throws Exception {
        return new JarFile(styleManagerJarPath);
    }

    private static /* synthetic */ URI lambda$loadStylesheet$171() throws Exception {
        return StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI();
    }

    static {
        cacheContainerMap = new WeakHashMap<Parent, CacheContainer>();
        errors = null;
    }

    static /* synthetic */ URI access$lambda$0() {
        return StyleManager.lambda$loadStylesheet$171();
    }

    static /* synthetic */ JarFile access$lambda$1(String string) {
        return StyleManager.lambda$loadStylesheet$172(string);
    }

    static /* synthetic */ Stylesheet access$lambda$2(String string) {
        return StyleManager.loadStylesheetUnPrivileged(string);
    }

    static /* synthetic */ Boolean access$lambda$3(String string) {
        return StyleManager.lambda$loadStylesheetUnPrivileged$174(string);
    }

    private static class Key {
        String className;
        String id;
        final StyleClassSet styleClasses = new StyleClassSet();

        private Key() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Key) {
                Key other = (Key)o;
                if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                    return false;
                }
                if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                    return false;
                }
                return this.styleClasses.equals(other.styleClasses);
            }
            return true;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.className != null ? this.className.hashCode() : 0);
            hash = 29 * hash + (this.id != null ? this.id.hashCode() : 0);
            hash = 29 * hash + this.styleClasses.hashCode();
            return hash;
        }
    }

    private static class Cache {
        private final List<Selector> selectors;
        private final Map<Key, Integer> cache;

        Cache(List<Selector> selectors) {
            this.selectors = selectors;
            this.cache = new HashMap<Key, Integer>();
        }

        private StyleMap getStyleMap(CacheContainer cacheContainer, Node node, Set<PseudoClass>[] triggerStates, boolean hasInlineStyle) {
            Selector selector;
            if ((this.selectors == null || this.selectors.isEmpty()) && !hasInlineStyle) {
                return StyleMap.EMPTY_MAP;
            }
            int selectorDataSize = this.selectors.size();
            long[] key = new long[selectorDataSize / 64 + 1];
            boolean nothingMatched = true;
            for (int s = 0; s < selectorDataSize; ++s) {
                long mask;
                Selector sel = this.selectors.get(s);
                if (!sel.applies(node, triggerStates, 0)) continue;
                int index = s / 64;
                key[index] = mask = key[index] | 1L << s;
                nothingMatched = false;
            }
            if (nothingMatched && !hasInlineStyle) {
                return StyleMap.EMPTY_MAP;
            }
            String inlineStyle = node.getStyle();
            Key keyObj = new Key(key, inlineStyle);
            if (this.cache.containsKey(keyObj)) {
                Integer styleMapId = this.cache.get(keyObj);
                StyleMap styleMap = styleMapId != null ? cacheContainer.getStyleMap(styleMapId) : StyleMap.EMPTY_MAP;
                return styleMap;
            }
            ArrayList<Selector> selectors = new ArrayList<Selector>();
            if (hasInlineStyle && (selector = cacheContainer.getInlineStyleSelector(inlineStyle)) != null) {
                selectors.add(selector);
            }
            for (int k = 0; k < key.length; ++k) {
                if (key[k] == 0L) continue;
                int offset = k * 64;
                for (int b = 0; b < 64; ++b) {
                    long mask = 1L << b;
                    if ((mask & key[k]) != mask) continue;
                    Selector pair = this.selectors.get(offset + b);
                    selectors.add(pair);
                }
            }
            int id = cacheContainer.nextSmapId();
            this.cache.put(keyObj, id);
            StyleMap styleMap = new StyleMap(id, selectors);
            cacheContainer.addStyleMap(styleMap);
            return styleMap;
        }

        private static class Key {
            final long[] key;
            final String inlineStyle;

            Key(long[] key, String inlineStyle) {
                this.key = key;
                this.inlineStyle = inlineStyle != null && inlineStyle.trim().isEmpty() ? null : inlineStyle;
            }

            public String toString() {
                return Arrays.toString(this.key) + (this.inlineStyle != null ? "* {" + this.inlineStyle + "}" : "");
            }

            public int hashCode() {
                int hash = 3;
                hash = 17 * hash + Arrays.hashCode(this.key);
                if (this.inlineStyle != null) {
                    hash = 17 * hash + this.inlineStyle.hashCode();
                }
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (this.inlineStyle == null ? other.inlineStyle != null : !this.inlineStyle.equals(other.inlineStyle)) {
                    return false;
                }
                return Arrays.equals(this.key, other.key);
            }
        }
    }

    static class CacheContainer {
        private Map<StyleCache.Key, StyleCache> styleCache;
        private Map<List<String>, Map<Key, Cache>> cacheMap;
        private List<StyleMap> styleMapList;
        private Map<String, Selector> inlineStylesCache;
        private int styleMapId = 0;
        private int baseStyleMapId = 0;

        CacheContainer() {
        }

        private Map<StyleCache.Key, StyleCache> getStyleCache() {
            if (this.styleCache == null) {
                this.styleCache = new HashMap<StyleCache.Key, StyleCache>();
            }
            return this.styleCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Key, Cache> getCacheMap(List<StylesheetContainer> parentStylesheets, String regionUserAgentStylesheet) {
            if (this.cacheMap == null) {
                this.cacheMap = new HashMap<List<String>, Map<Key, Cache>>();
            }
            Object object = styleLock;
            synchronized (object) {
                Map<Key, Cache> cmap;
                if ((parentStylesheets == null || parentStylesheets.isEmpty()) && (regionUserAgentStylesheet == null || regionUserAgentStylesheet.isEmpty())) {
                    Map<Key, Cache> cmap2 = this.cacheMap.get(null);
                    if (cmap2 == null) {
                        cmap2 = new HashMap<Key, Cache>();
                        this.cacheMap.put(null, cmap2);
                    }
                    return cmap2;
                }
                int nMax = parentStylesheets.size();
                if (cacheMapKey == null) {
                    cacheMapKey = new ArrayList(nMax);
                }
                for (int n = 0; n < nMax; ++n) {
                    StylesheetContainer sc = parentStylesheets.get(n);
                    if (sc == null || sc.fname == null || sc.fname.isEmpty()) continue;
                    cacheMapKey.add(sc.fname);
                }
                if (regionUserAgentStylesheet != null) {
                    cacheMapKey.add(regionUserAgentStylesheet);
                }
                if ((cmap = this.cacheMap.get(cacheMapKey)) == null) {
                    cmap = new HashMap<Key, Cache>();
                    this.cacheMap.put(cacheMapKey, cmap);
                    cacheMapKey = null;
                } else {
                    cacheMapKey.clear();
                }
                return cmap;
            }
        }

        private List<StyleMap> getStyleMapList() {
            if (this.styleMapList == null) {
                this.styleMapList = new ArrayList<StyleMap>();
            }
            return this.styleMapList;
        }

        private int nextSmapId() {
            this.styleMapId = this.baseStyleMapId + this.getStyleMapList().size();
            return this.styleMapId;
        }

        private void addStyleMap(StyleMap smap) {
            this.getStyleMapList().add(smap);
        }

        public StyleMap getStyleMap(int smapId) {
            int correctedId = smapId - this.baseStyleMapId;
            if (0 <= correctedId && correctedId < this.getStyleMapList().size()) {
                return this.getStyleMapList().get(correctedId);
            }
            return StyleMap.EMPTY_MAP;
        }

        private void clearCache() {
            if (this.cacheMap != null) {
                this.cacheMap.clear();
            }
            if (this.styleCache != null) {
                this.styleCache.clear();
            }
            if (this.styleMapList != null) {
                this.styleMapList.clear();
            }
            this.baseStyleMapId = this.styleMapId;
            if (this.baseStyleMapId > 0x6FFFFFF9) {
                this.styleMapId = 0;
                this.baseStyleMapId = 0;
            }
        }

        private Selector getInlineStyleSelector(String inlineStyle) {
            Stylesheet inlineStylesheet;
            if (inlineStyle == null || inlineStyle.trim().isEmpty()) {
                return null;
            }
            if (this.inlineStylesCache != null && this.inlineStylesCache.containsKey(inlineStyle)) {
                return this.inlineStylesCache.get(inlineStyle);
            }
            if (this.inlineStylesCache == null) {
                this.inlineStylesCache = new HashMap<String, Selector>();
            }
            if ((inlineStylesheet = new CSSParser().parse("*{" + inlineStyle + "}")) != null) {
                Selector selector;
                inlineStylesheet.setOrigin(StyleOrigin.INLINE);
                List<Rule> rules = inlineStylesheet.getRules();
                Rule rule = rules != null && !rules.isEmpty() ? rules.get(0) : null;
                List<Selector> selectors = rule != null ? rule.getUnobservedSelectorList() : null;
                Selector selector2 = selector = selectors != null && !selectors.isEmpty() ? selectors.get(0) : null;
                if (selector != null) {
                    selector.setOrdinal(-1);
                    this.inlineStylesCache.put(inlineStyle, selector);
                    return selector;
                }
            }
            this.inlineStylesCache.put(inlineStyle, null);
            return null;
        }
    }

    static class RefList<K> {
        final List<Reference<K>> list = new ArrayList<Reference<K>>();

        RefList() {
        }

        void add(K key) {
            for (int n = this.list.size() - 1; 0 <= n; --n) {
                Reference<K> ref = this.list.get(n);
                K k = ref.get();
                if (k == null) {
                    this.list.remove(n);
                    continue;
                }
                if (k != key) continue;
                return;
            }
            this.list.add(new WeakReference<K>(key));
        }

        void remove(K key) {
            for (int n = this.list.size() - 1; 0 <= n; --n) {
                Reference<K> ref = this.list.get(n);
                K k = ref.get();
                if (k == null) {
                    this.list.remove(n);
                    continue;
                }
                if (k != key) continue;
                this.list.remove(n);
                return;
            }
        }

        boolean contains(K key) {
            for (int n = this.list.size() - 1; 0 <= n; --n) {
                Reference<K> ref = this.list.get(n);
                K k = ref.get();
                if (k != key) continue;
                return true;
            }
            return false;
        }
    }

    static class StylesheetContainer {
        final String fname;
        final Stylesheet stylesheet;
        final SelectorPartitioning selectorPartitioning;
        final RefList<Parent> parentUsers;
        final List<Image> imageCache;
        final int hash;
        final byte[] checksum;
        boolean checksumInvalid = false;

        StylesheetContainer(String fname, Stylesheet stylesheet) {
            this(fname, stylesheet, stylesheet != null ? StyleManager.calculateCheckSum(stylesheet.getUrl()) : new byte[]{});
        }

        StylesheetContainer(String fname, Stylesheet stylesheet, byte[] checksum) {
            this.fname = fname;
            this.hash = fname != null ? fname.hashCode() : 127;
            this.stylesheet = stylesheet;
            if (stylesheet != null) {
                this.selectorPartitioning = new SelectorPartitioning();
                List<Rule> rules = stylesheet.getRules();
                int rMax = rules == null || rules.isEmpty() ? 0 : rules.size();
                for (int r = 0; r < rMax; ++r) {
                    Rule rule = rules.get(r);
                    List<Selector> selectors = rule.getUnobservedSelectorList();
                    int sMax = selectors == null || selectors.isEmpty() ? 0 : selectors.size();
                    for (int s = 0; s < sMax; ++s) {
                        Selector selector = selectors.get(s);
                        this.selectorPartitioning.partition(selector);
                    }
                }
            } else {
                this.selectorPartitioning = null;
            }
            this.parentUsers = new RefList();
            this.imageCache = new ArrayList<Image>();
            this.checksum = checksum;
        }

        void invalidateChecksum() {
            this.checksumInvalid = this.checksum.length > 0;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StylesheetContainer other = (StylesheetContainer)obj;
            return !(this.fname == null ? other.fname != null : !this.fname.equals(other.fname));
        }

        public String toString() {
            return this.fname;
        }
    }

    private static class InstanceHolder {
        static final StyleManager INSTANCE = new StyleManager();

        private InstanceHolder() {
        }
    }
}

