/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFileReader;
import com.sun.javafx.font.FontFileWriter;
import com.sun.javafx.font.WoffDecoder$$Lambda$1;
import java.util.Arrays;
import java.util.zip.Inflater;

class WoffDecoder
extends FontFileWriter {
    WoffHeader woffHeader;
    WoffDirectoryEntry[] woffTableDirectory;

    public void decode(FontFileReader input) throws Exception {
        input.reset();
        this.initWoffTables(input);
        if (this.woffHeader == null || this.woffTableDirectory == null) {
            throw new Exception("WoffDecoder: failure reading header");
        }
        int format = this.woffHeader.flavor;
        if (format != 65536 && format != 1953658213 && format != 0x4F54544F) {
            throw new Exception("WoffDecoder: invalid flavor");
        }
        short numTables = this.woffHeader.numTables;
        this.setLength(this.woffHeader.totalSfntSize);
        this.writeHeader(format, numTables);
        Arrays.sort(this.woffTableDirectory, WoffDecoder$$Lambda$1.lambdaFactory$());
        Inflater decompressor = new Inflater();
        int offset = 12 + numTables * 16;
        for (int i = 0; i < this.woffTableDirectory.length; ++i) {
            WoffDirectoryEntry table = this.woffTableDirectory[i];
            this.writeDirectoryEntry(table.index, table.tag, table.origChecksum, offset, table.origLength);
            FontFileReader.Buffer buffer = input.readBlock(table.offset, table.comLength);
            byte[] bytes = new byte[table.comLength];
            buffer.get(0, bytes, 0, table.comLength);
            if (table.comLength != table.origLength) {
                decompressor.setInput(bytes);
                byte[] output = new byte[table.origLength];
                int length = decompressor.inflate(output);
                if (length != table.origLength) {
                    throw new Exception("WoffDecoder: failure expanding table");
                }
                decompressor.reset();
                bytes = output;
            }
            this.seek(offset);
            this.writeBytes(bytes);
            offset += table.origLength + 3 & 0xFFFFFFFC;
        }
        decompressor.end();
    }

    void initWoffTables(FontFileReader input) throws Exception {
        long filesize = input.getLength();
        if (filesize < 44L) {
            throw new Exception("WoffDecoder: invalid filesize");
        }
        FontFileReader.Buffer buffer = input.readBlock(0, 44);
        WoffHeader header = new WoffHeader(buffer);
        int numTables = header.numTables;
        if (header.signature != 2001684038) {
            throw new Exception("WoffDecoder: invalid signature");
        }
        if (header.reserved != 0) {
            throw new Exception("WoffDecoder: invalid reserved != 0");
        }
        if (filesize < (long)(44 + numTables * 20)) {
            throw new Exception("WoffDecoder: invalid filesize");
        }
        WoffDirectoryEntry[] tableDirectory = new WoffDirectoryEntry[numTables];
        int headerOffset = 44 + numTables * 20;
        int size = 12 + numTables * 16;
        buffer = input.readBlock(44, numTables * 20);
        int prevTag = 0;
        for (int i = 0; i < numTables; ++i) {
            WoffDirectoryEntry table;
            tableDirectory[i] = table = new WoffDirectoryEntry(buffer, i);
            if (table.tag <= prevTag) {
                throw new Exception("WoffDecoder: table directory not ordered by tag");
            }
            int startOffset = table.offset;
            int endOffset = table.offset + table.comLength;
            if (headerOffset > startOffset || (long)startOffset > filesize) {
                throw new Exception("WoffDecoder: invalid table offset");
            }
            if (startOffset > endOffset || (long)endOffset > filesize) {
                throw new Exception("WoffDecoder: invalid table offset");
            }
            if (table.comLength > table.origLength) {
                throw new Exception("WoffDecoder: invalid compressed length");
            }
            if ((size += table.origLength + 3 & 0xFFFFFFFC) <= header.totalSfntSize) continue;
            throw new Exception("WoffDecoder: invalid totalSfntSize");
        }
        if (size != header.totalSfntSize) {
            throw new Exception("WoffDecoder: invalid totalSfntSize");
        }
        this.woffHeader = header;
        this.woffTableDirectory = tableDirectory;
    }

    private static /* synthetic */ int lambda$decode$243(WoffDirectoryEntry o1, WoffDirectoryEntry o2) {
        return o1.offset - o2.offset;
    }

    static /* synthetic */ int access$lambda$0(WoffDirectoryEntry woffDirectoryEntry, WoffDirectoryEntry woffDirectoryEntry2) {
        return WoffDecoder.lambda$decode$243(woffDirectoryEntry, woffDirectoryEntry2);
    }

    static class WoffDirectoryEntry {
        int tag;
        int offset;
        int comLength;
        int origLength;
        int origChecksum;
        int index;

        WoffDirectoryEntry(FontFileReader.Buffer buffer, int index) {
            this.tag = buffer.getInt();
            this.offset = buffer.getInt();
            this.comLength = buffer.getInt();
            this.origLength = buffer.getInt();
            this.origChecksum = buffer.getInt();
            this.index = index;
        }
    }

    static class WoffHeader {
        int signature;
        int flavor;
        int length;
        short numTables;
        short reserved;
        int totalSfntSize;
        short majorVersion;
        short minorVersion;
        int metaOffset;
        int metaLength;
        int metaOrigLength;
        int privateOffset;
        int privateLength;

        WoffHeader(FontFileReader.Buffer buffer) {
            this.signature = buffer.getInt();
            this.flavor = buffer.getInt();
            this.length = buffer.getInt();
            this.numTables = buffer.getShort();
            this.reserved = buffer.getShort();
            this.totalSfntSize = buffer.getInt();
            this.majorVersion = buffer.getShort();
            this.minorVersion = buffer.getShort();
            this.metaOffset = buffer.getInt();
            this.metaLength = buffer.getInt();
            this.metaOrigLength = buffer.getInt();
            this.privateOffset = buffer.getInt();
            this.privateLength = buffer.getInt();
        }
    }
}

