/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.BinaryExpression;
import com.sun.javafx.fxml.expression.Expression$$Lambda$1;
import com.sun.javafx.fxml.expression.Expression$$Lambda$10;
import com.sun.javafx.fxml.expression.Expression$$Lambda$11;
import com.sun.javafx.fxml.expression.Expression$$Lambda$12;
import com.sun.javafx.fxml.expression.Expression$$Lambda$13;
import com.sun.javafx.fxml.expression.Expression$$Lambda$14;
import com.sun.javafx.fxml.expression.Expression$$Lambda$15;
import com.sun.javafx.fxml.expression.Expression$$Lambda$16;
import com.sun.javafx.fxml.expression.Expression$$Lambda$17;
import com.sun.javafx.fxml.expression.Expression$$Lambda$4;
import com.sun.javafx.fxml.expression.Expression$$Lambda$5;
import com.sun.javafx.fxml.expression.Expression$$Lambda$6;
import com.sun.javafx.fxml.expression.Expression$$Lambda$7;
import com.sun.javafx.fxml.expression.Expression$$Lambda$8;
import com.sun.javafx.fxml.expression.Expression$$Lambda$9;
import com.sun.javafx.fxml.expression.KeyPath;
import com.sun.javafx.fxml.expression.LiteralExpression;
import com.sun.javafx.fxml.expression.Operator;
import com.sun.javafx.fxml.expression.UnaryExpression;
import com.sun.javafx.fxml.expression.VariableExpression;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Expression<T> {
    private static final String NULL_KEYWORD = "null";
    private static final String TRUE_KEYWORD = "true";
    private static final String FALSE_KEYWORD = "false";

    public abstract T evaluate(Object var1);

    public abstract void update(Object var1, T var2);

    public abstract boolean isDefined(Object var1);

    public abstract boolean isLValue();

    public List<KeyPath> getArguments() {
        ArrayList<KeyPath> arguments = new ArrayList<KeyPath>();
        this.getArguments(arguments);
        return arguments;
    }

    protected abstract void getArguments(List<KeyPath> var1);

    public static <T> T get(Object namespace, KeyPath keyPath) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        return Expression.get(namespace, keyPath.iterator());
    }

    private static <T> T get(Object namespace, Iterator<String> keyPathIterator) {
        if (keyPathIterator == null) {
            throw new NullPointerException();
        }
        Object value = keyPathIterator.hasNext() ? Expression.get(Expression.get(namespace, keyPathIterator.next()), keyPathIterator) : namespace;
        return (T)value;
    }

    public static <T> T get(Object namespace, String key) {
        T value;
        if (key == null) {
            throw new NullPointerException();
        }
        if (namespace instanceof List) {
            List list = (List)namespace;
            value = (T)list.get(Integer.parseInt(key));
        } else if (namespace != null) {
            Map map = namespace instanceof Map ? (Map)namespace : new BeanAdapter(namespace);
            value = (T)map.get(key);
        } else {
            value = null;
        }
        return value;
    }

    public static void set(Object namespace, KeyPath keyPath, Object value) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        Expression.set(namespace, keyPath.iterator(), value);
    }

    private static void set(Object namespace, Iterator<String> keyPathIterator, Object value) {
        if (keyPathIterator == null) {
            throw new NullPointerException();
        }
        if (!keyPathIterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        String key = keyPathIterator.next();
        if (keyPathIterator.hasNext()) {
            Expression.set(Expression.get(namespace, key), keyPathIterator, value);
        } else {
            Expression.set(namespace, key, value);
        }
    }

    public static void set(Object namespace, String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (namespace instanceof List) {
            List list = (List)namespace;
            list.set(Integer.parseInt(key), value);
        } else if (namespace != null) {
            Map map = namespace instanceof Map ? (Map)namespace : new BeanAdapter(namespace);
            map.put(key, value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isDefined(Object namespace, KeyPath keyPath) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        return Expression.isDefined(namespace, keyPath.iterator());
    }

    private static boolean isDefined(Object namespace, Iterator<String> keyPathIterator) {
        if (keyPathIterator == null) {
            throw new NullPointerException();
        }
        if (!keyPathIterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        String key = keyPathIterator.next();
        boolean defined = keyPathIterator.hasNext() ? Expression.isDefined(Expression.get(namespace, key), keyPathIterator) : Expression.isDefined(namespace, key);
        return defined;
    }

    public static boolean isDefined(Object namespace, String key) {
        boolean defined;
        if (key == null) {
            throw new NullPointerException();
        }
        if (namespace instanceof List) {
            List list = (List)namespace;
            defined = Integer.parseInt(key) < list.size();
        } else if (namespace != null) {
            Map map = namespace instanceof Map ? (Map)namespace : new BeanAdapter(namespace);
            defined = map.containsKey(key);
        } else {
            defined = false;
        }
        return defined;
    }

    public static BinaryExpression add(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$1.lambdaFactory$());
    }

    public static BinaryExpression add(Expression left, Object right) {
        return Expression.add(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression add(Object left, Expression right) {
        return Expression.add(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression add(Object left, Object right) {
        return Expression.add(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression subtract(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$4.lambdaFactory$());
    }

    public static BinaryExpression subtract(Expression left, Number right) {
        return Expression.subtract(left, new LiteralExpression<Number>(right));
    }

    public static BinaryExpression subtract(Number left, Expression right) {
        return Expression.subtract(new LiteralExpression<Number>(left), right);
    }

    public static BinaryExpression subtract(Number left, Number right) {
        return Expression.subtract(new LiteralExpression<Number>(left), new LiteralExpression<Number>(right));
    }

    public static BinaryExpression multiply(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$5.lambdaFactory$());
    }

    public static BinaryExpression multiply(Expression left, Number right) {
        return Expression.multiply(left, new LiteralExpression<Number>(right));
    }

    public static BinaryExpression multiply(Number left, Expression right) {
        return Expression.multiply(new LiteralExpression<Number>(left), right);
    }

    public static BinaryExpression multiply(Number left, Number right) {
        return Expression.multiply(new LiteralExpression<Number>(left), new LiteralExpression<Number>(right));
    }

    public static BinaryExpression divide(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$6.lambdaFactory$());
    }

    public static BinaryExpression divide(Expression left, Number right) {
        return Expression.divide(left, new LiteralExpression<Number>(right));
    }

    public static BinaryExpression divide(Number left, Expression<Number> right) {
        return Expression.divide(new LiteralExpression<Number>(left), right);
    }

    public static BinaryExpression divide(Number left, Number right) {
        return Expression.divide(new LiteralExpression<Number>(left), new LiteralExpression<Number>(right));
    }

    public static BinaryExpression modulo(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$7.lambdaFactory$());
    }

    public static BinaryExpression modulo(Expression<Number> left, Number right) {
        return Expression.modulo(left, new LiteralExpression<Number>(right));
    }

    public static BinaryExpression modulo(Number left, Expression<Number> right) {
        return Expression.modulo(new LiteralExpression<Number>(left), right);
    }

    public static BinaryExpression modulo(Number left, Number right) {
        return Expression.modulo(new LiteralExpression<Number>(left), new LiteralExpression<Number>(right));
    }

    public static BinaryExpression equalTo(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$8.lambdaFactory$());
    }

    public static BinaryExpression equalTo(Expression left, Object right) {
        return Expression.equalTo(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression equalTo(Object left, Expression right) {
        return Expression.equalTo(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression equalTo(Object left, Object right) {
        return Expression.equalTo(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression notEqualTo(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$9.lambdaFactory$());
    }

    public static BinaryExpression notEqualTo(Expression left, Object right) {
        return Expression.notEqualTo(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression notEqualTo(Object left, Expression right) {
        return Expression.notEqualTo(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression notEqualTo(Object left, Object right) {
        return Expression.notEqualTo(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression greaterThan(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$10.lambdaFactory$());
    }

    public static BinaryExpression greaterThan(Expression left, Object right) {
        return Expression.greaterThan(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression greaterThan(Object left, Expression right) {
        return Expression.greaterThan(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression greaterThan(Object left, Object right) {
        return Expression.greaterThan(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression greaterThanOrEqualTo(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$11.lambdaFactory$());
    }

    public static BinaryExpression greaterThanOrEqualTo(Expression left, Object right) {
        return Expression.greaterThanOrEqualTo(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression greaterThanOrEqualTo(Object left, Expression right) {
        return Expression.greaterThanOrEqualTo(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression greaterThanOrEqualTo(Object left, Object right) {
        return Expression.greaterThanOrEqualTo(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression lessThan(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$12.lambdaFactory$());
    }

    public static BinaryExpression lessThan(Expression left, Object right) {
        return Expression.lessThan(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression lessThan(Object left, Expression right) {
        return Expression.lessThan(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression lessThan(Object left, Object right) {
        return Expression.lessThan(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression lessThanOrEqualTo(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$13.lambdaFactory$());
    }

    public static BinaryExpression lessThanOrEqualTo(Expression left, Object right) {
        return Expression.lessThanOrEqualTo(left, new LiteralExpression<Object>(right));
    }

    public static BinaryExpression lessThanOrEqualTo(Object left, Expression right) {
        return Expression.lessThanOrEqualTo(new LiteralExpression<Object>(left), right);
    }

    public static BinaryExpression lessThanOrEqualTo(Object left, Object right) {
        return Expression.lessThanOrEqualTo(new LiteralExpression<Object>(left), new LiteralExpression<Object>(right));
    }

    public static BinaryExpression and(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$14.lambdaFactory$());
    }

    public static BinaryExpression and(Expression left, Boolean right) {
        return Expression.and(left, new LiteralExpression<Boolean>(right));
    }

    public static BinaryExpression and(Boolean left, Expression right) {
        return Expression.and(new LiteralExpression<Boolean>(left), right);
    }

    public static BinaryExpression and(Boolean left, Boolean right) {
        return Expression.and(new LiteralExpression<Boolean>(left), new LiteralExpression<Boolean>(right));
    }

    public static BinaryExpression or(Expression left, Expression right) {
        return new BinaryExpression(left, right, Expression$$Lambda$15.lambdaFactory$());
    }

    public static BinaryExpression or(Expression left, Boolean right) {
        return Expression.or(left, new LiteralExpression<Boolean>(right));
    }

    public static BinaryExpression or(Boolean left, Expression right) {
        return Expression.or(new LiteralExpression<Boolean>(left), right);
    }

    public static BinaryExpression or(Boolean left, Boolean right) {
        return Expression.or(new LiteralExpression<Boolean>(left), new LiteralExpression<Boolean>(right));
    }

    public static UnaryExpression negate(Expression operand) {
        return new UnaryExpression(operand, Expression$$Lambda$16.lambdaFactory$());
    }

    public static UnaryExpression negate(Number operand) {
        return Expression.negate(new LiteralExpression<Number>(operand));
    }

    public static UnaryExpression not(Expression operand) {
        return new UnaryExpression(operand, Expression$$Lambda$17.lambdaFactory$());
    }

    public static UnaryExpression not(Boolean operand) {
        return Expression.not(new LiteralExpression<Boolean>(operand));
    }

    public static Expression valueOf(String value) {
        Expression expression;
        if (value == null) {
            throw new NullPointerException();
        }
        Parser parser = new Parser();
        try {
            expression = parser.parse(new StringReader(value));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return expression;
    }

    private static /* synthetic */ Boolean lambda$not$14(Boolean value) {
        return value == false;
    }

    private static /* synthetic */ Number lambda$negate$13(Number value) {
        Class<?> type = value.getClass();
        if (type == Byte.class) {
            return (int)(-value.byteValue());
        }
        if (type == Short.class) {
            return (int)(-value.shortValue());
        }
        if (type == Integer.class) {
            return -value.intValue();
        }
        if (type == Long.class) {
            return -value.longValue();
        }
        if (type == Float.class) {
            return Float.valueOf(-value.floatValue());
        }
        if (type == Double.class) {
            return -value.doubleValue();
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ Boolean lambda$or$12(Boolean leftValue, Boolean rightValue) {
        return leftValue != false || rightValue != false;
    }

    private static /* synthetic */ Boolean lambda$and$11(Boolean leftValue, Boolean rightValue) {
        return leftValue != false && rightValue != false;
    }

    private static /* synthetic */ Boolean lambda$lessThanOrEqualTo$10(Comparable leftValue, Comparable rightValue) {
        return leftValue.compareTo(rightValue) <= 0;
    }

    private static /* synthetic */ Boolean lambda$lessThan$9(Comparable leftValue, Comparable rightValue) {
        return leftValue.compareTo(rightValue) < 0;
    }

    private static /* synthetic */ Boolean lambda$greaterThanOrEqualTo$8(Comparable leftValue, Comparable rightValue) {
        return leftValue.compareTo(rightValue) >= 0;
    }

    private static /* synthetic */ Boolean lambda$greaterThan$7(Comparable leftValue, Comparable rightValue) {
        return leftValue.compareTo(rightValue) > 0;
    }

    private static /* synthetic */ Boolean lambda$notEqualTo$6(Comparable leftValue, Comparable rightValue) {
        return leftValue.compareTo(rightValue) != 0;
    }

    private static /* synthetic */ Boolean lambda$equalTo$5(Comparable leftValue, Comparable rightValue) {
        return leftValue.compareTo(rightValue) == 0;
    }

    private static /* synthetic */ Number lambda$modulo$4(Number leftValue, Number rightValue) {
        Number value;
        if (leftValue instanceof Double || rightValue instanceof Double) {
            value = leftValue.doubleValue() % rightValue.doubleValue();
        } else if (leftValue instanceof Float || rightValue instanceof Float) {
            value = Float.valueOf(leftValue.floatValue() % rightValue.floatValue());
        } else if (leftValue instanceof Long || rightValue instanceof Long) {
            value = leftValue.longValue() % rightValue.longValue();
        } else if (leftValue instanceof Integer || rightValue instanceof Integer) {
            value = leftValue.intValue() % rightValue.intValue();
        } else if (leftValue instanceof Short || rightValue instanceof Short) {
            value = leftValue.shortValue() % rightValue.shortValue();
        } else if (leftValue instanceof Byte || rightValue instanceof Byte) {
            value = leftValue.byteValue() % rightValue.byteValue();
        } else {
            throw new UnsupportedOperationException();
        }
        return value;
    }

    private static /* synthetic */ Number lambda$divide$3(Number leftValue, Number rightValue) {
        Number value;
        if (leftValue instanceof Double || rightValue instanceof Double) {
            value = leftValue.doubleValue() / rightValue.doubleValue();
        } else if (leftValue instanceof Float || rightValue instanceof Float) {
            value = Float.valueOf(leftValue.floatValue() / rightValue.floatValue());
        } else if (leftValue instanceof Long || rightValue instanceof Long) {
            value = leftValue.longValue() / rightValue.longValue();
        } else if (leftValue instanceof Integer || rightValue instanceof Integer) {
            value = leftValue.intValue() / rightValue.intValue();
        } else if (leftValue instanceof Short || rightValue instanceof Short) {
            value = leftValue.shortValue() / rightValue.shortValue();
        } else if (leftValue instanceof Byte || rightValue instanceof Byte) {
            value = leftValue.byteValue() / rightValue.byteValue();
        } else {
            throw new UnsupportedOperationException();
        }
        return value;
    }

    private static /* synthetic */ Number lambda$multiply$2(Number leftValue, Number rightValue) {
        Number value;
        if (leftValue instanceof Double || rightValue instanceof Double) {
            value = leftValue.doubleValue() * rightValue.doubleValue();
        } else if (leftValue instanceof Float || rightValue instanceof Float) {
            value = Float.valueOf(leftValue.floatValue() * rightValue.floatValue());
        } else if (leftValue instanceof Long || rightValue instanceof Long) {
            value = leftValue.longValue() * rightValue.longValue();
        } else if (leftValue instanceof Integer || rightValue instanceof Integer) {
            value = leftValue.intValue() * rightValue.intValue();
        } else if (leftValue instanceof Short || rightValue instanceof Short) {
            value = leftValue.shortValue() * rightValue.shortValue();
        } else if (leftValue instanceof Byte || rightValue instanceof Byte) {
            value = leftValue.byteValue() * rightValue.byteValue();
        } else {
            throw new UnsupportedOperationException();
        }
        return value;
    }

    private static /* synthetic */ Number lambda$subtract$1(Number leftValue, Number rightValue) {
        Number value;
        if (leftValue instanceof Double || rightValue instanceof Double) {
            value = leftValue.doubleValue() - rightValue.doubleValue();
        } else if (leftValue instanceof Float || rightValue instanceof Float) {
            value = Float.valueOf(leftValue.floatValue() - rightValue.floatValue());
        } else if (leftValue instanceof Long || rightValue instanceof Long) {
            value = leftValue.longValue() - rightValue.longValue();
        } else if (leftValue instanceof Integer || rightValue instanceof Integer) {
            value = leftValue.intValue() - rightValue.intValue();
        } else if (leftValue instanceof Short || rightValue instanceof Short) {
            value = leftValue.shortValue() - rightValue.shortValue();
        } else if (leftValue instanceof Byte || rightValue instanceof Byte) {
            value = leftValue.byteValue() - rightValue.byteValue();
        } else {
            throw new UnsupportedOperationException();
        }
        return value;
    }

    private static /* synthetic */ Object lambda$add$0(Object leftValue, Object rightValue) {
        Object value;
        if (leftValue instanceof String || rightValue instanceof String) {
            value = leftValue.toString().concat(rightValue.toString());
        } else {
            Number leftNumber = (Number)leftValue;
            Number rightNumber = (Number)rightValue;
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                value = leftNumber.doubleValue() + rightNumber.doubleValue();
            } else if (leftNumber instanceof Float || rightNumber instanceof Float) {
                value = Float.valueOf(leftNumber.floatValue() + rightNumber.floatValue());
            } else if (leftNumber instanceof Long || rightNumber instanceof Long) {
                value = leftNumber.longValue() + rightNumber.longValue();
            } else if (leftNumber instanceof Integer || rightNumber instanceof Integer) {
                value = leftNumber.intValue() + rightNumber.intValue();
            } else if (leftNumber instanceof Short || rightNumber instanceof Short) {
                value = leftNumber.shortValue() + rightNumber.shortValue();
            } else if (leftNumber instanceof Byte || rightNumber instanceof Byte) {
                value = leftNumber.byteValue() + rightNumber.byteValue();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return value;
    }

    static /* synthetic */ Object access$lambda$0(Object object, Object object2) {
        return Expression.lambda$add$0(object, object2);
    }

    static /* synthetic */ Number access$lambda$1(Number number, Number number2) {
        return Expression.lambda$subtract$1(number, number2);
    }

    static /* synthetic */ Number access$lambda$2(Number number, Number number2) {
        return Expression.lambda$multiply$2(number, number2);
    }

    static /* synthetic */ Number access$lambda$3(Number number, Number number2) {
        return Expression.lambda$divide$3(number, number2);
    }

    static /* synthetic */ Number access$lambda$4(Number number, Number number2) {
        return Expression.lambda$modulo$4(number, number2);
    }

    static /* synthetic */ Boolean access$lambda$5(Comparable comparable, Comparable comparable2) {
        return Expression.lambda$equalTo$5(comparable, comparable2);
    }

    static /* synthetic */ Boolean access$lambda$6(Comparable comparable, Comparable comparable2) {
        return Expression.lambda$notEqualTo$6(comparable, comparable2);
    }

    static /* synthetic */ Boolean access$lambda$7(Comparable comparable, Comparable comparable2) {
        return Expression.lambda$greaterThan$7(comparable, comparable2);
    }

    static /* synthetic */ Boolean access$lambda$8(Comparable comparable, Comparable comparable2) {
        return Expression.lambda$greaterThanOrEqualTo$8(comparable, comparable2);
    }

    static /* synthetic */ Boolean access$lambda$9(Comparable comparable, Comparable comparable2) {
        return Expression.lambda$lessThan$9(comparable, comparable2);
    }

    static /* synthetic */ Boolean access$lambda$10(Comparable comparable, Comparable comparable2) {
        return Expression.lambda$lessThanOrEqualTo$10(comparable, comparable2);
    }

    static /* synthetic */ Boolean access$lambda$11(Boolean bl, Boolean bl2) {
        return Expression.lambda$and$11(bl, bl2);
    }

    static /* synthetic */ Boolean access$lambda$12(Boolean bl, Boolean bl2) {
        return Expression.lambda$or$12(bl, bl2);
    }

    static /* synthetic */ Number access$lambda$13(Number number) {
        return Expression.lambda$negate$13(number);
    }

    static /* synthetic */ Boolean access$lambda$14(Boolean bl) {
        return Expression.lambda$not$14(bl);
    }

    private static class Parser {
        private int c = -1;
        private char[] pushbackBuffer = new char[6];
        private static final int PUSHBACK_BUFFER_SIZE = 6;

        private Parser() {
        }

        public Expression parse(Reader reader) throws IOException {
            LinkedList<Token> tokens = this.tokenize(new PushbackReader(reader, 6));
            LinkedList<LiteralExpression<Object>> stack = new LinkedList<LiteralExpression<Object>>();
            for (Token token : tokens) {
                Expression expression;
                block0 : switch (token.type) {
                    case LITERAL: {
                        expression = new LiteralExpression<Object>(token.value);
                        break;
                    }
                    case VARIABLE: {
                        expression = new VariableExpression((KeyPath)token.value);
                        break;
                    }
                    case FUNCTION: {
                        expression = null;
                        break;
                    }
                    case UNARY_OPERATOR: {
                        Operator operator = (Operator)((Object)token.value);
                        Expression operand = (Expression)stack.pop();
                        switch (operator) {
                            case NEGATE: {
                                expression = Expression.negate(operand);
                                break block0;
                            }
                            case NOT: {
                                expression = Expression.not(operand);
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    case BINARY_OPERATOR: {
                        Operator operator = (Operator)((Object)token.value);
                        Expression right = (Expression)stack.pop();
                        Expression left = (Expression)stack.pop();
                        switch (operator) {
                            case ADD: {
                                expression = Expression.add(left, right);
                                break block0;
                            }
                            case SUBTRACT: {
                                expression = Expression.subtract(left, right);
                                break block0;
                            }
                            case MULTIPLY: {
                                expression = Expression.multiply(left, right);
                                break block0;
                            }
                            case DIVIDE: {
                                expression = Expression.divide(left, right);
                                break block0;
                            }
                            case MODULO: {
                                expression = Expression.modulo(left, right);
                                break block0;
                            }
                            case GREATER_THAN: {
                                expression = Expression.greaterThan(left, right);
                                break block0;
                            }
                            case GREATER_THAN_OR_EQUAL_TO: {
                                expression = Expression.greaterThanOrEqualTo(left, right);
                                break block0;
                            }
                            case LESS_THAN: {
                                expression = Expression.lessThan(left, right);
                                break block0;
                            }
                            case LESS_THAN_OR_EQUAL_TO: {
                                expression = Expression.lessThanOrEqualTo(left, right);
                                break block0;
                            }
                            case EQUAL_TO: {
                                expression = Expression.equalTo(left, right);
                                break block0;
                            }
                            case NOT_EQUAL_TO: {
                                expression = Expression.notEqualTo(left, right);
                                break block0;
                            }
                            case AND: {
                                expression = Expression.and(left, right);
                                break block0;
                            }
                            case OR: {
                                expression = Expression.or(left, right);
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                stack.push((LiteralExpression<Object>)expression);
            }
            if (stack.size() != 1) {
                throw new IllegalArgumentException("Invalid expression.");
            }
            return (Expression)stack.peek();
        }

        private LinkedList<Token> tokenize(PushbackReader reader) throws IOException {
            LinkedList<Token> tokens = new LinkedList<Token>();
            LinkedList<Token> stack = new LinkedList<Token>();
            this.c = reader.read();
            boolean unary = true;
            while (this.c != -1) {
                Token token;
                block63: {
                    boolean readNext;
                    block70: {
                        block69: {
                            block68: {
                                block67: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                block62: {
                                                    while (this.c != -1 && Character.isWhitespace(this.c)) {
                                                        this.c = reader.read();
                                                    }
                                                    if (this.c == -1) continue;
                                                    if (this.c != 110) break block62;
                                                    if (this.readKeyword(reader, Expression.NULL_KEYWORD)) {
                                                        token = new Token(TokenType.LITERAL, null);
                                                    } else {
                                                        token = new Token(TokenType.VARIABLE, KeyPath.parse(reader));
                                                        this.c = reader.read();
                                                    }
                                                    break block63;
                                                }
                                                if (this.c != 34 && this.c != 39) break block64;
                                                StringBuilder stringBuilder = new StringBuilder();
                                                int t = this.c;
                                                this.c = reader.read();
                                                while (this.c != -1 && this.c != t) {
                                                    if (!Character.isISOControl(this.c)) {
                                                        if (this.c == 92) {
                                                            this.c = reader.read();
                                                            if (this.c == 98) {
                                                                this.c = 8;
                                                            } else if (this.c == 102) {
                                                                this.c = 12;
                                                            } else if (this.c == 110) {
                                                                this.c = 10;
                                                            } else if (this.c == 114) {
                                                                this.c = 13;
                                                            } else if (this.c == 116) {
                                                                this.c = 9;
                                                            } else if (this.c == 117) {
                                                                StringBuilder unicodeValueBuilder = new StringBuilder();
                                                                while (unicodeValueBuilder.length() < 4) {
                                                                    this.c = reader.read();
                                                                    unicodeValueBuilder.append((char)this.c);
                                                                }
                                                                String unicodeValue = unicodeValueBuilder.toString();
                                                                this.c = (char)Integer.parseInt(unicodeValue, 16);
                                                            } else if (this.c != 92 && this.c != 47 && this.c != 34 && this.c != 39 && this.c != t) {
                                                                throw new IllegalArgumentException("Unsupported escape sequence.");
                                                            }
                                                        }
                                                        stringBuilder.append((char)this.c);
                                                    }
                                                    this.c = reader.read();
                                                }
                                                if (this.c != t) {
                                                    throw new IllegalArgumentException("Unterminated string.");
                                                }
                                                this.c = reader.read();
                                                token = new Token(TokenType.LITERAL, stringBuilder.toString());
                                                break block63;
                                            }
                                            if (!Character.isDigit(this.c)) break block65;
                                            StringBuilder numberBuilder = new StringBuilder();
                                            boolean integer = true;
                                            while (this.c != -1 && (Character.isDigit(this.c) || this.c == 46 || this.c == 101 || this.c == 69)) {
                                                numberBuilder.append((char)this.c);
                                                integer &= this.c != 46;
                                                this.c = reader.read();
                                            }
                                            Number value = integer ? (Number)Long.parseLong(numberBuilder.toString()) : (Number)Double.parseDouble(numberBuilder.toString());
                                            token = new Token(TokenType.LITERAL, value);
                                            break block63;
                                        }
                                        if (this.c != 116) break block66;
                                        if (this.readKeyword(reader, Expression.TRUE_KEYWORD)) {
                                            token = new Token(TokenType.LITERAL, true);
                                        } else {
                                            token = new Token(TokenType.VARIABLE, KeyPath.parse(reader));
                                            this.c = reader.read();
                                        }
                                        break block63;
                                    }
                                    if (this.c != 102) break block67;
                                    if (this.readKeyword(reader, Expression.FALSE_KEYWORD)) {
                                        token = new Token(TokenType.LITERAL, false);
                                    } else {
                                        token = new Token(TokenType.VARIABLE, KeyPath.parse(reader));
                                        this.c = reader.read();
                                    }
                                    break block63;
                                }
                                if (!Character.isJavaIdentifierStart(this.c)) break block68;
                                reader.unread(this.c);
                                token = new Token(TokenType.VARIABLE, KeyPath.parse(reader));
                                this.c = reader.read();
                                break block63;
                            }
                            readNext = true;
                            if (!unary) break block69;
                            switch (this.c) {
                                case 45: {
                                    token = new Token(TokenType.UNARY_OPERATOR, (Object)Operator.NEGATE);
                                    break block70;
                                }
                                case 33: {
                                    token = new Token(TokenType.UNARY_OPERATOR, (Object)Operator.NOT);
                                    break block70;
                                }
                                case 40: {
                                    token = new Token(TokenType.BEGIN_GROUP, null);
                                    break block70;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unexpected character in expression.");
                                }
                            }
                        }
                        switch (this.c) {
                            case 43: {
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.ADD);
                                break;
                            }
                            case 45: {
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.SUBTRACT);
                                break;
                            }
                            case 42: {
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.MULTIPLY);
                                break;
                            }
                            case 47: {
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.DIVIDE);
                                break;
                            }
                            case 37: {
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.MODULO);
                                break;
                            }
                            case 61: {
                                this.c = reader.read();
                                if (this.c == 61) {
                                    token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.EQUAL_TO);
                                    break;
                                }
                                throw new IllegalArgumentException("Unexpected character in expression.");
                            }
                            case 33: {
                                this.c = reader.read();
                                if (this.c == 61) {
                                    token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.NOT_EQUAL_TO);
                                    break;
                                }
                                throw new IllegalArgumentException("Unexpected character in expression.");
                            }
                            case 62: {
                                this.c = reader.read();
                                if (this.c == 61) {
                                    token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.GREATER_THAN_OR_EQUAL_TO);
                                    break;
                                }
                                readNext = false;
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.GREATER_THAN);
                                break;
                            }
                            case 60: {
                                this.c = reader.read();
                                if (this.c == 61) {
                                    token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.LESS_THAN_OR_EQUAL_TO);
                                    break;
                                }
                                readNext = false;
                                token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.LESS_THAN);
                                break;
                            }
                            case 38: {
                                this.c = reader.read();
                                if (this.c == 38) {
                                    token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.AND);
                                    break;
                                }
                                throw new IllegalArgumentException("Unexpected character in expression.");
                            }
                            case 124: {
                                this.c = reader.read();
                                if (this.c == 124) {
                                    token = new Token(TokenType.BINARY_OPERATOR, (Object)Operator.OR);
                                    break;
                                }
                                throw new IllegalArgumentException("Unexpected character in expression.");
                            }
                            case 41: {
                                token = new Token(TokenType.END_GROUP, null);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unexpected character in expression.");
                            }
                        }
                    }
                    if (readNext) {
                        this.c = reader.read();
                    }
                }
                switch (token.type) {
                    case LITERAL: 
                    case VARIABLE: {
                        tokens.add(token);
                        break;
                    }
                    case UNARY_OPERATOR: 
                    case BINARY_OPERATOR: {
                        int priority = ((Operator)((Object)token.value)).getPriority();
                        while (!stack.isEmpty() && ((Token)stack.peek()).type != TokenType.BEGIN_GROUP && ((Operator)((Object)((Token)stack.peek()).value)).getPriority() >= priority && ((Operator)((Object)((Token)stack.peek()).value)).getPriority() != 6) {
                            tokens.add((Token)stack.pop());
                        }
                        stack.push(token);
                        break;
                    }
                    case BEGIN_GROUP: {
                        stack.push(token);
                        break;
                    }
                    case END_GROUP: {
                        Token t = (Token)stack.pop();
                        while (t.type != TokenType.BEGIN_GROUP) {
                            tokens.add(t);
                            t = (Token)stack.pop();
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                unary = token.type != TokenType.LITERAL && token.type != TokenType.VARIABLE && token.type != TokenType.END_GROUP;
            }
            while (!stack.isEmpty()) {
                tokens.add((Token)stack.pop());
            }
            return tokens;
        }

        private boolean readKeyword(PushbackReader reader, String keyword) throws IOException {
            boolean result;
            int i;
            int n = keyword.length();
            for (i = 0; this.c != -1 && i < n; ++i) {
                this.pushbackBuffer[i] = (char)this.c;
                if (keyword.charAt(i) != this.c) break;
                this.c = reader.read();
            }
            if (i < n) {
                reader.unread(this.pushbackBuffer, 0, i + 1);
                result = false;
            } else {
                result = true;
            }
            return result;
        }

        public static enum TokenType {
            LITERAL,
            VARIABLE,
            FUNCTION,
            UNARY_OPERATOR,
            BINARY_OPERATOR,
            BEGIN_GROUP,
            END_GROUP;

        }

        public static class Token {
            public final TokenType type;
            public final Object value;

            public Token(TokenType type, Object value) {
                this.type = type;
                this.value = value;
            }

            public String toString() {
                return this.value.toString();
            }
        }
    }
}

