/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.common.PushbroomScaler;
import java.nio.ByteBuffer;

public class RoughScaler
implements PushbroomScaler {
    protected int numBands;
    protected int destWidth;
    protected int destHeight;
    protected double scaleY;
    protected ByteBuffer destBuf;
    protected int[] colPositions;
    protected int sourceLine;
    protected int nextSourceLine;
    protected int destLine;

    public RoughScaler(int sourceWidth, int sourceHeight, int numBands, int destWidth, int destHeight) {
        if (sourceWidth <= 0 || sourceHeight <= 0 || numBands <= 0 || destWidth <= 0 || destHeight <= 0) {
            throw new IllegalArgumentException();
        }
        this.numBands = numBands;
        this.destWidth = destWidth;
        this.destHeight = destHeight;
        this.destBuf = ByteBuffer.wrap(new byte[destHeight * destWidth * numBands]);
        double scaleX = (double)sourceWidth / (double)destWidth;
        this.scaleY = (double)sourceHeight / (double)destHeight;
        this.colPositions = new int[destWidth];
        for (int i = 0; i < destWidth; ++i) {
            int pos = (int)(((double)i + 0.5) * scaleX);
            this.colPositions[i] = pos * numBands;
        }
        this.sourceLine = 0;
        this.destLine = 0;
        this.nextSourceLine = (int)(0.5 * this.scaleY);
    }

    @Override
    public ByteBuffer getDestination() {
        return this.destBuf;
    }

    @Override
    public boolean putSourceScanline(byte[] scanline, int off) {
        if (off < 0) {
            throw new IllegalArgumentException("off < 0!");
        }
        if (this.destLine < this.destHeight) {
            if (this.sourceLine == this.nextSourceLine) {
                int destOffset;
                assert (this.destBuf.hasArray()) : "destBuf.hasArray() == false => destBuf is direct";
                byte[] dest = this.destBuf.array();
                int doff = destOffset = this.destLine * this.destWidth * this.numBands;
                for (int i = 0; i < this.destWidth; ++i) {
                    int sourceOffset = off + this.colPositions[i];
                    for (int j = 0; j < this.numBands; ++j) {
                        dest[doff++] = scanline[sourceOffset + j];
                    }
                }
                while ((int)(((double)(++this.destLine) + 0.5) * this.scaleY) == this.sourceLine) {
                    System.arraycopy(dest, destOffset, dest, doff, this.destWidth * this.numBands);
                    doff += this.destWidth * this.numBands;
                }
                this.nextSourceLine = (int)(((double)this.destLine + 0.5) * this.scaleY);
            }
            ++this.sourceLine;
        }
        return this.destLine == this.destHeight;
    }
}

