/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase$$Lambda$1;
import com.sun.javafx.scene.control.behavior.BehaviorBase$$Lambda$2;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.traversal.Direction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class BehaviorBase<C extends Control> {
    protected static final boolean IS_TOUCH_SUPPORTED = Platform.isSupported(ConditionalFeature.INPUT_TOUCH);
    protected static final List<KeyBinding> TRAVERSAL_BINDINGS = new ArrayList<KeyBinding>();
    static final String TRAVERSE_UP = "TraverseUp";
    static final String TRAVERSE_DOWN = "TraverseDown";
    static final String TRAVERSE_LEFT = "TraverseLeft";
    static final String TRAVERSE_RIGHT = "TraverseRight";
    static final String TRAVERSE_NEXT = "TraverseNext";
    static final String TRAVERSE_PREVIOUS = "TraversePrevious";
    private final C control;
    private final List<KeyBinding> keyBindings;
    private final EventHandler<KeyEvent> keyEventListener = BehaviorBase$$Lambda$1.lambdaFactory$(this);
    private final InvalidationListener focusListener = BehaviorBase$$Lambda$2.lambdaFactory$(this);

    public BehaviorBase(C control, List<KeyBinding> keyBindings) {
        this.control = control;
        this.keyBindings = keyBindings == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<KeyBinding>(keyBindings));
        ((Node)control).addEventHandler(KeyEvent.ANY, this.keyEventListener);
        ((Node)control).focusedProperty().addListener(this.focusListener);
    }

    public void dispose() {
        ((Node)this.control).removeEventHandler(KeyEvent.ANY, this.keyEventListener);
        ((Node)this.control).focusedProperty().removeListener(this.focusListener);
    }

    public final C getControl() {
        return this.control;
    }

    protected void callActionForEvent(KeyEvent e) {
        String action = this.matchActionForEvent(e);
        if (action != null) {
            this.callAction(action);
            e.consume();
        }
    }

    protected String matchActionForEvent(KeyEvent e) {
        if (e == null) {
            throw new NullPointerException("KeyEvent must not be null");
        }
        KeyBinding match = null;
        int specificity = 0;
        int maxBindings = this.keyBindings.size();
        for (int i = 0; i < maxBindings; ++i) {
            KeyBinding binding = this.keyBindings.get(i);
            int s = binding.getSpecificity((Control)this.control, e);
            if (s <= specificity) continue;
            specificity = s;
            match = binding;
        }
        String action = null;
        if (match != null) {
            action = match.getAction();
        }
        return action;
    }

    protected void callAction(String name) {
        switch (name) {
            case "TraverseUp": {
                this.traverseUp();
                break;
            }
            case "TraverseDown": {
                this.traverseDown();
                break;
            }
            case "TraverseLeft": {
                this.traverseLeft();
                break;
            }
            case "TraverseRight": {
                this.traverseRight();
                break;
            }
            case "TraverseNext": {
                this.traverseNext();
                break;
            }
            case "TraversePrevious": {
                this.traversePrevious();
            }
        }
    }

    protected void traverse(Node node, Direction dir) {
        node.impl_traverse(dir);
    }

    public final void traverseUp() {
        this.traverse((Node)this.control, Direction.UP);
    }

    public final void traverseDown() {
        this.traverse((Node)this.control, Direction.DOWN);
    }

    public final void traverseLeft() {
        this.traverse((Node)this.control, Direction.LEFT);
    }

    public final void traverseRight() {
        this.traverse((Node)this.control, Direction.RIGHT);
    }

    public final void traverseNext() {
        this.traverse((Node)this.control, Direction.NEXT);
    }

    public final void traversePrevious() {
        this.traverse((Node)this.control, Direction.PREVIOUS);
    }

    protected void focusChanged() {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void contextMenuRequested(ContextMenuEvent e) {
    }

    private /* synthetic */ void lambda$new$75(Observable property) {
        this.focusChanged();
    }

    private /* synthetic */ void lambda$new$74(KeyEvent e) {
        if (!e.isConsumed()) {
            this.callActionForEvent(e);
        }
    }

    static {
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.UP, TRAVERSE_UP));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.DOWN, TRAVERSE_DOWN));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.LEFT, TRAVERSE_LEFT));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, TRAVERSE_RIGHT));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, TRAVERSE_NEXT));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, TRAVERSE_PREVIOUS).shift());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.UP, TRAVERSE_UP).shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.DOWN, TRAVERSE_DOWN).shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.LEFT, TRAVERSE_LEFT).shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, TRAVERSE_RIGHT).shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, TRAVERSE_NEXT).shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, TRAVERSE_PREVIOUS).alt().ctrl());
    }

    static /* synthetic */ void access$lambda$0(BehaviorBase behaviorBase, KeyEvent keyEvent) {
        behaviorBase.lambda$new$74(keyEvent);
    }

    static /* synthetic */ void access$lambda$1(BehaviorBase behaviorBase, Observable observable) {
        behaviorBase.lambda$new$75(observable);
    }
}

