/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TextAreaBehavior$$Lambda$1;
import com.sun.javafx.scene.control.behavior.TextAreaBehavior$$Lambda$2;
import com.sun.javafx.scene.control.behavior.TextAreaBehavior$$Lambda$3;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.behavior.TextInputControlBindings;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TextArea;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Window;

public class TextAreaBehavior
extends TextInputControlBehavior<TextArea> {
    protected static final List<KeyBinding> TEXT_AREA_BINDINGS = new ArrayList<KeyBinding>();
    private TextAreaSkin skin;
    private ContextMenu contextMenu = new ContextMenu();
    private TwoLevelFocusBehavior tlFocus;
    private TKStage tkStage;
    private boolean focusGainedByMouseClick = false;
    private boolean shiftDown = false;
    private boolean deferClick = false;

    public TextAreaBehavior(TextArea textArea) {
        super(textArea, TEXT_AREA_BINDINGS);
        if (IS_TOUCH_SUPPORTED) {
            this.contextMenu.getStyleClass().add("text-input-context-menu");
        }
        this.handleFocusChange();
        textArea.focusedProperty().addListener(TextAreaBehavior$$Lambda$1.lambdaFactory$(this));
        if (PlatformUtil.isIOS()) {
            ChangeListener textListener = TextAreaBehavior$$Lambda$2.lambdaFactory$(textArea);
            WeakChangeListener textWeakChangeListener = new WeakChangeListener(textListener);
            ChangeListener sceneListener = TextAreaBehavior$$Lambda$3.lambdaFactory$(textArea, textWeakChangeListener);
            textArea.sceneProperty().addListener(new WeakChangeListener(sceneListener));
            if (textArea.getScene() != null) {
                textArea.textProperty().addListener(textWeakChangeListener);
            }
        }
        if (com.sun.javafx.scene.control.skin.Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior(textArea);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    private void handleFocusChange() {
        TextArea textArea = (TextArea)this.getControl();
        if (textArea.isFocused()) {
            if (PlatformUtil.isIOS()) {
                Bounds bounds = textArea.getBoundsInParent();
                double w = bounds.getWidth();
                double h = bounds.getHeight();
                Affine3D trans = TextFieldBehavior.calculateNodeToSceneTransform(textArea);
                String text = textArea.textProperty().getValueSafe();
                textArea.getScene().getWindow().impl_getPeer().requestInput(text, TextFieldBehavior.TextInputTypes.TEXT_AREA.ordinal(), w, h, trans.getMxx(), trans.getMxy(), trans.getMxz(), trans.getMxt(), trans.getMyx(), trans.getMyy(), trans.getMyz(), trans.getMyt(), trans.getMzx(), trans.getMzy(), trans.getMzz(), trans.getMzt(), textArea.getFont().getSize());
                this.tkStage = textArea.getScene().getWindow().impl_getPeer();
            }
            if (!this.focusGainedByMouseClick) {
                this.setCaretAnimating(true);
            }
        } else {
            if (PlatformUtil.isIOS() && this.tkStage != null) {
                this.tkStage.releaseInput();
            }
            this.focusGainedByMouseClick = false;
            this.setCaretAnimating(false);
        }
    }

    public void setTextAreaSkin(TextAreaSkin skin) {
        this.skin = skin;
    }

    @Override
    public void callAction(String name) {
        TextArea textInputControl = (TextArea)this.getControl();
        boolean done = false;
        if (textInputControl.isEditable()) {
            this.setEditing(true);
            done = true;
            if ("InsertNewLine".equals(name)) {
                this.insertNewLine();
            } else if ("TraverseOrInsertTab".equals(name)) {
                this.insertTab();
            } else {
                done = false;
            }
            this.setEditing(false);
        }
        if (!done) {
            done = true;
            if ("LineStart".equals(name)) {
                this.lineStart(false, false);
            } else if ("LineEnd".equals(name)) {
                this.lineEnd(false, false);
            } else if ("SelectLineStart".equals(name)) {
                this.lineStart(true, false);
            } else if ("SelectLineStartExtend".equals(name)) {
                this.lineStart(true, true);
            } else if ("SelectLineEnd".equals(name)) {
                this.lineEnd(true, false);
            } else if ("SelectLineEndExtend".equals(name)) {
                this.lineEnd(true, true);
            } else if ("PreviousLine".equals(name)) {
                this.skin.previousLine(false);
            } else if ("NextLine".equals(name)) {
                this.skin.nextLine(false);
            } else if ("SelectPreviousLine".equals(name)) {
                this.skin.previousLine(true);
            } else if ("SelectNextLine".equals(name)) {
                this.skin.nextLine(true);
            } else if ("ParagraphStart".equals(name)) {
                this.skin.paragraphStart(true, false);
            } else if ("ParagraphEnd".equals(name)) {
                this.skin.paragraphEnd(true, PlatformUtil.isWindows(), false);
            } else if ("SelectParagraphStart".equals(name)) {
                this.skin.paragraphStart(true, true);
            } else if ("SelectParagraphEnd".equals(name)) {
                this.skin.paragraphEnd(true, PlatformUtil.isWindows(), true);
            } else if ("PreviousPage".equals(name)) {
                this.skin.previousPage(false);
            } else if ("NextPage".equals(name)) {
                this.skin.nextPage(false);
            } else if ("SelectPreviousPage".equals(name)) {
                this.skin.previousPage(true);
            } else if ("SelectNextPage".equals(name)) {
                this.skin.nextPage(true);
            } else if ("TraverseOrInsertTab".equals(name)) {
                name = "TraverseNext";
                done = false;
            } else {
                done = false;
            }
        }
        if (!done) {
            super.callAction(name);
        }
    }

    private void insertNewLine() {
        TextArea textArea = (TextArea)this.getControl();
        textArea.replaceSelection("\n");
    }

    private void insertTab() {
        TextArea textArea = (TextArea)this.getControl();
        textArea.replaceSelection("\t");
    }

    @Override
    protected void deleteChar(boolean previous) {
        this.skin.deleteChar(previous);
    }

    @Override
    protected void deleteFromLineStart() {
        TextArea textArea = (TextArea)this.getControl();
        int end = textArea.getCaretPosition();
        if (end > 0) {
            this.lineStart(false, false);
            int start = textArea.getCaretPosition();
            if (end > start) {
                this.replaceText(start, end, "");
            }
        }
    }

    private void lineStart(boolean select, boolean extendSelection) {
        this.skin.lineStart(select, extendSelection);
    }

    private void lineEnd(boolean select, boolean extendSelection) {
        this.skin.lineEnd(select, extendSelection);
    }

    @Override
    protected void scrollCharacterToVisible(int index) {
        this.skin.scrollCharacterToVisible(index);
    }

    @Override
    protected void replaceText(int start, int end, String txt) {
        ((TextArea)this.getControl()).replaceText(start, end, txt);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TextArea textArea = (TextArea)this.getControl();
        super.mousePressed(e);
        if (!textArea.isDisabled()) {
            if (!textArea.isFocused()) {
                this.focusGainedByMouseClick = true;
                textArea.requestFocus();
            }
            this.setCaretAnimating(false);
            if (e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown()) {
                HitInfo hit = this.skin.getIndex(e.getX(), e.getY());
                int i = com.sun.javafx.scene.control.skin.Utils.getHitInsertionIndex(hit, textArea.textProperty().getValueSafe());
                int anchor = textArea.getAnchor();
                int caretPosition = textArea.getCaretPosition();
                if (e.getClickCount() < 2 && (e.isSynthesized() || anchor != caretPosition && (i > anchor && i < caretPosition || i < anchor && i > caretPosition))) {
                    this.deferClick = true;
                } else if (!(e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown() || e.isShortcutDown())) {
                    switch (e.getClickCount()) {
                        case 1: {
                            this.skin.positionCaret(hit, false, false);
                            break;
                        }
                        case 2: {
                            this.mouseDoubleClick(hit);
                            break;
                        }
                        case 3: {
                            this.mouseTripleClick(hit);
                            break;
                        }
                    }
                } else if (!(!e.isShiftDown() || e.isControlDown() || e.isAltDown() || e.isMetaDown() || e.isShortcutDown() || e.getClickCount() != 1)) {
                    this.shiftDown = true;
                    if (PlatformUtil.isMac()) {
                        textArea.extendSelection(i);
                    } else {
                        this.skin.positionCaret(hit, true, false);
                    }
                }
            }
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TextArea textArea = (TextArea)this.getControl();
        if (!(textArea.isDisabled() || e.isSynthesized() || e.getButton() != MouseButton.PRIMARY || e.isMiddleButtonDown() || e.isSecondaryButtonDown() || e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown())) {
            this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), true, false);
        }
        this.deferClick = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TextArea textArea = (TextArea)this.getControl();
        super.mouseReleased(e);
        if (!textArea.isDisabled()) {
            this.setCaretAnimating(false);
            if (this.deferClick) {
                this.deferClick = false;
                this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), this.shiftDown, false);
                this.shiftDown = false;
            }
            this.setCaretAnimating(true);
        }
    }

    @Override
    public void contextMenuRequested(ContextMenuEvent e) {
        TextArea textArea = (TextArea)this.getControl();
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        } else if (textArea.getContextMenu() == null) {
            double screenX = e.getScreenX();
            double screenY = e.getScreenY();
            double sceneX = e.getSceneX();
            if (IS_TOUCH_SUPPORTED) {
                Point2D menuPos;
                if (textArea.getSelection().getLength() == 0) {
                    this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), false, false);
                    menuPos = this.skin.getMenuPosition();
                } else {
                    menuPos = this.skin.getMenuPosition();
                    if (menuPos != null && (menuPos.getX() <= 0.0 || menuPos.getY() <= 0.0)) {
                        this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), false, false);
                        menuPos = this.skin.getMenuPosition();
                    }
                }
                if (menuPos != null) {
                    Point2D p = ((TextArea)this.getControl()).localToScene(menuPos);
                    Scene scene = ((TextArea)this.getControl()).getScene();
                    Window window = scene.getWindow();
                    Point2D location = new Point2D(window.getX() + scene.getX() + p.getX(), window.getY() + scene.getY() + p.getY());
                    screenX = location.getX();
                    sceneX = p.getX();
                    screenY = location.getY();
                }
            }
            this.skin.populateContextMenu(this.contextMenu);
            double menuWidth = this.contextMenu.prefWidth(-1.0);
            double menuX = screenX - (IS_TOUCH_SUPPORTED ? menuWidth / 2.0 : 0.0);
            Screen currentScreen = Utils.getScreenForPoint(screenX, 0.0);
            Rectangle2D bounds = currentScreen.getBounds();
            if (menuX < bounds.getMinX()) {
                ((TextArea)this.getControl()).getProperties().put("CONTEXT_MENU_SCREEN_X", screenX);
                ((TextArea)this.getControl()).getProperties().put("CONTEXT_MENU_SCENE_X", sceneX);
                this.contextMenu.show((Node)this.getControl(), bounds.getMinX(), screenY);
            } else if (screenX + menuWidth > bounds.getMaxX()) {
                double leftOver = menuWidth - (bounds.getMaxX() - screenX);
                ((TextArea)this.getControl()).getProperties().put("CONTEXT_MENU_SCREEN_X", screenX);
                ((TextArea)this.getControl()).getProperties().put("CONTEXT_MENU_SCENE_X", sceneX);
                this.contextMenu.show((Node)this.getControl(), screenX - leftOver, screenY);
            } else {
                ((TextArea)this.getControl()).getProperties().put("CONTEXT_MENU_SCREEN_X", 0);
                ((TextArea)this.getControl()).getProperties().put("CONTEXT_MENU_SCENE_X", 0);
                this.contextMenu.show((Node)this.getControl(), menuX, screenY);
            }
        }
        e.consume();
    }

    @Override
    protected void setCaretAnimating(boolean play) {
        if (this.skin != null) {
            this.skin.setCaretAnimating(play);
        }
    }

    protected void mouseDoubleClick(HitInfo hit) {
        TextArea textArea = (TextArea)this.getControl();
        textArea.previousWord();
        if (PlatformUtil.isWindows()) {
            textArea.selectNextWord();
        } else {
            textArea.selectEndOfNextWord();
        }
    }

    protected void mouseTripleClick(HitInfo hit) {
        this.skin.paragraphStart(false, false);
        this.skin.paragraphEnd(false, PlatformUtil.isWindows(), true);
    }

    private static /* synthetic */ void lambda$new$228(TextArea textArea, WeakChangeListener textWeakChangeListener, ObservableValue observable, Scene oldValue, Scene newValue) {
        if (oldValue != null) {
            textArea.textProperty().removeListener(textWeakChangeListener);
        }
        if (newValue != null) {
            textArea.textProperty().addListener(textWeakChangeListener);
        }
    }

    private static /* synthetic */ void lambda$new$227(TextArea textArea, ObservableValue observable, String oldValue, String newValue) {
        if (newValue != null) {
            textArea.getScene().getWindow().impl_getPeer().updateInput(newValue);
        }
    }

    private /* synthetic */ void lambda$new$226(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        this.handleFocusChange();
    }

    static {
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_PRESSED, "LineStart"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_PRESSED, "LineEnd"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "PreviousLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "PreviousLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "NextLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "NextLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, KeyEvent.KEY_PRESSED, "PreviousPage"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, KeyEvent.KEY_PRESSED, "NextPage"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, "InsertNewLine"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.TAB, KeyEvent.KEY_PRESSED, "TraverseOrInsertTab"));
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_PRESSED, "SelectLineStart").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_PRESSED, "SelectLineEnd").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectPreviousLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectPreviousLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectNextLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectNextLine").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, KeyEvent.KEY_PRESSED, "SelectPreviousPage").shift());
        TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, KeyEvent.KEY_PRESSED, "SelectNextPage").shift());
        if (PlatformUtil.isMac()) {
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.LEFT, KeyEvent.KEY_PRESSED, "LineStart").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, KeyEvent.KEY_PRESSED, "LineStart").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, KeyEvent.KEY_PRESSED, "LineEnd").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, KeyEvent.KEY_PRESSED, "LineEnd").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "Home").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "Home").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "End").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "End").shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.LEFT, KeyEvent.KEY_PRESSED, "SelectLineStartExtend").shift().shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, KeyEvent.KEY_PRESSED, "SelectLineStartExtend").shift().shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, KeyEvent.KEY_PRESSED, "SelectLineEndExtend").shift().shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, KeyEvent.KEY_PRESSED, "SelectLineEndExtend").shift().shortcut());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectHomeExtend").shortcut().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectHomeExtend").shortcut().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectEndExtend").shortcut().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectEndExtend").shortcut().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "ParagraphStart").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "ParagraphStart").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").alt());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").alt().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").alt().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").alt().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").alt().shift());
        } else {
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "ParagraphStart").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "ParagraphStart").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "ParagraphEnd").ctrl());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").ctrl().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, KeyEvent.KEY_PRESSED, "SelectParagraphStart").ctrl().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").ctrl().shift());
            TEXT_AREA_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, KeyEvent.KEY_PRESSED, "SelectParagraphEnd").ctrl().shift());
        }
        TEXT_AREA_BINDINGS.addAll(TextInputControlBindings.BINDINGS);
        TEXT_AREA_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }

    static /* synthetic */ void access$lambda$0(TextAreaBehavior textAreaBehavior, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        textAreaBehavior.lambda$new$226(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$1(TextArea textArea, ObservableValue observableValue, String string, String string2) {
        TextAreaBehavior.lambda$new$227(textArea, observableValue, string, string2);
    }

    static /* synthetic */ void access$lambda$2(TextArea textArea, WeakChangeListener weakChangeListener, ObservableValue observableValue, Scene scene, Scene scene2) {
        TextAreaBehavior.lambda$new$228(textArea, weakChangeListener, observableValue, scene, scene2);
    }
}

