/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableViewBehavior$$Lambda$1;
import com.sun.javafx.scene.control.behavior.TreeTableViewBehavior$$Lambda$2;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;

public class TreeTableViewBehavior<T>
extends TableViewBehaviorBase<TreeTableView<T>, TreeItem<T>, TreeTableColumn<T, ?>> {
    protected static final List<KeyBinding> TREE_TABLE_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private final ChangeListener<TreeTableView.TreeTableViewSelectionModel<T>> selectionModelListener = TreeTableViewBehavior$$Lambda$1.lambdaFactory$(this);
    private final WeakChangeListener<TreeTableView.TreeTableViewSelectionModel<T>> weakSelectionModelListener = new WeakChangeListener<TreeTableView.TreeTableViewSelectionModel<TreeTableView.TreeTableViewSelectionModel<T>>>(this.selectionModelListener);

    @Override
    protected String matchActionForEvent(KeyEvent e) {
        String action = super.matchActionForEvent(e);
        if (((TreeTableView)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            if ("CollapseRow".equals(action) && (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.KP_LEFT)) {
                action = "ExpandRow";
            } else if ("ExpandRow".equals(action) && (e.getCode() == KeyCode.RIGHT || e.getCode() == KeyCode.KP_RIGHT)) {
                action = "CollapseRow";
            }
        }
        return action;
    }

    @Override
    protected void callAction(String name) {
        if ("ExpandRow".equals(name)) {
            this.rightArrowPressed();
        } else if ("CollapseRow".equals(name)) {
            this.leftArrowPressed();
        } else if ("ExpandAll".equals(name)) {
            this.expandAll();
        } else {
            super.callAction(name);
        }
    }

    public TreeTableViewBehavior(TreeTableView<T> control) {
        super(control, TREE_TABLE_VIEW_BINDINGS);
        control.selectionModelProperty().addListener(this.weakSelectionModelListener);
        if (this.getSelectionModel() != null) {
            control.getSelectionModel().getSelectedCells().addListener(this.selectedCellsListener);
        }
    }

    @Override
    protected int getItemCount() {
        return ((TreeTableView)this.getControl()).getExpandedItemCount();
    }

    @Override
    protected TableFocusModel getFocusModel() {
        return ((TreeTableView)this.getControl()).getFocusModel();
    }

    @Override
    protected TableSelectionModel<TreeItem<T>> getSelectionModel() {
        return ((TreeTableView)this.getControl()).getSelectionModel();
    }

    @Override
    protected ObservableList<TreeTablePosition<T, ?>> getSelectedCells() {
        return ((TreeTableView)this.getControl()).getSelectionModel().getSelectedCells();
    }

    @Override
    protected TablePositionBase getFocusedCell() {
        return ((TreeTableView)this.getControl()).getFocusModel().getFocusedCell();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumnBase tc) {
        return ((TreeTableView)this.getControl()).getVisibleLeafIndex((TreeTableColumn)tc);
    }

    @Override
    protected TreeTableColumn getVisibleLeafColumn(int index) {
        return ((TreeTableView)this.getControl()).getVisibleLeafColumn(index);
    }

    @Override
    protected void editCell(int row, TableColumnBase tc) {
        ((TreeTableView)this.getControl()).edit(row, (TreeTableColumn)tc);
    }

    @Override
    protected ObservableList<TreeTableColumn<T, ?>> getVisibleLeafColumns() {
        return ((TreeTableView)this.getControl()).getVisibleLeafColumns();
    }

    @Override
    protected TablePositionBase<TreeTableColumn<T, ?>> getTablePosition(int row, TableColumnBase<TreeItem<T>, ?> tc) {
        return new TreeTablePosition((TreeTableView)this.getControl(), row, (TreeTableColumn)tc);
    }

    @Override
    protected void selectAllToFocus(boolean setAnchorToFocusIndex) {
        if (((TreeTableView)this.getControl()).getEditingCell() != null) {
            return;
        }
        super.selectAllToFocus(setAnchorToFocusIndex);
    }

    private void rightArrowPressed() {
        if (((TreeTableView)this.getControl()).getSelectionModel().isCellSelectionEnabled()) {
            if (this.isRTL()) {
                this.selectLeftCell();
            } else {
                this.selectRightCell();
            }
        } else {
            this.expandRow();
        }
    }

    private void leftArrowPressed() {
        if (((TreeTableView)this.getControl()).getSelectionModel().isCellSelectionEnabled()) {
            if (this.isRTL()) {
                this.selectRightCell();
            } else {
                this.selectLeftCell();
            }
        } else {
            this.collapseRow();
        }
    }

    private void expandRow() {
        Callback getIndex = TreeTableViewBehavior$$Lambda$2.lambdaFactory$(this);
        TreeViewBehavior.expandRow(((TreeTableView)this.getControl()).getSelectionModel(), getIndex);
    }

    private void expandAll() {
        TreeViewBehavior.expandAll(((TreeTableView)this.getControl()).getRoot());
    }

    private void collapseRow() {
        TreeTableView control = (TreeTableView)this.getControl();
        TreeViewBehavior.collapseRow(control.getSelectionModel(), control.getRoot(), control.isShowRoot());
    }

    private /* synthetic */ Integer lambda$expandRow$269(TreeItem p) {
        return ((TreeTableView)this.getControl()).getRow(p);
    }

    private /* synthetic */ void lambda$new$268(ObservableValue observable, TreeTableView.TreeTableViewSelectionModel oldValue, TreeTableView.TreeTableViewSelectionModel newValue) {
        if (oldValue != null) {
            oldValue.getSelectedCells().removeListener(this.weakSelectedCellsListener);
        }
        if (newValue != null) {
            newValue.getSelectedCells().addListener(this.weakSelectedCellsListener);
        }
    }

    static {
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "CollapseRow"));
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "CollapseRow"));
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "ExpandRow"));
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "ExpandRow"));
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.MULTIPLY, "ExpandAll"));
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ADD, "ExpandRow"));
        TREE_TABLE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SUBTRACT, "CollapseRow"));
        TREE_TABLE_VIEW_BINDINGS.addAll(TABLE_VIEW_BINDINGS);
    }

    static /* synthetic */ void access$lambda$0(TreeTableViewBehavior treeTableViewBehavior, ObservableValue observableValue, TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel, TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel2) {
        treeTableViewBehavior.lambda$new$268(observableValue, treeTableViewSelectionModel, treeTableViewSelectionModel2);
    }

    static /* synthetic */ Integer access$lambda$1(TreeTableViewBehavior treeTableViewBehavior, TreeItem treeItem) {
        return treeTableViewBehavior.lambda$expandRow$269(treeItem);
    }
}

