/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.AccordionBehavior;
import com.sun.javafx.scene.control.skin.AccordionSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.AccordionSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Skin;
import javafx.scene.control.TitledPane;
import javafx.scene.shape.Rectangle;

public class AccordionSkin
extends BehaviorSkinBase<Accordion, AccordionBehavior> {
    private TitledPane firstTitledPane;
    private Rectangle clipRect;
    private boolean forceRelayout = false;
    private boolean relayout = false;
    private double previousHeight = 0.0;
    private TitledPane expandedPane = null;
    private TitledPane previousPane = null;
    private Map<TitledPane, ChangeListener<Boolean>> listeners = new HashMap<TitledPane, ChangeListener<Boolean>>();

    public AccordionSkin(Accordion accordion) {
        super(accordion, new AccordionBehavior(accordion));
        accordion.getPanes().addListener(AccordionSkin$$Lambda$1.lambdaFactory$(this, accordion));
        if (!accordion.getPanes().isEmpty()) {
            this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
            this.firstTitledPane.getStyleClass().add("first-titled-pane");
        }
        this.clipRect = new Rectangle(accordion.getWidth(), accordion.getHeight());
        ((Accordion)this.getSkinnable()).setClip(this.clipRect);
        this.initTitledPaneListeners(accordion.getPanes());
        this.getChildren().setAll((Collection<Node>)accordion.getPanes());
        ((Accordion)this.getSkinnable()).requestLayout();
        this.registerChangeListener(((Accordion)this.getSkinnable()).widthProperty(), "WIDTH");
        this.registerChangeListener(((Accordion)this.getSkinnable()).heightProperty(), "HEIGHT");
    }

    @Override
    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("WIDTH".equals(property)) {
            this.clipRect.setWidth(((Accordion)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(property)) {
            this.clipRect.setHeight(((Accordion)this.getSkinnable()).getHeight());
            this.relayout = true;
        }
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double h = 0.0;
        if (this.expandedPane != null) {
            h += this.expandedPane.minHeight(width);
        }
        if (this.previousPane != null && !this.previousPane.equals(this.expandedPane)) {
            h += this.previousPane.minHeight(width);
        }
        for (Node child : this.getChildren()) {
            TitledPane pane = (TitledPane)child;
            if (pane.equals(this.expandedPane) || pane.equals(this.previousPane)) continue;
            Skin<?> skin = ((TitledPane)child).getSkin();
            if (skin instanceof TitledPaneSkin) {
                TitledPaneSkin childSkin = (TitledPaneSkin)skin;
                h += childSkin.getTitleRegionSize(width);
                continue;
            }
            h += pane.minHeight(width);
        }
        return h + topInset + bottomInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double h = 0.0;
        if (this.expandedPane != null) {
            h += this.expandedPane.prefHeight(width);
        }
        if (this.previousPane != null && !this.previousPane.equals(this.expandedPane)) {
            h += this.previousPane.prefHeight(width);
        }
        for (Node child : this.getChildren()) {
            TitledPane pane = (TitledPane)child;
            if (pane.equals(this.expandedPane) || pane.equals(this.previousPane)) continue;
            Skin<?> skin = ((TitledPane)child).getSkin();
            if (skin instanceof TitledPaneSkin) {
                TitledPaneSkin childSkin = (TitledPaneSkin)skin;
                h += childSkin.getTitleRegionSize(width);
                continue;
            }
            h += pane.prefHeight(width);
        }
        return h + topInset + bottomInset;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        boolean rebuild = this.forceRelayout || this.relayout && this.previousHeight != h;
        this.forceRelayout = false;
        this.previousHeight = h;
        double collapsedPanesHeight = 0.0;
        for (TitledPane tp : ((Accordion)this.getSkinnable()).getPanes()) {
            if (tp.equals(this.expandedPane)) continue;
            TitledPaneSkin childSkin = (TitledPaneSkin)tp.getSkin();
            collapsedPanesHeight += this.snapSize(childSkin.getTitleRegionSize(w));
        }
        double maxTitledPaneHeight = h - collapsedPanesHeight;
        for (TitledPane tp : ((Accordion)this.getSkinnable()).getPanes()) {
            double ph;
            Skin<?> skin = tp.getSkin();
            if (skin instanceof TitledPaneSkin) {
                ((TitledPaneSkin)skin).setMaxTitledPaneHeightForAccordion(maxTitledPaneHeight);
                ph = this.snapSize(((TitledPaneSkin)skin).getTitledPaneHeightForAccordion());
            } else {
                ph = tp.prefHeight(w);
            }
            tp.resize(w, ph);
            boolean needsRelocate = true;
            if (!rebuild && this.previousPane != null && this.expandedPane != null) {
                ObservableList<TitledPane> panes = ((Accordion)this.getSkinnable()).getPanes();
                int previousPaneIndex = panes.indexOf(this.previousPane);
                int expandedPaneIndex = panes.indexOf(this.expandedPane);
                int currentPaneIndex = panes.indexOf(tp);
                if (previousPaneIndex < expandedPaneIndex) {
                    if (currentPaneIndex <= expandedPaneIndex) {
                        tp.relocate(x, y);
                        y += ph;
                        needsRelocate = false;
                    }
                } else if (previousPaneIndex > expandedPaneIndex) {
                    if (currentPaneIndex <= previousPaneIndex) {
                        tp.relocate(x, y);
                        y += ph;
                        needsRelocate = false;
                    }
                } else {
                    tp.relocate(x, y);
                    y += ph;
                    needsRelocate = false;
                }
            }
            if (!needsRelocate) continue;
            tp.relocate(x, y);
            y += ph;
        }
    }

    private void initTitledPaneListeners(List<? extends TitledPane> list) {
        for (TitledPane titledPane : list) {
            titledPane.setExpanded(titledPane == ((Accordion)this.getSkinnable()).getExpandedPane());
            if (titledPane.isExpanded()) {
                this.expandedPane = titledPane;
            }
            ChangeListener<Boolean> changeListener = this.expandedPropertyListener(titledPane);
            titledPane.expandedProperty().addListener(changeListener);
            this.listeners.put(titledPane, changeListener);
        }
    }

    private void removeTitledPaneListeners(List<? extends TitledPane> list) {
        for (TitledPane titledPane : list) {
            if (!this.listeners.containsKey(titledPane)) continue;
            titledPane.expandedProperty().removeListener(this.listeners.get(titledPane));
            this.listeners.remove(titledPane);
        }
    }

    private ChangeListener<Boolean> expandedPropertyListener(TitledPane tp) {
        return AccordionSkin$$Lambda$2.lambdaFactory$(this, tp);
    }

    private /* synthetic */ void lambda$expandedPropertyListener$279(TitledPane tp, ObservableValue observable, Boolean wasExpanded, Boolean expanded) {
        this.previousPane = this.expandedPane;
        Accordion accordion = (Accordion)this.getSkinnable();
        if (expanded.booleanValue()) {
            if (this.expandedPane != null) {
                this.expandedPane.setExpanded(false);
            }
            if (tp != null) {
                accordion.setExpandedPane(tp);
            }
            this.expandedPane = accordion.getExpandedPane();
        } else {
            this.expandedPane = null;
            accordion.setExpandedPane(null);
        }
    }

    private /* synthetic */ void lambda$new$278(Accordion accordion, ListChangeListener.Change c) {
        if (this.firstTitledPane != null) {
            this.firstTitledPane.getStyleClass().remove("first-titled-pane");
        }
        if (!accordion.getPanes().isEmpty()) {
            this.firstTitledPane = (TitledPane)accordion.getPanes().get(0);
            this.firstTitledPane.getStyleClass().add("first-titled-pane");
        }
        this.getChildren().setAll((Collection<Node>)accordion.getPanes());
        while (c.next()) {
            this.removeTitledPaneListeners(c.getRemoved());
            this.initTitledPaneListeners(c.getAddedSubList());
        }
        this.forceRelayout = true;
    }

    static /* synthetic */ void access$lambda$0(AccordionSkin accordionSkin, Accordion accordion, ListChangeListener.Change change) {
        accordionSkin.lambda$new$278(accordion, change);
    }

    static /* synthetic */ void access$lambda$1(AccordionSkin accordionSkin, TitledPane titledPane, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        accordionSkin.lambda$expandedPropertyListener$279(titledPane, observableValue, bl, bl2);
    }
}

