/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.TableRowSkinBase$$Lambda$1;
import com.sun.javafx.scene.control.skin.TableRowSkinBase$$Lambda$2;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.StyleOrigin;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.util.Duration;

public abstract class TableRowSkinBase<T, C extends IndexedCell, B extends CellBehaviorBase<C>, R extends IndexedCell>
extends CellSkinBase<C, B> {
    private static boolean IS_STUB_TOOLKIT = Toolkit.getToolkit().toString().contains("StubToolkit");
    private static boolean DO_ANIMATIONS = !IS_STUB_TOOLKIT && !PlatformUtil.isEmbedded();
    private static final Duration FADE_DURATION = Duration.millis(200.0);
    static final Map<Control, Double> maxDisclosureWidthMap = new WeakHashMap<Control, Double>();
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    protected WeakHashMap<TableColumnBase, Reference<R>> cellsMap;
    protected final List<R> cells = new ArrayList<R>();
    private int fullRefreshCounter = 100;
    protected boolean isDirty = false;
    protected boolean updateCells = false;
    private double fixedCellSize;
    private boolean fixedCellSizeEnabled;
    private ListChangeListener<TableColumnBase> visibleLeafColumnsListener = TableRowSkinBase$$Lambda$1.lambdaFactory$(this);
    private WeakListChangeListener<TableColumnBase> weakVisibleLeafColumnsListener = new WeakListChangeListener<TableColumnBase>(this.visibleLeafColumnsListener);

    public TableRowSkinBase(C control, B behavior) {
        super(control, behavior);
    }

    protected void init(C control) {
        ((IndexedCell)this.getSkinnable()).setPickOnBounds(false);
        this.recreateCells();
        this.updateCells(true);
        this.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        ((Cell)control).itemProperty().addListener(TableRowSkinBase$$Lambda$2.lambdaFactory$(this));
        this.registerChangeListener(((IndexedCell)control).indexProperty(), "INDEX");
        if (this.fixedCellSizeProperty() != null) {
            this.registerChangeListener(this.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
            this.fixedCellSize = this.fixedCellSizeProperty().get();
            this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        }
    }

    protected abstract ObjectProperty<Node> graphicProperty();

    protected abstract Control getVirtualFlowOwner();

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected abstract void updateCell(R var1, C var2);

    protected abstract DoubleProperty fixedCellSizeProperty();

    protected abstract boolean isColumnPartiallyOrFullyVisible(TableColumnBase var1);

    protected abstract R getCell(TableColumnBase var1);

    protected abstract TableColumnBase<T, ?> getTableColumnBase(R var1);

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("INDEX".equals(p)) {
            if (((IndexedCell)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        } else if ("FIXED_CELL_SIZE".equals(p)) {
            this.fixedCellSize = this.fixedCellSizeProperty().get();
            this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        this.checkState();
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList<TableColumnBase> visibleLeafColumns = this.getVisibleLeafColumns();
        if (visibleLeafColumns.isEmpty()) {
            super.layoutChildren(x, y, w, h);
            return;
        }
        IndexedCell control = (IndexedCell)this.getSkinnable();
        double leftMargin = 0.0;
        double disclosureWidth = 0.0;
        double graphicWidth = 0.0;
        boolean indentationRequired = this.isIndentationRequired();
        boolean disclosureVisible = this.isDisclosureNodeVisible();
        int indentationColumnIndex = 0;
        Node disclosureNode = null;
        if (indentationRequired) {
            double defaultDisclosureWidth;
            TableColumnBase treeColumn = this.getTreeColumn();
            indentationColumnIndex = treeColumn == null ? 0 : visibleLeafColumns.indexOf(treeColumn);
            indentationColumnIndex = indentationColumnIndex < 0 ? 0 : indentationColumnIndex;
            int indentationLevel = this.getIndentationLevel(control);
            if (!this.isShowRoot()) {
                --indentationLevel;
            }
            double indentationPerLevel = this.getIndentationPerLevel();
            leftMargin = (double)indentationLevel * indentationPerLevel;
            Control c = this.getVirtualFlowOwner();
            disclosureWidth = defaultDisclosureWidth = maxDisclosureWidthMap.containsKey(c) ? maxDisclosureWidthMap.get(c) : 0.0;
            disclosureNode = this.getDisclosureNode();
            if (disclosureNode != null) {
                disclosureNode.setVisible(disclosureVisible);
                if (disclosureVisible && (disclosureWidth = disclosureNode.prefWidth(h)) > defaultDisclosureWidth) {
                    maxDisclosureWidthMap.put(c, disclosureWidth);
                    VirtualFlow<C> flow = this.getVirtualFlow();
                    int thisIndex = ((IndexedCell)this.getSkinnable()).getIndex();
                    for (int i = 0; i < flow.cells.size(); ++i) {
                        IndexedCell cell = (IndexedCell)flow.cells.get(i);
                        if (cell == null || cell.isEmpty()) continue;
                        cell.requestLayout();
                        cell.layout();
                    }
                }
            }
        }
        double verticalPadding = this.snappedTopInset() + this.snappedBottomInset();
        double horizontalPadding = this.snappedLeftInset() + this.snappedRightInset();
        double controlHeight = control.getHeight();
        int index = control.getIndex();
        if (index < 0) {
            return;
        }
        int max = this.cells.size();
        for (int column = 0; column < max; ++column) {
            double width;
            double height;
            IndexedCell tableCell = (IndexedCell)this.cells.get(column);
            TableColumnBase<T, ?> tableColumn = this.getTableColumnBase(tableCell);
            boolean isVisible = true;
            if (this.fixedCellSizeEnabled) {
                isVisible = this.isColumnPartiallyOrFullyVisible(tableColumn);
                height = this.fixedCellSize;
            } else {
                height = Math.max(controlHeight, tableCell.prefHeight(-1.0));
                height = this.snapSize(height) - this.snapSize(verticalPadding);
            }
            if (isVisible) {
                if (this.fixedCellSizeEnabled && tableCell.getParent() == null) {
                    this.getChildren().add(tableCell);
                }
                width = this.snapSize(tableCell.prefWidth(-1.0)) - this.snapSize(horizontalPadding);
                boolean centreContent = h <= 24.0;
                StyleOrigin origin = ((StyleableObjectProperty)tableCell.alignmentProperty()).getStyleOrigin();
                if (!centreContent && origin == null) {
                    tableCell.setAlignment(Pos.TOP_LEFT);
                }
                if (indentationRequired && column == indentationColumnIndex) {
                    ObjectProperty<Node> graphicProperty;
                    Node graphic;
                    if (disclosureVisible) {
                        double ph = disclosureNode.prefHeight(disclosureWidth);
                        if (width > 0.0 && width < disclosureWidth + leftMargin) {
                            this.fadeOut(disclosureNode);
                        } else {
                            this.fadeIn(disclosureNode);
                            disclosureNode.resize(disclosureWidth, ph);
                            disclosureNode.relocate(x + leftMargin, centreContent ? h / 2.0 - ph / 2.0 : y + tableCell.getPadding().getTop());
                            disclosureNode.toFront();
                        }
                    }
                    Node node = graphic = (graphicProperty = this.graphicProperty()) == null ? null : (Node)graphicProperty.get();
                    if (graphic != null) {
                        graphicWidth = graphic.prefWidth(-1.0) + 3.0;
                        double ph = graphic.prefHeight(graphicWidth);
                        if (width > 0.0 && width < disclosureWidth + leftMargin + graphicWidth) {
                            this.fadeOut(graphic);
                        } else {
                            this.fadeIn(graphic);
                            graphic.relocate(x + leftMargin + disclosureWidth, centreContent ? h / 2.0 - ph / 2.0 : y + tableCell.getPadding().getTop());
                            graphic.toFront();
                        }
                    }
                }
                tableCell.resize(width, height);
                tableCell.relocate(x, this.snappedTopInset());
                tableCell.requestLayout();
            } else {
                if (this.fixedCellSizeEnabled) {
                    this.getChildren().remove(tableCell);
                }
                width = this.snapSize(tableCell.prefWidth(-1.0)) - this.snapSize(horizontalPadding);
            }
            x += width;
        }
    }

    protected int getIndentationLevel(C control) {
        return 0;
    }

    protected double getIndentationPerLevel() {
        return 0.0;
    }

    protected boolean isIndentationRequired() {
        return false;
    }

    protected TableColumnBase getTreeColumn() {
        return null;
    }

    protected Node getDisclosureNode() {
        return null;
    }

    protected boolean isDisclosureNodeVisible() {
        return false;
    }

    protected boolean isShowRoot() {
        return true;
    }

    protected TableColumnBase<T, ?> getVisibleLeafColumn(int column) {
        ObservableList<TableColumnBase> visibleLeafColumns = this.getVisibleLeafColumns();
        if (column < 0 || column >= visibleLeafColumns.size()) {
            return null;
        }
        return (TableColumnBase)visibleLeafColumns.get(column);
    }

    protected void updateCells(boolean resetChildren) {
        if (resetChildren) {
            if (this.fullRefreshCounter == 0) {
                this.recreateCells();
            }
            --this.fullRefreshCounter;
        }
        boolean cellsEmpty = this.cells.isEmpty();
        this.cells.clear();
        IndexedCell skinnable = (IndexedCell)this.getSkinnable();
        int skinnableIndex = skinnable.getIndex();
        ObservableList<TableColumnBase> visibleLeafColumns = this.getVisibleLeafColumns();
        int max = visibleLeafColumns.size();
        for (int i = 0; i < max; ++i) {
            TableColumnBase col = (TableColumnBase)visibleLeafColumns.get(i);
            IndexedCell cell = null;
            if (this.cellsMap.containsKey(col) && (cell = (IndexedCell)this.cellsMap.get(col).get()) == null) {
                this.cellsMap.remove(col);
            }
            if (cell == null) {
                cell = (IndexedCell)this.createCell(col);
            }
            this.updateCell(cell, skinnable);
            cell.updateIndex(skinnableIndex);
            this.cells.add(cell);
        }
        if (!this.fixedCellSizeEnabled && (resetChildren || cellsEmpty)) {
            this.getChildren().setAll((Collection<Node>)this.cells);
        }
    }

    private VirtualFlow<C> getVirtualFlow() {
        for (Object p = this.getSkinnable(); p != null; p = ((Node)p).getParent()) {
            if (!(p instanceof VirtualFlow)) continue;
            return (VirtualFlow)p;
        }
        return null;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = 0.0;
        ObservableList<TableColumnBase> visibleLeafColumns = this.getVisibleLeafColumns();
        int max = visibleLeafColumns.size();
        for (int i = 0; i < max; ++i) {
            prefWidth += ((TableColumnBase)visibleLeafColumns.get(i)).getWidth();
        }
        return prefWidth;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        if (this.getCellSize() < 24.0) {
            return this.getCellSize();
        }
        double prefHeight = 0.0;
        int count = this.cells.size();
        for (int i = 0; i < count; ++i) {
            IndexedCell tableCell = (IndexedCell)this.cells.get(i);
            prefHeight = Math.max(prefHeight, tableCell.prefHeight(-1.0));
        }
        double ph = Math.max(prefHeight, Math.max(this.getCellSize(), ((IndexedCell)this.getSkinnable()).minHeight(-1.0)));
        return ph;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        if (this.getCellSize() < 24.0) {
            return this.getCellSize();
        }
        double minHeight = 0.0;
        int count = this.cells.size();
        for (int i = 0; i < count; ++i) {
            IndexedCell tableCell = (IndexedCell)this.cells.get(i);
            minHeight = Math.max(minHeight, tableCell.minHeight(-1.0));
        }
        return minHeight;
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected final void checkState() {
        if (this.isDirty) {
            this.updateCells(true);
            this.isDirty = false;
        } else if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    private void requestCellUpdate() {
        this.updateCells = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
        int newIndex = ((IndexedCell)this.getSkinnable()).getIndex();
        int max = this.cells.size();
        for (int i = 0; i < max; ++i) {
            ((IndexedCell)this.cells.get(i)).updateIndex(newIndex);
        }
    }

    private void recreateCells() {
        if (this.cellsMap != null) {
            Collection<Reference<R>> cells = this.cellsMap.values();
            for (Reference<R> cellRef : cells) {
                IndexedCell cell = (IndexedCell)cellRef.get();
                if (cell == null) continue;
                cell.updateIndex(-1);
                cell.getSkin().dispose();
                cell.setSkin(null);
            }
            this.cellsMap.clear();
        }
        ObservableList<TableColumnBase> columns = this.getVisibleLeafColumns();
        this.cellsMap = new WeakHashMap(columns.size());
        this.fullRefreshCounter = 100;
        this.getChildren().clear();
        for (TableColumnBase col : columns) {
            if (this.cellsMap.containsKey(col)) continue;
            this.createCell(col);
        }
    }

    private R createCell(TableColumnBase col) {
        R cell = this.getCell(col);
        this.cellsMap.put(col, new WeakReference<R>(cell));
        return cell;
    }

    private void fadeOut(Node node) {
        if (node.getOpacity() < 1.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(0.0);
            return;
        }
        FadeTransition fader = new FadeTransition(FADE_DURATION, node);
        fader.setToValue(0.0);
        fader.play();
    }

    private void fadeIn(Node node) {
        if (node.getOpacity() > 0.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(1.0);
            return;
        }
        FadeTransition fader = new FadeTransition(FADE_DURATION, node);
        fader.setToValue(1.0);
        fader.play();
    }

    private /* synthetic */ void lambda$new$502(ListChangeListener.Change c) {
        this.isDirty = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
    }

    private /* synthetic */ void lambda$init$501(Observable o) {
        this.requestCellUpdate();
    }

    static /* synthetic */ void access$lambda$0(TableRowSkinBase tableRowSkinBase, ListChangeListener.Change change) {
        tableRowSkinBase.lambda$new$502(change);
    }

    static /* synthetic */ void access$lambda$1(TableRowSkinBase tableRowSkinBase, Observable observable) {
        tableRowSkinBase.lambda$init$501(observable);
    }
}

