/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.control.skin.TextInputControlSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextInputControlSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextInputControlSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TextInputControlSkin$CaretBlinking$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextInputControlSkin$CaretBlinking$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextInputControlSkin$ContextMenuItem$$Lambda$1;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAction;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.VLineTo;
import javafx.stage.Window;
import javafx.util.Duration;

public abstract class TextInputControlSkin<T extends TextInputControl, B extends TextInputControlBehavior<T>>
extends BehaviorSkinBase<T, B> {
    static boolean preload = false;
    protected static final boolean SHOW_HANDLES;
    protected final ObservableObjectValue<FontMetrics> fontMetrics;
    protected final ObjectProperty<Paint> textFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "textFill";
        }

        @Override
        public CssMetaData<TextInputControl, Paint> getCssMetaData() {
            return StyleableProperties.TEXT_FILL;
        }
    };
    protected final ObjectProperty<Paint> promptTextFill = new StyleableObjectProperty<Paint>((Paint)Color.GRAY){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "promptTextFill";
        }

        @Override
        public CssMetaData<TextInputControl, Paint> getCssMetaData() {
            return StyleableProperties.PROMPT_TEXT_FILL;
        }
    };
    protected final ObjectProperty<Paint> highlightFill = new StyleableObjectProperty<Paint>((Paint)Color.DODGERBLUE){

        @Override
        protected void invalidated() {
            TextInputControlSkin.this.updateHighlightFill();
        }

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "highlightFill";
        }

        @Override
        public CssMetaData<TextInputControl, Paint> getCssMetaData() {
            return StyleableProperties.HIGHLIGHT_FILL;
        }
    };
    protected final ObjectProperty<Paint> highlightTextFill = new StyleableObjectProperty<Paint>((Paint)Color.WHITE){

        @Override
        protected void invalidated() {
            TextInputControlSkin.this.updateHighlightTextFill();
        }

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "highlightTextFill";
        }

        @Override
        public CssMetaData<TextInputControl, Paint> getCssMetaData() {
            return StyleableProperties.HIGHLIGHT_TEXT_FILL;
        }
    };
    protected final BooleanProperty displayCaret = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "displayCaret";
        }

        @Override
        public CssMetaData<TextInputControl, Boolean> getCssMetaData() {
            return StyleableProperties.DISPLAY_CARET;
        }
    };
    private BooleanProperty forwardBias = new SimpleBooleanProperty(this, "forwardBias", true);
    private BooleanProperty blink = new SimpleBooleanProperty(this, "blink", true);
    protected ObservableBooleanValue caretVisible;
    private CaretBlinking caretBlinking = new CaretBlinking(this.blink);
    protected final Path caretPath = new Path();
    protected StackPane caretHandle = null;
    protected StackPane selectionHandle1 = null;
    protected StackPane selectionHandle2 = null;
    private static final boolean IS_FXVK_SUPPORTED;
    private static boolean USE_FXVK;
    static int vkType;
    private int imstart;
    private int imlength;
    private List<Shape> imattrs = new ArrayList<Shape>();
    final MenuItem undoMI = new ContextMenuItem("Undo");
    final MenuItem redoMI = new ContextMenuItem("Redo");
    final MenuItem cutMI = new ContextMenuItem("Cut");
    final MenuItem copyMI = new ContextMenuItem("Copy");
    final MenuItem pasteMI = new ContextMenuItem("Paste");
    final MenuItem deleteMI = new ContextMenuItem("DeleteSelection");
    final MenuItem selectWordMI = new ContextMenuItem("SelectWord");
    final MenuItem selectAllMI = new ContextMenuItem("SelectAll");
    final MenuItem separatorMI = new SeparatorMenuItem();

    public BooleanProperty forwardBiasProperty() {
        return this.forwardBias;
    }

    public void setForwardBias(boolean isLeading) {
        this.forwardBias.set(isLeading);
    }

    public boolean isForwardBias() {
        return this.forwardBias.get();
    }

    public Point2D getMenuPosition() {
        if (SHOW_HANDLES) {
            if (this.caretHandle.isVisible()) {
                return new Point2D(this.caretHandle.getLayoutX() + this.caretHandle.getWidth() / 2.0, this.caretHandle.getLayoutY());
            }
            if (this.selectionHandle1.isVisible() && this.selectionHandle2.isVisible()) {
                return new Point2D((this.selectionHandle1.getLayoutX() + this.selectionHandle1.getWidth() / 2.0 + this.selectionHandle2.getLayoutX() + this.selectionHandle2.getWidth() / 2.0) / 2.0, this.selectionHandle2.getLayoutY() + this.selectionHandle2.getHeight() / 2.0);
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public void toggleUseVK() {
        if (++vkType < 4) {
            USE_FXVK = true;
            ((TextInputControl)this.getSkinnable()).getProperties().put("vkType", FXVK.VK_TYPE_NAMES[vkType]);
            FXVK.attach((Node)((Object)this.getSkinnable()));
        } else {
            FXVK.detach();
            vkType = -1;
            USE_FXVK = false;
        }
    }

    public TextInputControlSkin(final T textInput, B behavior) {
        super(textInput, behavior);
        this.fontMetrics = new ObjectBinding<FontMetrics>(){
            {
                this.bind(textInput.fontProperty());
            }

            @Override
            protected FontMetrics computeValue() {
                TextInputControlSkin.this.invalidateMetrics();
                return Toolkit.getToolkit().getFontLoader().getFontMetrics(textInput.getFont());
            }
        };
        this.caretVisible = new BooleanBinding((TextInputControl)textInput){
            final /* synthetic */ TextInputControl val$textInput;
            {
                this.val$textInput = textInputControl;
                this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), this.val$textInput.editableProperty(), TextInputControlSkin.this.displayCaret, TextInputControlSkin.this.blink);
            }

            @Override
            protected boolean computeValue() {
                return !TextInputControlSkin.this.blink.get() && TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && (PlatformUtil.isWindows() || this.val$textInput.getCaretPosition() == this.val$textInput.getAnchor()) && !this.val$textInput.isDisabled() && this.val$textInput.isEditable();
            }
        };
        if (SHOW_HANDLES) {
            this.caretHandle = new StackPane();
            this.selectionHandle1 = new StackPane();
            this.selectionHandle2 = new StackPane();
            this.caretHandle.setManaged(false);
            this.selectionHandle1.setManaged(false);
            this.selectionHandle2.setManaged(false);
            this.caretHandle.visibleProperty().bind(new BooleanBinding((TextInputControl)textInput){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                    this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), this.val$textInput.editableProperty(), this.val$textInput.lengthProperty(), TextInputControlSkin.this.displayCaret);
                }

                @Override
                protected boolean computeValue() {
                    return TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && this.val$textInput.getCaretPosition() == this.val$textInput.getAnchor() && !this.val$textInput.isDisabled() && this.val$textInput.isEditable() && this.val$textInput.getLength() > 0;
                }
            });
            this.selectionHandle1.visibleProperty().bind(new BooleanBinding((TextInputControl)textInput){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                    this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), TextInputControlSkin.this.displayCaret);
                }

                @Override
                protected boolean computeValue() {
                    return TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && this.val$textInput.getCaretPosition() != this.val$textInput.getAnchor() && !this.val$textInput.isDisabled();
                }
            });
            this.selectionHandle2.visibleProperty().bind(new BooleanBinding((TextInputControl)textInput){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                    this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), TextInputControlSkin.this.displayCaret);
                }

                @Override
                protected boolean computeValue() {
                    return TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && this.val$textInput.getCaretPosition() != this.val$textInput.getAnchor() && !this.val$textInput.isDisabled();
                }
            });
            this.caretHandle.getStyleClass().setAll((String[])new String[]{"caret-handle"});
            this.selectionHandle1.getStyleClass().setAll((String[])new String[]{"selection-handle"});
            this.selectionHandle2.getStyleClass().setAll((String[])new String[]{"selection-handle"});
            this.selectionHandle1.setId("selection-handle-1");
            this.selectionHandle2.setId("selection-handle-2");
        }
        if (IS_FXVK_SUPPORTED) {
            Window window;
            Scene scene;
            if (preload && (scene = ((Node)textInput).getScene()) != null && (window = scene.getWindow()) != null) {
                FXVK.init(textInput);
            }
            ((Node)textInput).focusedProperty().addListener(TextInputControlSkin$$Lambda$1.lambdaFactory$(this, textInput));
        }
        if (((Node)textInput).getOnInputMethodTextChanged() == null) {
            ((Node)textInput).setOnInputMethodTextChanged(TextInputControlSkin$$Lambda$2.lambdaFactory$(this));
        }
        ((Node)textInput).setInputMethodRequests(new ExtendedInputMethodRequests((TextInputControl)textInput){
            final /* synthetic */ TextInputControl val$textInput;
            {
                this.val$textInput = textInputControl;
            }

            @Override
            public Point2D getTextLocation(int offset) {
                Scene scene = ((TextInputControl)TextInputControlSkin.this.getSkinnable()).getScene();
                Window window = scene.getWindow();
                Rectangle2D characterBounds = TextInputControlSkin.this.getCharacterBounds(this.val$textInput.getSelection().getStart() + offset);
                Point2D p = ((TextInputControl)TextInputControlSkin.this.getSkinnable()).localToScene(characterBounds.getMinX(), characterBounds.getMaxY());
                Point2D location = new Point2D(window.getX() + scene.getX() + p.getX(), window.getY() + scene.getY() + p.getY());
                return location;
            }

            @Override
            public int getLocationOffset(int x, int y) {
                return TextInputControlSkin.this.getInsertionPoint(x, y);
            }

            @Override
            public void cancelLatestCommittedText() {
            }

            @Override
            public String getSelectedText() {
                TextInputControl textInput = (TextInputControl)TextInputControlSkin.this.getSkinnable();
                IndexRange selection = textInput.getSelection();
                return textInput.getText(selection.getStart(), selection.getEnd());
            }

            @Override
            public int getInsertPositionOffset() {
                int caretPosition = ((TextInputControl)TextInputControlSkin.this.getSkinnable()).getCaretPosition();
                if (caretPosition < TextInputControlSkin.this.imstart) {
                    return caretPosition;
                }
                if (caretPosition < TextInputControlSkin.this.imstart + TextInputControlSkin.this.imlength) {
                    return TextInputControlSkin.this.imstart;
                }
                return caretPosition - TextInputControlSkin.this.imlength;
            }

            @Override
            public String getCommittedText(int begin, int end) {
                TextInputControl textInput = (TextInputControl)TextInputControlSkin.this.getSkinnable();
                if (begin < TextInputControlSkin.this.imstart) {
                    if (end <= TextInputControlSkin.this.imstart) {
                        return textInput.getText(begin, end);
                    }
                    return textInput.getText(begin, TextInputControlSkin.this.imstart) + textInput.getText(TextInputControlSkin.this.imstart + TextInputControlSkin.this.imlength, end + TextInputControlSkin.this.imlength);
                }
                return textInput.getText(begin + TextInputControlSkin.this.imlength, end + TextInputControlSkin.this.imlength);
            }

            @Override
            public int getCommittedTextLength() {
                return ((TextInputControl)TextInputControlSkin.this.getSkinnable()).getText().length() - TextInputControlSkin.this.imlength;
            }
        });
    }

    protected String maskText(String txt) {
        return txt;
    }

    public char getCharacter(int index) {
        return '\u0000';
    }

    public int getInsertionPoint(double x, double y) {
        return 0;
    }

    public Rectangle2D getCharacterBounds(int index) {
        return null;
    }

    public void scrollCharacterToVisible(int index) {
    }

    protected void invalidateMetrics() {
    }

    protected void updateTextFill() {
    }

    protected void updateHighlightFill() {
    }

    protected void updateHighlightTextFill() {
    }

    protected void handleInputMethodEvent(InputMethodEvent event) {
        TextInputControl textInput = (TextInputControl)this.getSkinnable();
        if (textInput.isEditable() && !textInput.textProperty().isBound() && !textInput.isDisabled()) {
            if (PlatformUtil.isIOS()) {
                textInput.setText(event.getCommitted());
                return;
            }
            if (this.imlength != 0) {
                this.removeHighlight(this.imattrs);
                this.imattrs.clear();
                textInput.selectRange(this.imstart, this.imstart + this.imlength);
            }
            if (event.getCommitted().length() != 0) {
                String committed = event.getCommitted();
                textInput.replaceText(textInput.getSelection(), committed);
            }
            this.imstart = textInput.getSelection().getStart();
            StringBuilder composed = new StringBuilder();
            for (InputMethodTextRun inputMethodTextRun : event.getComposed()) {
                composed.append(inputMethodTextRun.getText());
            }
            textInput.replaceText(textInput.getSelection(), composed.toString());
            this.imlength = composed.length();
            if (this.imlength != 0) {
                int pos = this.imstart;
                for (InputMethodTextRun run : event.getComposed()) {
                    int endPos = pos + run.getText().length();
                    this.createInputMethodAttributes(run.getHighlight(), pos, endPos);
                    pos = endPos;
                }
                this.addHighlight(this.imattrs, this.imstart);
                int n = event.getCaretPosition();
                if (n >= 0 && n < this.imlength) {
                    textInput.selectRange(this.imstart + n, this.imstart + n);
                }
            }
        }
    }

    protected abstract PathElement[] getUnderlineShape(int var1, int var2);

    protected abstract PathElement[] getRangeShape(int var1, int var2);

    protected abstract void addHighlight(List<? extends Node> var1, int var2);

    protected abstract void removeHighlight(List<? extends Node> var1);

    public abstract void nextCharacterVisually(boolean var1);

    private void createInputMethodAttributes(InputMethodHighlight highlight, int start, int end) {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        PathElement[] elements = this.getUnderlineShape(start, end);
        for (int i = 0; i < elements.length; ++i) {
            PathElement pe = elements[i];
            if (pe instanceof MoveTo) {
                minX = maxX = ((MoveTo)pe).getX();
                minY = maxY = ((MoveTo)pe).getY();
            } else if (pe instanceof LineTo) {
                minX = minX < ((LineTo)pe).getX() ? minX : ((LineTo)pe).getX();
                maxX = maxX > ((LineTo)pe).getX() ? maxX : ((LineTo)pe).getX();
                minY = minY < ((LineTo)pe).getY() ? minY : ((LineTo)pe).getY();
                maxY = maxY > ((LineTo)pe).getY() ? maxY : ((LineTo)pe).getY();
            } else if (pe instanceof HLineTo) {
                minX = minX < ((HLineTo)pe).getX() ? minX : ((HLineTo)pe).getX();
                maxX = maxX > ((HLineTo)pe).getX() ? maxX : ((HLineTo)pe).getX();
            } else if (pe instanceof VLineTo) {
                minY = minY < ((VLineTo)pe).getY() ? minY : ((VLineTo)pe).getY();
                double d = maxY = maxY > ((VLineTo)pe).getY() ? maxY : ((VLineTo)pe).getY();
            }
            if (!(pe instanceof ClosePath) && i != elements.length - 1 && (i >= elements.length - 1 || !(elements[i + 1] instanceof MoveTo))) continue;
            Shape attr = null;
            if (highlight == InputMethodHighlight.SELECTED_RAW) {
                attr = new Path();
                ((Path)attr).getElements().addAll((PathElement[])this.getRangeShape(start, end));
                attr.setFill(Color.BLUE);
                attr.setOpacity(0.3f);
            } else if (highlight == InputMethodHighlight.UNSELECTED_RAW) {
                attr = new Line(minX + 2.0, maxY + 1.0, maxX - 2.0, maxY + 1.0);
                attr.setStroke((Paint)this.textFill.get());
                attr.setStrokeWidth(maxY - minY);
                ObservableList<Double> dashArray = attr.getStrokeDashArray();
                dashArray.add(2.0);
                dashArray.add(2.0);
            } else if (highlight == InputMethodHighlight.SELECTED_CONVERTED) {
                attr = new Line(minX + 2.0, maxY + 1.0, maxX - 2.0, maxY + 1.0);
                attr.setStroke((Paint)this.textFill.get());
                attr.setStrokeWidth((maxY - minY) * 3.0);
            } else if (highlight == InputMethodHighlight.UNSELECTED_CONVERTED) {
                attr = new Line(minX + 2.0, maxY + 1.0, maxX - 2.0, maxY + 1.0);
                attr.setStroke((Paint)this.textFill.get());
                attr.setStrokeWidth(maxY - minY);
            }
            if (attr == null) continue;
            attr.setManaged(false);
            this.imattrs.add(attr);
        }
    }

    protected boolean isRTL() {
        return ((TextInputControl)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
    }

    public void setCaretAnimating(boolean value) {
        if (value) {
            this.caretBlinking.start();
        } else {
            this.caretBlinking.stop();
            this.blink.set(true);
        }
    }

    public void populateContextMenu(ContextMenu contextMenu) {
        TextInputControl textInputControl = (TextInputControl)this.getSkinnable();
        boolean editable = textInputControl.isEditable();
        boolean hasText = textInputControl.getLength() > 0;
        boolean hasSelection = textInputControl.getSelection().getLength() > 0;
        boolean maskText = this.maskText("A") != "A";
        ObservableList<MenuItem> items = contextMenu.getItems();
        if (SHOW_HANDLES) {
            items.clear();
            if (!maskText && hasSelection) {
                if (editable) {
                    items.add(this.cutMI);
                }
                items.add(this.copyMI);
            }
            if (editable && Clipboard.getSystemClipboard().hasString()) {
                items.add(this.pasteMI);
            }
            if (hasText) {
                if (!hasSelection) {
                    items.add(this.selectWordMI);
                }
                items.add(this.selectAllMI);
            }
            this.selectWordMI.getProperties().put("refreshMenu", Boolean.TRUE);
            this.selectAllMI.getProperties().put("refreshMenu", Boolean.TRUE);
        } else {
            if (editable) {
                items.setAll((MenuItem[])new MenuItem[]{this.undoMI, this.redoMI, this.cutMI, this.copyMI, this.pasteMI, this.deleteMI, this.separatorMI, this.selectAllMI});
            } else {
                items.setAll((MenuItem[])new MenuItem[]{this.copyMI, this.separatorMI, this.selectAllMI});
            }
            this.undoMI.setDisable(!((TextInputControl)this.getSkinnable()).isUndoable());
            this.redoMI.setDisable(!((TextInputControl)this.getSkinnable()).isRedoable());
            this.cutMI.setDisable(maskText || !hasSelection);
            this.copyMI.setDisable(maskText || !hasSelection);
            this.pasteMI.setDisable(!Clipboard.getSystemClipboard().hasString());
            this.deleteMI.setDisable(!hasSelection);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextInputControlSkin.getClassCssMetaData();
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SHOW_TEXT_RANGE: {
                Integer start = (Integer)parameters[0];
                Integer end = (Integer)parameters[1];
                if (start == null || end == null) break;
                this.scrollCharacterToVisible(end);
                this.scrollCharacterToVisible(start);
                this.scrollCharacterToVisible(end);
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    private /* synthetic */ void lambda$new$191(InputMethodEvent event) {
        this.handleInputMethodEvent(event);
    }

    private /* synthetic */ void lambda$new$190(TextInputControl textInput, Observable observable) {
        if (USE_FXVK) {
            Scene scene = ((TextInputControl)this.getSkinnable()).getScene();
            if (textInput.isEditable() && textInput.isFocused()) {
                FXVK.attach(textInput);
            } else if (!(scene != null && scene.getWindow() != null && scene.getWindow().isFocused() && scene.getFocusOwner() instanceof TextInputControl && ((TextInputControl)scene.getFocusOwner()).isEditable())) {
                FXVK.detach();
            }
        }
    }

    private static /* synthetic */ Void lambda$static$189() {
        String s = System.getProperty("com.sun.javafx.virtualKeyboard.preload");
        if (s != null && s.equalsIgnoreCase("PRERENDER")) {
            preload = true;
        }
        return null;
    }

    static {
        AccessController.doPrivileged(TextInputControlSkin$$Lambda$3.lambdaFactory$());
        SHOW_HANDLES = IS_TOUCH_SUPPORTED && !PlatformUtil.isIOS();
        USE_FXVK = IS_FXVK_SUPPORTED = Platform.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD);
        vkType = -1;
    }

    static /* synthetic */ void access$lambda$0(TextInputControlSkin textInputControlSkin, TextInputControl textInputControl, Observable observable) {
        textInputControlSkin.lambda$new$190(textInputControl, observable);
    }

    static /* synthetic */ void access$lambda$1(TextInputControlSkin textInputControlSkin, InputMethodEvent inputMethodEvent) {
        textInputControlSkin.lambda$new$191(inputMethodEvent);
    }

    static /* synthetic */ Void access$lambda$2() {
        return TextInputControlSkin.lambda$static$189();
    }

    private static class StyleableProperties {
        private static final CssMetaData<TextInputControl, Paint> TEXT_FILL = new CssMetaData<TextInputControl, Paint>("-fx-text-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return skin.textFill == null || !skin.textFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.textFill);
            }
        };
        private static final CssMetaData<TextInputControl, Paint> PROMPT_TEXT_FILL = new CssMetaData<TextInputControl, Paint>("-fx-prompt-text-fill", PaintConverter.getInstance(), (Paint)Color.GRAY){

            @Override
            public boolean isSettable(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return skin.promptTextFill == null || !skin.promptTextFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.promptTextFill);
            }
        };
        private static final CssMetaData<TextInputControl, Paint> HIGHLIGHT_FILL = new CssMetaData<TextInputControl, Paint>("-fx-highlight-fill", PaintConverter.getInstance(), (Paint)Color.DODGERBLUE){

            @Override
            public boolean isSettable(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return skin.highlightFill == null || !skin.highlightFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.highlightFill);
            }
        };
        private static final CssMetaData<TextInputControl, Paint> HIGHLIGHT_TEXT_FILL = new CssMetaData<TextInputControl, Paint>("-fx-highlight-text-fill", PaintConverter.getInstance(), (Paint)Color.WHITE){

            @Override
            public boolean isSettable(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return skin.highlightTextFill == null || !skin.highlightTextFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.highlightTextFill);
            }
        };
        private static final CssMetaData<TextInputControl, Boolean> DISPLAY_CARET = new CssMetaData<TextInputControl, Boolean>("-fx-display-caret", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return skin.displayCaret == null || !skin.displayCaret.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(TextInputControl n) {
                TextInputControlSkin skin = (TextInputControlSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.displayCaret);
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
            styleables.add(TEXT_FILL);
            styleables.add(PROMPT_TEXT_FILL);
            styleables.add(HIGHLIGHT_FILL);
            styleables.add(HIGHLIGHT_TEXT_FILL);
            styleables.add(DISPLAY_CARET);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    class ContextMenuItem
    extends MenuItem {
        ContextMenuItem(String action) {
            super(ControlResources.getString("TextInputControl.menu." + action));
            this.setOnAction(TextInputControlSkin$ContextMenuItem$$Lambda$1.lambdaFactory$(this, action));
        }

        private /* synthetic */ void lambda$new$194(String action, ActionEvent e) {
            ((TextInputControlBehavior)TextInputControlSkin.this.getBehavior()).callAction(action);
        }

        static /* synthetic */ void access$lambda$0(ContextMenuItem contextMenuItem, String string, ActionEvent actionEvent) {
            contextMenuItem.lambda$new$194(string, actionEvent);
        }
    }

    private static final class CaretBlinking {
        private final Timeline caretTimeline;
        private final WeakReference<BooleanProperty> blinkPropertyRef;

        public CaretBlinking(BooleanProperty blinkProperty) {
            this.blinkPropertyRef = new WeakReference<BooleanProperty>(blinkProperty);
            this.caretTimeline = new Timeline();
            this.caretTimeline.setCycleCount(-1);
            this.caretTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, TextInputControlSkin$CaretBlinking$$Lambda$1.lambdaFactory$(this), new KeyValue[0]), new KeyFrame(Duration.seconds(0.5), TextInputControlSkin$CaretBlinking$$Lambda$2.lambdaFactory$(this), new KeyValue[0]), new KeyFrame(Duration.seconds(1.0), new KeyValue[0])});
        }

        public void start() {
            this.caretTimeline.play();
        }

        public void stop() {
            this.caretTimeline.stop();
        }

        private void setBlink(boolean value) {
            BooleanProperty blinkProperty = (BooleanProperty)this.blinkPropertyRef.get();
            if (blinkProperty == null) {
                this.caretTimeline.stop();
                return;
            }
            blinkProperty.set(value);
        }

        private /* synthetic */ void lambda$new$193(ActionEvent event) {
            this.setBlink(true);
        }

        private /* synthetic */ void lambda$new$192(ActionEvent event) {
            this.setBlink(false);
        }

        static /* synthetic */ void access$lambda$0(CaretBlinking caretBlinking, ActionEvent actionEvent) {
            caretBlinking.lambda$new$192(actionEvent);
        }

        static /* synthetic */ void access$lambda$1(CaretBlinking caretBlinking, ActionEvent actionEvent) {
            caretBlinking.lambda$new$193(actionEvent);
        }
    }
}

