/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.TitledPaneBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.TitledPaneSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TitledPaneSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TitledPaneSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TitledPaneSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.TitledPaneSkin$TitleRegion$$Lambda$1;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class TitledPaneSkin
extends LabeledSkinBase<TitledPane, TitledPaneBehavior> {
    public static final Duration TRANSITION_DURATION = new Duration(350.0);
    private static final boolean CACHE_ANIMATION = PlatformUtil.isEmbedded();
    private final TitleRegion titleRegion;
    private final StackPane contentContainer;
    private Node content;
    private Timeline timeline;
    private double transitionStartValue = 0.0;
    private Rectangle clipRect = new Rectangle();
    private Pos pos;
    private HPos hpos;
    private VPos vpos;
    private DoubleProperty transition;
    private double prefHeightFromAccordion = 0.0;

    public TitledPaneSkin(TitledPane titledPane) {
        super(titledPane, new TitledPaneBehavior(titledPane));
        this.titleRegion = new TitleRegion();
        this.content = ((TitledPane)this.getSkinnable()).getContent();
        this.contentContainer = new StackPane(){
            {
                this.getStyleClass().setAll((String[])new String[]{"content"});
                if (TitledPaneSkin.this.content != null) {
                    this.getChildren().setAll((Node[])new Node[]{TitledPaneSkin.this.content});
                }
            }
        };
        this.contentContainer.setClip(this.clipRect);
        if (titledPane.isExpanded()) {
            this.setTransition(1.0);
            this.setExpanded(titledPane.isExpanded());
        } else {
            this.setTransition(0.0);
            if (this.content != null) {
                this.content.setVisible(false);
            }
        }
        this.getChildren().setAll((Node[])new Node[]{this.contentContainer, this.titleRegion});
        this.registerChangeListener(titledPane.contentProperty(), "CONTENT");
        this.registerChangeListener(titledPane.expandedProperty(), "EXPANDED");
        this.registerChangeListener(titledPane.collapsibleProperty(), "COLLAPSIBLE");
        this.registerChangeListener(titledPane.alignmentProperty(), "ALIGNMENT");
        this.registerChangeListener(titledPane.widthProperty(), "WIDTH");
        this.registerChangeListener(titledPane.heightProperty(), "HEIGHT");
        this.registerChangeListener(this.titleRegion.alignmentProperty(), "TITLE_REGION_ALIGNMENT");
        this.pos = titledPane.getAlignment();
        this.hpos = this.pos == null ? HPos.LEFT : this.pos.getHpos();
        this.vpos = this.pos == null ? VPos.CENTER : this.pos.getVpos();
    }

    public StackPane getContentContainer() {
        return this.contentContainer;
    }

    @Override
    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("CONTENT".equals(property)) {
            this.content = ((TitledPane)this.getSkinnable()).getContent();
            if (this.content == null) {
                this.contentContainer.getChildren().clear();
            } else {
                this.contentContainer.getChildren().setAll((Node[])new Node[]{this.content});
            }
        } else if ("EXPANDED".equals(property)) {
            this.setExpanded(((TitledPane)this.getSkinnable()).isExpanded());
        } else if ("COLLAPSIBLE".equals(property)) {
            this.titleRegion.update();
        } else if ("ALIGNMENT".equals(property)) {
            this.pos = ((TitledPane)this.getSkinnable()).getAlignment();
            this.hpos = this.pos.getHpos();
            this.vpos = this.pos.getVpos();
        } else if ("TITLE_REGION_ALIGNMENT".equals(property)) {
            this.pos = this.titleRegion.getAlignment();
            this.hpos = this.pos.getHpos();
            this.vpos = this.pos.getVpos();
        } else if ("WIDTH".equals(property)) {
            this.clipRect.setWidth(((TitledPane)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(property)) {
            this.clipRect.setHeight(this.contentContainer.getHeight());
        } else if ("GRAPHIC_TEXT_GAP".equals(property)) {
            this.titleRegion.requestLayout();
        }
    }

    @Override
    protected void updateChildren() {
        if (this.titleRegion != null) {
            this.titleRegion.update();
        }
    }

    private void setExpanded(boolean expanded) {
        if (!((TitledPane)this.getSkinnable()).isCollapsible()) {
            this.setTransition(1.0);
            return;
        }
        if (((TitledPane)this.getSkinnable()).isAnimated()) {
            this.transitionStartValue = this.getTransition();
            this.doAnimationTransition();
        } else {
            if (expanded) {
                this.setTransition(1.0);
            } else {
                this.setTransition(0.0);
            }
            if (this.content != null) {
                this.content.setVisible(expanded);
            }
            ((TitledPane)this.getSkinnable()).requestLayout();
        }
    }

    private void setTransition(double value) {
        this.transitionProperty().set(value);
    }

    private double getTransition() {
        return this.transition == null ? 0.0 : this.transition.get();
    }

    private DoubleProperty transitionProperty() {
        if (this.transition == null) {
            this.transition = new SimpleDoubleProperty(this, "transition", 0.0){

                @Override
                protected void invalidated() {
                    TitledPaneSkin.this.contentContainer.requestLayout();
                }
            };
        }
        return this.transition;
    }

    private boolean isInsideAccordion() {
        return ((TitledPane)this.getSkinnable()).getParent() != null && ((TitledPane)this.getSkinnable()).getParent() instanceof Accordion;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double headerHeight = this.snapSize(this.titleRegion.prefHeight(-1.0));
        this.titleRegion.resize(w, headerHeight);
        this.positionInArea(this.titleRegion, x, y, w, headerHeight, 0.0, HPos.LEFT, VPos.CENTER);
        double contentHeight = (h - headerHeight) * this.getTransition();
        if (this.isInsideAccordion() && this.prefHeightFromAccordion != 0.0) {
            contentHeight = (this.prefHeightFromAccordion - headerHeight) * this.getTransition();
        }
        contentHeight = this.snapSize(contentHeight);
        this.contentContainer.resize(w, contentHeight);
        this.clipRect.setHeight(contentHeight);
        this.positionInArea(this.contentContainer, x, y += this.snapSize(headerHeight), w, contentHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double titleWidth = this.snapSize(this.titleRegion.prefWidth(height));
        double contentWidth = this.snapSize(this.contentContainer.minWidth(height));
        return Math.max(titleWidth, contentWidth) + leftInset + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double headerHeight = this.snapSize(this.titleRegion.prefHeight(width));
        double contentHeight = this.contentContainer.minHeight(width) * this.getTransition();
        return headerHeight + this.snapSize(contentHeight) + topInset + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double titleWidth = this.snapSize(this.titleRegion.prefWidth(height));
        double contentWidth = this.snapSize(this.contentContainer.prefWidth(height));
        return Math.max(titleWidth, contentWidth) + leftInset + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double headerHeight = this.snapSize(this.titleRegion.prefHeight(width));
        double contentHeight = this.contentContainer.prefHeight(width) * this.getTransition();
        return headerHeight + this.snapSize(contentHeight) + topInset + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    double getTitleRegionSize(double width) {
        return this.snapSize(this.titleRegion.prefHeight(width)) + this.snappedTopInset() + this.snappedBottomInset();
    }

    void setMaxTitledPaneHeightForAccordion(double height) {
        this.prefHeightFromAccordion = height;
    }

    double getTitledPaneHeightForAccordion() {
        double headerHeight = this.snapSize(this.titleRegion.prefHeight(-1.0));
        double contentHeight = (this.prefHeightFromAccordion - headerHeight) * this.getTransition();
        return headerHeight + this.snapSize(contentHeight) + this.snappedTopInset() + this.snappedBottomInset();
    }

    private void doAnimationTransition() {
        KeyFrame k2;
        KeyFrame k1;
        Duration duration;
        if (this.content == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            this.timeline.stop();
        } else {
            duration = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (((TitledPane)this.getSkinnable()).isExpanded()) {
            k1 = new KeyFrame(Duration.ZERO, TitledPaneSkin$$Lambda$1.lambdaFactory$(this), new KeyValue(this.transitionProperty(), this.transitionStartValue));
            k2 = new KeyFrame(duration, TitledPaneSkin$$Lambda$2.lambdaFactory$(this), new KeyValue(this.transitionProperty(), 1, Interpolator.LINEAR));
        } else {
            k1 = new KeyFrame(Duration.ZERO, TitledPaneSkin$$Lambda$3.lambdaFactory$(this), new KeyValue(this.transitionProperty(), this.transitionStartValue));
            k2 = new KeyFrame(duration, TitledPaneSkin$$Lambda$4.lambdaFactory$(this), new KeyValue(this.transitionProperty(), 0, Interpolator.LINEAR));
        }
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{k1, k2});
        this.timeline.play();
    }

    private /* synthetic */ void lambda$doAnimationTransition$517(ActionEvent event) {
        this.content.setVisible(false);
        if (CACHE_ANIMATION) {
            this.content.setCache(false);
        }
    }

    private /* synthetic */ void lambda$doAnimationTransition$516(ActionEvent event) {
        if (CACHE_ANIMATION) {
            this.content.setCache(true);
        }
    }

    private /* synthetic */ void lambda$doAnimationTransition$515(ActionEvent event) {
        if (CACHE_ANIMATION) {
            this.content.setCache(false);
        }
    }

    private /* synthetic */ void lambda$doAnimationTransition$514(ActionEvent event) {
        if (CACHE_ANIMATION) {
            this.content.setCache(true);
        }
        this.content.setVisible(true);
    }

    static /* synthetic */ void access$lambda$0(TitledPaneSkin titledPaneSkin, ActionEvent actionEvent) {
        titledPaneSkin.lambda$doAnimationTransition$514(actionEvent);
    }

    static /* synthetic */ void access$lambda$1(TitledPaneSkin titledPaneSkin, ActionEvent actionEvent) {
        titledPaneSkin.lambda$doAnimationTransition$515(actionEvent);
    }

    static /* synthetic */ void access$lambda$2(TitledPaneSkin titledPaneSkin, ActionEvent actionEvent) {
        titledPaneSkin.lambda$doAnimationTransition$516(actionEvent);
    }

    static /* synthetic */ void access$lambda$3(TitledPaneSkin titledPaneSkin, ActionEvent actionEvent) {
        titledPaneSkin.lambda$doAnimationTransition$517(actionEvent);
    }

    class TitleRegion
    extends StackPane {
        private final StackPane arrowRegion;

        public TitleRegion() {
            this.getStyleClass().setAll((String[])new String[]{"title"});
            this.arrowRegion = new StackPane();
            this.arrowRegion.setId("arrowRegion");
            this.arrowRegion.getStyleClass().setAll((String[])new String[]{"arrow-button"});
            StackPane arrow = new StackPane();
            arrow.setId("arrow");
            arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.arrowRegion.getChildren().setAll((Node[])new Node[]{arrow});
            arrow.rotateProperty().bind(new DoubleBinding(){
                {
                    this.bind(TitledPaneSkin.this.transitionProperty());
                }

                @Override
                protected double computeValue() {
                    return -90.0 * (1.0 - TitledPaneSkin.this.getTransition());
                }
            });
            this.setAlignment(Pos.CENTER_LEFT);
            this.setOnMouseReleased(TitledPaneSkin$TitleRegion$$Lambda$1.lambdaFactory$(this));
            this.update();
        }

        private void update() {
            this.getChildren().clear();
            TitledPane titledPane = (TitledPane)TitledPaneSkin.this.getSkinnable();
            if (titledPane.isCollapsible()) {
                this.getChildren().add(this.arrowRegion);
            }
            if (TitledPaneSkin.this.graphic != null) {
                TitledPaneSkin.this.graphic.layoutBoundsProperty().removeListener(TitledPaneSkin.this.graphicPropertyChangedListener);
            }
            TitledPaneSkin.this.graphic = titledPane.getGraphic();
            if (TitledPaneSkin.this.isIgnoreGraphic()) {
                if (titledPane.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY) {
                    this.getChildren().clear();
                    this.getChildren().add(this.arrowRegion);
                } else {
                    this.getChildren().add(TitledPaneSkin.this.text);
                }
            } else {
                TitledPaneSkin.this.graphic.layoutBoundsProperty().addListener(TitledPaneSkin.this.graphicPropertyChangedListener);
                if (TitledPaneSkin.this.isIgnoreText()) {
                    this.getChildren().add(TitledPaneSkin.this.graphic);
                } else {
                    this.getChildren().addAll((Node[])new Node[]{TitledPaneSkin.this.graphic, TitledPaneSkin.this.text});
                }
            }
            this.setCursor(((TitledPane)TitledPaneSkin.this.getSkinnable()).isCollapsible() ? Cursor.HAND : Cursor.DEFAULT);
        }

        @Override
        protected double computePrefWidth(double height) {
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double arrowWidth = 0.0;
            double labelPrefWidth = this.labelPrefWidth(height);
            if (this.arrowRegion != null) {
                arrowWidth = this.snapSize(this.arrowRegion.prefWidth(height));
            }
            return left + arrowWidth + labelPrefWidth + right;
        }

        @Override
        protected double computePrefHeight(double width) {
            double top = this.snappedTopInset();
            double bottom = this.snappedBottomInset();
            double arrowHeight = 0.0;
            double labelPrefHeight = this.labelPrefHeight(width);
            if (this.arrowRegion != null) {
                arrowHeight = this.snapSize(this.arrowRegion.prefHeight(width));
            }
            return top + Math.max(arrowHeight, labelPrefHeight) + bottom;
        }

        @Override
        protected void layoutChildren() {
            double top = this.snappedTopInset();
            double bottom = this.snappedBottomInset();
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double width = this.getWidth() - (left + right);
            double height = this.getHeight() - (top + bottom);
            double arrowWidth = this.snapSize(this.arrowRegion.prefWidth(-1.0));
            double arrowHeight = this.snapSize(this.arrowRegion.prefHeight(-1.0));
            double labelWidth = this.snapSize(Math.min(width - arrowWidth / 2.0, this.labelPrefWidth(-1.0)));
            double labelHeight = this.snapSize(this.labelPrefHeight(-1.0));
            double x = left + arrowWidth + Utils.computeXOffset(width - arrowWidth, labelWidth, TitledPaneSkin.this.hpos);
            if (HPos.CENTER == TitledPaneSkin.this.hpos) {
                x = left + Utils.computeXOffset(width, labelWidth, TitledPaneSkin.this.hpos);
            }
            double y = top + Utils.computeYOffset(height, Math.max(arrowHeight, labelHeight), TitledPaneSkin.this.vpos);
            this.arrowRegion.resize(arrowWidth, arrowHeight);
            this.positionInArea(this.arrowRegion, left, top, arrowWidth, height, 0.0, HPos.CENTER, VPos.CENTER);
            TitledPaneSkin.this.layoutLabelInArea(x, y, labelWidth, height, TitledPaneSkin.this.pos);
        }

        private double labelPrefWidth(double height) {
            Labeled labeled = (Labeled)TitledPaneSkin.this.getSkinnable();
            Font font = TitledPaneSkin.this.text.getFont();
            String string = labeled.getText();
            boolean emptyText = string == null || string.isEmpty();
            Insets labelPadding = labeled.getLabelPadding();
            double widthPadding = labelPadding.getLeft() + labelPadding.getRight();
            double textWidth = emptyText ? 0.0 : Utils.computeTextWidth(font, string, 0.0);
            Node graphic = labeled.getGraphic();
            if (TitledPaneSkin.this.isIgnoreGraphic()) {
                return textWidth + widthPadding;
            }
            if (TitledPaneSkin.this.isIgnoreText()) {
                return graphic.prefWidth(-1.0) + widthPadding;
            }
            if (labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT) {
                return textWidth + labeled.getGraphicTextGap() + graphic.prefWidth(-1.0) + widthPadding;
            }
            return Math.max(textWidth, graphic.prefWidth(-1.0)) + widthPadding;
        }

        private double labelPrefHeight(double width) {
            double textHeight;
            Labeled labeled = (Labeled)TitledPaneSkin.this.getSkinnable();
            Font font = TitledPaneSkin.this.text.getFont();
            ContentDisplay contentDisplay = labeled.getContentDisplay();
            double gap = labeled.getGraphicTextGap();
            Insets labelPadding = labeled.getLabelPadding();
            double widthPadding = this.snappedLeftInset() + this.snappedRightInset() + labelPadding.getLeft() + labelPadding.getRight();
            String str = labeled.getText();
            if (str != null && str.endsWith("\n")) {
                str = str.substring(0, str.length() - 1);
            }
            if (!(TitledPaneSkin.this.isIgnoreGraphic() || contentDisplay != ContentDisplay.LEFT && contentDisplay != ContentDisplay.RIGHT)) {
                width -= TitledPaneSkin.this.graphic.prefWidth(-1.0) + gap;
            }
            double h = textHeight = Utils.computeTextHeight(font, str, labeled.isWrapText() ? (width -= widthPadding) : 0.0, TitledPaneSkin.this.text.getBoundsType());
            if (!TitledPaneSkin.this.isIgnoreGraphic()) {
                Node graphic = labeled.getGraphic();
                h = contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM ? graphic.prefHeight(-1.0) + gap + textHeight : Math.max(textHeight, graphic.prefHeight(-1.0));
            }
            return h + labelPadding.getTop() + labelPadding.getBottom();
        }

        private /* synthetic */ void lambda$new$518(MouseEvent e) {
            if (e.getButton() != MouseButton.PRIMARY) {
                return;
            }
            ContextMenu contextMenu = ((TitledPane)TitledPaneSkin.this.getSkinnable()).getContextMenu();
            if (contextMenu != null) {
                contextMenu.hide();
            }
            if (((TitledPane)TitledPaneSkin.this.getSkinnable()).isCollapsible() && ((TitledPane)TitledPaneSkin.this.getSkinnable()).isFocused()) {
                ((TitledPaneBehavior)TitledPaneSkin.this.getBehavior()).toggle();
            }
        }

        static /* synthetic */ void access$lambda$0(TitleRegion titleRegion, MouseEvent mouseEvent) {
            titleRegion.lambda$new$518(mouseEvent);
        }
    }
}

