/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.ToolBarBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ToolBarSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ToolBarSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.ToolBarSkin$ToolBarOverflowMenu$$Lambda$1;
import com.sun.javafx.scene.control.skin.ToolBarSkin$ToolBarOverflowMenu$$Lambda$2;
import com.sun.javafx.scene.control.skin.ToolBarSkin$ToolBarOverflowMenu$$Lambda$3;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ToolBarSkin
extends BehaviorSkinBase<ToolBar, ToolBarBehavior> {
    private Pane box;
    private ToolBarOverflowMenu overflowMenu;
    private boolean overflow = false;
    private double previousWidth = 0.0;
    private double previousHeight = 0.0;
    private double savedPrefWidth = 0.0;
    private double savedPrefHeight = 0.0;
    private ObservableList<MenuItem> overflowMenuItems = FXCollections.observableArrayList();
    private boolean needsUpdate = false;
    private final ParentTraversalEngine engine;
    private DoubleProperty spacing;
    private ObjectProperty<Pos> boxAlignment;

    public ToolBarSkin(ToolBar toolbar) {
        super(toolbar, new ToolBarBehavior(toolbar));
        this.initialize();
        this.registerChangeListener(toolbar.orientationProperty(), "ORIENTATION");
        this.engine = new ParentTraversalEngine((Parent)((Object)this.getSkinnable()), new Algorithm(){

            private Node selectPrev(int from, TraversalContext context) {
                for (int i = from; i >= 0; --i) {
                    Node selected;
                    Node n = (Node)ToolBarSkin.this.box.getChildren().get(i);
                    if (n.isDisabled() || !n.impl_isTreeVisible()) continue;
                    if (n instanceof Parent && (selected = context.selectLastInParent((Parent)n)) != null) {
                        return selected;
                    }
                    if (!n.isFocusTraversable()) continue;
                    return n;
                }
                return null;
            }

            private Node selectNext(int from, TraversalContext context) {
                int max = ToolBarSkin.this.box.getChildren().size();
                for (int i = from; i < max; ++i) {
                    Node selected;
                    Node n = (Node)ToolBarSkin.this.box.getChildren().get(i);
                    if (n.isDisabled() || !n.impl_isTreeVisible()) continue;
                    if (n.isFocusTraversable()) {
                        return n;
                    }
                    if (!(n instanceof Parent) || (selected = context.selectFirstInParent((Parent)n)) == null) continue;
                    return selected;
                }
                return null;
            }

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                int idx;
                ObservableList<Node> boxChildren = ToolBarSkin.this.box.getChildren();
                if (owner == ToolBarSkin.this.overflowMenu) {
                    if (dir.isForward()) {
                        return null;
                    }
                    Node selected = this.selectPrev(boxChildren.size() - 1, context);
                    if (selected != null) {
                        return selected;
                    }
                }
                if ((idx = boxChildren.indexOf(owner)) < 0) {
                    Parent item = owner.getParent();
                    while (!boxChildren.contains(item)) {
                        item = item.getParent();
                    }
                    Node selected = context.selectInSubtree(item, owner, dir);
                    if (selected != null) {
                        return selected;
                    }
                    idx = boxChildren.indexOf(owner);
                    if (dir == Direction.NEXT) {
                        dir = Direction.NEXT_IN_LINE;
                    }
                }
                if (idx >= 0) {
                    Node selected;
                    if (dir.isForward()) {
                        selected = this.selectNext(idx + 1, context);
                        if (selected != null) {
                            return selected;
                        }
                        if (ToolBarSkin.this.overflow) {
                            ToolBarSkin.this.overflowMenu.requestFocus();
                            return ToolBarSkin.this.overflowMenu;
                        }
                    } else {
                        selected = this.selectPrev(idx - 1, context);
                        if (selected != null) {
                            return selected;
                        }
                    }
                }
                return null;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                Node selected = this.selectNext(0, context);
                if (selected != null) {
                    return selected;
                }
                if (ToolBarSkin.this.overflow) {
                    return ToolBarSkin.this.overflowMenu;
                }
                return null;
            }

            @Override
            public Node selectLast(TraversalContext context) {
                if (ToolBarSkin.this.overflow) {
                    return ToolBarSkin.this.overflowMenu;
                }
                return this.selectPrev(ToolBarSkin.this.box.getChildren().size() - 1, context);
            }
        });
        ((ToolBar)this.getSkinnable()).setImpl_traversalEngine(this.engine);
        toolbar.focusedProperty().addListener(ToolBarSkin$$Lambda$1.lambdaFactory$(this));
        toolbar.getItems().addListener(ToolBarSkin$$Lambda$2.lambdaFactory$(this));
    }

    public final void setSpacing(double value) {
        this.spacingProperty().set(this.snapSpace(value));
    }

    public final double getSpacing() {
        return this.spacing == null ? 0.0 : this.snapSpace(this.spacing.get());
    }

    public final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                @Override
                protected void invalidated() {
                    double value = this.get();
                    if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        ((VBox)ToolBarSkin.this.box).setSpacing(value);
                    } else {
                        ((HBox)ToolBarSkin.this.box).setSpacing(value);
                    }
                }

                @Override
                public Object getBean() {
                    return ToolBarSkin.this;
                }

                @Override
                public String getName() {
                    return "spacing";
                }

                @Override
                public CssMetaData<ToolBar, Number> getCssMetaData() {
                    return StyleableProperties.SPACING;
                }
            };
        }
        return this.spacing;
    }

    public final void setBoxAlignment(Pos value) {
        this.boxAlignmentProperty().set(value);
    }

    public final Pos getBoxAlignment() {
        return this.boxAlignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.boxAlignment.get());
    }

    public final ObjectProperty<Pos> boxAlignmentProperty() {
        if (this.boxAlignment == null) {
            this.boxAlignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    Pos value = (Pos)((Object)this.get());
                    if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        ((VBox)ToolBarSkin.this.box).setAlignment(value);
                    } else {
                        ((HBox)ToolBarSkin.this.box).setAlignment(value);
                    }
                }

                @Override
                public Object getBean() {
                    return ToolBarSkin.this;
                }

                @Override
                public String getName() {
                    return "boxAlignment";
                }

                @Override
                public CssMetaData<ToolBar, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }
            };
        }
        return this.boxAlignment;
    }

    @Override
    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("ORIENTATION".equals(property)) {
            this.initialize();
        }
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        ToolBar toolbar = (ToolBar)this.getSkinnable();
        return toolbar.getOrientation() == Orientation.VERTICAL ? this.computePrefWidth(-1.0, topInset, rightInset, bottomInset, leftInset) : this.snapSize(this.overflowMenu.prefWidth(-1.0)) + leftInset + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ToolBar toolbar = (ToolBar)this.getSkinnable();
        return toolbar.getOrientation() == Orientation.VERTICAL ? this.snapSize(this.overflowMenu.prefHeight(-1.0)) + topInset + bottomInset : this.computePrefHeight(-1.0, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = 0.0;
        ToolBar toolbar = (ToolBar)this.getSkinnable();
        if (toolbar.getOrientation() == Orientation.HORIZONTAL) {
            for (Node node : toolbar.getItems()) {
                prefWidth += this.snapSize(node.prefWidth(-1.0)) + this.getSpacing();
            }
            prefWidth -= this.getSpacing();
        } else {
            for (Node node : toolbar.getItems()) {
                prefWidth = Math.max(prefWidth, this.snapSize(node.prefWidth(-1.0)));
            }
            if (toolbar.getItems().size() > 0) {
                this.savedPrefWidth = prefWidth;
            } else {
                prefWidth = this.savedPrefWidth;
            }
        }
        return leftInset + prefWidth + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight = 0.0;
        ToolBar toolbar = (ToolBar)this.getSkinnable();
        if (toolbar.getOrientation() == Orientation.VERTICAL) {
            for (Node node : toolbar.getItems()) {
                prefHeight += this.snapSize(node.prefHeight(-1.0)) + this.getSpacing();
            }
            prefHeight -= this.getSpacing();
        } else {
            for (Node node : toolbar.getItems()) {
                prefHeight = Math.max(prefHeight, this.snapSize(node.prefHeight(-1.0)));
            }
            if (toolbar.getItems().size() > 0) {
                this.savedPrefHeight = prefHeight;
            } else {
                prefHeight = this.savedPrefHeight;
            }
        }
        return topInset + prefHeight + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSize(((ToolBar)this.getSkinnable()).prefWidth(-1.0)) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : this.snapSize(((ToolBar)this.getSkinnable()).prefHeight(-1.0));
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        ToolBar toolbar = (ToolBar)this.getSkinnable();
        if (toolbar.getOrientation() == Orientation.VERTICAL) {
            if (this.snapSize(toolbar.getHeight()) != this.previousHeight || this.needsUpdate) {
                ((VBox)this.box).setSpacing(this.getSpacing());
                ((VBox)this.box).setAlignment(this.getBoxAlignment());
                this.previousHeight = this.snapSize(toolbar.getHeight());
                this.addNodesToToolBar();
            }
        } else if (this.snapSize(toolbar.getWidth()) != this.previousWidth || this.needsUpdate) {
            ((HBox)this.box).setSpacing(this.getSpacing());
            ((HBox)this.box).setAlignment(this.getBoxAlignment());
            this.previousWidth = this.snapSize(toolbar.getWidth());
            this.addNodesToToolBar();
        }
        this.needsUpdate = false;
        double toolbarWidth = w;
        double toolbarHeight = h;
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            toolbarHeight -= this.overflow ? this.snapSize(this.overflowMenu.prefHeight(-1.0)) : 0.0;
        } else {
            toolbarWidth -= this.overflow ? this.snapSize(this.overflowMenu.prefWidth(-1.0)) : 0.0;
        }
        this.box.resize(toolbarWidth, toolbarHeight);
        this.positionInArea(this.box, x, y, toolbarWidth, toolbarHeight, 0.0, HPos.CENTER, VPos.CENTER);
        if (this.overflow) {
            double overflowMenuWidth = this.snapSize(this.overflowMenu.prefWidth(-1.0));
            double overflowMenuHeight = this.snapSize(this.overflowMenu.prefHeight(-1.0));
            double overflowX = x;
            double overflowY = x;
            if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                HPos pos;
                if (toolbarWidth == 0.0) {
                    toolbarWidth = this.savedPrefWidth;
                }
                overflowX = HPos.LEFT.equals((Object)(pos = ((VBox)this.box).getAlignment().getHpos())) ? x + Math.abs((toolbarWidth - overflowMenuWidth) / 2.0) : (HPos.RIGHT.equals((Object)pos) ? this.snapSize(toolbar.getWidth()) - this.snappedRightInset() - toolbarWidth + Math.abs((toolbarWidth - overflowMenuWidth) / 2.0) : x + Math.abs((this.snapSize(toolbar.getWidth()) - x + this.snappedRightInset() - overflowMenuWidth) / 2.0));
                overflowY = this.snapSize(toolbar.getHeight()) - overflowMenuHeight - y;
            } else {
                VPos pos;
                if (toolbarHeight == 0.0) {
                    toolbarHeight = this.savedPrefHeight;
                }
                overflowY = VPos.TOP.equals((Object)(pos = ((HBox)this.box).getAlignment().getVpos())) ? y + Math.abs((toolbarHeight - overflowMenuHeight) / 2.0) : (VPos.BOTTOM.equals((Object)pos) ? this.snapSize(toolbar.getHeight()) - this.snappedBottomInset() - toolbarHeight + Math.abs((toolbarHeight - overflowMenuHeight) / 2.0) : y + Math.abs((toolbarHeight - overflowMenuHeight) / 2.0));
                overflowX = this.snapSize(toolbar.getWidth()) - overflowMenuWidth - this.snappedRightInset();
            }
            this.overflowMenu.resize(overflowMenuWidth, overflowMenuHeight);
            this.positionInArea(this.overflowMenu, overflowX, overflowY, overflowMenuWidth, overflowMenuHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void initialize() {
        this.box = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? new VBox() : new HBox();
        this.box.getStyleClass().add("container");
        this.box.getChildren().addAll((Collection<Node>)((ToolBar)this.getSkinnable()).getItems());
        this.overflowMenu = new ToolBarOverflowMenu(this.overflowMenuItems);
        this.overflowMenu.setVisible(false);
        this.overflowMenu.setManaged(false);
        this.getChildren().clear();
        this.getChildren().add(this.box);
        this.getChildren().add(this.overflowMenu);
        this.previousWidth = 0.0;
        this.previousHeight = 0.0;
        this.savedPrefWidth = 0.0;
        this.savedPrefHeight = 0.0;
        this.needsUpdate = true;
        ((ToolBar)this.getSkinnable()).requestLayout();
    }

    private void addNodesToToolBar() {
        Node last;
        ToolBar toolbar = (ToolBar)this.getSkinnable();
        double length = 0.0;
        length = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSize(toolbar.getHeight()) - this.snappedTopInset() - this.snappedBottomInset() + this.getSpacing() : this.snapSize(toolbar.getWidth()) - this.snappedLeftInset() - this.snappedRightInset() + this.getSpacing();
        double x = 0.0;
        boolean hasOverflow = false;
        for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
            x = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (x += this.snapSize(node.prefHeight(-1.0)) + this.getSpacing()) : (x += this.snapSize(node.prefWidth(-1.0)) + this.getSpacing());
            if (!(x > length)) continue;
            hasOverflow = true;
            break;
        }
        if (hasOverflow) {
            length = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (length -= this.snapSize(this.overflowMenu.prefHeight(-1.0))) : (length -= this.snapSize(this.overflowMenu.prefWidth(-1.0)));
            length -= this.getSpacing();
        }
        x = 0.0;
        this.overflowMenuItems.clear();
        this.box.getChildren().clear();
        for (Node node : ((ToolBar)this.getSkinnable()).getItems()) {
            String nodeType;
            node.getStyleClass().remove("menu-item");
            node.getStyleClass().remove("custom-menu-item");
            x = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (x += this.snapSize(node.prefHeight(-1.0)) + this.getSpacing()) : (x += this.snapSize(node.prefWidth(-1.0)) + this.getSpacing());
            if (x <= length) {
                this.box.getChildren().add(node);
                continue;
            }
            if (node.isFocused()) {
                if (!this.box.getChildren().isEmpty()) {
                    Node last2 = this.engine.selectLast();
                    if (last2 != null) {
                        last2.requestFocus();
                    }
                } else {
                    this.overflowMenu.requestFocus();
                }
            }
            if (node instanceof Separator) {
                this.overflowMenuItems.add(new SeparatorMenuItem());
                continue;
            }
            CustomMenuItem customMenuItem = new CustomMenuItem(node);
            switch (nodeType = node.getTypeSelector()) {
                case "Button": 
                case "Hyperlink": 
                case "Label": {
                    customMenuItem.setHideOnClick(true);
                    break;
                }
                case "CheckBox": 
                case "ChoiceBox": 
                case "ColorPicker": 
                case "ComboBox": 
                case "DatePicker": 
                case "MenuButton": 
                case "PasswordField": 
                case "RadioButton": 
                case "ScrollBar": 
                case "ScrollPane": 
                case "Slider": 
                case "SplitMenuButton": 
                case "SplitPane": 
                case "TextArea": 
                case "TextField": 
                case "ToggleButton": 
                case "ToolBar": {
                    customMenuItem.setHideOnClick(false);
                }
            }
            this.overflowMenuItems.add(customMenuItem);
        }
        boolean bl = this.overflow = this.overflowMenuItems.size() > 0;
        if (!this.overflow && this.overflowMenu.isFocused() && (last = this.engine.selectLast()) != null) {
            last.requestFocus();
        }
        this.overflowMenu.setVisible(this.overflow);
        this.overflowMenu.setManaged(this.overflow);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToolBarSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case OVERFLOW_BUTTON: {
                return this.overflowMenu;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SHOW_MENU: {
                this.overflowMenu.fire();
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    private /* synthetic */ void lambda$new$520(ListChangeListener.Change c) {
        while (c.next()) {
            for (Node n : c.getRemoved()) {
                this.box.getChildren().remove(n);
            }
            this.box.getChildren().addAll(c.getAddedSubList());
        }
        this.needsUpdate = true;
        ((ToolBar)this.getSkinnable()).requestLayout();
    }

    private /* synthetic */ void lambda$new$519(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            if (!this.box.getChildren().isEmpty()) {
                ((Node)this.box.getChildren().get(0)).requestFocus();
            } else {
                this.overflowMenu.requestFocus();
            }
        }
    }

    static /* synthetic */ void access$lambda$0(ToolBarSkin toolBarSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        toolBarSkin.lambda$new$519(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$1(ToolBarSkin toolBarSkin, ListChangeListener.Change change) {
        toolBarSkin.lambda$new$520(change);
    }

    private static class StyleableProperties {
        private static final CssMetaData<ToolBar, Number> SPACING = new CssMetaData<ToolBar, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(ToolBar n) {
                ToolBarSkin skin = (ToolBarSkin)n.getSkin();
                return skin.spacing == null || !skin.spacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ToolBar n) {
                ToolBarSkin skin = (ToolBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.spacingProperty());
            }
        };
        private static final CssMetaData<ToolBar, Pos> ALIGNMENT = new CssMetaData<ToolBar, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(ToolBar n) {
                ToolBarSkin skin = (ToolBarSkin)n.getSkin();
                return skin.boxAlignment == null || !skin.boxAlignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(ToolBar n) {
                ToolBarSkin skin = (ToolBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.boxAlignmentProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
            String alignmentProperty = ALIGNMENT.getProperty();
            int nMax = styleables.size();
            for (int n = 0; n < nMax; ++n) {
                CssMetaData prop = (CssMetaData)styleables.get(n);
                if (!alignmentProperty.equals(prop.getProperty())) continue;
                styleables.remove(prop);
            }
            styleables.add(SPACING);
            styleables.add(ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    class ToolBarOverflowMenu
    extends StackPane {
        private StackPane downArrow;
        private ContextMenu popup;
        private ObservableList<MenuItem> menuItems;

        public ToolBarOverflowMenu(ObservableList<MenuItem> items) {
            this.getStyleClass().setAll((String[])new String[]{"tool-bar-overflow-button"});
            this.setAccessibleRole(AccessibleRole.BUTTON);
            this.setAccessibleText(ControlResources.getString("Accessibility.title.ToolBar.OverflowButton"));
            this.setFocusTraversable(true);
            this.menuItems = items;
            this.downArrow = new StackPane();
            this.downArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.downArrow.setOnMousePressed(ToolBarSkin$ToolBarOverflowMenu$$Lambda$1.lambdaFactory$(this));
            this.setOnKeyPressed(ToolBarSkin$ToolBarOverflowMenu$$Lambda$2.lambdaFactory$(this));
            this.visibleProperty().addListener(ToolBarSkin$ToolBarOverflowMenu$$Lambda$3.lambdaFactory$(this));
            this.popup = new ContextMenu();
            this.setVisible(false);
            this.setManaged(false);
            this.getChildren().add(this.downArrow);
        }

        private void fire() {
            if (this.popup.isShowing()) {
                this.popup.hide();
            } else {
                this.popup.getItems().clear();
                this.popup.getItems().addAll((Collection<MenuItem>)this.menuItems);
                this.popup.show(this.downArrow, Side.BOTTOM, 0.0, 0.0);
            }
        }

        @Override
        protected double computePrefWidth(double height) {
            return this.snappedLeftInset() + this.snappedRightInset();
        }

        @Override
        protected double computePrefHeight(double width) {
            return this.snappedTopInset() + this.snappedBottomInset();
        }

        @Override
        protected void layoutChildren() {
            double w = this.snapSize(this.downArrow.prefWidth(-1.0));
            double h = this.snapSize(this.downArrow.prefHeight(-1.0));
            double x = (this.snapSize(this.getWidth()) - w) / 2.0;
            double y = (this.snapSize(this.getHeight()) - h) / 2.0;
            if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                this.downArrow.setRotate(0.0);
            }
            this.downArrow.resize(w, h);
            this.positionInArea(this.downArrow, x, y, w, h, 0.0, HPos.CENTER, VPos.CENTER);
        }

        @Override
        public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
            switch (action) {
                case FIRE: {
                    this.fire();
                    break;
                }
                default: {
                    super.executeAccessibleAction(action, new Object[0]);
                }
            }
        }

        private /* synthetic */ void lambda$new$523(ObservableValue observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue() && ToolBarSkin.this.box.getChildren().isEmpty()) {
                this.setFocusTraversable(true);
            }
        }

        private /* synthetic */ void lambda$new$522(KeyEvent ke) {
            if (KeyCode.SPACE.equals((Object)ke.getCode())) {
                if (!this.popup.isShowing()) {
                    this.popup.getItems().clear();
                    this.popup.getItems().addAll((Collection<MenuItem>)this.menuItems);
                    this.popup.show(this.downArrow, Side.BOTTOM, 0.0, 0.0);
                }
                ke.consume();
            } else if (KeyCode.ESCAPE.equals((Object)ke.getCode())) {
                if (this.popup.isShowing()) {
                    this.popup.hide();
                }
                ke.consume();
            } else if (KeyCode.ENTER.equals((Object)ke.getCode())) {
                this.fire();
                ke.consume();
            }
        }

        private /* synthetic */ void lambda$new$521(MouseEvent me) {
            this.fire();
        }

        static /* synthetic */ void access$lambda$0(ToolBarOverflowMenu toolBarOverflowMenu, MouseEvent mouseEvent) {
            toolBarOverflowMenu.lambda$new$521(mouseEvent);
        }

        static /* synthetic */ void access$lambda$1(ToolBarOverflowMenu toolBarOverflowMenu, KeyEvent keyEvent) {
            toolBarOverflowMenu.lambda$new$522(keyEvent);
        }

        static /* synthetic */ void access$lambda$2(ToolBarOverflowMenu toolBarOverflowMenu, ObservableValue observableValue, Boolean bl, Boolean bl2) {
            toolBarOverflowMenu.lambda$new$523(observableValue, bl, bl2);
        }
    }
}

